/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import java.util.Random;
import swisseph.SMath;
import swisseph.SwephData;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

public class TCPlanetPlanet
extends TransitCalculator
implements Serializable {
    int precalcCount = 50;
    private int pl1;
    private int pl2;
    private int idx = 0;
    private int tflags = 0;
    private int flags = 0;
    private boolean calcPartile = false;
    private boolean calcNonPartile = false;
    private boolean calcPartileBoth = false;
    private boolean isPartile = false;
    private boolean calcYoga = false;
    private double minSpeed1;
    private double maxSpeed1;
    private double minSpeed2;
    private double maxSpeed2;
    private double minSpeed;
    private double maxSpeed;
    private double offset = 0.0;
    private double lon1 = 0.0;
    private double lon2 = -1000.0;
    double minVal = 0.0;
    double maxVal = 0.0;

    public TCPlanetPlanet(SwissEph swissEph, int n, int n2, int n3, double d) {
        this(swissEph, n, n2, n3, d, 200, 1.4);
    }

    public TCPlanetPlanet(SwissEph swissEph, int n, int n2, int n3, double d, int n4, double d2) {
        double[] dArray;
        this.sw = swissEph;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        n4 = Math.max(n4, 100);
        d2 = Math.max(d2, 1.1);
        this.tflags = n3;
        int n5 = 16748063;
        if ((n3 & 8) != 0) {
            n5 |= 0x600;
        }
        if ((n3 & ~n5) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (n3 & ~n5));
        }
        int n6 = n3 & 0xE0000;
        if (n6 != 131072 && n6 != 262144 && n6 != 524288) {
            throw new IllegalArgumentException("Invalid flag combination '" + n3 + "': specify exactly one of SEFLG_TRANSIT_LONGITUDE (" + 131072 + "), SEFLG_TRANSIT_LATITUDE (" + 262144 + "), SEFLG_TRANSIT_DISTANCE (" + 524288 + ").");
        }
        if ((n3 & 8) != 0 && (n == 12 || n == 13 || n == 10 || n == 11)) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ") for heliocentric calculations");
        }
        if ((n3 & 8) != 0 && (n2 == 12 || n2 == 13 || n2 == 10 || n2 == 11)) {
            throw new IllegalArgumentException("Unsupported planet number " + n2 + " (" + swissEph.swe_get_planet_name(n2) + ") for heliocentric calculations");
        }
        if (n == n2) {
            throw new IllegalArgumentException("Transiting and referred planet have to be different!");
        }
        this.pl1 = n;
        this.pl2 = n2;
        this.calcPartile = (n3 & 0x400000) != 0;
        this.calcNonPartile = (n3 & 0x800000) != 0;
        this.calcPartileBoth = this.calcPartile && this.calcNonPartile;
        boolean bl = this.calcYoga = (n3 & 0x200000) != 0;
        if ((n3 & 0x40000) != 0) {
            this.idx = 1;
        } else if ((n3 & 0x80000) != 0) {
            this.idx = 2;
        }
        if ((n3 & 0x100000) != 0) {
            this.idx += 3;
            n3 |= 0x100;
        }
        this.flags = n3 &= 0xFF01FFFF;
        boolean bl2 = this.rollover = this.idx == 0;
        if (this.calcPartile || this.calcNonPartile) {
            if (d % 30.0 != 0.0) {
                throw new IllegalArgumentException("Wrong offset (" + d + "). Calculation of partile aspect may have offsets of multiples of 30 degrees only.");
            }
            this.rollover = false;
        }
        this.offset = this.checkOffset(d);
        this.maxSpeed1 = this.getSpeed(false, n);
        this.minSpeed1 = this.getSpeed(true, n);
        this.maxSpeed2 = this.getSpeed(false, n2);
        this.minSpeed2 = this.getSpeed(true, n2);
        if ((Double.isInfinite(this.maxSpeed1) || Double.isInfinite(this.minSpeed1)) && this.idx < 3) {
            dArray = this.getTestspeed(n, this.idx, n4, d2);
            this.minSpeed1 = dArray[0];
            this.maxSpeed1 = dArray[1];
        }
        if (Double.isInfinite(this.maxSpeed1) || Double.isInfinite(this.minSpeed1)) {
            throw new IllegalArgumentException(((n3 & 0x8000) != 0 ? "Topo" : ((n3 & 8) != 0 ? "Helio" : "Geo")) + "centric transit calculations with planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ") not possible: extreme " + ((n3 & 0x100) != 0 ? "accelerations" : "speeds") + " of the planet " + ((n3 & 0x800) != 0 ? "in equatorial system " : "") + "not available.");
        }
        if ((Double.isInfinite(this.maxSpeed2) || Double.isInfinite(this.minSpeed2)) && this.idx < 3) {
            dArray = this.getTestspeed(n2, this.idx, n4, d2);
            this.minSpeed2 = dArray[0];
            this.maxSpeed2 = dArray[1];
        }
        if (Double.isInfinite(this.maxSpeed2) || Double.isInfinite(this.minSpeed2)) {
            throw new IllegalArgumentException(((n3 & 0x8000) != 0 ? "Topo" : ((n3 & 8) != 0 ? "Helio" : "Geo")) + "centric transit calculations with planet number " + n2 + " (" + swissEph.swe_get_planet_name(n2) + ") not possible: extreme " + ((n3 & 0x100) != 0 ? "accelerations" : "speeds") + " of the planet " + ((n3 & 0x800) != 0 ? "in equatorial system " : "") + "not available.");
        }
        if (this.calcYoga) {
            this.minSpeed = this.minSpeed1 + this.minSpeed2;
            this.maxSpeed = this.maxSpeed1 + this.maxSpeed2;
        } else if (this.rollover) {
            this.minSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.minSpeed1 - this.maxSpeed2 : this.minSpeed2 - this.maxSpeed1;
            this.maxSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.maxSpeed1 - this.minSpeed2 : this.maxSpeed2 - this.minSpeed1;
        } else {
            this.minSpeed = SMath.min(this.minSpeed1 - this.maxSpeed2, this.minSpeed2 - this.maxSpeed1);
            this.maxSpeed = SMath.max(this.maxSpeed1 - this.minSpeed2, this.maxSpeed2 - this.minSpeed1);
        }
    }

    @Override
    double preprocessDate(double d, boolean bl) {
        if (this.calcPartile || this.calcNonPartile) {
            this.isPartile = this.hasPartileAspect(d, this.pl1, this.pl2, this.flags, this.offset);
            if (!this.calcPartileBoth) {
                if (this.isPartile && this.calcPartile) {
                    int n = this.flags & 0xFFBFFFFF;
                    TCPlanetPlanet tCPlanetPlanet = new TCPlanetPlanet(this.sw, this.pl1, this.pl2, n |= 0x820000, this.offset);
                    d = this.sw.getTransitET(tCPlanetPlanet, d, bl);
                    this.isPartile = !this.isPartile;
                } else if (!this.isPartile && this.calcNonPartile) {
                    int n = this.flags & 0xFF7FFFFF;
                    TCPlanetPlanet tCPlanetPlanet = new TCPlanetPlanet(this.sw, this.pl1, this.pl2, n |= 0x420000, this.offset);
                    d = this.sw.getTransitET(tCPlanetPlanet, d, bl);
                    this.isPartile = !this.isPartile;
                }
            }
        }
        return d;
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public double getMinOffset() {
        if ((this.tflags & 0x100000) != 0) {
            double d = this.getSpeed(true, this.pl1, false);
            double d2 = this.getSpeed(true, this.pl1, true);
            double d3 = this.getSpeed(true, this.pl2, false);
            double d4 = this.getSpeed(true, this.pl2, true);
            return SMath.min(d - d4, d3 - d2);
        }
        return 0.0;
    }

    @Override
    public double getMaxOffset() {
        if ((this.tflags & 0x100000) != 0) {
            double d = this.getSpeed(true, this.pl1, false);
            double d2 = this.getSpeed(true, this.pl1, true);
            double d3 = this.getSpeed(true, this.pl2, false);
            double d4 = this.getSpeed(true, this.pl2, true);
            return SMath.max(d2 - d3, d4 - d);
        }
        return 360.0;
    }

    @Override
    public void setOffset(double d) {
        this.offset = this.checkOffset(d);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public Object[] getObjectIdentifiers() {
        return new String[]{"" + this.pl1, "" + this.pl2};
    }

    public boolean hasPartileAspect(double d, int n, int n2, int n3, double d2) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        d2 = (int)d2;
        int n4 = this.sw.swe_calc(d, n, n3 &= 0xFF01FFFF, dArray, stringBuffer);
        if (n4 < 0) {
            throw new SwissephException(d, 0, "Calculation failed with return code " + n4 + ":\n" + stringBuffer.toString());
        }
        n4 = this.sw.swe_calc(d, n2, n3, dArray2, stringBuffer);
        if (n4 < 0) {
            throw new SwissephException(d, 0, "Calculation failed with return code " + n4 + ":\n" + stringBuffer.toString());
        }
        return (int)(dArray[0] % 30.0) == (int)(dArray2[0] % 30.0) && (((double)((int)dArray[0]) + d2 + this.rolloverVal) % this.rolloverVal == (double)((int)dArray2[0]) || ((double)((int)dArray[0]) - d2 + this.rolloverVal) % this.rolloverVal == (double)((int)dArray2[0]));
    }

    @Override
    protected double getMaxSpeed() {
        return this.maxSpeed;
    }

    @Override
    protected double getMinSpeed() {
        return this.minSpeed;
    }

    @Override
    protected double calc(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        int n = this.sw.swe_calc(d, this.pl1, this.flags, dArray, stringBuffer);
        if (n < 0) {
            int n2 = 0;
            if (stringBuffer.toString().matches("jd 2488117.1708818264 > Swiss Eph. upper limit 2487932.5;")) {
                n2 = 786432;
            }
            System.err.println("SERR: " + stringBuffer);
            throw new SwissephException(d, n2, "Calculation failed with return code " + n + ":\n" + stringBuffer.toString());
        }
        n = this.sw.swe_calc(d, this.pl2, this.flags, dArray2, stringBuffer);
        if (n < 0) {
            int n3 = 0;
            if (stringBuffer.toString().matches("jd 2488117.1708818264 > Swiss Eph. upper limit 2487932.5;")) {
                n3 = 786432;
            }
            throw new SwissephException(d, n3, "Calculation failed with return code " + n + ":\n" + stringBuffer.toString());
        }
        if (this.calcPartile || this.calcNonPartile) {
            this.lon1 = dArray[0];
            this.lon2 = dArray2[0];
            double d2 = ((double)((int)this.lon1) + this.offset + this.rolloverVal) % this.rolloverVal;
            double d3 = ((double)((int)this.lon1) - this.offset + this.rolloverVal) % this.rolloverVal;
            double d4 = ((double)((int)this.lon2) + this.offset + this.rolloverVal) % this.rolloverVal;
            double d5 = ((double)((int)this.lon2) - this.offset + this.rolloverVal) % this.rolloverVal;
            double d6 = this.lon2 > d2 ? SMath.abs(this.lon2 - d2 - 1.0 + 1.0E-9) : d2 - this.lon2;
            double d7 = this.lon2 > d3 ? SMath.abs(this.lon2 - d3 - 1.0 + 1.0E-9) : d3 - this.lon2;
            double d8 = this.lon1 > d4 ? SMath.abs(this.lon1 - d4 - 1.0 + 1.0E-9) : d4 - this.lon1;
            double d9 = this.lon1 > d5 ? SMath.abs(this.lon1 - d5 - 1.0 + 1.0E-9) : d5 - this.lon1;
            double d10 = SMath.min(SMath.min(SMath.min(d6, d7), d8), d9) % 1.0;
            if (!this.isPartile && this.calcPartile && d10 == 0.0 || this.isPartile && this.calcNonPartile && d10 != 0.0) {
                return this.offset;
            }
            if (((double)((int)dArray[this.idx] - (int)dArray2[this.idx]) + this.rolloverVal) % this.rolloverVal - this.offset == 0.0 || ((double)((int)dArray2[this.idx] - (int)dArray[this.idx]) + this.rolloverVal) % this.rolloverVal - this.offset == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return (dArray[this.idx] % this.rolloverVal - dArray2[this.idx] % this.rolloverVal + this.rolloverVal) % this.rolloverVal;
        }
        if (this.calcYoga) {
            return dArray[this.idx] + dArray2[this.idx];
        }
        return dArray[this.idx] - dArray2[this.idx];
    }

    @Override
    protected double getTimePrecision(double d) {
        double d2 = SMath.min(SMath.abs(this.minSpeed1), SMath.abs(this.minSpeed2));
        double d3 = SMath.min(SMath.abs(this.maxSpeed1), SMath.abs(this.maxSpeed2));
        double d4 = SMath.max(SMath.abs(d2), SMath.abs(d3));
        if (d4 != 0.0) {
            return d / d4;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double d) {
        double d2 = 0.005;
        if (this.idx > 2) {
            d2 = 0.002;
        } else {
            if (this.pl1 >= 0 && this.pl1 <= 5) {
                if (d < 1980.0 || d > 2099.0) {
                    d2 = 0.08;
                }
            } else if (d >= 1900.0 && d < 1980.0) {
                d2 = 0.08;
            } else if (d < 1900.0 || d > 2099.0) {
                d2 = 1.0;
            }
            if (this.pl2 >= 0 && this.pl2 <= 5) {
                if (d < 1980.0 || d > 2099.0) {
                    d2 = SMath.max(0.08, d2);
                }
            } else if (d >= 1900.0 && d < 1980.0) {
                d2 = SMath.max(0.08, d2);
            } else if (d < 1900.0 || d > 2099.0) {
                d2 = SMath.max(1.0, d2);
            }
        }
        d2 /= 3600.0;
        d2 *= 0.5;
        switch (this.idx) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                double d3 = this.pl1 >= this.sw.ext.maxBaryDist.length ? 0.05 : this.sw.ext.maxBaryDist[this.pl1];
                double d4 = this.pl2 >= this.sw.ext.maxBaryDist.length ? 0.05 : this.sw.ext.maxBaryDist[this.pl2];
                d2 *= SMath.max(d3, d4);
            }
        }
        return d2;
    }

    private double checkOffset(double d) {
        if (this.rollover) {
            while (d < 0.0) {
                d += this.rolloverVal;
            }
            d %= this.rolloverVal;
            this.minVal = 0.0;
            this.maxVal = this.rolloverVal;
        } else if (this.idx == 1) {
            while (d < -90.0) {
                d += 180.0;
            }
            while (d > 90.0) {
                d -= 180.0;
            }
            this.minVal = -90.0;
            this.maxVal = 90.0;
        }
        return d;
    }

    private double getSpeed(boolean bl, int n) {
        boolean bl2 = (this.tflags & 0x100000) != 0;
        return this.getSpeed(bl, n, bl2);
    }

    private double getSpeed(boolean bl, int n, boolean bl2) {
        boolean bl3 = (this.tflags & 0x20000) != 0;
        boolean bl4 = (this.tflags & 0x40000) != 0;
        boolean bl5 = (this.tflags & 0x80000) != 0;
        boolean bl6 = (this.tflags & 0x8000) != 0;
        boolean bl7 = (this.tflags & 8) != 0;
        boolean bl8 = (this.tflags & 0x800) != 0 && !bl4 && !bl5;
        boolean bl9 = (this.tflags & 0x800) != 0 && bl4;
        try {
            if (bl6) {
                if (!this.sw.swed.geopos_is_set) {
                    throw new IllegalArgumentException("Geographic position is not set for requested topocentric calculations.");
                }
                if (this.sw.swed.topd.geoalt > 50000.0 || this.sw.swed.topd.geoalt < -1.2E7) {
                    return Double.POSITIVE_INFINITY;
                }
                if (bl2) {
                    if (bl8) {
                        return bl ? SwephData.minTopoRectAccel[n] : SwephData.maxTopoRectAccel[n];
                    }
                    if (bl9) {
                        return bl ? SwephData.minTopoDeclAccel[n] : SwephData.maxTopoDeclAccel[n];
                    }
                    if (bl4) {
                        return bl ? SwephData.minTopoLatAccel[n] : SwephData.maxTopoLatAccel[n];
                    }
                    if (bl5) {
                        return bl ? SwephData.minTopoDistAccel[n] : SwephData.maxTopoDistAccel[n];
                    }
                    if (bl3) {
                        return bl ? SwephData.minTopoLonAccel[n] : SwephData.maxTopoLonAccel[n];
                    }
                } else {
                    if (bl8) {
                        return bl ? SwephData.minTopoRectSpeed[n] : SwephData.maxTopoRectSpeed[n];
                    }
                    if (bl9) {
                        return bl ? SwephData.minTopoDeclSpeed[n] : SwephData.maxTopoDeclSpeed[n];
                    }
                    if (bl4) {
                        return bl ? SwephData.minTopoLatSpeed[n] : SwephData.maxTopoLatSpeed[n];
                    }
                    if (bl5) {
                        return bl ? SwephData.minTopoDistSpeed[n] : SwephData.maxTopoDistSpeed[n];
                    }
                    if (bl3) {
                        return bl ? SwephData.minTopoLonSpeed[n] : SwephData.maxTopoLonSpeed[n];
                    }
                }
            }
            if (bl7) {
                if (bl2) {
                    if (bl8) {
                        return bl ? SwephData.minHelioRectAccel[n] : SwephData.maxHelioRectAccel[n];
                    }
                    if (bl9) {
                        return bl ? SwephData.minHelioDeclAccel[n] : SwephData.maxHelioDeclAccel[n];
                    }
                    if (bl4) {
                        return bl ? SwephData.minHelioLatAccel[n] : SwephData.maxHelioLatAccel[n];
                    }
                    if (bl5) {
                        return bl ? SwephData.minHelioDistAccel[n] : SwephData.maxHelioDistAccel[n];
                    }
                    if (bl3) {
                        return bl ? SwephData.minHelioLonAccel[n] : SwephData.maxHelioLonAccel[n];
                    }
                } else {
                    if (bl8) {
                        return bl ? SwephData.minHelioRectSpeed[n] : SwephData.maxHelioRectSpeed[n];
                    }
                    if (bl9) {
                        return bl ? SwephData.minHelioDeclSpeed[n] : SwephData.maxHelioDeclSpeed[n];
                    }
                    if (bl4) {
                        return bl ? SwephData.minHelioLatSpeed[n] : SwephData.maxHelioLatSpeed[n];
                    }
                    if (bl5) {
                        return bl ? SwephData.minHelioDistSpeed[n] : SwephData.maxHelioDistSpeed[n];
                    }
                    if (bl3) {
                        return bl ? SwephData.minHelioLonSpeed[n] : SwephData.maxHelioLonSpeed[n];
                    }
                }
            }
            if (bl2) {
                if (bl8) {
                    return bl ? SwephData.minRectAccel[n] : SwephData.maxRectAccel[n];
                }
                if (bl9) {
                    return bl ? SwephData.minDeclAccel[n] : SwephData.maxDeclAccel[n];
                }
                if (bl4) {
                    return bl ? SwephData.minLatAccel[n] : SwephData.maxLatAccel[n];
                }
                if (bl5) {
                    return bl ? SwephData.minDistAccel[n] : SwephData.maxDistAccel[n];
                }
                if (bl3) {
                    return bl ? SwephData.minLonAccel[n] : SwephData.maxLonAccel[n];
                }
            } else {
                if (bl8) {
                    return bl ? SwephData.minRectSpeed[n] : SwephData.maxRectSpeed[n];
                }
                if (bl9) {
                    return bl ? SwephData.minDeclSpeed[n] : SwephData.maxDeclSpeed[n];
                }
                if (bl4) {
                    return bl ? SwephData.minLatSpeed[n] : SwephData.maxLatSpeed[n];
                }
                if (bl5) {
                    return bl ? SwephData.minDistSpeed[n] : SwephData.maxDistSpeed[n];
                }
                if (bl3) {
                    return bl ? SwephData.minLonSpeed[n] : SwephData.maxLonSpeed[n];
                }
            }
            return Double.POSITIVE_INFINITY;
        }
        catch (Exception exception) {
            return Double.POSITIVE_INFINITY;
        }
    }

    @Override
    protected boolean checkIdenticalResult(double d, double d2) {
        if (this.calcPartile) {
            boolean bl = (this.lon1 % 1.0 < 1.0E-9 || this.lon2 % 1.0 < 1.0E-9) && (int)(this.lon1 % 30.0) == (int)(this.lon2 % 30.0) && (((double)((int)this.lon1) + d + this.rolloverVal) % this.rolloverVal == (double)((int)this.lon2) || ((double)((int)this.lon1) - d + this.rolloverVal) % this.rolloverVal == (double)((int)this.lon2));
            return bl;
        }
        if (this.calcNonPartile) {
            boolean bl = this.lon1 % 1.0 < 1.0E-9 && this.lon2 % 1.0 < 1.0E-9 || (int)(this.lon1 % 30.0) != (int)(this.lon2 % 30.0) || ((double)((int)this.lon1) + d + this.rolloverVal) % this.rolloverVal != (double)((int)this.lon2) && ((double)((int)this.lon1) - d + this.rolloverVal) % this.rolloverVal != (double)((int)this.lon2);
            return bl;
        }
        return d2 == d;
    }

    @Override
    protected boolean checkResult(double d, double d2, double d3, boolean bl, boolean bl2) {
        if (this.calcPartile) {
            boolean bl3 = (int)(this.lon1 % 30.0) == (int)(this.lon2 % 30.0) && (((double)((int)this.lon1) + d + this.rolloverVal) % this.rolloverVal == (double)((int)this.lon2) || ((double)((int)this.lon1) - d + this.rolloverVal) % this.rolloverVal == (double)((int)this.lon2));
            return bl3;
        }
        if (this.calcNonPartile) {
            boolean bl4 = (int)(this.lon1 % 30.0) != (int)(this.lon2 % 30.0) || ((double)((int)this.lon1) + d + this.rolloverVal) % this.rolloverVal != (double)((int)this.lon2) && ((double)((int)this.lon1) - d + this.rolloverVal) % this.rolloverVal != (double)((int)this.lon2);
            return bl4;
        }
        return super.checkResult(d, d2, d3, bl, bl2);
    }

    @Override
    protected double getNextJD(double d, double d2, double d3, double d4, double d5, boolean bl) {
        if (this.calcPartile || this.calcNonPartile) {
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11;
            if (this.calcPartile) {
                d11 = ((double)((int)this.lon1) + d3 + this.rolloverVal) % this.rolloverVal;
                d10 = ((double)((int)this.lon1) - d3 + this.rolloverVal) % this.rolloverVal;
                double d12 = ((double)((int)this.lon2) + d3 + this.rolloverVal) % this.rolloverVal;
                double d13 = ((double)((int)this.lon2) - d3 + this.rolloverVal) % this.rolloverVal;
                d9 = this.lon2 > d11 ? SMath.abs(this.lon2 - d11 - 1.0 + 1.0E-9) : d11 - this.lon2;
                d8 = this.lon2 > d10 ? SMath.abs(this.lon2 - d10 - 1.0 + 1.0E-9) : d10 - this.lon2;
                d7 = this.lon1 > d12 ? SMath.abs(this.lon1 - d12 - 1.0 + 1.0E-9) : d12 - this.lon1;
                d6 = this.lon1 > d13 ? SMath.abs(this.lon1 - d13 - 1.0 + 1.0E-9) : d13 - this.lon1;
            } else {
                d9 = this.lon1 - (double)((int)this.lon1);
                d8 = 1.0 - d9;
                d7 = this.lon2 - (double)((int)this.lon2);
                d6 = 1.0 - d7;
                d9 += 1.0E-9;
                d8 += 1.0E-9;
                d7 += 1.0E-9;
                d6 += 1.0E-9;
            }
            d11 = SMath.abs(this.maxSpeed2 - this.minSpeed1);
            d11 = SMath.max(d11, SMath.abs(this.maxSpeed1 - this.minSpeed2));
            d10 = SMath.min(SMath.min(SMath.min(d9, d8), d7), d6) % 1.0;
            double d14 = SMath.abs(d10 / d11);
            return d + (bl ? -d14 : d14);
        }
        return super.getNextJD(d, d2, d3, d4, d5, bl);
    }

    double[] getTestspeed(int n, int n2, int n3, double d) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double[] dArray = new double[]{625000.5, 2818000.5};
        if (n > 10000) {
            object2 = SwissLib.swi_gen_filename(2457264.5, n);
            object = null;
            SwissephException swissephException = null;
            try {
                object = this.sw.swi_fopen(3, (String)object2, this.sw.swed.ephepath, stringBuffer);
            }
            catch (SwissephException swissephException2) {
                swissephException = swissephException2;
            }
            if (object == null) {
                if (((String)object2).indexOf("s.") <= 0) {
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf(".")) + "s." + "se1";
                }
                try {
                    object = this.sw.swi_fopen(3, (String)object2, this.sw.swed.ephepath, stringBuffer);
                }
                catch (SwissephException swissephException3) {
                    swissephException = swissephException3;
                }
            }
            if (object == null) {
                throw swissephException;
            }
            try {
                object.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dArray = this.sw.getDatafileTimerange((String)object2);
            }
            catch (SwissephException swissephException4) {
                // empty catch block
            }
        }
        object2 = new Random();
        object = new double[6];
        for (int i = 0; i < n3; ++i) {
            double d4 = ((Random)object2).nextDouble();
            int n4 = this.sw.swe_calc(d4 = d4 * (dArray[1] - dArray[0]) + dArray[0], n, this.flags | 0x100, (double[])object, stringBuffer);
            if (n4 < 0) continue;
            if (d2 > object[n2 + 3]) {
                d2 = object[n2 + 3];
            }
            if (!(d3 < object[n2 + 3])) continue;
            d3 = object[n2 + 3];
        }
        if (d2 == d3 || d2 == Double.MAX_VALUE || d3 == -1.7976931348623157E308) {
            d2 = Double.POSITIVE_INFINITY;
        } else {
            switch ((int)Math.signum(d2)) {
                case -1: {
                    d2 *= d;
                    break;
                }
                case 0: {
                    d2 = -0.1;
                    break;
                }
                case 1: {
                    d2 /= d;
                }
            }
            switch ((int)Math.signum(d3)) {
                case -1: {
                    d3 /= d;
                    break;
                }
                case 0: {
                    d3 = 0.1;
                    break;
                }
                case 1: {
                    d3 *= d;
                }
            }
        }
        return new double[]{d2, d3};
    }

    public String toString() {
        return "[Planets:" + this.pl1 + "/" + this.pl2 + "];Offset:" + this.getOffset();
    }
}

