/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.Serializable;
import java.util.Random;
import swisseph.SMath;
import swisseph.SweDate;
import swisseph.SwephData;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;
import swisseph.TransitBase;
import swisseph.TransitCalculator;

public class TCPlanetHouse
extends TransitCalculator
implements Serializable {
    int precalcCount = 100;
    private int planet;
    private int idx = 0;
    private int transitFlags = 0;
    private int planetFlags = 0;
    private int houseObject = 0;
    private int houseSystem = 0;
    private int houseFlags = 0;
    private double houseGeolon;
    private double houseGeolat;
    private double minSpeed1;
    private double maxSpeed1;
    private double minSpeed2;
    private double maxSpeed2;
    private double minSpeed;
    private double maxSpeed;
    private double offset = 0.0;

    public TCPlanetHouse(SwissEph swissEph, int n, int n2, int n3, int n4, int n5, double d, double d2, double d3) {
        this(swissEph, n, n2, n3, n4, n5, d, d2, d3, 200, 1.4);
    }

    public TCPlanetHouse(SwissEph swissEph, int n, int n2, int n3, int n4, int n5, double d, double d2, double d3, int n6, double d4) {
        this.sw = swissEph;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        n6 = Math.max(n6, 100);
        d4 = Math.max(d4, 1.1);
        this.transitFlags = (n2 | n5) & 0x20000;
        int n7 = 232991;
        if ((n2 & 8) != 0) {
            n7 |= 0x600;
        }
        if ((n2 & ~n7) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (n2 & ~n7));
        }
        if (this.transitFlags != 131072) {
            throw new IllegalArgumentException("Invalid flag combination (" + n2 + " or " + n5 + "): only SEFLG_TRANSIT_LONGITUDE (" + 131072 + ") is allowed as transit method.");
        }
        if ((n2 & 8) != 0 && (n == 12 || n == 13 || n == 10 || n == 11)) {
            throw new IllegalArgumentException("Unsupported planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ") for heliocentric calculations");
        }
        int n8 = 229383;
        if ((n5 & ~n8) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (n5 & ~n8));
        }
        int n9 = n3 & 0xFFFFFFFF;
        if (n9 != -1 && n9 != -2 && n9 != -3 && n9 != -4 && n9 != -5 && n9 != -6 && n9 != -7 && n9 != -8 && n9 != -9 && n9 != -10 && n9 != -11 && n9 != -12 && n9 != 0 && n9 != 1 && n9 != 2 && n9 != 3 && n9 != 4 && n9 != 5 && n9 != 6 && n9 != 7) {
            throw new IllegalArgumentException("Invalid or multiple house objects given: " + n9);
        }
        if (n4 != 80 && n4 != 75 && n4 != 79 && n4 != 82 && n4 != 67 && n4 != 69 && n4 != 86 && n4 != 88 && n4 != 72 && n4 != 84 && n4 != 66 && n4 != 77 && n4 != 85 && n4 != 87) {
            throw new IllegalArgumentException("Unsupported house system '" + n4 + "'.");
        }
        this.planet = n;
        this.planetFlags = n2 &= 0xFFFDFFFF;
        this.houseObject = n3;
        this.houseSystem = n4;
        this.houseFlags = n5 &= 0xFFFDFFFF;
        this.houseGeolon = d;
        this.houseGeolat = d2;
        this.rollover = true;
        this.offset = d3;
        this.maxSpeed1 = this.getSpeed(false, n);
        this.minSpeed1 = this.getSpeed(true, n);
        this.maxSpeed2 = TransitBase.getHouseSpeed(false, n4, n3, d2);
        this.minSpeed2 = TransitBase.getHouseSpeed(true, n4, n3, d2);
        if ((Double.isInfinite(this.maxSpeed1) || Double.isInfinite(this.minSpeed1)) && this.idx < 3) {
            double[] dArray = this.getTestspeed(n, this.idx, n6, d4);
            this.minSpeed1 = dArray[0];
            this.maxSpeed1 = dArray[1];
        }
        if (Double.isInfinite(this.maxSpeed1) || Double.isInfinite(this.minSpeed1)) {
            throw new IllegalArgumentException(((n2 & 0x8000) != 0 ? "Topo" : ((n2 & 8) != 0 ? "Helio" : "Geo")) + "centric transit calculations with planet number " + n + " (" + swissEph.swe_get_planet_name(n) + ") not possible: extreme speeds of the planet " + ((n2 & 0x800) != 0 ? "in equatorial system " : "") + "not available.");
        }
        if (Double.isInfinite(this.maxSpeed2) || Double.isInfinite(this.minSpeed2)) {
            // empty if block
        }
        if (Double.isInfinite(this.maxSpeed2) || Double.isInfinite(this.minSpeed2)) {
            throw new IllegalArgumentException(((n5 & 0x8000) != 0 ? "Topo" : ((n5 & 8) != 0 ? "Helio" : "Geo")) + "centric transit calculations with house object " + n3 + " (" + SwissEph.getHouseobjectname(n3) + ") not possible: extreme " + ((n5 & 0x100) != 0 ? "accelerations" : "speeds") + " of the house system " + ((n5 & 0x800) != 0 ? "in equatorial system " : "") + "not available.");
        }
        this.minSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.minSpeed1 - this.maxSpeed2 : this.minSpeed2 - this.maxSpeed1;
        this.maxSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.maxSpeed1 - this.minSpeed2 : this.maxSpeed2 - this.minSpeed1;
        swissEph.swe_set_topo(d, d2, 0.0);
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public void setOffset(double d) {
        this.offset = d;
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    public Object[] getObjectIdentifiers() {
        return new String[]{"" + this.planet, "" + this.houseObject, "" + this.houseSystem};
    }

    @Override
    protected double getMaxSpeed() {
        return this.maxSpeed;
    }

    @Override
    protected double getMinSpeed() {
        return this.minSpeed;
    }

    @Override
    protected double calc(double d) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[6];
        double[] dArray2 = new double[this.houseSystem == 71 ? 37 : 13];
        double[] dArray3 = new double[10];
        int n = this.sw.swe_calc(d, this.planet, this.planetFlags, dArray, stringBuffer);
        if (n < 0) {
            int n2 = 0;
            if (stringBuffer.toString().matches("jd 2488117.1708818264 > Swiss Eph. upper limit 2487932.5;")) {
                n2 = 786432;
            }
            System.err.println("SERR: " + stringBuffer);
            throw new SwissephException(d, n2, "Calculation failed with return code " + n + ":\n" + stringBuffer.toString());
        }
        n = this.sw.swe_houses(d - SweDate.getDeltaT(d), this.houseFlags, this.houseGeolat, this.houseGeolon, this.houseSystem, dArray2, dArray3);
        if (n < 0) {
            throw new SwissephException(d, 0, "Calculation failed with return code " + n + ".");
        }
        double d2 = 0.0;
        d2 = this.houseObject < 0 ? dArray2[Math.abs(this.houseObject)] : dArray3[this.houseObject];
        return dArray[0] - d2;
    }

    @Override
    protected double getTimePrecision(double d) {
        double d2 = SMath.min(SMath.abs(this.minSpeed1), SMath.abs(this.minSpeed2));
        double d3 = SMath.min(SMath.abs(this.maxSpeed1), SMath.abs(this.maxSpeed2));
        double d4 = SMath.max(SMath.abs(d2), SMath.abs(d3));
        if (d4 != 0.0) {
            return d / d4;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double d) {
        double d2 = 0.005;
        if (this.idx > 2) {
            d2 = 0.002;
        } else if (this.planet >= 0 && this.planet <= 5) {
            if (d < 1980.0 || d > 2099.0) {
                d2 = 0.08;
            }
        } else if (d >= 1900.0 && d < 1980.0) {
            d2 = 0.08;
        } else if (d < 1900.0 || d > 2099.0) {
            d2 = 1.0;
        }
        d2 /= 3600.0;
        return d2 *= 0.5;
    }

    private double getSpeed(boolean bl, int n) {
        boolean bl2 = (this.transitFlags & 0x20000) != 0;
        boolean bl3 = (this.planetFlags & 0x8000) != 0;
        boolean bl4 = (this.planetFlags & 8) != 0;
        boolean bl5 = (this.planetFlags & 0x800) != 0;
        try {
            if (bl3) {
                if (!this.sw.swed.geopos_is_set) {
                    throw new IllegalArgumentException("Geographic position is not set for requested topocentric calculations.");
                }
                if (this.sw.swed.topd.geoalt > 50000.0 || this.sw.swed.topd.geoalt < -1.2E7) {
                    return Double.POSITIVE_INFINITY;
                }
                if (bl5) {
                    return bl ? SwephData.minTopoRectSpeed[n] : SwephData.maxTopoRectSpeed[n];
                }
                if (bl2) {
                    return bl ? SwephData.minTopoLonSpeed[n] : SwephData.maxTopoLonSpeed[n];
                }
            }
            if (bl4) {
                if (bl5) {
                    return bl ? SwephData.minHelioRectSpeed[n] : SwephData.maxHelioRectSpeed[n];
                }
                if (bl2) {
                    return bl ? SwephData.minHelioLonSpeed[n] : SwephData.maxHelioLonSpeed[n];
                }
            }
            if (bl5) {
                return bl ? SwephData.minRectSpeed[n] : SwephData.maxRectSpeed[n];
            }
            if (bl2) {
                return bl ? SwephData.minLonSpeed[n] : SwephData.maxLonSpeed[n];
            }
            return Double.POSITIVE_INFINITY;
        }
        catch (Exception exception) {
            return Double.POSITIVE_INFINITY;
        }
    }

    @Override
    protected boolean checkIdenticalResult(double d, double d2) {
        return d2 == d;
    }

    double[] getTestspeed(int n, int n2, int n3, double d) {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        double d2 = Double.MAX_VALUE;
        double d3 = -1.7976931348623157E308;
        double[] dArray = new double[]{625000.5, 2818000.5};
        if (n > 10000) {
            object2 = SwissLib.swi_gen_filename(2457264.5, n);
            object = null;
            SwissephException swissephException = null;
            try {
                object = this.sw.swi_fopen(3, (String)object2, this.sw.swed.ephepath, stringBuffer);
            }
            catch (SwissephException swissephException2) {
                swissephException = swissephException2;
            }
            if (object == null) {
                if (((String)object2).indexOf("s.") <= 0) {
                    object2 = ((String)object2).substring(0, ((String)object2).indexOf(".")) + "s." + "se1";
                }
                try {
                    object = this.sw.swi_fopen(3, (String)object2, this.sw.swed.ephepath, stringBuffer);
                }
                catch (SwissephException swissephException3) {
                    swissephException = swissephException3;
                }
            }
            if (object == null) {
                throw swissephException;
            }
            try {
                object.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dArray = this.sw.getDatafileTimerange((String)object2);
            }
            catch (SwissephException swissephException4) {
                // empty catch block
            }
        }
        object2 = new Random();
        object = new double[6];
        for (int i = 0; i < n3; ++i) {
            double d4 = ((Random)object2).nextDouble();
            int n4 = this.sw.swe_calc(d4 = d4 * (dArray[1] - dArray[0]) + dArray[0], n, this.planetFlags | 0x100, (double[])object, stringBuffer);
            if (n4 < 0) continue;
            if (d2 > object[n2 + 3]) {
                d2 = object[n2 + 3];
            }
            if (!(d3 < object[n2 + 3])) continue;
            d3 = object[n2 + 3];
        }
        if (d2 == d3 || d2 == Double.MAX_VALUE || d3 == -1.7976931348623157E308) {
            d2 = Double.POSITIVE_INFINITY;
        } else {
            switch ((int)Math.signum(d2)) {
                case -1: {
                    d2 *= d;
                    break;
                }
                case 0: {
                    d2 = -0.1;
                    break;
                }
                case 1: {
                    d2 /= d;
                }
            }
            switch ((int)Math.signum(d3)) {
                case -1: {
                    d3 /= d;
                    break;
                }
                case 0: {
                    d3 = 0.1;
                    break;
                }
                case 1: {
                    d3 *= d;
                }
            }
        }
        return new double[]{d2, d3};
    }

    public String toString() {
        return "[Planet/house/house system:" + this.planet + "/" + this.houseObject + "/" + this.houseSystem + "];Offset:" + this.getOffset();
    }
}

