/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import swisseph.DblObj;
import swisseph.Epsilon;
import swisseph.Extensions;
import swisseph.FileData;
import swisseph.FilePtr;
import swisseph.MeffEle;
import swisseph.Nut;
import swisseph.PlanData;
import swisseph.SMath;
import swisseph.SavePositions;
import swisseph.SidData;
import swisseph.SweDate;
import swisseph.SweHouse;
import swisseph.Swecl;
import swisseph.Swemmoon;
import swisseph.SwephData;
import swisseph.SwephJPL;
import swisseph.SwephMosh;
import swisseph.SwissData;
import swisseph.SwissLib;
import swisseph.SwissephException;
import swisseph.TCHouses;
import swisseph.TransitCalculator;

public class SwissEph
implements Serializable {
    SwissData swed;
    SwephMosh smosh;
    SwephJPL sj;
    SwissLib sl;
    Swecl sc = null;
    Swemmoon sm;
    SweHouse sh = null;
    Extensions ext = null;
    double lastLat = 0.0;
    double lastLong = 0.0;
    int lastHSys = -1;
    private int httpBufSize = 300;
    private int swe_calc_epheflag_sv = 0;
    String slast_stardata;
    String slast_starname;
    static final MeffEle[] eff_arr = new MeffEle[]{new MeffEle(1.0, 1.0), new MeffEle(0.99, 0.999979), new MeffEle(0.98, 0.99994), new MeffEle(0.97, 0.999881), new MeffEle(0.96, 0.999811), new MeffEle(0.95, 0.999724), new MeffEle(0.94, 0.999622), new MeffEle(0.93, 0.999497), new MeffEle(0.92, 0.999354), new MeffEle(0.91, 0.999192), new MeffEle(0.9, 0.999), new MeffEle(0.89, 0.998786), new MeffEle(0.88, 0.998535), new MeffEle(0.87, 0.998242), new MeffEle(0.86, 0.997919), new MeffEle(0.85, 0.997571), new MeffEle(0.84, 0.997198), new MeffEle(0.83, 0.996792), new MeffEle(0.82, 0.996316), new MeffEle(0.81, 0.995791), new MeffEle(0.8, 0.995226), new MeffEle(0.79, 0.994625), new MeffEle(0.78, 0.993991), new MeffEle(0.77, 0.993326), new MeffEle(0.76, 0.992598), new MeffEle(0.75, 0.99177), new MeffEle(0.74, 0.990873), new MeffEle(0.73, 0.989919), new MeffEle(0.72, 0.988912), new MeffEle(0.71, 0.987856), new MeffEle(0.7, 0.986755), new MeffEle(0.69, 0.98561), new MeffEle(0.68, 0.984398), new MeffEle(0.67, 0.982986), new MeffEle(0.66, 0.981437), new MeffEle(0.65, 0.979779), new MeffEle(0.64, 0.978024), new MeffEle(0.63, 0.976182), new MeffEle(0.62, 0.974256), new MeffEle(0.61, 0.972253), new MeffEle(0.6, 0.970174), new MeffEle(0.59, 0.968024), new MeffEle(0.58, 0.965594), new MeffEle(0.57, 0.962797), new MeffEle(0.56, 0.959758), new MeffEle(0.55, 0.956515), new MeffEle(0.54, 0.953088), new MeffEle(0.53, 0.949495), new MeffEle(0.52, 0.945741), new MeffEle(0.51, 0.941838), new MeffEle(0.5, 0.93779), new MeffEle(0.49, 0.933563), new MeffEle(0.48, 0.928668), new MeffEle(0.47, 0.923288), new MeffEle(0.46, 0.917527), new MeffEle(0.45, 0.911432), new MeffEle(0.44, 0.905035), new MeffEle(0.43, 0.898353), new MeffEle(0.42, 0.891022), new MeffEle(0.41, 0.88294), new MeffEle(0.4, 0.874312), new MeffEle(0.39, 0.865206), new MeffEle(0.38, 0.855423), new MeffEle(0.37, 0.844619), new MeffEle(0.36, 0.833074), new MeffEle(0.35, 0.820876), new MeffEle(0.34, 0.808031), new MeffEle(0.33, 0.793962), new MeffEle(0.32, 0.778931), new MeffEle(0.31, 0.763021), new MeffEle(0.3, 0.745815), new MeffEle(0.29, 0.727557), new MeffEle(0.28, 0.708234), new MeffEle(0.27, 0.687583), new MeffEle(0.26, 0.665741), new MeffEle(0.25, 0.642597), new MeffEle(0.24, 0.618252), new MeffEle(0.23, 0.592586), new MeffEle(0.22, 0.565747), new MeffEle(0.21, 0.537697), new MeffEle(0.2, 0.508554), new MeffEle(0.19, 0.47842), new MeffEle(0.18, 0.447322), new MeffEle(0.17, 0.415454), new MeffEle(0.16, 0.382892), new MeffEle(0.15, 0.349955), new MeffEle(0.14, 0.316691), new MeffEle(0.13, 0.283565), new MeffEle(0.12, 0.250431), new MeffEle(0.11, 0.218327), new MeffEle(0.1, 0.186794), new MeffEle(0.09, 0.156287), new MeffEle(0.08, 0.128421), new MeffEle(0.07, 0.102237), new MeffEle(0.06, 0.077393), new MeffEle(0.05, 0.054833), new MeffEle(0.04, 0.036361), new MeffEle(0.03, 0.020953), new MeffEle(0.02, 0.009645), new MeffEle(0.01, 0.002767), new MeffEle(0.0, 0.0)};
    int chck_nut_nutflag = 0;

    public SwissEph() {
        this(null);
    }

    public SwissEph(String string) {
        if (this.swed == null) {
            this.swed = new SwissData();
        }
        SweDate.setSwissEphObject(this);
        this.sl = new SwissLib(this.swed);
        this.sm = new Swemmoon(this.swed, this.sl);
        this.smosh = new SwephMosh(this.sl, this, this.swed);
        this.sj = new SwephJPL(this, this.swed, this.sl);
        this.swed.ephe_path_is_set = false;
        this.swed.jpl_file_is_open = false;
        this.swed.fixfp = null;
        this.swed.ephepath = ".:./ephe:/users/ephe2/:/users/ephe/";
        this.swed.jplfnam = "de431.eph";
        this.swed.geopos_is_set = false;
        this.swed.ayana_is_set = false;
        this.swe_set_ephe_path(string);
    }

    public void setHttpBufSize(int n) {
        this.httpBufSize = n;
        if (n < 100) {
            this.httpBufSize = 100;
        }
        this.swe_close();
    }

    public String swe_version() {
        return "2.01.00";
    }

    public String swe_java_version() {
        return "2.01.00_02";
    }

    public int swe_calc_ut(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        int n3 = 0;
        SweDate.swi_set_tid_acc(d, n2, 0);
        double d2 = SweDate.getDeltaT(d);
        n3 = this.swe_calc(d + d2, n, n2, dArray, stringBuffer);
        return n3;
    }

    public int swe_calc(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        int n3;
        block2: {
            n3 = 0;
            try {
                n3 = this._calc(d, n, n2, dArray, stringBuffer);
            }
            catch (SwissephException swissephException) {
                n3 = -1;
                if (stringBuffer == null) break block2;
                stringBuffer.setLength(0);
                stringBuffer.append(swissephException.getMessage());
            }
        }
        return n3;
    }

    public int calc(double d, int n, int n2, double[] dArray) throws SwissephException {
        return this._calc(d, n, n2, dArray, new StringBuffer());
    }

    private int _calc(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) throws SwissephException {
        int n3;
        int n4;
        int n5 = n2;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[24];
        double[] dArray4 = new double[24];
        if (n == 144340) {
            n = 9;
        }
        if (((n4 = n2 & 7) & 2) != 0) {
            n4 = 0;
        }
        if (this.swe_calc_epheflag_sv != n4 && n != -1) {
            this.free_planets();
            this.swe_calc_epheflag_sv = n4;
        }
        if ((n2 & 0x80) != 0 && (n2 & 0x100) != 0) {
            n2 &= 0xFFFFFF7F;
        }
        if ((n2 & 0x1000) != 0 && (n2 & 0x2000) != 0) {
            n2 &= 0xFFFFDFFF;
        }
        SavePositions savePositions = n < 23 && n >= 0 ? this.swed.savedat[n] : this.swed.savedat[23];
        int n6 = 14336;
        try {
            if (savePositions.tsave != d || d == 0.0 || n != savePositions.ipl || (savePositions.iflgsave & ~n6) != (n2 & ~n6)) {
                if ((n2 & 0x80) == 0) {
                    savePositions.tsave = d;
                    savePositions.ipl = n;
                    savePositions.iflgsave = this.swecalc(d, n, n2, savePositions.xsaves, stringBuffer);
                    if (savePositions.iflgsave == -1) {
                        return this.swe_calc_error(dArray);
                    }
                } else {
                    double d2;
                    savePositions.tsave = d;
                    savePositions.ipl = n;
                    switch (n) {
                        case 1: {
                            d2 = 5.0E-5;
                            break;
                        }
                        case 11: 
                        case 13: {
                            d2 = 0.1;
                            break;
                        }
                        default: {
                            d2 = 1.0E-4;
                        }
                    }
                    savePositions.iflgsave = this.swecalc(d - d2, n, n2, dArray3, stringBuffer);
                    if (savePositions.iflgsave == -1) {
                        return this.swe_calc_error(dArray);
                    }
                    savePositions.iflgsave = this.swecalc(d + d2, n, n2, dArray4, stringBuffer);
                    if (savePositions.iflgsave == -1) {
                        return this.swe_calc_error(dArray);
                    }
                    savePositions.iflgsave = this.swecalc(d, n, n2, savePositions.xsaves, stringBuffer);
                    if (savePositions.iflgsave == -1) {
                        return this.swe_calc_error(dArray);
                    }
                    this.denormalize_positions(dArray3, savePositions.xsaves, dArray4);
                    this.calc_speed(dArray3, savePositions.xsaves, dArray4, d2);
                }
            }
        }
        catch (SwissephException swissephException) {
            savePositions.iflgsave = -1;
            this.swe_calc_error(dArray);
            throw swissephException;
        }
        int n7 = 0;
        double[] dArray5 = savePositions.xsaves;
        if ((n2 & 0x800) != 0) {
            n7 = 12;
        }
        if ((n2 & 0x1000) != 0) {
            n7 += 6;
        }
        int n8 = n == -1 ? 4 : 3;
        for (n3 = 0; n3 < n8; ++n3) {
            dArray2[n3] = dArray5[n3 + n7];
        }
        for (n3 = n8; n3 < 6; ++n3) {
            dArray2[n3] = 0.0;
        }
        if ((n2 & 0x180) != 0) {
            for (n3 = 3; n3 < 6; ++n3) {
                dArray2[n3] = dArray5[n3 + n7];
            }
        }
        if ((n2 & 0x2000) != 0) {
            if (n == -1) {
                n3 = 0;
                while (n3 < 4) {
                    int n9 = n3++;
                    dArray2[n9] = dArray2[n9] * 0.0174532925199433;
                }
            } else {
                n3 = 0;
                while (n3 < 2) {
                    int n10 = n3++;
                    dArray2[n10] = dArray2[n10] * 0.0174532925199433;
                }
                if ((n2 & 0x180) != 0) {
                    n3 = 3;
                    while (n3 < 5) {
                        int n11 = n3++;
                        dArray2[n11] = dArray2[n11] * 0.0174532925199433;
                    }
                }
            }
        }
        for (n8 = 0; n8 <= 5; ++n8) {
            dArray[n8] = dArray2[n8];
        }
        n2 = savePositions.iflgsave;
        if ((n5 & 7) == 0) {
            n2 &= 0xFFFFFFFD;
        }
        return n2;
    }

    private void free_planets() {
        try {
            int n;
            for (n = 0; n < 18; ++n) {
                this.swed.pldat[n].clearData();
            }
            for (n = 0; n <= 23; ++n) {
                this.swed.savedat[n].clearData();
            }
            for (n = 0; n < 6; ++n) {
                this.swed.nddat[n].clearData();
            }
            this.swed.oec.clearData();
            this.swed.oec2000.clearData();
            this.swed.nut.clearData();
            this.swed.nut2000.clearData();
            this.swed.nutv.clearData();
            this.sj.swi_close_jpl_file();
            this.swed.jpl_file_is_open = false;
            this.swed.jpldenum = 0;
            if (this.swed.fixfp != null) {
                this.swed.fixfp.close();
                this.swed.fixfp = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void swe_close() {
        for (int i = 0; i < 7; ++i) {
            if (this.swed.fidat[i].fptr != null) {
                try {
                    this.swed.fidat[i].fptr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.swed.fidat[i].clearData();
        }
        this.free_planets();
        this.swed.oec.clearData();
        this.swed.oec2000.clearData();
        this.swed.nut.clearData();
        this.swed.nut2000.clearData();
        this.swed.nutv.clearData();
        Arrays.fill(this.swed.astro_models, 0);
        this.sj.swi_close_jpl_file();
        this.swed.jpl_file_is_open = false;
        this.swed.jpldenum = 0;
        if (this.swed.fixfp != null) {
            try {
                this.swed.fixfp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.swed.fixfp = null;
        }
        SweDate.swe_set_tid_acc(999999.0);
        this.swed.geopos_is_set = false;
        this.swed.ayana_is_set = false;
        this.swed.is_old_starfile = false;
        this.swed.i_saved_planet_name = 0;
        this.swed.saved_planet_name = "";
        this.swed.topd.clearData();
        this.swed.sidd.clearData();
        this.swed.timeout = 0;
        this.swed.dpsi = null;
        this.swed.deps = null;
    }

    public void swe_set_ephe_path(String string) {
        if (string == null) {
            return;
        }
        String string2 = "";
        double[] dArray = new double[6];
        this.swed.ephe_path_is_set = true;
        this.swe_close();
        string2 = string == null || string.length() == 0 ? ".:./ephe:/users/ephe2/:/users/ephe/" : (string.length() <= 242 ? string : ".:./ephe:/users/ephe2/:/users/ephe/");
        this.swed.ephepath = string2;
        int n = 131122;
        this.swe_calc(2451545.0, 1, n, dArray, null);
        if (this.swed.fidat[1].fptr != null) {
            SweDate.swi_set_tid_acc(0.0, 0, this.swed.fidat[1].sweph_denum);
        }
    }

    void load_dpsi_deps() {
        FilePtr filePtr;
        String[] stringArray = new String[20];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double d = 2400000.5;
        if (this.swed.eop_dpsi_loaded > 0) {
            return;
        }
        try {
            filePtr = this.swi_fopen(-1, "eop_1962_today.txt", this.swed.ephepath, null);
        }
        catch (SwissephException swissephException) {
            this.swed.eop_dpsi_loaded = -1;
            return;
        }
        this.swed.dpsi = new double[36525];
        this.swed.deps = new double[36525];
        this.swed.eop_tjd_beg_horizons = 2437684.5;
        try {
            String string;
            while ((string = filePtr.readLine()) != null) {
                int n4 = this.sl.swi_cutstr(string, " ", stringArray, 16);
                int n5 = SwissLib.atoi(stringArray[0]);
                if (n5 == 0) continue;
                n2 = SwissLib.atoi(stringArray[3]);
                if (n3 > 0 && n2 - n3 != 1) {
                    this.swed.eop_dpsi_loaded = -2;
                    filePtr.close();
                    return;
                }
                if (n == 0) {
                    this.swed.eop_tjd_beg = (double)n2 + d;
                }
                this.swed.dpsi[n] = SwissLib.atof(stringArray[8]);
                this.swed.deps[n] = SwissLib.atof(stringArray[9]);
                ++n;
                n3 = n2;
            }
            this.swed.eop_tjd_end = (double)n2 + d;
            this.swed.eop_dpsi_loaded = 1;
            filePtr.close();
            try {
                filePtr = this.swi_fopen(-1, "eop_finals.txt", this.swed.ephepath, null);
            }
            catch (SwissephException swissephException) {
                return;
            }
            while ((string = filePtr.readLine()) != null) {
                n2 = SwissLib.atoi(string.substring(7));
                if ((double)n2 + d <= this.swed.eop_tjd_end) continue;
                if (n >= 36525) {
                    return;
                }
                if (n3 > 0 && n2 - n3 != 1) {
                    this.swed.eop_dpsi_loaded = -3;
                    filePtr.close();
                    return;
                }
                double d2 = SwissLib.atof(string + 168);
                double d3 = SwissLib.atof(string + 178);
                if (d2 == 0.0) {
                    d2 = SwissLib.atof(string + 99);
                    d3 = SwissLib.atof(string + 118);
                }
                if (d2 == 0.0) {
                    this.swed.eop_dpsi_loaded = 2;
                    filePtr.close();
                    return;
                }
                this.swed.eop_tjd_end = (double)n2 + d;
                this.swed.dpsi[n] = d2 / 1000.0;
                this.swed.deps[n] = d3 / 1000.0;
                ++n;
                n3 = n2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.swed.eop_dpsi_loaded = 2;
        try {
            filePtr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void swe_set_jpl_file(String string) {
        int n;
        double[] dArray = new double[3];
        this.swe_close();
        if (string.indexOf(SwissData.DIR_GLUE) >= 0) {
            string = string.substring(string.lastIndexOf(SwissData.DIR_GLUE));
        }
        if (string.length() >= 256) {
            string = string.substring(0, 256);
        }
        this.swed.jplfnam = string;
        if (!this.swed.jpl_file_is_open && (n = this.open_jpl_file(dArray, this.swed.jplfnam, this.swed.ephepath, null)) == 0 && this.swed.jpldenum >= 403) {
            this.load_dpsi_deps();
        }
    }

    public void swe_set_sid_mode(int n) {
        this.swe_set_sid_mode(n, 0.0, 0.0);
    }

    public void swe_set_sid_mode(int n, double d, double d2) {
        if (n < 0) {
            n = 0;
        }
        SidData sidData = this.swed.sidd;
        sidData.sid_mode = n;
        if (n >= 256) {
            n %= 256;
        }
        if (n == 18 || n == 19 || n == 20) {
            sidData.sid_mode &= 0xFFFFFDFF;
            sidData.sid_mode |= 0x100;
        }
        if (n == 27 || n == 28) {
            sidData.sid_mode &= 0xFFFFFCFF;
        }
        if (n >= 30 && n != 255) {
            n = 0;
            sidData.sid_mode = 0;
        }
        this.swed.ayana_is_set = true;
        if (n == 255) {
            sidData.t0 = d;
            sidData.ayan_t0 = d2;
        } else {
            sidData.t0 = SwephData.ayanamsa[n].t0;
            sidData.ayan_t0 = SwephData.ayanamsa[n].ayan_t0;
        }
        this.swi_force_app_pos_etc();
    }

    public double swe_get_ayanamsa(double d) {
        double[] dArray = new double[6];
        SidData sidData = this.swed.sidd;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (!this.swed.ayana_is_set) {
            this.swe_set_sid_mode(0, 0.0, 0.0);
        }
        if (sidData.sid_mode == 27) {
            stringBuffer.append("Spica");
            this.swe_fixstar(stringBuffer, d, 64, dArray, null);
            return this.sl.swe_degnorm(dArray[0] - 180.0);
        }
        if (sidData.sid_mode == 28) {
            stringBuffer.append(",zePsc");
            this.swe_fixstar(stringBuffer, d, 64, dArray, null);
            return this.sl.swe_degnorm(dArray[0]);
        }
        if (sidData.sid_mode == 29) {
            stringBuffer.append(",deCnc");
            this.swe_fixstar(stringBuffer, d, 64, dArray, null);
            return this.sl.swe_degnorm(dArray[0] - 106.0);
        }
        dArray[0] = 1.0;
        dArray[2] = 0.0;
        dArray[1] = 0.0;
        if (d != 2451545.0) {
            this.sl.swi_precess(dArray, d, 0, 1);
        }
        this.sl.swi_precess(dArray, sidData.t0, 0, -1);
        double d2 = this.sl.swi_epsiln(sidData.t0, 0);
        this.sl.swi_coortrf(dArray, dArray, d2);
        this.sl.swi_cartpol(dArray, dArray);
        dArray[0] = dArray[0] * 57.2957795130823 - sidData.ayan_t0;
        return this.sl.swe_degnorm(-dArray[0]);
    }

    public double swe_get_ayanamsa_ut(double d) {
        return this.swe_get_ayanamsa(d + SweDate.getDeltaT(d));
    }

    public int swe_fixstar(StringBuffer stringBuffer, double d, int n, double[] dArray, StringBuffer stringBuffer2) {
        int n2 = n |= 0x100;
        if (stringBuffer2 != null) {
            stringBuffer2.setLength(0);
        }
        if (((n = this.plaus_iflag(n, -1, d, stringBuffer2)) & 0x10000) != 0 && !this.swed.ayana_is_set) {
            this.swe_set_sid_mode(0, 0.0, 0.0);
        }
        int n3 = n & 7;
        this.swi_check_ecliptic(d, n);
        this.swi_check_nutation(d, n);
        String[] stringArray = this.readFixstarParameters(stringBuffer, stringBuffer2);
        if (stringArray != null) {
            return this.swe_fixstar_found(stringBuffer2, stringArray[1], stringBuffer, Integer.parseInt(stringArray[0]), d, n, n2, n3, dArray);
        }
        return this.swe_fixstar_error(dArray, -1);
    }

    protected String[] readFixstarParameters(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        String string = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        string = stringBuffer.toString().substring(0, SMath.min(stringBuffer.length(), 256));
        if (string.length() > 0) {
            if (string.charAt(0) == ',') {
                bl = true;
            } else if (Character.isDigit(string.charAt(0))) {
                n = Integer.parseInt(string);
            } else {
                if (string.indexOf(44) >= 0) {
                    string = string.substring(0, string.indexOf(44));
                }
                string = string.toLowerCase();
            }
            string = string.trim();
        }
        if (string.length() == 0) {
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("swe_fixstar(): star name empty");
            }
            return null;
        }
        if (this.slast_stardata != null && this.slast_starname.equals(string)) {
            String string2 = this.slast_stardata;
            return new String[]{"" + n2, string2};
        }
        if (this.swed.fixfp == null) {
            int n4 = 3;
            try {
                this.swed.fixfp = this.swi_fopen(4, "sefstars.txt", this.swed.ephepath, stringBuffer2);
            }
            catch (SwissephException swissephException) {
                if (stringBuffer2 != null) {
                    stringBuffer2.setLength(0);
                    stringBuffer2.append(swissephException.getMessage());
                    n4 = swissephException.getType();
                }
                this.swed.is_old_starfile = true;
                try {
                    this.swed.fixfp = this.swi_fopen(4, "fixstars.cat", this.swed.ephepath, null);
                }
                catch (SwissephException swissephException2) {
                    if (stringBuffer2 != null) {
                        stringBuffer2.append(swissephException2.getMessage() == null ? "" : swissephException2.getMessage());
                        n4 = swissephException2.getType();
                    }
                    this.swed.is_old_starfile = false;
                    if (stringBuffer.toString().startsWith("Spica")) {
                        String string3 = "Spica,alVir,ICRS,13,25,11.5793,-11,09,40.759,-42.50,-31.73,1.0,12.44,1.04,-10,3672";
                        string = "spica";
                        return new String[]{"-1", string3};
                    }
                    return null;
                }
            }
        }
        this.swed.fixfp.seek(0L);
        try {
            String string4;
            while ((string4 = this.swed.fixfp.readLine()) != null) {
                String string5;
                ++n2;
                if (string4.startsWith("#")) continue;
                if (n == ++n3) {
                    this.slast_stardata = string4;
                    this.slast_starname = string;
                    return new String[]{"" + n2, string4};
                }
                if (n > 0) continue;
                if (string4.indexOf(44) < 0) {
                    if (stringBuffer2 != null) {
                        stringBuffer2.setLength(0);
                        stringBuffer2.append("star file sefstars.txt damaged at line " + n2);
                    }
                    return null;
                }
                if (!bl && string4.toLowerCase().startsWith(string)) {
                    this.slast_stardata = string4;
                    this.slast_starname = string;
                    return new String[]{"" + n2, string4};
                }
                if (!bl || !(string5 = string4.substring(string4.indexOf(44)).trim()).startsWith(string)) continue;
                this.slast_stardata = string4;
                this.slast_starname = string;
                return new String[]{"" + n2, string4};
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (stringBuffer2 != null && stringBuffer.length() < 236) {
            stringBuffer2.setLength(0);
            stringBuffer2.append("star  not found");
            if (stringBuffer2.length() + stringBuffer.length() < 256) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("star " + stringBuffer + " not found");
            }
        }
        return null;
    }

    public int swe_fixstar_ut(StringBuffer stringBuffer, double d, int n, double[] dArray, StringBuffer stringBuffer2) {
        SweDate.swi_set_tid_acc(d, n, 0);
        return this.swe_fixstar(stringBuffer, d + SweDate.getDeltaT(d), n, dArray, stringBuffer2);
    }

    public String swe_get_planet_name(int n) {
        String string = "";
        double[] dArray = new double[6];
        if (n == 144340) {
            n = 9;
        }
        if (n != 0 && n == this.swed.i_saved_planet_name) {
            string = this.swed.saved_planet_name;
            return string;
        }
        block2 : switch (n) {
            case 0: {
                string = "Sun";
                break;
            }
            case 1: {
                string = "Moon";
                break;
            }
            case 2: {
                string = "Mercury";
                break;
            }
            case 3: {
                string = "Venus";
                break;
            }
            case 4: {
                string = "Mars";
                break;
            }
            case 5: {
                string = "Jupiter";
                break;
            }
            case 6: {
                string = "Saturn";
                break;
            }
            case 7: {
                string = "Uranus";
                break;
            }
            case 8: {
                string = "Neptune";
                break;
            }
            case 9: {
                string = "Pluto";
                break;
            }
            case 10: {
                string = "mean Node";
                break;
            }
            case 11: {
                string = "true Node";
                break;
            }
            case 12: {
                string = "mean Apogee";
                break;
            }
            case 13: {
                string = "osc. Apogee";
                break;
            }
            case 21: {
                string = "intp. Apogee";
                break;
            }
            case 22: {
                string = "intp. Perigee";
                break;
            }
            case 14: {
                string = "Earth";
                break;
            }
            case 15: 
            case 12060: {
                string = "Chiron";
                break;
            }
            case 16: 
            case 15145: {
                string = "Pholus";
                break;
            }
            case 17: 
            case 10001: {
                string = "Ceres";
                break;
            }
            case 18: 
            case 10002: {
                string = "Pallas";
                break;
            }
            case 19: 
            case 10003: {
                string = "Juno";
                break;
            }
            case 20: 
            case 10004: {
                string = "Vesta";
                break;
            }
            default: {
                if (n >= 40 && n <= 999) {
                    return this.smosh.swi_get_fict_name(n - 40, string);
                }
                if (n > 10000) {
                    int n2;
                    string = n == this.swed.fidat[3].ipl[0] ? this.swed.fidat[3].astnam : ((n2 = this.sweph(2451545.0, n, 3, 0, null, false, dArray, null)) != -1 && n2 != -2 ? this.swed.fidat[3].astnam : n - 10000 + ": not found");
                    if (string.charAt(0) != '?' && !Character.isDigit(string.charAt(1))) break;
                    int n3 = n - 10000;
                    int n4 = 0;
                    FilePtr filePtr = null;
                    try {
                        filePtr = this.swi_fopen(-1, "seasnam.txt", this.swed.ephepath, null);
                    }
                    catch (SwissephException swissephException) {
                        // empty catch block
                    }
                    if (filePtr == null) break;
                    while (n3 != n4) {
                        try {
                            String string2 = filePtr.readLine();
                            if (string2 == null) break block2;
                            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t([{");
                            String string3 = stringTokenizer.nextToken();
                            if (string3.startsWith("#") || Character.isWhitespace(string3.charAt(0)) || n3 != (n4 = Double.valueOf(string3).intValue())) continue;
                            string = stringTokenizer.nextToken("#\r\n").trim();
                            filePtr.close();
                        }
                        catch (IOException iOException) {
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    }
                    break;
                }
                int n5 = n;
                string = "" + n5;
            }
        }
        if (string.length() < 80) {
            this.swed.i_saved_planet_name = n;
            this.swed.saved_planet_name = string;
        }
        return string;
    }

    public String swe_get_ayanamsa_name(int n) {
        if ((n %= 256) < 30) {
            return SwissData.ayanamsa_name[n];
        }
        return null;
    }

    public static String getHouseobjectname(int n) {
        switch (n) {
            case -1: {
                return "house 1";
            }
            case -2: {
                return "house 2";
            }
            case -3: {
                return "house 3";
            }
            case -4: {
                return "house 4";
            }
            case -5: {
                return "house 5";
            }
            case -6: {
                return "house 6";
            }
            case -7: {
                return "house 7";
            }
            case -8: {
                return "house 8";
            }
            case -9: {
                return "house 9";
            }
            case -10: {
                return "house 10";
            }
            case -11: {
                return "house 11";
            }
            case -12: {
                return "house 12";
            }
            case 0: {
                return "ascendant";
            }
            case 1: {
                return "medium coeli";
            }
            case 2: {
                return "sidereal time";
            }
            case 3: {
                return "vertex";
            }
            case 4: {
                return "equatorial ascendant";
            }
            case 5: {
                return "co-ascendant of W. Koch";
            }
            case 6: {
                return "co-ascendant of M. Munkasey";
            }
            case 7: {
                return "polar asc. of M. Munkasey";
            }
        }
        return "";
    }

    public void swe_set_topo(double d, double d2, double d3) {
        this.swed.topd.geolon = d;
        this.swed.topd.geolat = d2;
        this.swed.topd.geoalt = d3;
        this.swed.geopos_is_set = true;
        this.swed.topd.teval = 0.0;
        this.swi_force_app_pos_etc();
    }

    public double[] getDatafileTimerange(String string) throws SwissephException {
        if (Pattern.matches(".*\\Ws(e|[0-9])[0-9][0-9][0-9][0-9][0-9](s|).se1", string)) {
            return new FileData().getDatafileTimerange(this, string, this.swed.ephepath, true);
        }
        if (Pattern.matches("seas[_m][0-9]+.se1", string) || Pattern.matches("semo[_m][0-9]+.se1", string) || Pattern.matches("sepl[_m][0-9]+.se1", string)) {
            return new FileData().getDatafileTimerange(this, string, this.swed.ephepath);
        }
        if (this.sj == null) {
            this.sj = new SwephJPL(this, this.swed, this.sl);
        }
        return this.sj.getJPLRange(string);
    }

    public void swe_azalt(double d, int n, double[] dArray, double d2, double d3, double[] dArray2, double[] dArray3) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        this.sc.swe_azalt(d, n, dArray, d2, d3, dArray2, dArray3);
    }

    public void swe_azalt_rev(double d, int n, double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        this.sc.swe_azalt_rev(d, n, dArray, dArray2, dArray3);
    }

    public int swe_lun_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_lun_eclipse_how(d, n, dArray, dArray2, stringBuffer);
    }

    public int swe_lun_eclipse_when(double d, int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_lun_eclipse_when(d, n, n2, dArray, n3, stringBuffer);
    }

    public int swe_nod_aps(double d, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_nod_aps(d, n, n2, n3, dArray, dArray2, dArray3, dArray4, stringBuffer);
    }

    public int swe_nod_aps_ut(double d, int n, int n2, int n3, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_nod_aps_ut(d, n, n2, n3, dArray, dArray2, dArray3, dArray4, stringBuffer);
    }

    public int swe_pheno(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_pheno(d, n, n2, dArray, stringBuffer);
    }

    public int swe_pheno_ut(double d, int n, int n2, double[] dArray, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_pheno_ut(d, n, n2, dArray, stringBuffer);
    }

    public double swe_refrac(double d, double d2, double d3, int n) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_refrac(d, d2, d3, n);
    }

    public double swe_refrac_extended(double d, double d2, double d3, double d4, double d5, int n, double[] dArray) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_refrac_extended(d, d2, d3, d4, d5, n, dArray);
    }

    public int swe_rise_trans(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, DblObj dblObj, StringBuffer stringBuffer2) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_rise_trans(d, n, stringBuffer, n2, n3, dArray, d2, d3, dblObj, stringBuffer2);
    }

    public int swe_rise_trans_true_hor(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, double d4, DblObj dblObj, StringBuffer stringBuffer2) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_rise_trans_true_hor(d, n, stringBuffer, n2, n3, dArray, d2, d3, d4, dblObj, stringBuffer2);
    }

    public int swe_sol_eclipse_how(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_sol_eclipse_how(d, n, dArray, dArray2, stringBuffer);
    }

    public int swe_sol_eclipse_when_glob(double d, int n, int n2, double[] dArray, int n3, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_sol_eclipse_when_glob(d, n, n2, dArray, n3, stringBuffer);
    }

    public int swe_sol_eclipse_when_loc(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_sol_eclipse_when_loc(d, n, dArray, dArray2, dArray3, n2, stringBuffer);
    }

    public int swe_sol_eclipse_where(double d, int n, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_sol_eclipse_where(d, n, dArray, dArray2, stringBuffer);
    }

    public int swe_lun_occult_when_loc(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, double[] dArray3, int n3, StringBuffer stringBuffer2) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_lun_occult_when_loc(d, n, stringBuffer, n2, dArray, dArray2, dArray3, n3, stringBuffer2);
    }

    public int swe_lun_eclipse_when_loc(double d, int n, double[] dArray, double[] dArray2, double[] dArray3, int n2, StringBuffer stringBuffer) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_lun_eclipse_when_loc(d, n, dArray, dArray2, dArray3, n2, stringBuffer);
    }

    public int swe_lun_occult_where(double d, int n, StringBuffer stringBuffer, int n2, double[] dArray, double[] dArray2, StringBuffer stringBuffer2) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_lun_occult_where(d, n, stringBuffer, n2, dArray, dArray2, stringBuffer2);
    }

    public int swe_lun_occult_when_glob(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, int n4, StringBuffer stringBuffer2) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_lun_occult_when_glob(d, n, stringBuffer, n2, n3, dArray, n4, stringBuffer2);
    }

    public int swe_gauquelin_sector(double d, int n, StringBuffer stringBuffer, int n2, int n3, double[] dArray, double d2, double d3, DblObj dblObj, StringBuffer stringBuffer2) {
        if (this.sc == null) {
            this.sc = new Swecl(this, this.sl, this.sm, this.swed);
        }
        return this.sc.swe_gauquelin_sector(d, n, stringBuffer, n2, n3, dArray, d2, d3, dblObj, stringBuffer2);
    }

    public String swe_house_name(char c) {
        if (this.sh == null) {
            this.sh = new SweHouse(this.sl, this, this.swed);
        }
        return this.sh.swe_house_name(c);
    }

    public double swe_house_pos(double d, double d2, double d3, int n, double[] dArray, StringBuffer stringBuffer) {
        if (this.sh == null) {
            this.sh = new SweHouse(this.sl, this, this.swed);
        }
        if (dArray.length != 6) {
            dArray = new double[]{dArray[0], dArray[1], 0.0, 0.0, 0.0, 0.0};
        }
        return this.sh.swe_house_pos(d, d2, d3, n, dArray, stringBuffer);
    }

    public int swe_houses_armc(double d, double d2, double d3, int n, double[] dArray, double[] dArray2) {
        if (this.sh == null) {
            this.sh = new SweHouse(this.sl, this, this.swed);
        }
        return this.sh.swe_houses_armc(d, d2, d3, n, dArray, dArray2, 0);
    }

    public int swe_houses(double d, int n, double d2, double d3, int n2, double[] dArray, double[] dArray2) {
        return this.swe_houses(d, n, d2, d3, n2, dArray, dArray2, 0);
    }

    public int swe_houses(double d, int n, double d2, double d3, int n2, double[] dArray, double[] dArray2, int n3) {
        if (this.sh == null) {
            this.sh = new SweHouse(this.sl, this, this.swed);
        }
        return this.sh.swe_houses(d, n, d2, d3, n2, dArray, dArray2, n3);
    }

    public void setTransitSpeedsfile(String string, boolean bl) {
    }

    public double getTransitET(TransitCalculator transitCalculator, double d, boolean bl) throws IllegalArgumentException, SwissephException {
        return this.getTransitET(transitCalculator, d, bl, bl ? -1.7976931348623157E308 : Double.MAX_VALUE);
    }

    public double getTransitET(TransitCalculator transitCalculator, double d, boolean bl, double d2) throws IllegalArgumentException, SwissephException {
        boolean bl2;
        if (this.ext == null) {
            this.ext = new Extensions(this);
        }
        return this.ext.getTransit(transitCalculator, d - ((bl2 = transitCalculator instanceof TCHouses) ? SweDate.getDeltaT(d) : 0.0), bl, d2) + (bl2 ? SweDate.getDeltaT(d) : 0.0);
    }

    public double getTransitUT(TransitCalculator transitCalculator, double d, boolean bl) throws IllegalArgumentException, SwissephException {
        boolean bl2;
        if (this.ext == null) {
            this.ext = new Extensions(this);
        }
        double d2 = this.ext.getTransit(transitCalculator, d + ((bl2 = transitCalculator instanceof TCHouses) ? 0.0 : SweDate.getDeltaT(d)), bl, bl ? -1.7976931348623157E308 : Double.MAX_VALUE);
        return d2 - (bl2 ? 0.0 : SweDate.getDeltaT(d2));
    }

    public double getTransitUT(TransitCalculator transitCalculator, double d, boolean bl, double d2) throws IllegalArgumentException, SwissephException {
        if (this.ext == null) {
            this.ext = new Extensions(this);
        }
        double d3 = this.ext.getTransit(transitCalculator, d + SweDate.getDeltaT(d), bl, d2 + SweDate.getDeltaT(d2));
        return d3 - SweDate.getDeltaT(d3);
    }

    private int swe_calc_error(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = 0.0;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int swecalc(double var1_1, int var3_2, int var4_3, double[] var5_4, StringBuffer var6_5) throws SwissephException {
        block111: {
            block110: {
                var12_6 = 2;
                var14_7 = this.swed.pldat[0];
                var15_8 = this.swed.pldat[10];
                var19_9 = new double[3];
                var20_10 = "";
                if (var6_5 != null) {
                    var6_5.setLength(0);
                }
                if (((var4_3 = this.plaus_iflag(var4_3, var3_2, var1_1, var6_5)) & 4) != 0) {
                    var12_6 = 4;
                }
                if ((var4_3 & 2) != 0) {
                    var12_6 = 2;
                }
                if ((var4_3 & 1) != 0) {
                    var12_6 = 1;
                }
                if ((var4_3 & 16384) != 0 && (var4_3 & 4) != 0) {
                    if (var6_5 == null) throw new SwissephException(var1_1, 9216, -1, var6_5);
                    var6_5.append("barycentric Moshier positions are not supported.");
                    throw new SwissephException(var1_1, 9216, -1, var6_5);
                }
                if (var12_6 != 4 && !this.swed.ephe_path_is_set && !this.swed.jpl_file_is_open) {
                    this.swe_set_ephe_path(null);
                }
                if ((var4_3 & 65536) != 0 && !this.swed.ayana_is_set) {
                    this.swe_set_sid_mode(0, 0.0, 0.0);
                }
                this.swi_check_ecliptic(var1_1, var4_3);
                this.swi_check_nutation(var1_1, var4_3);
                if (var3_2 == -1) {
                    var5_4[0] = this.swed.oec.eps + this.swed.nut.nutlo[1];
                    var5_4[1] = this.swed.oec.eps;
                    var5_4[2] = this.swed.nut.nutlo[0];
                    var5_4[3] = this.swed.nut.nutlo[1];
                    var7_11 = 0;
                    while (var7_11 <= 3) {
                        v0 = var7_11++;
                        var5_4[v0] = var5_4[v0] * 57.2957795130823;
                    }
                    return var4_3;
                }
                if (var3_2 != 1) break block110;
                var8_23 = 1;
                var13_24 = this.swed.pldat[var8_23];
                var17_25 = var13_24.xreturn;
                switch (var12_6) {
                    case 1: {
                        try {
                            var11_26 = this.jplplan(var1_1, var8_23, var4_3, true, null, null, null, var6_5);
                        }
                        catch (SwissephException var21_27) {
                            var11_26 = var21_27.getRC();
                            if (var11_26 != -1) ** GOTO lbl51
                            this.swecalc_error(var5_4);
                            throw new SwissephException(var1_1, 65, -1, var6_5);
                        }
lbl51:
                        // 2 sources

                        if (var11_26 == -2) {
                            var4_3 = var4_3 & -2 | 2;
                            if (var6_5 != null && var6_5.length() + 30 < 256) {
                                var6_5.append(" \ntrying Swiss Eph; ");
                            }
                            if ((var11_26 = this.sweph_moon(var1_1, var8_23, var4_3, var6_5)) != -1) break;
                            return this.swecalc_error(var5_4);
                        }
                        if (var11_26 != -3) break;
                        if (!(var1_1 > 625000.5) || !(var1_1 < 2818000.5)) return this.swecalc_error(var5_4);
                        var4_3 = var4_3 & -2 | 4;
                        if (var6_5 != null && var6_5.length() + 30 < 256) {
                            var6_5.append(" \nusing Moshier Eph; ");
                        }
                        if ((var11_26 = this.moshier_moon(var1_1, true, null, var6_5)) != -1) break;
                        return this.swecalc_error(var5_4);
                    }
                    case 2: {
                        var11_26 = this.sweph_moon(var1_1, var8_23, var4_3, var6_5);
                        if (var11_26 != -1) break;
                        return this.swecalc_error(var5_4);
                    }
                    case 4: {
                        var11_26 = this.moshier_moon(var1_1, true, null, var6_5);
                        if (var11_26 != -1) break;
                        return this.swecalc_error(var5_4);
                    }
                }
                var11_26 = this.app_pos_etc_moon(var4_3, var6_5);
                if (var11_26 != 0) {
                    return this.swecalc_error(var5_4);
                }
                break block111;
            }
            if (var3_2 == 0 && (var4_3 & 16384) != 0) {
                var8_23 = 0;
                var17_25 = var14_7.xreturn;
                switch (var12_6) {
                    case 1: {
                        if (!this.swed.jpl_file_is_open) {
                            var11_26 = this.open_jpl_file(var19_9, this.swed.jplfnam, this.swed.ephepath, var6_5);
                            if (var11_26 != 0) {
                                var11_26 = this.sweph_sbar(var1_1, var4_3, var15_8, var14_7, var6_5);
                            }
                            if (var11_26 == -1) {
                                return this.swecalc_error(var5_4);
                            }
                        }
                        try {
                            var11_26 = this.sj.swi_pleph(var1_1, 10, 11, var15_8.x, var6_5);
                        }
                        catch (SwissephException var21_28) {
                            var11_26 = var21_28.getRC();
                        }
                        if (var11_26 == -1 || var11_26 == -3) {
                            this.sj.swi_close_jpl_file();
                            this.swed.jpl_file_is_open = false;
                            return this.swecalc_error(var5_4);
                        }
                        if (var11_26 == -2) {
                            var4_3 = var4_3 & -2 | 2;
                            if (var6_5 != null && var6_5.length() + 30 < 256) {
                                var6_5.append(" \ntrying Swiss Eph; ");
                            }
                            if ((var11_26 = this.sweph_sbar(var1_1, var4_3, var15_8, var14_7, var6_5)) == -1) {
                                return this.swecalc_error(var5_4);
                            }
                        }
                        var15_8.teval = var1_1;
                        break;
                    }
                    case 2: {
                        var11_26 = this.sweph_sbar(var1_1, var4_3, var15_8, var14_7, var6_5);
                        if (var11_26 != -1) break;
                        return this.swecalc_error(var5_4);
                    }
                    default: {
                        return -1;
                    }
                }
                var11_26 = this.app_pos_etc_sbar(var4_3, var6_5);
                if (var11_26 != 0) {
                    return this.swecalc_error(var5_4);
                }
                var4_3 = var14_7.xflgs;
                var14_7.xflgs = -1;
            } else if (var3_2 == 0 || var3_2 == 2 || var3_2 == 3 || var3_2 == 4 || var3_2 == 5 || var3_2 == 6 || var3_2 == 7 || var3_2 == 8 || var3_2 == 9 || var3_2 == 14) {
                if ((var4_3 & 8) != 0) {
                    if (var3_2 == 0) {
                        for (var7_12 = 0; var7_12 < 24; ++var7_12) {
                            var5_4[var7_12] = 0.0;
                        }
                        return var4_3;
                    }
                } else if ((var4_3 & 16384) == 0 && var3_2 == 14) {
                    for (var7_13 = 0; var7_13 < 24; ++var7_13) {
                        var5_4[var7_13] = 0.0;
                    }
                    return var4_3;
                }
                var8_23 = SwissData.pnoext2int[var3_2];
                var13_24 = this.swed.pldat[var8_23];
                var17_25 = var13_24.xreturn;
                var11_26 = this.main_planet(var1_1, var8_23, var12_6, var4_3, var6_5);
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
                var4_3 = var13_24.xflgs;
            } else if (var3_2 == 10) {
                if ((var4_3 & 8) != 0 || (var4_3 & 16384) != 0) {
                    for (var7_14 = 0; var7_14 < 24; ++var7_14) {
                        var5_4[var7_14] = 0.0;
                    }
                    return var4_3;
                }
                var16_30 = this.swed.nddat[0];
                var17_25 = var16_30.xreturn;
                var18_31 = var16_30.x;
                var11_26 = this.sm.swi_mean_node(var1_1, var18_31, var6_5);
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
                var11_26 = this.sm.swi_mean_node(var1_1 - 0.001, var18_31, 3, var6_5);
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
                var18_31[3] = this.sl.swe_difrad2n(var18_31[0], var18_31[3]) / 0.001;
                var18_31[5] = 0.0;
                var18_31[4] = 0.0;
                var16_30.teval = var1_1;
                var16_30.xflgs = -1;
                var11_26 = this.app_pos_etc_mean(0, var4_3, var6_5);
                if (var11_26 != 0) {
                    return this.swecalc_error(var5_4);
                }
                if ((var4_3 & 65536) == 0 && (var4_3 & 32) == 0) {
                    var16_30.xreturn[1] = 0.0;
                    var16_30.xreturn[4] = 0.0;
                    var16_30.xreturn[5] = 0.0;
                    var16_30.xreturn[8] = 0.0;
                    var16_30.xreturn[11] = 0.0;
                }
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
            } else if (var3_2 == 12) {
                if ((var4_3 & 8) != 0 || (var4_3 & 16384) != 0) {
                    for (var7_15 = 0; var7_15 < 24; ++var7_15) {
                        var5_4[var7_15] = 0.0;
                    }
                    return var4_3;
                }
                var16_30 = this.swed.nddat[2];
                var17_25 = var16_30.xreturn;
                var18_31 = var16_30.x;
                var11_26 = this.sm.swi_mean_apog(var1_1, var18_31, var6_5);
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
                var11_26 = this.sm.swi_mean_apog(var1_1 - 0.001, var18_31, 3, var6_5);
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
                for (var7_16 = 0; var7_16 <= 1; ++var7_16) {
                    var18_31[3 + var7_16] = this.sl.swe_difrad2n(var18_31[var7_16], var18_31[3 + var7_16]) / 0.001;
                }
                var18_31[5] = 0.0;
                var16_30.teval = var1_1;
                var16_30.xflgs = -1;
                var11_26 = this.app_pos_etc_mean(2, var4_3, var6_5);
                if (var11_26 != 0) {
                    return this.swecalc_error(var5_4);
                }
                var16_30.xreturn[5] = 0.0;
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
            } else if (var3_2 == 11) {
                if ((var4_3 & 8) != 0 || (var4_3 & 16384) != 0) {
                    for (var7_17 = 0; var7_17 < 24; ++var7_17) {
                        var5_4[var7_17] = 0.0;
                    }
                    return var4_3;
                }
                var16_30 = this.swed.nddat[1];
                var17_25 = var16_30.xreturn;
                var11_26 = this.lunar_osc_elem(var1_1, 1, var4_3, var6_5);
                var4_3 = var16_30.xflgs;
                if ((var4_3 & 65536) == 0 && (var4_3 & 32) == 0) {
                    var16_30.xreturn[1] = 0.0;
                    var16_30.xreturn[4] = 0.0;
                    var16_30.xreturn[8] = 0.0;
                    var16_30.xreturn[11] = 0.0;
                }
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
            } else if (var3_2 == 13) {
                if ((var4_3 & 8) != 0 || (var4_3 & 16384) != 0) {
                    for (var7_18 = 0; var7_18 < 24; ++var7_18) {
                        var5_4[var7_18] = 0.0;
                    }
                    return var4_3;
                }
                var16_30 = this.swed.nddat[3];
                var17_25 = var16_30.xreturn;
                var11_26 = this.lunar_osc_elem(var1_1, 3, var4_3, var6_5);
                var4_3 = var16_30.xflgs;
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
            } else if (var3_2 == 21) {
                if ((var4_3 & 8) != 0 || (var4_3 & 16384) != 0) {
                    for (var7_19 = 0; var7_19 < 24; ++var7_19) {
                        var5_4[var7_19] = 0.0;
                    }
                    return var4_3;
                }
                if (var1_1 < 625000.5 || var1_1 > 2818000.5) {
                    for (var7_20 = 0; var7_20 < 24; ++var7_20) {
                        var5_4[var7_20] = 0.0;
                    }
                    if (var6_5 == null) return -1;
                    var6_5.setLength(0);
                    var6_5.append("Interpolated apsides are restricted to JD 625000.5 - JD 2818000.5");
                    return -1;
                }
                var16_30 = this.swed.nddat[4];
                var17_25 = var16_30.xreturn;
                var11_26 = this.intp_apsides(var1_1, 4, var4_3, var6_5);
                var4_3 = var16_30.xflgs;
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
            } else if (var3_2 == 22) {
                if ((var4_3 & 8) != 0 || (var4_3 & 16384) != 0) {
                    for (var7_21 = 0; var7_21 < 24; ++var7_21) {
                        var5_4[var7_21] = 0.0;
                    }
                    return var4_3;
                }
                if (var1_1 < 625000.5 || var1_1 > 2818000.5) {
                    for (var7_22 = 0; var7_22 < 24; ++var7_22) {
                        var5_4[var7_22] = 0.0;
                    }
                    if (var6_5 == null) return -1;
                    var6_5.setLength(0);
                    var6_5.append("Interpolated apsides are restricted to JD 625000.5 - JD 2818000.5");
                    return -1;
                }
                var16_30 = this.swed.nddat[5];
                var17_25 = var16_30.xreturn;
                var11_26 = this.intp_apsides(var1_1, 5, var4_3, var6_5);
                var4_3 = var16_30.xflgs;
                if (var11_26 == -1) {
                    return this.swecalc_error(var5_4);
                }
            } else if (var3_2 == 15 || var3_2 == 16 || var3_2 == 17 || var3_2 == 18 || var3_2 == 19 || var3_2 == 20 || var3_2 > 10000) {
                if (var3_2 < 23) {
                    var8_23 = SwissData.pnoext2int[var3_2];
                } else if (var3_2 <= 10004) {
                    var8_23 = 14 + var3_2 - 10000 - 1;
                    var3_2 = 17 + var3_2 - 10000 - 1;
                } else {
                    var8_23 = 11;
                }
                var9_32 = var8_23 == 11 ? var3_2 : var8_23;
                var13_24 = this.swed.pldat[var8_23];
                var17_25 = var13_24.xreturn;
                var10_33 = var9_32 > 10000 ? 3 : 2;
                if (var8_23 == 12 && (var1_1 < 1967601.5 || var1_1 > 3419437.5)) {
                    if (var6_5 == null) return -1;
                    var6_5.setLength(0);
                    var6_5.append("Chiron's ephemeris is restricted to JD 1967601.5 - JD 3419437.5");
                    return -1;
                }
                if (var8_23 == 13 && (var1_1 < 640648.5 || var1_1 > 4390617.5)) {
                    if (var6_5 == null) return -1;
                    var6_5.setLength(0);
                    var6_5.append("Pholus's ephemeris is restricted to JD 640648.5 - JD 4390617.5");
                    return -1;
                }
                while (true) {
                    if ((var11_26 = this.main_planet(var1_1, 0, var12_6, var4_3, var6_5)) == -1) {
                        return this.swecalc_error(var5_4);
                    }
                    var4_3 = this.swed.pldat[0].xflgs;
                    if (var6_5 != null) {
                        var20_10 = var6_5.toString();
                        var6_5.setLength(0);
                    }
                    if ((var11_26 = this.sweph(var1_1, var9_32, var10_33, var4_3, var15_8.x, true, null, var6_5)) == -1 || var11_26 == -2) {
                        return this.swecalc_error(var5_4);
                    }
                    var11_26 = this.app_pos_etc_plan(var9_32, var4_3, var6_5);
                    if (var11_26 == -1) {
                        return this.swecalc_error(var5_4);
                    }
                    if (var11_26 != -2 && var11_26 != -3) break;
                    if (var12_6 == 4) return this.swecalc_error(var5_4);
                    var4_3 = var4_3 & -8 | 4;
                    var12_6 = 4;
                    if (var6_5 == null || var6_5.length() + 30 >= 256) continue;
                    var6_5.append("\nusing Moshier eph.; ");
                }
                if (var6_5 != null && var6_5.length() == 0 && var20_10.length() != 0) {
                    var6_5.setLength(0);
                    var20_10 = var20_10.substring(0, SMath.min(var20_10.length(), 251));
                    var6_5.append("sun: " + var20_10);
                }
            } else if (var3_2 >= 40 && var3_2 <= 999) {
                var8_23 = 11;
                var13_24 = this.swed.pldat[var8_23];
                var17_25 = var13_24.xreturn;
                while (true) {
                    var11_26 = this.main_planet(var1_1, 0, var12_6, var4_3, var6_5);
                    var4_3 = this.swed.pldat[0].xflgs;
                    if (this.smosh.swi_osc_el_plan(var1_1, var13_24.x, var3_2 - 40, var8_23, var14_7.x, var15_8.x, var6_5) != 0) {
                        return this.swecalc_error(var5_4);
                    }
                    if (var11_26 == -1) {
                        return this.swecalc_error(var5_4);
                    }
                    var11_26 = this.app_pos_etc_plan_osc(var3_2, var8_23, var4_3, var6_5);
                    if (var11_26 == -1) {
                        return this.swecalc_error(var5_4);
                    }
                    if (var11_26 == -2 || var11_26 == -3) {
                        if (var12_6 == 4) return this.swecalc_error(var5_4);
                        var4_3 = var4_3 & -8 | 4;
                        var12_6 = 4;
                        if (var6_5 == null || var6_5.length() + 30 >= 256) continue;
                        var6_5.append("\nusing Moshier eph.; ");
                        continue;
                    }
                    break;
                }
            } else {
                if (var6_5 == null) return this.swecalc_error(var5_4);
                var6_5.setLength(0);
                var6_5.append("illegal planet number " + var3_2 + ".");
                return this.swecalc_error(var5_4);
            }
        }
        for (var7_16 = 0; var7_16 < 24; ++var7_16) {
            var5_4[var7_16] = var17_25[var7_16];
        }
        return var4_3;
    }

    int moshier_moon(double d, boolean bl, double[] dArray, StringBuffer stringBuffer) {
        int n = this.sm.swi_moshmoon(d, bl, null, stringBuffer);
        if (n == -1) {
            return -1;
        }
        n = this.smosh.swi_moshplan(d, 0, bl, null, null, stringBuffer);
        if (n == -1) {
            return -1;
        }
        return 0;
    }

    int swecalc_error(double[] dArray) {
        for (int i = 0; i < 24; ++i) {
            dArray[i] = 0.0;
        }
        return -1;
    }

    int sweph_sbar(double d, int n, PlanData planData, PlanData planData2, StringBuffer stringBuffer) {
        int n2 = this.sweplan(d, 0, 0, n, true, null, null, null, null, stringBuffer);
        if (n2 == -1 || n2 == -2) {
            return -1;
        }
        planData.teval = d;
        return 0;
    }

    int sweph_moon(double d, int n, int n2, StringBuffer stringBuffer) {
        int n3 = this.sweplan(d, n, 1, n2, true, null, null, null, null, stringBuffer);
        if (n3 == -1) {
            return -1;
        }
        if (n3 == -2) {
            if (d > 625000.5 && d < 2818000.5) {
                n2 = n2 & 0xFFFFFFFD | 4;
                if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                    stringBuffer.append(" \nusing Moshier eph.; ");
                }
                if ((n3 = this.moshier_moon(d, true, null, stringBuffer)) == -1) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        return 0;
    }

    void calc_epsilon(double d, int n, Epsilon epsilon) {
        epsilon.teps = d;
        epsilon.eps = this.sl.swi_epsiln(d, n);
        epsilon.seps = SMath.sin(epsilon.eps);
        epsilon.ceps = SMath.cos(epsilon.eps);
    }

    private int main_planet(double d, int n, int n2, int n3, StringBuffer stringBuffer) throws SwissephException {
        int n4;
        boolean bl = false;
        boolean bl2 = false;
        if (n2 == 1) {
            block34: {
                try {
                    n4 = this.jplplan(d, n, n3, true, null, null, null, stringBuffer);
                }
                catch (SwissephException swissephException) {
                    n4 = swissephException.getRC();
                    if (n4 != -1) break block34;
                    return -1;
                }
            }
            if (n4 == -2) {
                n3 = n3 & 0xFFFFFFFE | 2;
                if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                    stringBuffer.append(" \ntrying Swiss Eph; ");
                }
                bl = true;
            } else if (n4 == -3) {
                if (d > 625000.5 && d < 2818000.5) {
                    n3 = n3 & 0xFFFFFFFE | 4;
                    if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                        stringBuffer.append(" \nusing Moshier Eph; ");
                    }
                    bl2 = true;
                } else {
                    return -1;
                }
            }
            if (!bl && !bl2) {
                n4 = n == 0 ? this.app_pos_etc_sun(n3, stringBuffer) : this.app_pos_etc_plan(n, n3, stringBuffer);
                if (n4 == -1) {
                    return -1;
                }
                if (n4 == -2) {
                    n3 = n3 & 0xFFFFFFFE | 2;
                    if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                        stringBuffer.append(" \ntrying Swiss Eph; ");
                    }
                    bl = true;
                } else if (n4 == -3) {
                    if (d > 625000.5 && d < 2818000.5) {
                        n3 = n3 & 0xFFFFFFFE | 4;
                        if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                            stringBuffer.append(" \nusing Moshier Eph; ");
                        }
                        bl2 = true;
                    } else {
                        return -1;
                    }
                }
            }
        }
        if (n2 == 2 || bl) {
            n4 = this.sweplan(d, n, 0, n3, true, null, null, null, null, stringBuffer);
            if (n4 == -1) {
                return -1;
            }
            if (n4 == -2) {
                if (d > 625000.5 && d < 2818000.5) {
                    n3 = n3 & 0xFFFFFFFD | 4;
                    if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                        stringBuffer.append(" \nusing Moshier eph.; ");
                    }
                    bl2 = true;
                } else {
                    return -1;
                }
            }
            if (!bl2) {
                n4 = n == 0 ? this.app_pos_etc_sun(n3, stringBuffer) : this.app_pos_etc_plan(n, n3, stringBuffer);
                if (n4 == -1) {
                    return -1;
                }
                if (n4 == -2) {
                    if (d > 625000.5 && d < 2818000.5) {
                        n3 = n3 & 0xFFFFFFFD | 4;
                        if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                            stringBuffer.append(" \nusing Moshier eph.; ");
                        }
                        bl2 = true;
                    } else {
                        return -1;
                    }
                }
            }
        }
        if (n2 == 4 || bl2) {
            n4 = this.smosh.swi_moshplan(d, n, true, null, null, stringBuffer);
            if (n4 == -1) {
                return -1;
            }
            n4 = n == 0 ? this.app_pos_etc_sun(n3, stringBuffer) : this.app_pos_etc_plan(n, n3, stringBuffer);
            if (n4 == -1) {
                return -1;
            }
        }
        return 0;
    }

    int main_planet_bary(double d, int n, int n2, int n3, boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        int n4;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 == 1) {
            block9: {
                try {
                    n4 = this.jplplan(d, n, n3, bl, dArray, dArray2, dArray3, stringBuffer);
                }
                catch (SwissephException swissephException) {
                    n4 = swissephException.getRC();
                    if (n4 != -1 && n4 != -3) break block9;
                    return n4;
                }
            }
            if (n4 == -2) {
                n3 = n3 & 0xFFFFFFFE | 2;
                if (stringBuffer != null && stringBuffer.length() + 30 < 256) {
                    stringBuffer.append(" \ntrying Swiss Eph; ");
                }
                bl3 = true;
            }
        }
        if (!(n2 != 2 && !bl3 || (n4 = this.sweplan(d, n, 0, n3, bl, dArray, dArray2, dArray3, dArray4, stringBuffer)) != -1 && n4 != -2)) {
            return n4;
        }
        if (n2 == 4 || bl2) {
            n4 = this.smosh.swi_moshplan(d, n, bl, dArray, dArray2, stringBuffer);
            if (n4 == -1) {
                return -1;
            }
            for (int i = 0; i <= 5; ++i) {
                dArray3[i] = 0.0;
            }
        }
        return 0;
    }

    int swemoon(double d, int n, boolean bl, double[] dArray, StringBuffer stringBuffer) {
        PlanData planData = this.swed.pldat[1];
        double[] dArray2 = new double[6];
        double[] dArray3 = bl ? planData.x : dArray2;
        int n2 = planData.xflgs & 0x100;
        int n3 = n & 0x100;
        if (d == planData.teval && planData.iephe == 2 && (n3 == 0 || n2 != 0)) {
            dArray3 = planData.x;
        } else {
            int n4 = this.sweph(d, 1, 1, n, null, bl, dArray3, stringBuffer);
            if (n4 != 0) {
                return n4;
            }
            if (bl) {
                planData.teval = d;
                planData.xflgs = -1;
                planData.iephe = 2;
            }
        }
        if (dArray != null) {
            for (int i = 0; i <= 5; ++i) {
                dArray[i] = dArray3[i];
            }
        }
        return 0;
    }

    int sweplan(double d, int n, int n2, int n3, boolean bl, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, StringBuffer stringBuffer) {
        int n4;
        int n5;
        int n6;
        double[] dArray5;
        double[] dArray6;
        double[] dArray7;
        double[] dArray8;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        PlanData planData = this.swed.pldat[n];
        PlanData planData2 = this.swed.pldat[0];
        PlanData planData3 = this.swed.pldat[10];
        PlanData planData4 = this.swed.pldat[1];
        double[] dArray9 = new double[6];
        double[] dArray10 = new double[6];
        double[] dArray11 = new double[6];
        double[] dArray12 = new double[6];
        if (bl || n == 10 || (planData.iflg & 1) != 0 || dArray3 != null || (n3 & 8) != 0) {
            bl4 = true;
        }
        if (bl || n == 0 || dArray2 != null) {
            bl2 = true;
        }
        if (n == 1) {
            bl2 = true;
            bl4 = true;
        }
        if (bl || n == 1 || n == 0 || dArray2 != null || dArray4 != null) {
            bl3 = true;
        }
        if (bl) {
            dArray8 = planData.x;
            dArray7 = planData2.x;
            dArray6 = planData3.x;
            dArray5 = planData4.x;
        } else {
            dArray8 = dArray9;
            dArray7 = dArray12;
            dArray6 = dArray11;
            dArray5 = dArray10;
        }
        int n7 = n3 & 0x100;
        if (bl4) {
            n6 = planData3.xflgs & 0x100;
            if (d == planData3.teval && planData3.iephe == 2 && (n7 == 0 || n6 != 0)) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray6[n5] = planData3.x[n5];
                }
            } else {
                n4 = this.sweph(d, 10, 0, n3, null, bl, dArray6, stringBuffer);
                if (n4 != 0) {
                    return n4;
                }
            }
            if (dArray3 != null) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray3[n5] = dArray6[n5];
                }
            }
        }
        if (bl3) {
            n6 = planData4.xflgs & 0x100;
            if (d == planData4.teval && planData4.iephe == 2 && (n7 == 0 || n6 != 0)) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray5[n5] = planData4.x[n5];
                }
            } else {
                n4 = this.sweph(d, 1, 1, n3, null, bl, dArray5, stringBuffer);
                if (n4 == -1) {
                    return n4;
                }
                if (this.swed.fidat[1].fptr == null) {
                    if (stringBuffer != null && stringBuffer.length() + 35 < 256) {
                        stringBuffer.append(" \nusing Moshier eph. for moon; ");
                    }
                    if ((n4 = this.sm.swi_moshmoon(d, bl, dArray5, stringBuffer)) != 0) {
                        return n4;
                    }
                }
            }
            if (dArray4 != null) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray4[n5] = dArray5[n5];
                }
            }
        }
        if (bl2) {
            n6 = planData2.xflgs & 0x100;
            if (d == planData2.teval && planData2.iephe == 2 && (n7 == 0 || n6 != 0)) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray7[n5] = planData2.x[n5];
                }
            } else {
                n4 = this.sweph(d, 0, 0, n3, null, bl, dArray7, stringBuffer);
                if (n4 != 0) {
                    return n4;
                }
                this.embofs(dArray7, 0, dArray5, 0);
                if (dArray7 == planData2.x || (n3 & 0x100) != 0) {
                    this.embofs(dArray7, 3, dArray5, 3);
                }
            }
            if (dArray2 != null) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray2[n5] = dArray7[n5];
                }
            }
        }
        if (n == 1) {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray8[n5] = dArray5[n5];
            }
        } else if (n == 0) {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray8[n5] = dArray7[n5];
            }
        } else if (n == 0) {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray8[n5] = dArray6[n5];
            }
        } else {
            n6 = planData.xflgs & 0x100;
            if (d == planData.teval && planData.iephe == 2 && (n7 == 0 || n6 != 0)) {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray8[n5] = planData.x[n5];
                }
                return 0;
            }
            n4 = this.sweph(d, n, n2, n3, null, bl, dArray8, stringBuffer);
            if (n4 != 0) {
                return n4;
            }
            if ((planData.iflg & 1) != 0) {
                for (n5 = 0; n5 <= 2; ++n5) {
                    int n8 = n5;
                    dArray8[n8] = dArray8[n8] + dArray6[n5];
                }
                if (bl || (n3 & 0x100) != 0) {
                    for (n5 = 3; n5 <= 5; ++n5) {
                        int n9 = n5;
                        dArray8[n9] = dArray8[n9] + dArray6[n5];
                    }
                }
            }
        }
        if (dArray != null) {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray[n5] = dArray8[n5];
            }
        }
        return 0;
    }

    int jplplan(double d, int n, int n2, boolean bl, double[] dArray, double[] dArray2, double[] dArray3, StringBuffer stringBuffer) throws SwissephException {
        int n3;
        int n4;
        double[] dArray4;
        double[] dArray5;
        double[] dArray6;
        boolean bl2 = false;
        boolean bl3 = false;
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        double[] dArray10 = new double[6];
        int n5 = 11;
        PlanData planData = this.swed.pldat[n];
        PlanData planData2 = this.swed.pldat[0];
        PlanData planData3 = this.swed.pldat[10];
        if (bl) {
            dArray6 = planData.x;
            dArray5 = planData2.x;
            dArray4 = planData3.x;
        } else {
            dArray6 = dArray8;
            dArray5 = dArray9;
            dArray4 = dArray10;
        }
        if (bl || n == 0 || dArray2 != null || n == 1) {
            bl2 = true;
        }
        if (bl || n == 10 || dArray3 != null || n == 1) {
            bl3 = true;
        }
        if (n == 1) {
            n5 = 2;
        }
        if (!this.swed.jpl_file_is_open && (n4 = this.open_jpl_file(dArray7, this.swed.jplfnam, this.swed.ephepath, stringBuffer)) != 0) {
            throw new SwissephException(d, 17, n4, stringBuffer);
        }
        if (bl2) {
            if (d != planData2.teval || d == 0.0) {
                try {
                    n4 = this.sj.swi_pleph(d, 2, 11, dArray5, stringBuffer);
                }
                catch (SwissephException swissephException) {
                    n4 = swissephException.getRC();
                }
                if (n4 != 0) {
                    this.sj.swi_close_jpl_file();
                    this.swed.jpl_file_is_open = false;
                    return n4;
                }
                if (bl) {
                    planData2.teval = d;
                    planData2.xflgs = -1;
                    planData2.iephe = 1;
                }
            } else {
                dArray5 = planData2.x;
            }
            if (dArray2 != null) {
                for (n3 = 0; n3 <= 5; ++n3) {
                    dArray2[n3] = dArray5[n3];
                }
            }
        }
        if (bl3) {
            if (d != planData3.teval || d == 0.0) {
                try {
                    n4 = this.sj.swi_pleph(d, 10, 11, dArray4, stringBuffer);
                }
                catch (SwissephException swissephException) {
                    n4 = swissephException.getRC();
                }
                if (n4 != 0) {
                    this.sj.swi_close_jpl_file();
                    this.swed.jpl_file_is_open = false;
                    return n4;
                }
                if (bl) {
                    planData3.teval = d;
                    planData3.xflgs = -1;
                    planData3.iephe = 1;
                }
            } else {
                dArray4 = planData3.x;
            }
            if (dArray3 != null) {
                for (n3 = 0; n3 <= 5; ++n3) {
                    dArray3[n3] = dArray4[n3];
                }
            }
        }
        if (n == 0) {
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray6[n3] = dArray5[n3];
            }
        }
        if (n == 10) {
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray6[n3] = dArray4[n3];
            }
        } else if (d == planData.teval && planData.iephe == 1) {
            dArray6 = planData.x;
        } else {
            try {
                n4 = this.sj.swi_pleph(d, SwephData.pnoint2jpl[n], n5, dArray6, stringBuffer);
            }
            catch (SwissephException swissephException) {
                n4 = swissephException.getRC();
            }
            if (n4 != 0) {
                this.sj.swi_close_jpl_file();
                this.swed.jpl_file_is_open = false;
                return n4;
            }
            if (bl) {
                planData.teval = d;
                planData.xflgs = -1;
                planData.iephe = 1;
            }
        }
        if (dArray != null) {
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray[n3] = dArray6[n3];
            }
        }
        return 0;
    }

    int sweph(double d, int n, int n2, int n3, double[] dArray, boolean bl, double[] dArray2, StringBuffer stringBuffer) {
        int n4;
        int n5;
        String string = "";
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        FileData fileData = this.swed.fidat[n2];
        int n6 = n;
        if (n > 10000) {
            n6 = 11;
        }
        PlanData planData3 = this.swed.pldat[n6];
        double[] dArray5 = bl ? planData3.x : dArray4;
        int n7 = planData3.xflgs & 0x100;
        int n8 = n3 & 0x100;
        if (d == planData3.teval && planData3.iephe == 2 && (n8 == 0 || n7 != 0) && n6 < 11) {
            if (dArray2 != null) {
                for (int i = 0; i <= 5; ++i) {
                    dArray2[i] = planData3.x[i];
                }
            }
            return 0;
        }
        if (fileData.fptr != null && (d < fileData.tfstart || d > fileData.tfend || n6 == 11 && n != planData3.ibdy)) {
            try {
                fileData.fptr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fileData.fptr = null;
            planData3.refep = null;
            planData3.segp = null;
        }
        if (fileData.fptr == null) {
            int n9;
            String string2 = "";
            try {
                string2 = SwissLib.swi_gen_filename(d, n);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            String string3 = string2;
            if (string3.lastIndexOf(SwissData.DIR_GLUE) > 0) {
                string3 = string3.substring(0, string3.indexOf(SwissData.DIR_GLUE));
                n9 = string3.length();
            } else {
                n9 = 0;
            }
            string = string2;
            while (fileData.fptr == null) {
                try {
                    fileData.fptr = this.swi_fopen(n2, string, this.swed.ephepath, stringBuffer);
                }
                catch (SwissephException swissephException) {
                    // empty catch block
                }
                if (fileData.fptr != null) continue;
                if (n > 10000) {
                    if (string.indexOf("s.") < 0) {
                        string = string.substring(0, string.indexOf(".")) + "s." + "se1";
                        continue;
                    }
                    string = string.substring(0, string.indexOf("s.")) + string.substring(string.indexOf("s.") + 1);
                    if (n9 > 0 && string.startsWith(string3.substring(0, SMath.min(string3.length(), n9)))) {
                        string = string.substring(n9 + 1);
                        continue;
                    }
                }
                return -2;
            }
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
            }
            if ((n5 = this.swed.fidat[n2].read_const(n2, stringBuffer, this.swed)) != 0) {
                return n5;
            }
        }
        if (d < fileData.tfstart || d > fileData.tfend) {
            if (stringBuffer != null) {
                string = d < fileData.tfstart ? "jd " + d + " < Swiss Eph. lower limit " + fileData.tfstart + ";" : "jd " + d + " > Swiss Eph. upper limit " + fileData.tfend + ";";
                if (stringBuffer.length() + string.length() < 256) {
                    stringBuffer.append(string);
                }
            }
            return -2;
        }
        if (planData3.segp == null || d < planData3.tseg0 || d > planData3.tseg1) {
            n5 = this.swed.fidat[n2].get_new_segment(this.swed, d, n6, n2, stringBuffer);
            if (n5 != 0) {
                return n5;
            }
            if ((planData3.iflg & 2) != 0) {
                this.rot_back(n6);
            } else {
                planData3.neval = planData3.ncoe;
            }
        }
        double d2 = (d - planData3.tseg0) / planData3.dseg;
        d2 = d2 * 2.0 - 1.0;
        boolean bl2 = bl || (n3 & 0x100) != 0;
        for (n4 = 0; n4 <= 2; ++n4) {
            dArray5[n4] = this.sl.swi_echeb(d2, planData3.segp, n4 * planData3.ncoe, planData3.neval);
            dArray5[n4 + 3] = bl2 ? this.sl.swi_edcheb(d2, planData3.segp, n4 * planData3.ncoe, planData3.neval) / planData3.dseg * 2.0 : 0.0;
        }
        if (n6 == 10 && (planData3.iflg & 8) != 0) {
            double d3 = planData.teval;
            planData.teval = 0.0;
            n5 = this.sweph(d, 0, n2, n3 | 0x100, null, false, dArray3, stringBuffer);
            if (n5 != 0) {
                return n5;
            }
            planData.teval = d3;
            for (n4 = 0; n4 <= 2; ++n4) {
                dArray5[n4] = dArray3[n4] - dArray5[n4];
            }
            if (bl2) {
                for (n4 = 3; n4 <= 5; ++n4) {
                    dArray5[n4] = dArray3[n4] - dArray5[n4];
                }
            }
        }
        if (((n3 & 1) != 0 || (n3 & 2) != 0) && n6 >= 11) {
            for (n4 = 0; n4 <= 2; ++n4) {
                int n10 = n4;
                dArray5[n10] = dArray5[n10] + dArray[n4];
            }
            if (bl2) {
                for (n4 = 3; n4 <= 5; ++n4) {
                    int n11 = n4;
                    dArray5[n11] = dArray5[n11] + dArray[n4];
                }
            }
        }
        if (bl) {
            planData3.teval = d;
            planData3.xflgs = -1;
            planData3.iephe = n2 == 0 || n2 == 1 ? 2 : planData2.iephe;
        }
        if (dArray2 != null) {
            for (n4 = 0; n4 <= 5; ++n4) {
                dArray2[n4] = dArray5[n4];
            }
        }
        return 0;
    }

    FilePtr swi_fopen(int n, String string, String string2, StringBuffer stringBuffer) throws SwissephException {
        String string3;
        RandomAccessFile randomAccessFile = null;
        String[] stringArray = new String[20];
        String string4 = string2;
        int n2 = this.sl.swi_cutstr(string4, ";:", stringArray, 20);
        for (int i = 0; i < n2; ++i) {
            FilePtr filePtr;
            string3 = stringArray[i];
            if (string3.equals(".")) {
                string3 = "";
            } else if (!string3.endsWith(SwissData.DIR_GLUE) && !string3.equals("")) {
                string3 = string3 + SwissData.DIR_GLUE;
            }
            if (string3.length() + string.length() < 256) {
                string3 = string3 + string;
            } else if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("error: file path and name must be shorter than 256.");
                throw new SwissephException(Double.POSITIVE_INFINITY, 5, -1, stringBuffer);
            }
            String string5 = string3;
            try {
                randomAccessFile = new RandomAccessFile(string5, "r");
                if (n >= 0) {
                    this.swed.fidat[n].fnam = string5;
                }
                FilePtr filePtr2 = new FilePtr(randomAccessFile, null, null, null, string5, -1L, this.httpBufSize);
                return filePtr2;
            }
            catch (IOException iOException) {
                filePtr = this.tryFileAsURL(string3 + "/" + string, n);
                if (filePtr == null) continue;
                return filePtr;
            }
            catch (SecurityException securityException) {
                filePtr = this.tryFileAsURL(string3 + "/" + string, n);
                if (filePtr == null) continue;
                return filePtr;
            }
        }
        string3 = "SwissEph file '" + string + "' not found in the paths of: ";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || "".equals(stringArray[i])) continue;
            string3 = string3 + "'" + stringArray[i] + "', ";
        }
        if (stringBuffer != null) {
            stringBuffer.setLength(0);
            stringBuffer.append(string3);
        }
        throw new SwissephException(Double.POSITIVE_INFINITY, 9, -2, stringBuffer);
    }

    private FilePtr tryFileAsURL(String string, int n) {
        if (!string.startsWith("http://")) {
            return null;
        }
        Socket socket = null;
        try {
            URL uRL = new URL(string);
            socket = new Socket(uRL.getHost(), uRL.getPort() < 0 ? 80 : uRL.getPort());
            String string2 = "HEAD " + string + " HTTP/1.1\r\nUser-Agent: " + "swisseph-java-2.01.00_02" + "\r\nHost: " + uRL.getHost() + ":" + (uRL.getPort() < 0 ? 80 : uRL.getPort()) + "\r\n\r\n";
            socket.setSoTimeout(5000);
            InputStream inputStream = socket.getInputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
            for (int i = 0; i < string2.length(); ++i) {
                bufferedOutputStream.write((byte)string2.charAt(i));
            }
            bufferedOutputStream.flush();
            String string3 = "" + (char)inputStream.read();
            while (inputStream.available() > 0) {
                string3 = string3 + (char)inputStream.read();
            }
            int n2 = string3.indexOf("Content-Length:");
            if (n2 < 0) {
                socket.close();
                return null;
            }
            if (string3.indexOf("Accept-Ranges: none") >= 0) {
                System.err.println("Server does not accept HTTP range requests. Aborting!");
                socket.close();
                return null;
            }
            string3 = string3.substring(n2 + "Content-Length:".length());
            string3 = string3.substring(0, string3.indexOf("\n")).trim();
            long l = Long.parseLong(string3);
            if (n >= 0) {
                this.swed.fidat[n].fnam = string;
            }
            return new FilePtr(null, socket, inputStream, bufferedOutputStream, string, l, this.httpBufSize);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    int app_pos_etc_plan(int n, int n2, StringBuffer stringBuffer) {
        int n3;
        PlanData planData;
        int n4;
        int n5;
        int n6 = 0;
        double[] dArray = new double[6];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        PlanData planData2 = this.swed.pldat[0];
        Epsilon epsilon = this.swed.oec2000;
        int n7 = n2 & 7;
        double d = 0.0;
        double d2 = 0.0;
        if (n > 10000) {
            n5 = 3;
            n4 = 2;
            planData = this.swed.pldat[11];
        } else if (n == 12 || n == 13 || n == 14 || n == 15 || n == 16 || n == 17) {
            n5 = 2;
            n4 = 3;
            planData = this.swed.pldat[n];
        } else {
            n5 = 0;
            n4 = 0;
            planData = this.swed.pldat[n];
        }
        int n8 = n2 & 0xFFFFF7FF & 0xFFFFEFFF;
        int n9 = planData.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (n8 == n9) {
            planData.xflgs = n2;
            planData.iephe = n2 & 7;
            return 0;
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            dArray[n3] = planData.x[n3];
        }
        if ((n2 & 8) != 0 && (planData.iephe == 1 || planData.iephe == 2)) {
            for (n3 = 0; n3 <= 5; ++n3) {
                int n10 = n3;
                dArray[n10] = dArray[n10] - this.swed.pldat[10].x[n3];
            }
        }
        if ((n2 & 0x8000) != 0) {
            if (this.swed.topd.teval != planData2.teval || planData2.teval == 0.0) {
                if (this.swi_get_observer(planData2.teval, n2 | 0x40, true, dArray3, stringBuffer) != 0) {
                    return -1;
                }
            } else {
                for (n3 = 0; n3 <= 5; ++n3) {
                    dArray3[n3] = this.swed.topd.xobs[n3];
                }
            }
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray3[n3] = dArray3[n3] + planData2.x[n3];
            }
        } else {
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray3[n3] = planData2.x[n3];
            }
        }
        if ((n2 & 0x10) == 0) {
            double d3;
            int n11;
            int n12 = planData.iephe == 1 || planData.iephe == 2 ? 1 : 0;
            if ((n2 & 0x100) != 0) {
                for (n3 = 0; n3 <= 2; ++n3) {
                    dArray8[n3] = dArray7[n3] = dArray[n3] - dArray[n3 + 3];
                }
                for (n11 = 0; n11 <= n12; ++n11) {
                    for (n3 = 0; n3 <= 2; ++n3) {
                        dArray2[n3] = dArray7[n3];
                        if ((n2 & 8) != 0 || (n2 & 0x4000) != 0) continue;
                        int n13 = n3;
                        dArray2[n13] = dArray2[n13] - (dArray3[n3] - dArray3[n3 + 3]);
                    }
                    d3 = SMath.sqrt(this.sl.square_sum(dArray2)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                    for (n3 = 0; n3 <= 2; ++n3) {
                        dArray7[n3] = dArray8[n3] - d3 * planData.x[n3 + 3];
                    }
                }
                for (n3 = 0; n3 <= 2; ++n3) {
                    dArray7[n3] = dArray8[n3] - dArray7[n3];
                }
            }
            for (n11 = 0; n11 <= n12; ++n11) {
                for (n3 = 0; n3 <= 2; ++n3) {
                    dArray2[n3] = dArray[n3];
                    if ((n2 & 8) != 0 || (n2 & 0x4000) != 0) continue;
                    int n14 = n3;
                    dArray2[n14] = dArray2[n14] - dArray3[n3];
                }
                d3 = SMath.sqrt(this.sl.square_sum(dArray2)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                d2 = planData.teval - d3;
                d = d3;
                for (n3 = 0; n3 <= 2; ++n3) {
                    dArray[n3] = planData.x[n3] - d3 * planData.x[n3 + 3];
                }
            }
            if ((n2 & 0x100) != 0) {
                for (n3 = 0; n3 <= 2; ++n3) {
                    dArray7[n3] = planData.x[n3] - dArray[n3] - dArray7[n3];
                }
            }
            switch (n7) {
                case 1: {
                    int n15 = n4 >= 2 ? -1 : SwephData.pnoint2jpl[n];
                    if (n4 == 0) {
                        try {
                            n6 = this.sj.swi_pleph(d2, n15, 11, dArray, stringBuffer);
                        }
                        catch (SwissephException swissephException) {
                            n6 = swissephException.getRC();
                        }
                        if (n6 != 0) {
                            this.sj.swi_close_jpl_file();
                            this.swed.jpl_file_is_open = false;
                        }
                    } else {
                        try {
                            n6 = this.sj.swi_pleph(d2, 10, 11, dArray6, stringBuffer);
                        }
                        catch (SwissephException swissephException) {
                            n6 = swissephException.getRC();
                        }
                        if (n6 != 0) {
                            this.sj.swi_close_jpl_file();
                            this.swed.jpl_file_is_open = false;
                        }
                        n6 = this.sweph(d2, n, n5, n2, dArray6, false, dArray, stringBuffer);
                    }
                    if (n6 != 0) {
                        return n6;
                    }
                    if ((n2 & 0x100) == 0 || (n2 & 8) != 0 || (n2 & 0x4000) != 0) break;
                    try {
                        n6 = this.sj.swi_pleph(d2, 2, 11, dArray5, stringBuffer);
                    }
                    catch (SwissephException swissephException) {
                        n6 = swissephException.getRC();
                    }
                    if (n6 == 0) break;
                    this.sj.swi_close_jpl_file();
                    this.swed.jpl_file_is_open = false;
                    return n6;
                }
                case 2: {
                    if (n4 == 0) {
                        n6 = this.sweplan(d2, n, n5, n2, false, dArray, dArray5, dArray6, null, stringBuffer);
                    } else {
                        n6 = this.sweplan(d2, 0, 0, n2, false, dArray5, null, dArray6, null, stringBuffer);
                        if (n6 == 0) {
                            n6 = this.sweph(d2, n, n5, n2, dArray6, false, dArray, stringBuffer);
                        }
                    }
                    if (n6 == 0) break;
                    return n6;
                }
                default: {
                    if ((n2 & 0x100) == 0 || (n2 & 0x4008) != 0) break;
                    if (n4 == 0) {
                        n6 = this.smosh.swi_moshplan(d2, n, false, dArray8, dArray5, stringBuffer);
                    } else {
                        n6 = this.sweph(d2, n, n5, n2, null, false, dArray8, stringBuffer);
                        if (n6 == 0) {
                            n6 = this.smosh.swi_moshplan(d2, 0, false, dArray5, dArray5, stringBuffer);
                        }
                    }
                    if (n6 != 0) {
                        return n6;
                    }
                    for (n3 = 3; n3 <= 5; ++n3) {
                        dArray[n3] = dArray8[n3];
                    }
                }
            }
            if ((n2 & 8) != 0 && (planData.iephe == 1 || planData.iephe == 2)) {
                for (n3 = 0; n3 <= 5; ++n3) {
                    int n16 = n3;
                    dArray[n16] = dArray[n16] - this.swed.pldat[10].x[n3];
                }
            }
            if ((n2 & 0x100) != 0) {
                if ((n2 & 0x8000) != 0) {
                    if (this.swi_get_observer(d2, n2 | 0x40, false, dArray4, stringBuffer) != 0) {
                        return -1;
                    }
                    for (n3 = 0; n3 <= 5; ++n3) {
                        int n17 = n3;
                        dArray4[n17] = dArray4[n17] + dArray5[n3];
                    }
                } else {
                    for (n3 = 0; n3 <= 5; ++n3) {
                        dArray4[n3] = dArray5[n3];
                    }
                }
            }
        }
        if ((n2 & 8) == 0 && (n2 & 0x4000) == 0) {
            for (n3 = 0; n3 <= 5; ++n3) {
                int n18 = n3;
                dArray[n18] = dArray[n18] - dArray3[n3];
            }
            if ((n2 & 0x10) == 0 && (n2 & 0x100) != 0) {
                for (n3 = 3; n3 <= 5; ++n3) {
                    int n19 = n3;
                    dArray[n19] = dArray[n19] - dArray7[n3 - 3];
                }
            }
        }
        if ((n2 & 0x100) == 0) {
            for (n3 = 3; n3 <= 5; ++n3) {
                dArray[n3] = 0.0;
            }
        }
        if ((n2 & 0x10) == 0 && (n2 & 0x200) == 0) {
            this.swi_deflect_light(dArray, 0, d, n2);
        }
        if ((n2 & 0x10) == 0 && (n2 & 0x400) == 0) {
            this.swi_aberr_light(dArray, dArray3, n2);
            if ((n2 & 0x100) != 0) {
                for (n3 = 3; n3 <= 5; ++n3) {
                    int n20 = n3;
                    dArray[n20] = dArray[n20] + (dArray3[n3] - dArray4[n3]);
                }
            }
        }
        if ((n2 & 0x100) == 0) {
            for (n3 = 3; n3 <= 5; ++n3) {
                dArray[n3] = 0.0;
            }
        }
        if ((n2 & 0x20000) == 0 && this.swed.jpldenum >= 403) {
            this.sl.swi_bias(dArray, d2, n2, false);
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            dArray8[n3] = dArray[n3];
        }
        if ((n2 & 0x20) == 0) {
            this.sl.swi_precess(dArray, planData.teval, n2, -1);
            if ((n2 & 0x100) != 0) {
                this.swi_precess_speed(dArray, planData.teval, n2, -1);
            }
            epsilon = this.swed.oec;
        } else {
            epsilon = this.swed.oec2000;
        }
        return this.app_pos_rest(planData, n2, dArray, dArray8, epsilon, stringBuffer);
    }

    int app_pos_rest(PlanData planData, int n, double[] dArray, double[] dArray2, Epsilon epsilon, StringBuffer stringBuffer) {
        int n2;
        if ((n & 0x40) == 0) {
            this.swi_nutate(dArray, 0, n, false);
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            planData.xreturn[18 + n2] = dArray[n2];
        }
        this.sl.swi_coortrf2(dArray, dArray, epsilon.seps, epsilon.ceps);
        if ((n & 0x100) != 0) {
            this.sl.swi_coortrf2(dArray, 3, dArray, 3, epsilon.seps, epsilon.ceps);
        }
        if ((n & 0x40) == 0) {
            this.sl.swi_coortrf2(dArray, dArray, this.swed.nut.snut, this.swed.nut.cnut);
            if ((n & 0x100) != 0) {
                this.sl.swi_coortrf2(dArray, 3, dArray, 3, this.swed.nut.snut, this.swed.nut.cnut);
            }
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            planData.xreturn[6 + n2] = dArray[n2];
        }
        if ((n & 0x10000) != 0) {
            if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                if (this.swi_trop_ra2sid_lon(dArray2, planData.xreturn, 6, planData.xreturn, 18, n, stringBuffer) != 0) {
                    return -1;
                }
            } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                if (this.swi_trop_ra2sid_lon_sosy(dArray2, planData.xreturn, 6, planData.xreturn, 18, n, stringBuffer) != 0) {
                    return -1;
                }
            } else {
                this.sl.swi_cartpol_sp(planData.xreturn, 6, planData.xreturn, 0);
                planData.xreturn[0] = planData.xreturn[0] - this.swe_get_ayanamsa(planData.teval) * 0.0174532925199433;
                this.sl.swi_polcart_sp(planData.xreturn, 0, planData.xreturn, 6);
            }
        }
        this.sl.swi_cartpol_sp(planData.xreturn, 18, planData.xreturn, 12);
        this.sl.swi_cartpol_sp(planData.xreturn, 6, planData.xreturn, 0);
        for (n2 = 0; n2 < 2; ++n2) {
            int n3 = n2;
            planData.xreturn[n3] = planData.xreturn[n3] * 57.2957795130823;
            int n4 = n2 + 3;
            planData.xreturn[n4] = planData.xreturn[n4] * 57.2957795130823;
            int n5 = n2 + 12;
            planData.xreturn[n5] = planData.xreturn[n5] * 57.2957795130823;
            int n6 = n2 + 15;
            planData.xreturn[n6] = planData.xreturn[n6] * 57.2957795130823;
        }
        planData.xflgs = n;
        planData.iephe = n & 7;
        return 0;
    }

    int swi_trop_ra2sid_lon(double[] dArray, double[] dArray2, double[] dArray3, int n, StringBuffer stringBuffer) {
        return this.swi_trop_ra2sid_lon(dArray, dArray2, 0, dArray3, 0, n, stringBuffer);
    }

    int swi_trop_ra2sid_lon(double[] dArray, double[] dArray2, int n, double[] dArray3, int n2, int n3, StringBuffer stringBuffer) {
        int n4;
        double[] dArray4 = new double[6];
        SidData sidData = this.swed.sidd;
        Epsilon epsilon = new Epsilon();
        for (n4 = 0; n4 <= 5; ++n4) {
            dArray4[n4] = dArray[n4];
        }
        if (sidData.t0 != 2451545.0) {
            this.sl.swi_precess(dArray4, sidData.t0, 0, -1);
            this.sl.swi_precess(dArray4, 3, sidData.t0, 0, -1);
        }
        for (n4 = 0; n4 <= 5; ++n4) {
            dArray3[n4 + n2] = dArray4[n4];
        }
        this.calc_epsilon(this.swed.sidd.t0, n3, epsilon);
        this.sl.swi_coortrf2(dArray4, dArray4, epsilon.seps, epsilon.ceps);
        if ((n3 & 0x100) != 0) {
            this.sl.swi_coortrf2(dArray4, 3, dArray4, 3, epsilon.seps, epsilon.ceps);
        }
        this.sl.swi_cartpol_sp(dArray4, dArray4);
        dArray4[0] = dArray4[0] - sidData.ayan_t0 * 0.0174532925199433;
        this.sl.swi_polcart_sp(dArray4, 0, dArray2, n);
        return 0;
    }

    int swi_trop_ra2sid_lon_sosy(double[] dArray, double[] dArray2, double[] dArray3, int n, StringBuffer stringBuffer) {
        return this.swi_trop_ra2sid_lon_sosy(dArray, dArray2, 0, dArray3, 0, n, stringBuffer);
    }

    int swi_trop_ra2sid_lon_sosy(double[] dArray, double[] dArray2, int n, double[] dArray3, int n2, int n3, StringBuffer stringBuffer) {
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        SidData sidData = this.swed.sidd;
        Epsilon epsilon = this.swed.oec2000;
        double d = 1.877670046803984;
        double d2 = 0.027553530354527005;
        for (int i = 0; i <= 5; ++i) {
            dArray4[i] = dArray[i];
        }
        this.sl.swi_coortrf2(dArray4, dArray4, epsilon.seps, epsilon.ceps);
        if ((n3 & 0x100) != 0) {
            this.sl.swi_coortrf2(dArray4, 3, dArray4, 3, epsilon.seps, epsilon.ceps);
        }
        this.sl.swi_cartpol_sp(dArray4, dArray4);
        dArray4[0] = dArray4[0] - d;
        this.sl.swi_polcart_sp(dArray4, dArray4);
        this.sl.swi_coortrf(dArray4, dArray4, d2);
        this.sl.swi_coortrf(dArray4, 3, dArray4, 3, d2);
        this.sl.swi_cartpol_sp(dArray4, dArray4);
        dArray5[0] = 1.0;
        dArray5[2] = 0.0;
        dArray5[1] = 0.0;
        if (sidData.t0 != 2451545.0) {
            this.sl.swi_precess(dArray5, sidData.t0, 0, 1);
        }
        this.sl.swi_coortrf2(dArray5, dArray5, epsilon.seps, epsilon.ceps);
        this.sl.swi_cartpol(dArray5, dArray5);
        dArray5[0] = dArray5[0] - d;
        this.sl.swi_polcart(dArray5, dArray5);
        this.sl.swi_coortrf(dArray5, dArray5, d2);
        this.sl.swi_cartpol(dArray5, dArray5);
        dArray4[0] = dArray4[0] - dArray5[0];
        dArray4[0] = dArray4[0] * 57.2957795130823;
        dArray4[0] = dArray4[0] - sidData.ayan_t0;
        dArray4[0] = this.sl.swe_degnorm(dArray4[0]) * 0.0174532925199433;
        this.sl.swi_polcart_sp(dArray4, 0, dArray2, n);
        return 0;
    }

    int app_pos_etc_plan_osc(int n, int n2, int n3, StringBuffer stringBuffer) {
        int n4;
        double[] dArray = new double[6];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[]{0.0, 0.0, 0.0};
        double[] dArray8 = new double[6];
        double[] dArray9 = new double[6];
        PlanData planData = this.swed.pldat[n2];
        PlanData planData2 = this.swed.pldat[0];
        PlanData planData3 = this.swed.pldat[10];
        Epsilon epsilon = this.swed.oec2000;
        int n5 = 2;
        double d = 0.0;
        double d2 = 0.0;
        if ((n3 & 4) != 0) {
            n5 = 4;
        } else if ((n3 & 2) != 0) {
            n5 = 2;
        } else if ((n3 & 1) != 0) {
            n5 = 1;
        }
        for (n4 = 0; n4 <= 5; ++n4) {
            dArray[n4] = planData.x[n4];
        }
        if ((n3 & 0x8000) != 0) {
            if (this.swed.topd.teval != planData2.teval || this.swed.topd.teval != 0.0) {
                if (this.swi_get_observer(planData2.teval, n3 | 0x40, true, dArray8, stringBuffer) != 0) {
                    return -1;
                }
            } else {
                for (n4 = 0; n4 <= 5; ++n4) {
                    dArray8[n4] = this.swed.topd.xobs[n4];
                }
            }
            for (n4 = 0; n4 <= 5; ++n4) {
                dArray8[n4] = dArray8[n4] + planData2.x[n4];
            }
        } else if ((n3 & 0x4000) != 0) {
            for (n4 = 0; n4 <= 5; ++n4) {
                dArray8[n4] = 0.0;
            }
        } else if ((n3 & 8) != 0) {
            if ((n3 & 4) != 0) {
                for (n4 = 0; n4 <= 5; ++n4) {
                    dArray8[n4] = 0.0;
                }
            } else {
                for (n4 = 0; n4 <= 5; ++n4) {
                    dArray8[n4] = planData3.x[n4];
                }
            }
        } else {
            for (n4 = 0; n4 <= 5; ++n4) {
                dArray8[n4] = planData2.x[n4];
            }
        }
        if ((n3 & 0x10) == 0) {
            int n6;
            int n7 = 1;
            if ((n3 & 0x100) != 0) {
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray6[n4] = dArray7[n4] = dArray[n4] - dArray[n4 + 3];
                }
                for (n6 = 0; n6 <= n7; ++n6) {
                    for (n4 = 0; n4 <= 2; ++n4) {
                        dArray2[n4] = dArray7[n4];
                        if ((n3 & 8) != 0 || (n3 & 0x4000) != 0) continue;
                        int n8 = n4;
                        dArray2[n8] = dArray2[n8] - (dArray8[n4] - dArray8[n4 + 3]);
                    }
                    d2 = SMath.sqrt(this.sl.square_sum(dArray2)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                    for (n4 = 0; n4 <= 2; ++n4) {
                        dArray7[n4] = dArray6[n4] - d2 * planData.x[n4 + 3];
                    }
                }
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray7[n4] = dArray6[n4] - dArray7[n4];
                }
            }
            for (n6 = 0; n6 <= n7; ++n6) {
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray2[n4] = dArray[n4];
                    if ((n3 & 8) != 0 || (n3 & 0x4000) != 0) continue;
                    int n9 = n4;
                    dArray2[n9] = dArray2[n9] - dArray8[n4];
                }
                d = d2 = SMath.sqrt(this.sl.square_sum(dArray2)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray[n4] = planData.x[n4] - d2 * planData.x[n4 + 3];
                    dArray[n4 + 3] = planData.x[n4 + 3];
                }
            }
            if ((n3 & 0x100) != 0) {
                for (n4 = 0; n4 <= 2; ++n4) {
                    dArray7[n4] = planData.x[n4] - dArray[n4] - dArray7[n4];
                }
                double d3 = planData.teval - d2;
                int n10 = this.main_planet_bary(d3, 0, n5, n3, false, dArray3, dArray3, dArray4, dArray5, stringBuffer);
                if (this.smosh.swi_osc_el_plan(d3, dArray, n - 40, n2, dArray3, dArray4, stringBuffer) != 0) {
                    return -1;
                }
                if (n10 != 0) {
                    return n10;
                }
                if ((n3 & 0x8000) != 0) {
                    if (this.swi_get_observer(d3, n3 | 0x40, false, dArray9, stringBuffer) != 0) {
                        return -1;
                    }
                    for (n4 = 0; n4 <= 5; ++n4) {
                        int n11 = n4;
                        dArray9[n11] = dArray9[n11] + dArray3[n4];
                    }
                } else {
                    for (n4 = 0; n4 <= 5; ++n4) {
                        dArray9[n4] = dArray3[n4];
                    }
                }
            }
        }
        for (n4 = 0; n4 <= 5; ++n4) {
            int n12 = n4;
            dArray[n12] = dArray[n12] - dArray8[n4];
        }
        if ((n3 & 0x10) == 0 && (n3 & 0x100) != 0) {
            for (n4 = 3; n4 <= 5; ++n4) {
                int n13 = n4;
                dArray[n13] = dArray[n13] - dArray7[n4 - 3];
            }
        }
        if ((n3 & 0x100) == 0) {
            for (n4 = 3; n4 <= 5; ++n4) {
                dArray[n4] = 0.0;
            }
        }
        if ((n3 & 0x10) == 0 && (n3 & 0x200) == 0) {
            this.swi_deflect_light(dArray, 0, d, n3);
        }
        if ((n3 & 0x10) == 0 && (n3 & 0x400) == 0) {
            this.swi_aberr_light(dArray, dArray8, n3);
            if ((n3 & 0x100) != 0) {
                for (n4 = 3; n4 <= 5; ++n4) {
                    int n14 = n4;
                    dArray[n14] = dArray[n14] + (dArray8[n4] - dArray9[n4]);
                }
            }
        }
        for (n4 = 0; n4 <= 5; ++n4) {
            dArray6[n4] = dArray[n4];
        }
        if ((n3 & 0x20) == 0) {
            this.sl.swi_precess(dArray, planData.teval, n3, -1);
            if ((n3 & 0x100) != 0) {
                this.swi_precess_speed(dArray, planData.teval, n3, -1);
            }
            epsilon = this.swed.oec;
        } else {
            epsilon = this.swed.oec2000;
        }
        return this.app_pos_rest(planData, n3, dArray, dArray6, epsilon, stringBuffer);
    }

    void swi_precess_speed(double[] dArray, double d, int n, int n2) {
        this.swi_precess_speed(dArray, 0, d, n, n2);
    }

    void swi_precess_speed(double[] dArray, int n, double d, int n2, int n3) {
        Epsilon epsilon;
        double d2;
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double d3 = (d - 2451545.0) / 36525.0;
        int n4 = this.swed.astro_models[0];
        if (n4 == 0) {
            n4 = 8;
        }
        if (n3 == -1) {
            d2 = 1.0;
            epsilon = this.swed.oec;
        } else {
            d2 = -1.0;
            epsilon = this.swed.oec2000;
        }
        this.sl.swi_precess(dArray, 3 + n, d, n2, n3);
        this.sl.swi_coortrf2(dArray, n, dArray, n, epsilon.seps, epsilon.ceps);
        this.sl.swi_coortrf2(dArray, 3 + n, dArray, 3 + n, epsilon.seps, epsilon.ceps);
        this.sl.swi_cartpol_sp(dArray, n, dArray, n);
        if (n4 == 8) {
            this.sl.swi_ldp_peps(d, dArray2, null);
            this.sl.swi_ldp_peps(d + 1.0, dArray3, null);
            dArray[3] = dArray[3] + (dArray3[0] - dArray2[0]) * d2;
        } else {
            dArray[3] = dArray[3] + (50.290966 + 0.0222226 * d3) / 3600.0 / 365.25 * 0.0174532925199433 * d2;
        }
        this.sl.swi_polcart_sp(dArray, n, dArray, n);
        this.sl.swi_coortrf2(dArray, n, dArray, n, -epsilon.seps, epsilon.ceps);
        this.sl.swi_coortrf2(dArray, 3 + n, dArray, 3 + n, -epsilon.seps, epsilon.ceps);
    }

    void swi_nutate(double[] dArray, int n, int n2, boolean bl) {
        int n3;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray2[n3] = bl ? dArray[0 + n] * this.swed.nut.matrix[n3][0] + dArray[1 + n] * this.swed.nut.matrix[n3][1] + dArray[2 + n] * this.swed.nut.matrix[n3][2] : dArray[0 + n] * this.swed.nut.matrix[0][n3] + dArray[1 + n] * this.swed.nut.matrix[1][n3] + dArray[2 + n] * this.swed.nut.matrix[2][n3];
        }
        if ((n2 & 0x100) != 0) {
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray2[n3 + 3] = bl ? dArray[3 + n] * this.swed.nut.matrix[n3][0] + dArray[4 + n] * this.swed.nut.matrix[n3][1] + dArray[5 + n] * this.swed.nut.matrix[n3][2] : dArray[3 + n] * this.swed.nut.matrix[0][n3] + dArray[4 + n] * this.swed.nut.matrix[1][n3] + dArray[5 + n] * this.swed.nut.matrix[2][n3];
            }
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray3[n3] = bl ? dArray[0 + n] * this.swed.nutv.matrix[n3][0] + dArray[1 + n] * this.swed.nutv.matrix[n3][1] + dArray[2 + n] * this.swed.nutv.matrix[n3][2] : dArray[0 + n] * this.swed.nutv.matrix[0][n3] + dArray[1 + n] * this.swed.nutv.matrix[1][n3] + dArray[2 + n] * this.swed.nutv.matrix[2][n3];
                dArray[3 + n3 + n] = dArray2[3 + n3] + (dArray2[n3] - dArray3[n3]) / 1.0E-4;
            }
        }
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray[n3 + n] = dArray2[n3];
        }
    }

    void swi_aberr_light(double[] dArray, double[] dArray2, int n) {
        this.swi_aberr_light(dArray, 0, dArray2, n);
    }

    void swi_aberr_light(double[] dArray, int n, double[] dArray2, int n2) {
        int n3;
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double d = 1.0E-4;
        for (n3 = 0; n3 <= 5; ++n3) {
            dArray5[n3] = dArray3[n3] = dArray[n3 + n];
        }
        double d2 = SMath.sqrt(this.sl.square_sum(dArray5));
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray4[n3] = dArray2[n3 + 3] / 24.0 / 3600.0 / 2.99792458E8 * 1.4959787066E11;
        }
        double d3 = this.sl.square_sum(dArray4);
        double d4 = SMath.sqrt(1.0 - d3);
        double d5 = this.dot_prod(dArray5, dArray4) / d2;
        double d6 = 1.0 + d5 / (1.0 + d4);
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray[n3 + n] = (d4 * dArray[n3 + n] + d6 * d2 * dArray4[n3]) / (1.0 + d5);
        }
        if ((n2 & 0x100) != 0) {
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray5[n3] = dArray3[n3] - d * dArray3[n3 + 3];
            }
            d2 = SMath.sqrt(this.sl.square_sum(dArray5));
            d5 = this.dot_prod(dArray5, dArray4) / d2;
            d6 = 1.0 + d5 / (1.0 + d4);
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray6[n3] = (d4 * dArray5[n3] + d6 * d2 * dArray4[n3]) / (1.0 + d5);
            }
            for (n3 = 0; n3 <= 2; ++n3) {
                double d7 = dArray[n3 + n] - dArray3[n3];
                double d8 = dArray6[n3] - dArray5[n3];
                int n4 = n3 + 3 + n;
                dArray[n4] = dArray[n4] + (d7 -= d8) / d;
            }
        }
    }

    void swi_deflect_light(double[] dArray, int n, double d, int n2) {
        double d2;
        int n3;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        int n4 = planData.iephe;
        for (n3 = 0; n3 <= 5; ++n3) {
            dArray8[n3] = planData.x[n3];
        }
        if ((n2 & 0x8000) != 0) {
            for (n3 = 0; n3 <= 5; ++n3) {
                int n5 = n3;
                dArray8[n5] = dArray8[n5] + this.swed.topd.xobs[n3];
            }
        }
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray3[n3] = dArray[n3 + n];
        }
        if (n4 == 1 || n4 == 2) {
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray4[n3] = dArray8[n3] - planData2.x[n3];
            }
        } else {
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray4[n3] = dArray8[n3];
            }
        }
        if (n4 == 1 || n4 == 2) {
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray7[n3] = planData2.x[n3] - d * planData2.x[n3 + 3];
            }
            for (n3 = 3; n3 <= 5; ++n3) {
                dArray7[n3] = planData2.x[n3];
            }
        } else {
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray7[n3] = planData2.x[n3];
            }
        }
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray5[n3] = dArray[n3 + n] + dArray8[n3] - dArray7[n3];
        }
        double d3 = SMath.sqrt(this.sl.square_sum(dArray3));
        double d4 = SMath.sqrt(this.sl.square_sum(dArray5));
        double d5 = SMath.sqrt(this.sl.square_sum(dArray4));
        n3 = 0;
        while (n3 <= 2) {
            int n6 = n3;
            dArray3[n6] = dArray3[n6] / d3;
            int n7 = n3;
            dArray5[n7] = dArray5[n7] / d4;
            int n8 = n3++;
            dArray4[n8] = dArray4[n8] / d5;
        }
        double d6 = this.dot_prod(dArray3, dArray5);
        double d7 = this.dot_prod(dArray3, dArray4);
        double d8 = this.dot_prod(dArray5, dArray4);
        double d9 = SMath.sqrt(1.0 - d7 * d7);
        double d10 = d9 < (d2 = 0.004652417528031441 / d5) ? this.meff(d9 / d2) : 1.0;
        double d11 = 2.65424880035974E20 * d10 / 2.99792458E8 / 2.99792458E8 / 1.4959787066E11 / d5;
        double d12 = 1.0 + d8;
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray2[n3] = d3 * (dArray3[n3] + d11 / d12 * (d6 * dArray4[n3] - d7 * dArray5[n3]));
        }
        if ((n2 & 0x100) != 0) {
            double d13 = -5.0E-7;
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray3[n3] = dArray[n3 + n] - d13 * dArray[n3 + 3 + n];
            }
            if (n4 == 1 || n4 == 2) {
                for (n3 = 0; n3 <= 2; ++n3) {
                    dArray4[n3] = dArray8[n3] - planData2.x[n3] - d13 * (dArray8[n3 + 3] - planData2.x[n3 + 3]);
                }
            } else {
                for (n3 = 0; n3 <= 2; ++n3) {
                    dArray4[n3] = dArray8[n3] - d13 * dArray8[n3 + 3];
                }
            }
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray5[n3] = dArray3[n3] + dArray8[n3] - dArray7[n3] - d13 * (dArray8[n3 + 3] - dArray7[n3 + 3]);
            }
            d3 = SMath.sqrt(this.sl.square_sum(dArray3));
            d4 = SMath.sqrt(this.sl.square_sum(dArray5));
            d5 = SMath.sqrt(this.sl.square_sum(dArray4));
            n3 = 0;
            while (n3 <= 2) {
                int n9 = n3;
                dArray3[n9] = dArray3[n9] / d3;
                int n10 = n3;
                dArray5[n10] = dArray5[n10] / d4;
                int n11 = n3++;
                dArray4[n11] = dArray4[n11] / d5;
            }
            d6 = this.dot_prod(dArray3, dArray5);
            d7 = this.dot_prod(dArray3, dArray4);
            d8 = this.dot_prod(dArray5, dArray4);
            d9 = SMath.sqrt(1.0 - d7 * d7);
            d10 = d9 < (d2 = 0.004652417528031441 / d5) ? this.meff(d9 / d2) : 1.0;
            d11 = 2.65424880035974E20 * d10 / 2.99792458E8 / 2.99792458E8 / 1.4959787066E11 / d5;
            d12 = 1.0 + d8;
            for (n3 = 0; n3 <= 2; ++n3) {
                dArray6[n3] = d3 * (dArray3[n3] + d11 / d12 * (d6 * dArray4[n3] - d7 * dArray5[n3]));
            }
            for (n3 = 0; n3 <= 2; ++n3) {
                double d14 = dArray2[n3] - dArray[n3 + n];
                double d15 = dArray6[n3] - dArray3[n3] * d3;
                int n12 = n3 + 3 + n;
                dArray[n12] = dArray[n12] + (d14 -= d15) / d13;
            }
        }
        for (n3 = 0; n3 <= 2; ++n3) {
            dArray[n3 + n] = dArray2[n3];
        }
    }

    private int app_pos_etc_sun(int n, StringBuffer stringBuffer) {
        int n2;
        int n3 = 0;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[3];
        double d = 0.0;
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        Epsilon epsilon = this.swed.oec2000;
        int n4 = n & 0xFFFFF7FF & 0xFFFFEFFF;
        int n5 = planData.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (n4 == n5) {
            planData.xflgs = n;
            planData.iephe = n & 7;
            return 0;
        }
        if ((n & 0x8000) != 0) {
            if (this.swed.topd.teval != planData.teval || this.swed.topd.teval == 0.0) {
                if (this.swi_get_observer(planData.teval, n | 0x40, true, dArray6, stringBuffer) != 0) {
                    return -1;
                }
            } else {
                for (n2 = 0; n2 <= 5; ++n2) {
                    dArray6[n2] = this.swed.topd.xobs[n2];
                }
            }
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray6[n2] = dArray6[n2] + planData.x[n2];
            }
        } else {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray6[n2] = planData.x[n2];
            }
        }
        if (planData.iephe == 4 || (n & 0x4000) != 0) {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray[n2] = dArray6[n2];
            }
        } else {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray[n2] = dArray6[n2] - planData2.x[n2];
            }
        }
        if ((n & 0x10) == 0 && (planData.iephe == 1 || planData.iephe == 2 || (n & 8) != 0 || (n & 0x4000) != 0)) {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray4[n2] = dArray6[n2];
                dArray5[n2] = planData.iephe == 4 ? 0.0 : planData2.x[n2];
            }
            int n6 = 1;
            for (int i = 0; i <= n6; ++i) {
                for (n2 = 0; n2 <= 2; ++n2) {
                    dArray3[n2] = dArray4[n2];
                    if ((n & 0x4000) != 0) continue;
                    int n7 = n2;
                    dArray3[n7] = dArray3[n7] - dArray5[n2];
                }
                double d2 = SMath.sqrt(this.sl.square_sum(dArray3)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                d = planData.teval - d2;
                switch (planData.iephe) {
                    case 1: {
                        try {
                            n3 = (n & 8) != 0 || (n & 0x4000) != 0 ? this.sj.swi_pleph(d, 2, 11, dArray4, stringBuffer) : this.sj.swi_pleph(d, 10, 11, dArray5, stringBuffer);
                        }
                        catch (SwissephException swissephException) {
                            n3 = swissephException.getRC();
                        }
                        if (n3 == 0) break;
                        this.sj.swi_close_jpl_file();
                        this.swed.jpl_file_is_open = false;
                        return n3;
                    }
                    case 2: {
                        if ((n & 8) != 0 || (n & 0x4000) != 0) {
                            n3 = this.sweplan(d, 0, 0, n, false, dArray4, null, dArray5, null, stringBuffer);
                            break;
                        }
                        n3 = this.sweph(d, 10, 0, n, null, false, dArray5, stringBuffer);
                        break;
                    }
                    case 4: {
                        if ((n & 8) == 0 && (n & 0x4000) == 0) break;
                        n3 = this.smosh.swi_moshplan(d, 0, false, dArray4, dArray4, stringBuffer);
                        break;
                    }
                    default: {
                        n3 = -1;
                    }
                }
                if (n3 == 0) continue;
                return n3;
            }
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray[n2] = dArray4[n2];
                if ((n & 0x4000) != 0) continue;
                int n8 = n2;
                dArray[n8] = dArray[n8] - dArray5[n2];
            }
        }
        if ((n & 0x100) == 0) {
            for (n2 = 3; n2 <= 5; ++n2) {
                dArray[n2] = 0.0;
            }
        }
        if ((n & 8) == 0 && (n & 0x4000) == 0) {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray[n2] = -dArray[n2];
            }
        }
        if ((n & 0x10) == 0 && (n & 0x400) == 0) {
            this.swi_aberr_light(dArray, dArray6, n);
        }
        if ((n & 0x100) == 0) {
            for (n2 = 3; n2 <= 5; ++n2) {
                dArray[n2] = 0.0;
            }
        }
        if ((n & 0x20000) == 0 && this.swed.jpldenum >= 403) {
            this.sl.swi_bias(dArray, d, n, false);
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        if ((n & 0x20) == 0) {
            this.sl.swi_precess(dArray, planData.teval, n, -1);
            if ((n & 0x100) != 0) {
                this.swi_precess_speed(dArray, planData.teval, n, -1);
            }
            epsilon = this.swed.oec;
        } else {
            epsilon = this.swed.oec2000;
        }
        return this.app_pos_rest(planData, n, dArray, dArray2, epsilon, stringBuffer);
    }

    int app_pos_etc_moon(int n, StringBuffer stringBuffer) {
        int n2;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        double[] dArray5 = new double[6];
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        PlanData planData3 = this.swed.pldat[1];
        Epsilon epsilon = this.swed.oec;
        double d = 0.0;
        int n3 = n & 0xFFFFF7FF & 0xFFFFEFFF;
        int n4 = planData3.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (n3 == n4) {
            planData3.xflgs = n;
            planData3.iephe = n & 7;
            return 0;
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            dArray[n2] = planData3.x[n2];
            dArray4[n2] = dArray[n2];
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            int n5 = n2;
            dArray[n5] = dArray[n5] + planData.x[n2];
        }
        if ((n & 0x8000) != 0) {
            if (this.swed.topd.teval != planData3.teval || this.swed.topd.teval == 0.0) {
                if (this.swi_get_observer(planData3.teval, n | 0x40, true, dArray3, null) != 0) {
                    return -1;
                }
            } else {
                for (n2 = 0; n2 <= 5; ++n2) {
                    dArray3[n2] = this.swed.topd.xobs[n2];
                }
            }
            for (n2 = 0; n2 <= 5; ++n2) {
                int n6 = n2;
                dArray4[n6] = dArray4[n6] - dArray3[n2];
            }
            for (n2 = 0; n2 <= 5; ++n2) {
                int n7 = n2;
                dArray3[n7] = dArray3[n7] + planData.x[n2];
            }
        } else if ((n & 0x4000) != 0) {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray3[n2] = 0.0;
            }
            for (n2 = 0; n2 <= 5; ++n2) {
                int n8 = n2;
                dArray4[n8] = dArray4[n8] + planData.x[n2];
            }
        } else if ((n & 8) != 0) {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray3[n2] = planData2.x[n2];
            }
            for (n2 = 0; n2 <= 5; ++n2) {
                int n9 = n2;
                dArray4[n9] = dArray4[n9] + (planData.x[n2] - planData2.x[n2]);
            }
        } else {
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray3[n2] = planData.x[n2];
            }
        }
        if ((n & 0x10) == 0) {
            double d2 = SMath.sqrt(this.sl.square_sum(dArray4)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            d = planData3.teval - d2;
            switch (planData3.iephe) {
                case 1: {
                    int n10;
                    try {
                        n10 = this.sj.swi_pleph(d, 9, 2, dArray, stringBuffer);
                    }
                    catch (SwissephException swissephException) {
                        n10 = swissephException.getRC();
                    }
                    if (n10 == 0) {
                        try {
                            n10 = this.sj.swi_pleph(d, 2, 11, dArray6, stringBuffer);
                        }
                        catch (SwissephException swissephException) {
                            n10 = swissephException.getRC();
                        }
                    }
                    if (n10 == 0 && (n & 8) != 0) {
                        try {
                            n10 = this.sj.swi_pleph(d, 10, 11, dArray5, stringBuffer);
                        }
                        catch (SwissephException swissephException) {
                            n10 = swissephException.getRC();
                        }
                    }
                    if (n10 != 0) {
                        this.sj.swi_close_jpl_file();
                        this.swed.jpl_file_is_open = false;
                    }
                    for (n2 = 0; n2 <= 5; ++n2) {
                        int n11 = n2;
                        dArray[n11] = dArray[n11] + dArray6[n2];
                    }
                    break;
                }
                case 2: {
                    int n10 = this.sweplan(d, 1, 1, n, false, dArray, dArray6, dArray5, null, stringBuffer);
                    if (n10 != 0) {
                        return n10;
                    }
                    for (n2 = 0; n2 <= 5; ++n2) {
                        int n12 = n2;
                        dArray[n12] = dArray[n12] + dArray6[n2];
                    }
                    break;
                }
                case 4: {
                    for (n2 = 0; n2 <= 2; ++n2) {
                        int n13 = n2;
                        dArray[n13] = dArray[n13] - d2 * dArray[n2 + 3];
                        dArray6[n2] = planData.x[n2] - d2 * planData.x[n2 + 3];
                        dArray6[n2 + 3] = planData.x[n2 + 3];
                        dArray5[n2] = 0.0;
                        dArray5[n2 + 3] = 0.0;
                    }
                    break;
                }
            }
            if ((n & 0x8000) != 0) {
                if (this.swi_get_observer(d, n | 0x40, false, dArray7, null) != 0) {
                    return -1;
                }
                for (n2 = 0; n2 <= 5; ++n2) {
                    int n14 = n2;
                    dArray7[n14] = dArray7[n14] + dArray6[n2];
                }
            } else if ((n & 0x4000) != 0) {
                for (n2 = 0; n2 <= 5; ++n2) {
                    dArray7[n2] = 0.0;
                }
            } else if ((n & 8) != 0) {
                for (n2 = 0; n2 <= 5; ++n2) {
                    dArray7[n2] = dArray5[n2];
                }
            } else {
                for (n2 = 0; n2 <= 5; ++n2) {
                    dArray7[n2] = dArray6[n2];
                }
            }
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            int n15 = n2;
            dArray[n15] = dArray[n15] - dArray3[n2];
        }
        if ((n & 0x10) == 0 && (n & 0x400) == 0) {
            this.swi_aberr_light(dArray, dArray3, n);
            if ((n & 0x100) != 0) {
                for (n2 = 3; n2 <= 5; ++n2) {
                    int n16 = n2;
                    dArray[n16] = dArray[n16] + (dArray3[n2] - dArray7[n2]);
                }
            }
        }
        if ((n & 0x100) == 0) {
            for (n2 = 3; n2 <= 5; ++n2) {
                dArray[n2] = 0.0;
            }
        }
        if ((n & 0x20000) == 0 && this.swed.jpldenum >= 403) {
            this.sl.swi_bias(dArray, d, n, false);
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        if ((n & 0x20) == 0) {
            this.sl.swi_precess(dArray, planData3.teval, n, -1);
            if ((n & 0x100) != 0) {
                this.swi_precess_speed(dArray, planData3.teval, n, -1);
            }
            epsilon = this.swed.oec;
        } else {
            epsilon = this.swed.oec2000;
        }
        return this.app_pos_rest(planData3, n, dArray, dArray2, epsilon, stringBuffer);
    }

    int app_pos_etc_sbar(int n, StringBuffer stringBuffer) {
        int n2;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        Epsilon epsilon = this.swed.oec;
        for (n2 = 0; n2 <= 5; ++n2) {
            dArray[n2] = planData2.x[n2];
        }
        if ((n & 0x10) == 0) {
            double d = SMath.sqrt(this.sl.square_sum(dArray)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            for (n2 = 0; n2 <= 2; ++n2) {
                int n3 = n2;
                dArray[n3] = dArray[n3] - d * dArray[n2 + 3];
            }
        }
        if ((n & 0x100) == 0) {
            for (n2 = 3; n2 <= 5; ++n2) {
                dArray[n2] = 0.0;
            }
        }
        if ((n & 0x20000) == 0 && this.swed.jpldenum >= 403) {
            this.sl.swi_bias(dArray, planData.teval, n, false);
        }
        for (n2 = 0; n2 <= 5; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        if ((n & 0x20) == 0) {
            this.sl.swi_precess(dArray, planData2.teval, n, -1);
            if ((n & 0x100) != 0) {
                this.swi_precess_speed(dArray, planData2.teval, n, -1);
            }
            epsilon = this.swed.oec;
        } else {
            epsilon = this.swed.oec2000;
        }
        return this.app_pos_rest(planData, n, dArray, dArray2, epsilon, stringBuffer);
    }

    int app_pos_etc_mean(int n, int n2, StringBuffer stringBuffer) {
        Epsilon epsilon;
        int n3;
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        PlanData planData = this.swed.nddat[n];
        int n4 = n2 & 0xFFFFF7FF & 0xFFFFEFFF;
        int n5 = planData.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        if (n4 == n5) {
            planData.xflgs = n2;
            planData.iephe = n2 & 7;
            return 0;
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            dArray[n3] = planData.x[n3];
        }
        this.sl.swi_polcart_sp(dArray, dArray);
        this.sl.swi_coortrf2(dArray, dArray, -this.swed.oec.seps, this.swed.oec.ceps);
        this.sl.swi_coortrf2(dArray, 3, dArray, 3, -this.swed.oec.seps, this.swed.oec.ceps);
        if ((n2 & 0x100) == 0) {
            for (n3 = 3; n3 <= 5; ++n3) {
                dArray[n3] = 0.0;
            }
        }
        if ((n2 & 0x10000) != 0 && (this.swed.sidd.sid_mode & 0x100) != 0 || (this.swed.sidd.sid_mode & 0x200) != 0) {
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray2[n3] = dArray[n3];
            }
            if (planData.teval != 2451545.0) {
                this.sl.swi_precess(dArray2, planData.teval, n2, 1);
                if ((n2 & 0x100) != 0) {
                    this.swi_precess_speed(dArray2, planData.teval, n2, 1);
                }
            }
        }
        if ((n2 & 0x20) != 0) {
            this.sl.swi_precess(dArray, planData.teval, n2, 1);
            if ((n2 & 0x100) != 0) {
                this.swi_precess_speed(dArray, planData.teval, n2, 1);
            }
            epsilon = this.swed.oec2000;
        } else {
            epsilon = this.swed.oec;
        }
        return this.app_pos_rest(planData, n2, dArray, dArray2, epsilon, stringBuffer);
    }

    void rot_back(int n) {
        double d;
        double d2;
        int n2;
        double[][] dArray = new double[41][3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double d3 = this.swed.oec2000.seps;
        double d4 = this.swed.oec2000.ceps;
        PlanData planData = this.swed.pldat[n];
        int n3 = planData.ncoe;
        double d5 = planData.tseg0 + planData.dseg / 2.0;
        double[] dArray5 = planData.segp;
        int n4 = n3;
        int n5 = 2 * n3;
        double d6 = (d5 - planData.telem) / 365250.0;
        if (n == 1) {
            double d7 = planData.prot + d6 * planData.dprot;
            n2 = (int)(d7 / (Math.PI * 2));
            d2 = (planData.qrot + d6 * planData.dqrot) * SMath.cos(d7 -= (double)n2 * (Math.PI * 2));
            d = (planData.qrot + d6 * planData.dqrot) * SMath.sin(d7);
        } else {
            d2 = planData.qrot + d6 * planData.dqrot;
            d = planData.prot + d6 * planData.dprot;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2][0] = dArray5[n2];
            dArray[n2][1] = dArray5[n2 + n4];
            dArray[n2][2] = dArray5[n2 + n5];
        }
        if ((planData.iflg & 4) != 0) {
            double[] dArray6 = planData.refep;
            int n6 = n3;
            double d8 = planData.peri + d6 * planData.dperi;
            n2 = (int)(d8 / (Math.PI * 2));
            double d9 = SMath.cos(d8 -= (double)n2 * (Math.PI * 2));
            double d10 = SMath.sin(d8);
            for (n2 = 0; n2 < n3; ++n2) {
                dArray[n2][0] = dArray5[n2] + d9 * dArray6[n2] - d10 * dArray6[n2 + n6];
                dArray[n2][1] = dArray5[n2 + n4] + d9 * dArray6[n2 + n6] + d10 * dArray6[n2];
            }
        }
        double d11 = 1.0 / (1.0 + d2 * d2 + d * d);
        dArray4[0] = 2.0 * d * d11;
        dArray4[1] = -2.0 * d2 * d11;
        dArray4[2] = (1.0 - d2 * d2 - d * d) * d11;
        dArray2[0] = (1.0 + d2 * d2 - d * d) * d11;
        dArray2[1] = 2.0 * d2 * d * d11;
        dArray2[2] = -2.0 * d * d11;
        dArray3[0] = 2.0 * d2 * d * d11;
        dArray3[1] = (1.0 - d2 * d2 + d * d) * d11;
        dArray3[2] = 2.0 * d2 * d11;
        for (n2 = 0; n2 < n3; ++n2) {
            double d12 = dArray[n2][0] * dArray2[0] + dArray[n2][1] * dArray3[0] + dArray[n2][2] * dArray4[0];
            double d13 = dArray[n2][0] * dArray2[1] + dArray[n2][1] * dArray3[1] + dArray[n2][2] * dArray4[1];
            double d14 = dArray[n2][0] * dArray2[2] + dArray[n2][1] * dArray3[2] + dArray[n2][2] * dArray4[2];
            if (SMath.abs(d12) + SMath.abs(d13) + SMath.abs(d14) >= 1.0E-14) {
                planData.neval = n2;
            }
            dArray[n2][0] = d12;
            dArray[n2][1] = d13;
            dArray[n2][2] = d14;
            if (n != 1) continue;
            dArray[n2][1] = d4 * d13 - d3 * d14;
            dArray[n2][2] = d3 * d13 + d4 * d14;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            dArray5[n2] = dArray[n2][0];
            dArray5[n2 + n4] = dArray[n2][1];
            dArray5[n2 + n5] = dArray[n2][2];
        }
    }

    void embofs(double[] dArray, int n, double[] dArray2, int n2) {
        for (int i = 0; i <= 2; ++i) {
            int n3 = i + n;
            dArray[n3] = dArray[n3] - dArray2[i + n2] / 82.30055985272827;
        }
    }

    void nut_matrix(Nut nut, Epsilon epsilon) {
        double d = nut.nutlo[0];
        double d2 = epsilon.eps + nut.nutlo[1];
        double d3 = SMath.sin(d);
        double d4 = SMath.cos(d);
        double d5 = epsilon.seps;
        double d6 = epsilon.ceps;
        double d7 = SMath.sin(d2);
        double d8 = SMath.cos(d2);
        nut.matrix[0][0] = d4;
        nut.matrix[0][1] = d3 * d8;
        nut.matrix[0][2] = d3 * d7;
        nut.matrix[1][0] = -d3 * d6;
        nut.matrix[1][1] = d4 * d8 * d6 + d7 * d5;
        nut.matrix[1][2] = d4 * d7 * d6 - d8 * d5;
        nut.matrix[2][0] = -d3 * d5;
        nut.matrix[2][1] = d4 * d8 * d5 - d7 * d6;
        nut.matrix[2][2] = d4 * d7 * d5 + d8 * d6;
    }

    /*
     * Unable to fully structure code
     */
    private int lunar_osc_elem(double var1_1, int var3_2, int var4_3, StringBuffer var5_4) {
        var9_5 = 1;
        var10_6 = 2;
        var11_7 = -1;
        var18_8 = 1.0E-4;
        var24_9 = new double[3][6];
        var25_10 = new double[3][6];
        var26_11 = new double[3][6];
        var28_12 = new double[6];
        var29_13 = new double[6];
        var17_14 = this.swed.oec;
        var14_15 = this.swed.nddat[var3_2];
        var12_16 = var4_3 & -2049 & -4097;
        var13_17 = var14_15.xflgs & -2049 & -4097;
        var74_18 = var14_15.xflgs & 256;
        var75_19 = var4_3 & 256;
        if (var1_1 == var14_15.teval && var1_1 != 0.0 && var12_16 == var13_17 && (var75_19 == 0 || var74_18 != 0)) {
            var14_15.xflgs = var4_3;
            var14_15.iephe = var4_3 & 7;
            return 0;
        }
        if ((var4_3 & 4) != 0) {
            var10_6 = 4;
        } else if ((var4_3 & 2) != 0) {
            var10_6 = 2;
        } else if ((var4_3 & 1) != 0) {
            var10_6 = 1;
        }
        this.swed.pldat[1].teval = 0.0;
        var8_20 = (var4_3 & 256) != 0 ? 0 : 2;
        if (var5_4 != null) {
            var5_4.setLength(0);
        }
        block9: do {
            block2 : switch (var10_6) {
                case 1: {
                    var18_8 = 1.0E-4;
                    for (var6_21 = var8_20; var6_21 <= 2; ++var6_21) {
                        var34_26 = var6_21 == 0 ? var1_1 - var18_8 : (var6_21 == 1 ? var1_1 + var18_8 : var1_1);
                        var27_25 = var24_9[var6_21];
                        try {
                            var11_7 = this.jplplan(var34_26, var9_5, var4_3, false, var27_25, null, null, var5_4);
                        }
                        catch (SwissephException var76_23) {
                            var11_7 = var76_23.getRC();
                            if (var11_7 != -1) ** GOTO lbl46
                            return -1;
                        }
lbl46:
                        // 2 sources

                        if ((var4_3 & 16) != 0 || var11_7 < 0) ** GOTO lbl55
                        var36_27 = SMath.sqrt(this.sl.square_sum(var24_9[var6_21])) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                        try {
                            var11_7 = this.jplplan(var34_26 - var36_27, var9_5, var4_3, false, var24_9[var6_21], null, null, var5_4);
                        }
                        catch (SwissephException var76_24) {
                            var11_7 = var76_24.getRC();
                            if (var11_7 != -1) ** GOTO lbl55
                            return -1;
                        }
lbl55:
                        // 3 sources

                        if (var11_7 == -2) {
                            var4_3 = var4_3 & -2 | 2;
                            var10_6 = 2;
                            if (var5_4 == null || var5_4.length() + 30 >= 256) continue block9;
                            var5_4.append(" \ntrying Swiss Eph; ");
                            break block2;
                        }
                        if (var11_7 == -3) {
                            if (var1_1 > 625000.5 && var1_1 < 2818000.5) {
                                var4_3 = var4_3 & -2 | 4;
                                var10_6 = 4;
                                if (var5_4 == null || var5_4.length() + 30 >= 256) continue block9;
                                var5_4.append(" \nusing Moshier Eph; ");
                                break block2;
                            }
                            return -1;
                        }
                        var11_7 = this.swi_plan_for_osc_elem(var4_3 | 256, var34_26, var24_9[var6_21]);
                    }
                    continue block9;
                }
                case 2: {
                    var18_8 = 1.0E-4;
                    for (var6_21 = var8_20; var6_21 <= 2; ++var6_21) {
                        var34_26 = var6_21 == 0 ? var1_1 - var18_8 : (var6_21 == 1 ? var1_1 + var18_8 : var1_1);
                        var11_7 = this.swemoon(var34_26, var4_3 | 256, false, var24_9[var6_21], var5_4);
                        if (var11_7 == -1) {
                            return -1;
                        }
                        if ((var4_3 & 16) == 0 && var11_7 >= 0 && (var11_7 = this.swemoon(var34_26 - (var36_27 = SMath.sqrt(this.sl.square_sum(var24_9[var6_21])) * 1.4959787066E11 / 2.99792458E8 / 86400.0), var4_3 | 256, false, var24_9[var6_21], var5_4)) == -1) {
                            return -1;
                        }
                        if (var11_7 == -2) {
                            if (var1_1 > 625000.5 && var1_1 < 2818000.5) {
                                var4_3 = var4_3 & -3 | 4;
                                var10_6 = 4;
                                if (var5_4 == null || var5_4.length() + 30 >= 256) continue block9;
                                var5_4.append(" \nusing Moshier eph.; ");
                                break block2;
                            }
                            return -1;
                        }
                        var11_7 = this.swi_plan_for_osc_elem(var4_3 | 256, var34_26, var24_9[var6_21]);
                    }
                    continue block9;
                }
                case 4: {
                    var18_8 = 0.1;
                    for (var6_21 = var8_20; var6_21 <= 2; ++var6_21) {
                        var34_26 = var6_21 == 0 ? var1_1 - var18_8 : (var6_21 == 1 ? var1_1 + var18_8 : var1_1);
                        var11_7 = this.sm.swi_moshmoon(var34_26, false, var24_9[var6_21], var5_4);
                        if (var11_7 == -1) {
                            return var11_7;
                        }
                        var11_7 = this.swi_plan_for_osc_elem(var4_3 | 256, var34_26, var24_9[var6_21]);
                    }
                }
            }
        } while (var11_7 == -2 || var11_7 == -3);
        var15_28 = this.swed.nddat[1];
        for (var6_21 = var8_20; var6_21 <= 2; ++var6_21) {
            if (SMath.abs(var24_9[var6_21][5]) < 1.0E-15) {
                var24_9[var6_21][5] = 1.0E-15;
            }
            var38_30 = var24_9[var6_21][2] / var24_9[var6_21][5];
            var40_31 = var24_9[var6_21][5] / SMath.abs(var24_9[var6_21][5]);
            for (var7_29 = 0; var7_29 <= 2; ++var7_29) {
                var25_10[var6_21][var7_29] = (var24_9[var6_21][var7_29] - var38_30 * var24_9[var6_21][var7_29 + 3]) * var40_31;
            }
        }
        for (var6_21 = 0; var6_21 <= 2; ++var6_21) {
            var15_28.x[var6_21] = var25_10[2][var6_21];
            if ((var4_3 & 256) != 0) {
                var22_33 = (var25_10[1][var6_21] - var25_10[0][var6_21]) / 2.0;
                var20_32 = (var25_10[1][var6_21] + var25_10[0][var6_21]) / 2.0 - var25_10[2][var6_21];
                var15_28.x[var6_21 + 3] = (2.0 * var20_32 + var22_33) / var18_8;
            } else {
                var15_28.x[var6_21 + 3] = 0.0;
            }
            var15_28.teval = var1_1;
            var15_28.iephe = var10_6;
        }
        var16_34 = this.swed.nddat[3];
        var66_35 = 8.997011693402468E-10;
        for (var6_21 = var8_20; var6_21 <= 2; ++var6_21) {
            var30_36 = SMath.sqrt(var25_10[var6_21][0] * var25_10[var6_21][0] + var25_10[var6_21][1] * var25_10[var6_21][1]);
            var44_39 = var25_10[var6_21][0] / var30_36;
            var42_38 = var25_10[var6_21][1] / var30_36;
            this.sl.swi_cross_prod(var24_9[var6_21], 0, var24_9[var6_21], 3, var28_12, 0);
            var30_36 = var28_12[0] * var28_12[0] + var28_12[1] * var28_12[1];
            var68_50 = var30_36 + var28_12[2] * var28_12[2];
            var32_37 = SMath.sqrt(var68_50);
            var30_36 = SMath.sqrt(var30_36);
            var46_40 = var30_36 / var32_37;
            var48_41 = SMath.sqrt(1.0 - var46_40 * var46_40);
            var52_43 = var24_9[var6_21][0] * var44_39 + var24_9[var6_21][1] * var42_38;
            var50_42 = var24_9[var6_21][2] / var46_40;
            var58_46 = SMath.atan2(var50_42, var52_43);
            var32_37 = SMath.sqrt(this.sl.square_sum(var24_9[var6_21]));
            var70_51 = this.sl.square_sum(var24_9[var6_21], 3);
            var62_48 = 1.0 / (2.0 / var32_37 - var70_51 / var66_35);
            var72_52 = var68_50 / var66_35;
            var64_49 = SMath.sqrt(1.0 - var72_52 / var62_48);
            var56_45 = 1.0 / var64_49 * (1.0 - var32_37 / var62_48);
            var54_44 = 1.0 / var64_49 / SMath.sqrt(var62_48 * var66_35) * this.dot_prod(var24_9[var6_21], var24_9[var6_21], 3);
            var60_47 = 2.0 * SMath.atan(SMath.sqrt((1.0 + var64_49) / (1.0 - var64_49)) * var54_44 / (1.0 + var56_45));
            var26_11[var6_21][0] = this.sl.swi_mod2PI(var58_46 - var60_47 + 3.141592653589793);
            var26_11[var6_21][1] = 0.0;
            var26_11[var6_21][2] = var62_48 * (1.0 + var64_49);
            this.sl.swi_polcart(var26_11[var6_21], var26_11[var6_21]);
            this.sl.swi_coortrf2(var26_11[var6_21], var26_11[var6_21], -var46_40, var48_41);
            this.sl.swi_cartpol(var26_11[var6_21], var26_11[var6_21]);
            v0 = var26_11[var6_21];
            v0[0] = v0[0] + SMath.atan2(var42_38, var44_39);
            this.sl.swi_polcart(var26_11[var6_21], var26_11[var6_21]);
            var60_47 = this.sl.swi_mod2PI(var60_47 - var58_46);
            var56_45 = SMath.cos(2.0 * SMath.atan(SMath.tan(var60_47 / 2.0) / SMath.sqrt((1.0 + var64_49) / (1.0 - var64_49))));
            var29_13[0] = var62_48 * (1.0 - var64_49 * var56_45);
            var29_13[1] = SMath.sqrt(this.sl.square_sum(var25_10[var6_21]));
            var7_29 = 0;
            while (var7_29 <= 2) {
                v1 = var25_10[var6_21];
                v2 = var7_29++;
                v1[v2] = v1[v2] * (var29_13[0] / var29_13[1]);
            }
        }
        for (var6_21 = 0; var6_21 <= 2; ++var6_21) {
            var16_34.x[var6_21] = var26_11[2][var6_21];
            var16_34.x[var6_21 + 3] = (var4_3 & 256) != 0 ? (var26_11[1][var6_21] - var26_11[0][var6_21]) / var18_8 / 2.0 : 0.0;
            var16_34.teval = var1_1;
            var16_34.iephe = var10_6;
            var15_28.x[var6_21] = var25_10[2][var6_21];
            var15_28.x[var6_21 + 3] = (var4_3 & 256) != 0 ? (var25_10[1][var6_21] - var25_10[0][var6_21]) / var18_8 / 2.0 : 0.0;
        }
        var76_22 = new double[6];
        for (var7_29 = 0; var7_29 <= 1; ++var7_29) {
            var14_15 = var7_29 == 0 ? this.swed.nddat[1] : this.swed.nddat[3];
            for (var77_53 = 0; var77_53 < var14_15.xreturn.length; ++var77_53) {
                var14_15.xreturn[var77_53] = 0.0;
            }
            for (var6_21 = 0; var6_21 <= 5; ++var6_21) {
                var14_15.xreturn[6 + var6_21] = var14_15.x[var6_21];
            }
            this.sl.swi_cartpol_sp(var14_15.xreturn, 6, var14_15.xreturn, 0);
            this.sl.swi_coortrf2(var14_15.xreturn, 6, var14_15.xreturn, 18, -var17_14.seps, var17_14.ceps);
            if ((var4_3 & 256) != 0) {
                this.sl.swi_coortrf2(var14_15.xreturn, 9, var14_15.xreturn, 21, -var17_14.seps, var17_14.ceps);
            }
            if ((var4_3 & 64) == 0) {
                this.sl.swi_coortrf2(var14_15.xreturn, 18, var14_15.xreturn, 18, -this.swed.nut.snut, this.swed.nut.cnut);
                if ((var4_3 & 256) != 0) {
                    this.sl.swi_coortrf2(var14_15.xreturn, 21, var14_15.xreturn, 21, -this.swed.nut.snut, this.swed.nut.cnut);
                }
            }
            this.sl.swi_cartpol_sp(var14_15.xreturn, 18, var14_15.xreturn, 12);
            var14_15.xflgs = var4_3;
            var14_15.iephe = var4_3 & 7;
            if ((var4_3 & 65536) != 0) {
                if ((this.swed.sidd.sid_mode & 256) != 0 || (this.swed.sidd.sid_mode & 512) != 0) {
                    for (var6_21 = 0; var6_21 <= 5; ++var6_21) {
                        var76_22[var6_21] = var14_15.xreturn[18 + var6_21];
                    }
                    if ((var4_3 & 64) == 0) {
                        this.swi_nutate(var76_22, 0, var4_3, true);
                    }
                    this.sl.swi_precess(var76_22, var1_1, var4_3, 1);
                    if ((var4_3 & 256) != 0) {
                        this.swi_precess_speed(var76_22, var1_1, var4_3, 1);
                    }
                    if ((this.swed.sidd.sid_mode & 256) != 0) {
                        this.swi_trop_ra2sid_lon(var76_22, var14_15.xreturn, 6, var14_15.xreturn, 18, var4_3, null);
                    } else if ((this.swed.sidd.sid_mode & 512) != 0) {
                        this.swi_trop_ra2sid_lon_sosy(var76_22, var14_15.xreturn, 6, var14_15.xreturn, 18, var4_3, null);
                    }
                    this.sl.swi_cartpol_sp(var14_15.xreturn, 6, var14_15.xreturn, 0);
                    this.sl.swi_cartpol_sp(var14_15.xreturn, 18, var14_15.xreturn, 12);
                } else {
                    this.sl.swi_cartpol_sp(var14_15.xreturn, 6, var14_15.xreturn, 0);
                    var14_15.xreturn[0] = var14_15.xreturn[0] - this.swe_get_ayanamsa(var14_15.teval) * 0.0174532925199433;
                    this.sl.swi_polcart_sp(var14_15.xreturn, 0, var14_15.xreturn, 6);
                }
            } else if ((var4_3 & 32) != 0) {
                for (var6_21 = 0; var6_21 <= 5; ++var6_21) {
                    var76_22[var6_21] = var14_15.xreturn[18 + var6_21];
                }
                this.sl.swi_precess(var76_22, var1_1, var4_3, 1);
                if ((var4_3 & 256) != 0) {
                    this.swi_precess_speed(var76_22, var1_1, var4_3, 1);
                }
                for (var6_21 = 0; var6_21 <= 5; ++var6_21) {
                    var14_15.xreturn[18 + var6_21] = var76_22[var6_21];
                }
                this.sl.swi_cartpol_sp(var14_15.xreturn, 18, var14_15.xreturn, 12);
                this.sl.swi_coortrf2(var14_15.xreturn, 18, var14_15.xreturn, 6, this.swed.oec2000.seps, this.swed.oec2000.ceps);
                if ((var4_3 & 256) != 0) {
                    this.sl.swi_coortrf2(var14_15.xreturn, 21, var14_15.xreturn, 9, this.swed.oec2000.seps, this.swed.oec2000.ceps);
                }
                this.sl.swi_cartpol_sp(var14_15.xreturn, 6, var14_15.xreturn, 0);
            }
            for (var6_21 = 0; var6_21 < 2; ++var6_21) {
                v3 = var6_21;
                var14_15.xreturn[v3] = var14_15.xreturn[v3] * 57.2957795130823;
                v4 = var6_21 + 3;
                var14_15.xreturn[v4] = var14_15.xreturn[v4] * 57.2957795130823;
                v5 = var6_21 + 12;
                var14_15.xreturn[v5] = var14_15.xreturn[v5] * 57.2957795130823;
                v6 = var6_21 + 15;
                var14_15.xreturn[v6] = var14_15.xreturn[v6] * 57.2957795130823;
            }
            var14_15.xreturn[0] = this.sl.swe_degnorm(var14_15.xreturn[0]);
            var14_15.xreturn[12] = this.sl.swe_degnorm(var14_15.xreturn[12]);
        }
        return 0;
    }

    private int intp_apsides(double d, int n, int n2, StringBuffer stringBuffer) {
        int n3;
        double d2 = 0.1;
        double[][] dArray = new double[3][6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        if (d < 625000.5 || d > 2818000.5) {
            if (stringBuffer != null) {
                String string = "jd " + d + " outside Moshier's Moon range " + 625000.5 + " .. " + 2818000.5 + " ";
                if (stringBuffer.length() + string.length() < 256) {
                    stringBuffer.append(string);
                }
            }
            return -1;
        }
        Epsilon epsilon = this.swed.oec;
        Nut nut = this.swed.nut;
        PlanData planData = this.swed.nddat[n];
        int n4 = n2 & 0xFFFFF7FF & 0xFFFFEFFF;
        int n5 = planData.xflgs & 0xFFFFF7FF & 0xFFFFEFFF;
        int n6 = planData.xflgs & 0x100;
        int n7 = n2 & 0x100;
        if (d == planData.teval && d != 0.0 && n4 == n5 && (n7 == 0 || n6 != 0)) {
            planData.xflgs = n2;
            planData.iephe = n2 & 4;
            return 0;
        }
        double d3 = d - d2;
        for (n3 = 0; n3 < 3; ++n3) {
            if ((n2 & 0x100) != 0 || n3 == 1) {
                this.sm.swi_intp_apsides(d3, dArray[n3], n);
            }
            d3 += d2;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            dArray2[n3] = dArray[1][n3];
            dArray2[n3 + 3] = 0.0;
        }
        if ((n2 & 0x100) != 0) {
            dArray2[3] = this.sl.swe_difrad2n(dArray[2][0], dArray[0][0]) / d2 / 2.0;
            dArray2[4] = (dArray[2][1] - dArray[0][1]) / d2 / 2.0;
            dArray2[5] = (dArray[2][2] - dArray[0][2]) / d2 / 2.0;
        }
        for (int i = 0; i < 24; ++i) {
            planData.xreturn[i] = 0.0;
        }
        this.sl.swi_polcart_sp(dArray2, dArray2);
        if ((n2 & 0x10) == 0) {
            double d4 = SMath.sqrt(this.sl.square_sum(dArray2)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            for (n3 = 1; n3 < 3; ++n3) {
                int n8 = n3;
                dArray2[n8] = dArray2[n8] - d4 * dArray2[n3 + 3];
            }
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            planData.xreturn[n3 + 6] = dArray2[n3];
        }
        this.sl.swi_coortrf2(planData.xreturn, 6, planData.xreturn, 18, -epsilon.seps, epsilon.ceps);
        if ((n2 & 0x100) != 0) {
            this.sl.swi_coortrf2(planData.xreturn, 9, planData.xreturn, 21, -epsilon.seps, epsilon.ceps);
        }
        planData.teval = d;
        planData.xflgs = n2;
        planData.iephe = n2 & 7;
        if ((n2 & 0x10000) != 0) {
            if ((this.swed.sidd.sid_mode & 0x100) != 0 || (this.swed.sidd.sid_mode & 0x200) != 0) {
                for (n3 = 0; n3 <= 5; ++n3) {
                    dArray3[n3] = planData.xreturn[18 + n3];
                }
                this.sl.swi_precess(dArray3, d, n2, 1);
                if ((n2 & 0x100) != 0) {
                    this.swi_precess_speed(dArray3, d, n2, 1);
                }
                if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                    this.swi_trop_ra2sid_lon(dArray3, planData.xreturn, 6, planData.xreturn, 18, n2, null);
                } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                    this.swi_trop_ra2sid_lon_sosy(dArray3, planData.xreturn, 6, planData.xreturn, 18, n2, null);
                }
                this.sl.swi_cartpol_sp(planData.xreturn, 6, planData.xreturn, 0);
                this.sl.swi_cartpol_sp(planData.xreturn, 18, planData.xreturn, 12);
            } else {
                this.sl.swi_cartpol_sp(planData.xreturn, 6, planData.xreturn, 0);
                planData.xreturn[0] = planData.xreturn[0] - this.swe_get_ayanamsa(planData.teval) * 0.0174532925199433;
                this.sl.swi_polcart_sp(planData.xreturn, 0, planData.xreturn, 6);
                this.sl.swi_cartpol_sp(planData.xreturn, 18, planData.xreturn, 12);
            }
        } else if ((n2 & 0x20) != 0) {
            for (n3 = 0; n3 <= 5; ++n3) {
                dArray3[n3] = planData.xreturn[18 + n3];
            }
            this.sl.swi_precess(dArray3, d, n2, 1);
            if ((n2 & 0x100) != 0) {
                this.swi_precess_speed(dArray3, d, n2, 1);
            }
            for (n3 = 0; n3 <= 5; ++n3) {
                planData.xreturn[18 + n3] = dArray3[n3];
            }
            this.sl.swi_cartpol_sp(planData.xreturn, 18, planData.xreturn, 12);
            this.sl.swi_coortrf2(planData.xreturn, 18, planData.xreturn, 6, this.swed.oec2000.seps, this.swed.oec2000.ceps);
            if ((n2 & 0x100) != 0) {
                this.sl.swi_coortrf2(planData.xreturn, 21, planData.xreturn, 9, this.swed.oec2000.seps, this.swed.oec2000.ceps);
            }
            this.sl.swi_cartpol_sp(planData.xreturn, 6, planData.xreturn, 0);
        } else {
            if ((n2 & 0x40) == 0) {
                this.swi_nutate(planData.xreturn, 18, n2, false);
            }
            this.sl.swi_cartpol_sp(planData.xreturn, 18, planData.xreturn, 12);
            this.sl.swi_coortrf2(planData.xreturn, 18, planData.xreturn, 6, epsilon.seps, epsilon.ceps);
            if ((n2 & 0x100) != 0) {
                this.sl.swi_coortrf2(planData.xreturn, 21, planData.xreturn, 9, epsilon.seps, epsilon.ceps);
            }
            if ((n2 & 0x40) == 0) {
                this.sl.swi_coortrf2(planData.xreturn, 6, planData.xreturn, 6, nut.snut, nut.cnut);
                if ((n2 & 0x100) != 0) {
                    this.sl.swi_coortrf2(planData.xreturn, 9, planData.xreturn, 9, nut.snut, nut.cnut);
                }
            }
            this.sl.swi_cartpol_sp(planData.xreturn, 6, planData.xreturn, 0);
        }
        for (n3 = 0; n3 < 2; ++n3) {
            int n9 = n3;
            planData.xreturn[n9] = planData.xreturn[n9] * 57.2957795130823;
            int n10 = n3 + 3;
            planData.xreturn[n10] = planData.xreturn[n10] * 57.2957795130823;
            int n11 = n3 + 12;
            planData.xreturn[n11] = planData.xreturn[n11] * 57.2957795130823;
            int n12 = n3 + 15;
            planData.xreturn[n12] = planData.xreturn[n12] * 57.2957795130823;
        }
        planData.xreturn[0] = this.sl.swe_degnorm(planData.xreturn[0]);
        planData.xreturn[12] = this.sl.swe_degnorm(planData.xreturn[12]);
        return 0;
    }

    int swi_plan_for_osc_elem(int n, double d, double[] dArray) {
        Nut nut;
        double[] dArray2 = new double[6];
        Nut nut2 = nut = new Nut();
        Epsilon epsilon = this.swed.oec;
        Epsilon epsilon2 = new Epsilon();
        if ((n & 0x20000) == 0 && this.swed.jpldenum >= 403) {
            this.sl.swi_bias(dArray, d, n, false);
        }
        this.sl.swi_precess(dArray, d, n, -1);
        this.sl.swi_precess(dArray, 3, d, n, -1);
        if (d == this.swed.oec.teps) {
            epsilon = this.swed.oec;
        } else if (d == 2451545.0) {
            epsilon = this.swed.oec2000;
        } else {
            this.calc_epsilon(d, n, epsilon2);
            epsilon = epsilon2;
        }
        if ((n & 0x40) == 0) {
            int n2;
            if (d == this.swed.nut.tnut) {
                nut2 = this.swed.nut;
            } else if (d == 2451545.0) {
                nut2 = this.swed.nut2000;
            } else if (d == this.swed.nutv.tnut) {
                nut2 = this.swed.nutv;
            } else {
                nut2 = nut;
                this.sl.swi_nutation(d, n, nut2.nutlo);
                nut2.tnut = d;
                nut2.snut = SMath.sin(nut2.nutlo[1]);
                nut2.cnut = SMath.cos(nut2.nutlo[1]);
                this.nut_matrix(nut2, epsilon);
            }
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2] = dArray[0] * nut2.matrix[0][n2] + dArray[1] * nut2.matrix[1][n2] + dArray[2] * nut2.matrix[2][n2];
            }
            for (n2 = 0; n2 <= 2; ++n2) {
                dArray2[n2 + 3] = dArray[3] * nut2.matrix[0][n2] + dArray[4] * nut2.matrix[1][n2] + dArray[5] * nut2.matrix[2][n2];
            }
            for (n2 = 0; n2 <= 5; ++n2) {
                dArray[n2] = dArray2[n2];
            }
        }
        this.sl.swi_coortrf2(dArray, dArray, epsilon.seps, epsilon.ceps);
        this.sl.swi_coortrf2(dArray, 3, dArray, 3, epsilon.seps, epsilon.ceps);
        if ((n & 0x40) == 0) {
            this.sl.swi_coortrf2(dArray, dArray, nut2.snut, nut2.cnut);
            this.sl.swi_coortrf2(dArray, 3, dArray, 3, nut2.snut, nut2.cnut);
        }
        return 0;
    }

    double meff(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        int n = 0;
        while (SwissEph.eff_arr[n].r > d) {
            ++n;
        }
        double d2 = (d - SwissEph.eff_arr[n - 1].r) / (SwissEph.eff_arr[n].r - SwissEph.eff_arr[n - 1].r);
        double d3 = SwissEph.eff_arr[n - 1].m + d2 * (SwissEph.eff_arr[n].m - SwissEph.eff_arr[n - 1].m);
        return d3;
    }

    void denormalize_positions(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i <= 12; i += 12) {
            if (dArray2[i] - dArray[i] < -180.0) {
                int n = i;
                dArray[n] = dArray[n] - 360.0;
            }
            if (dArray2[i] - dArray[i] > 180.0) {
                int n = i;
                dArray[n] = dArray[n] + 360.0;
            }
            if (dArray2[i] - dArray3[i] < -180.0) {
                int n = i;
                dArray3[n] = dArray3[n] - 360.0;
            }
            if (!(dArray2[i] - dArray3[i] > 180.0)) continue;
            int n = i;
            dArray3[n] = dArray3[n] + 360.0;
        }
    }

    void calc_speed(double[] dArray, double[] dArray2, double[] dArray3, double d) {
        for (int i = 0; i <= 18; i += 6) {
            for (int j = 0; j < 3; ++j) {
                int n = i + j;
                double d2 = (dArray3[n] - dArray[n]) / 2.0;
                double d3 = (dArray3[n] + dArray[n]) / 2.0 - dArray2[n];
                dArray2[n + 3] = (2.0 * d3 + d2) / d;
            }
        }
    }

    void swi_check_ecliptic(double d, int n) {
        if (this.swed.oec2000.teps != 2451545.0) {
            this.calc_epsilon(2451545.0, n, this.swed.oec2000);
        }
        if (d == 2451545.0) {
            this.swed.oec.teps = this.swed.oec2000.teps;
            this.swed.oec.eps = this.swed.oec2000.eps;
            this.swed.oec.seps = this.swed.oec2000.seps;
            this.swed.oec.ceps = this.swed.oec2000.ceps;
            return;
        }
        if (this.swed.oec.teps != d || d == 0.0) {
            this.calc_epsilon(d, n, this.swed.oec);
        }
    }

    void swi_check_nutation(double d, int n) {
        int n2 = this.chck_nut_nutflag & 0x100;
        int n3 = n & 0x100;
        if ((n & 0x40) == 0 && (d != this.swed.nut.tnut || d == 0.0 || n2 == 0 && n3 != 0)) {
            this.sl.swi_nutation(d, n, this.swed.nut.nutlo);
            this.swed.nut.tnut = d;
            this.swed.nut.snut = SMath.sin(this.swed.nut.nutlo[1]);
            this.swed.nut.cnut = SMath.cos(this.swed.nut.nutlo[1]);
            this.chck_nut_nutflag = n;
            this.nut_matrix(this.swed.nut, this.swed.oec);
            if ((n & 0x100) != 0) {
                double d2 = d - 1.0E-4;
                this.sl.swi_nutation(d2, n, this.swed.nutv.nutlo);
                this.swed.nutv.tnut = d2;
                this.swed.nutv.snut = SMath.sin(this.swed.nutv.nutlo[1]);
                this.swed.nutv.cnut = SMath.cos(this.swed.nutv.nutlo[1]);
                this.nut_matrix(this.swed.nutv, this.swed.oec);
            }
        }
    }

    private int plaus_iflag(int n, int n2, double d, StringBuffer stringBuffer) {
        int n3 = 0;
        int n4 = this.swed.astro_models[5];
        int n5 = this.swed.astro_models[6];
        if (n4 == 0) {
            n4 = 1;
        }
        if (n5 == 0) {
            n5 = 1;
        }
        if ((n & 0x40000) != 0) {
            n &= 0xFFF7FFFF;
        }
        if ((n & 0x8000) != 0) {
            n &= 0xFFFFBFF7;
            n &= 0xFFF3FFFF;
        }
        if ((n & 8) != 0) {
            n |= 0x600;
        }
        if ((n & 0x4000) != 0) {
            n |= 0x600;
        }
        if ((n & 0x20) != 0) {
            n |= 0x40;
        }
        if ((n & 0x10) != 0) {
            n |= 0x600;
        }
        if ((n & 0x10000) != 0) {
            n |= 0x40;
            n &= 0xFFF3FFFF;
        }
        if ((n & 4) != 0) {
            n3 = 4;
        }
        if ((n & 2) != 0) {
            n3 = 2;
        }
        if ((n & 1) != 0) {
            n3 = 1;
        }
        if (n3 == 0) {
            n3 = 2;
        }
        n = n & 0xFFFFFFF8 | n3;
        if ((n3 & 1) == 0) {
            n &= 0xFFF3FFFF;
        }
        if (n2 == 13 || n2 == 11 || n2 == 12 || n2 == 10 || n2 == 21 || n2 == 22) {
            n &= 0xFFF3FFFF;
        }
        if (n2 >= 40 && n2 <= 999) {
            n &= 0xFFF3FFFF;
        }
        if ((n & 0x40000) != 0 && (this.swed.eop_dpsi_loaded <= 0 || (d < this.swed.eop_tjd_beg || d > this.swed.eop_tjd_end) && n4 != 1)) {
            if (stringBuffer != null) {
                switch (this.swed.eop_dpsi_loaded) {
                    case 0: {
                        stringBuffer.setLength(0);
                        stringBuffer.append("you did not call swe_set_jpl_file(); default to SEFLG_JPLHOR_APPROX");
                        break;
                    }
                    case -1: {
                        stringBuffer.setLength(0);
                        stringBuffer.append("file eop_1962_today.txt not found; default to SEFLG_JPLHOR_APPROX");
                        break;
                    }
                    case -2: {
                        stringBuffer.setLength(0);
                        stringBuffer.append("file eop_1962_today.txt corrupt; default to SEFLG_JPLHOR_APPROX");
                        break;
                    }
                    case -3: {
                        stringBuffer.setLength(0);
                        stringBuffer.append("file eop_finals.txt corrupt; default to SEFLG_JPLHOR_APPROX");
                    }
                }
            }
            n &= 0xFFFBFFFF;
            n |= 0x80000;
        }
        if ((n & 0x40000) != 0) {
            n |= 0x20000;
        }
        if ((n & 0x80000) != 0 && n5 != 1) {
            n |= 0x20000;
        }
        return n;
    }

    int swe_fixstar_found(StringBuffer stringBuffer, String string, StringBuffer stringBuffer2, int n, double d, int n2, int n3, int n4, double[] dArray) {
        double d2;
        Object object = null;
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        double[] dArray4 = new double[6];
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[10];
        Epsilon epsilon = this.swed.oec2000;
        String[] stringArray = new String[20];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n5 = stringTokenizer.countTokens();
        if (n5 < 2) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("star file sefstars.txt damaged at line " + n);
            }
            return this.swe_fixstar_error(dArray, -1);
        }
        int n6 = 0;
        while (stringTokenizer.hasMoreTokens() && n6 < 20) {
            stringArray[n6++] = stringTokenizer.nextToken();
        }
        stringArray[0] = stringArray[0].trim();
        stringArray[1] = stringArray[1].trim();
        if (n5 < 13) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("data of star '" + stringArray[0] + "," + stringArray[1] + "' incomplete");
            }
            return this.swe_fixstar_error(dArray, -1);
        }
        int n7 = stringArray[2].length();
        while (true) {
            try {
                d2 = Double.valueOf(stringArray[2].substring(0, n7));
            }
            catch (NumberFormatException numberFormatException) {
                if (--n7 != 0) continue;
                d2 = 0.0;
            }
            break;
        }
        double d3 = new Double(stringArray[3]);
        double d4 = new Double(stringArray[4]);
        double d5 = new Double(stringArray[5]);
        double d6 = new Double(stringArray[6]);
        String string2 = stringArray[6];
        double d7 = new Double(stringArray[7]);
        double d8 = new Double(stringArray[8]);
        double d9 = new Double(stringArray[9]);
        double d10 = new Double(stringArray[10]);
        double d11 = new Double(stringArray[11]);
        double d12 = new Double(stringArray[12]);
        if (stringArray[0].length() > 256) {
            stringArray[0] = stringArray[0].substring(0, 256);
        }
        if (stringArray[1].length() > 255) {
            stringArray[1] = stringArray[1].substring(0, 255);
        }
        stringBuffer2.setLength(0);
        stringBuffer2.append(stringArray[0]);
        if (stringArray[0].length() + stringArray[1].length() + 1 < 255) {
            stringBuffer2.append("," + stringArray[1]);
        }
        double d13 = (d5 / 3600.0 + d4 / 60.0 + d3) * 15.0;
        double d14 = string2.indexOf(45) < 0 ? d8 / 3600.0 + d7 / 60.0 + d6 : -d8 / 3600.0 - d7 / 60.0 + d6;
        if (this.swed.is_old_starfile) {
            d9 = d9 * 15.0 / 3600.0;
            d10 /= 3600.0;
        } else {
            d9 = d9 / 10.0 / 3600.0;
            d10 = d10 / 10.0 / 3600.0;
            d12 /= 1000.0;
        }
        d12 = d12 > 1.0 ? 1.0 / d12 / 3600.0 : (d12 /= 3600.0);
        d11 *= 21.095;
        d9 *= 0.0174532925199433;
        d10 *= 0.0174532925199433;
        d9 /= SMath.cos(d14 *= 0.0174532925199433);
        d12 *= 0.0174532925199433;
        dArray2[0] = d13 *= 0.0174532925199433;
        dArray2[1] = d14;
        dArray2[2] = 1.0;
        this.sl.swi_polcart(dArray2, dArray2);
        double d15 = SMath.cos(d13);
        double d16 = SMath.cos(d14);
        double d17 = SMath.sin(d13);
        double d18 = SMath.sin(d14);
        dArray2[3] = -d9 * d16 * d17 - d10 * d18 * d15 + d11 * d12 * d16 * d15;
        dArray2[4] = d9 * d16 * d15 - d10 * d18 * d17 + d11 * d12 * d16 * d17;
        dArray2[5] = d10 * d16 + d11 * d12 * d18;
        dArray2[3] = dArray2[3] / 36525.0;
        dArray2[4] = dArray2[4] / 36525.0;
        dArray2[5] = dArray2[5] / 36525.0;
        if (d2 == 1950.0) {
            this.sl.swi_FK4_FK5(dArray2, 2433282.42345905);
            this.sl.swi_precess(dArray2, 2433282.42345905, 0, 1);
            this.sl.swi_precess(dArray2, 3, 2433282.42345905, 0, 1);
        }
        if (d2 != 0.0) {
            this.sl.swi_icrs2fk5(dArray2, n2, true);
            if (this.swed.jpldenum < 403) {
                this.sl.swi_bias(dArray2, 2451545.0, 256, false);
            }
        }
        if ((n2 & 0x4000) == 0 && ((n2 & 8) == 0 || (n2 & 4) == 0)) {
            int n8 = this.main_planet(d, 0, n4, n2, stringBuffer);
            if (n8 != 0) {
                n2 &= 0xFFFF7FF7;
                n8 = n2 |= 0x4210;
            } else {
                n2 = this.swed.pldat[0].xflgs;
            }
        }
        if ((n2 & 0x8000) != 0) {
            if (this.swed.topd.teval != planData.teval || this.swed.topd.teval == 0.0) {
                if (this.swi_get_observer(planData.teval, n2 | 0x40, true, dArray4, stringBuffer) != 0) {
                    return -1;
                }
            } else {
                for (n5 = 0; n5 <= 5; ++n5) {
                    dArray4[n5] = this.swed.topd.xobs[n5];
                }
            }
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray4[n5] = dArray4[n5] + planData.x[n5];
            }
        } else if ((n2 & 0x4000) == 0 && ((n2 & 8) == 0 || (n2 & 4) == 0)) {
            for (n5 = 0; n5 <= 5; ++n5) {
                dArray4[n5] = planData.x[n5];
            }
        }
        double d19 = d2 == 1950.0 ? d - 2433282.42345905 : d - 2451545.0;
        object = (n2 & 8) != 0 && (n2 & 4) != 0 ? null : ((n2 & 8) != 0 ? planData2.x : (Object)((n2 & 0x4000) != 0 ? null : dArray4));
        if (object == null) {
            for (n5 = 0; n5 <= 2; ++n5) {
                int n9 = n5;
                dArray2[n9] = dArray2[n9] + d19 * dArray2[n5 + 3];
            }
        } else {
            for (n5 = 0; n5 <= 2; ++n5) {
                int n10 = n5;
                dArray2[n10] = dArray2[n10] + (d19 * dArray2[n5 + 3] - d12 * object[n5]);
                int n11 = n5 + 3;
                dArray2[n11] = dArray2[n11] - d12 * object[n5 + 3];
            }
        }
        n5 = 0;
        while (n5 <= 5) {
            int n12 = n5++;
            dArray2[n12] = dArray2[n12] * 10000.0;
        }
        if ((n2 & 0x10) == 0 && (n2 & 0x200) == 0) {
            this.swi_deflect_light(dArray2, 0, 0.0, n2 & 0x100);
        }
        if ((n2 & 0x10) == 0 && (n2 & 0x400) == 0) {
            this.swi_aberr_light(dArray2, (double[])object, n2 & 0x100);
        }
        if ((n2 & 0x20000) == 0 && (this.swed.jpldenum >= 403 || (n2 & 0x4000) != 0)) {
            this.sl.swi_bias(dArray2, d, n2, false);
        }
        for (n5 = 0; n5 <= 5; ++n5) {
            dArray3[n5] = dArray2[n5];
        }
        if ((n2 & 0x20) == 0) {
            this.sl.swi_precess(dArray2, d, n2, -1);
            if ((n2 & 0x100) != 0) {
                this.swi_precess_speed(dArray2, d, n2, -1);
            }
            epsilon = this.swed.oec;
        } else {
            epsilon = this.swed.oec2000;
        }
        if ((n2 & 0x40) == 0) {
            this.swi_nutate(dArray2, 0, 0, false);
        }
        double d20 = SMath.sqrt(this.sl.square_sum(dArray2));
        n5 = 0;
        while (n5 <= 5) {
            int n13 = n5++;
            dArray2[n13] = dArray2[n13] / d20;
        }
        d20 = SMath.sqrt(this.sl.square_sum(dArray3));
        n5 = 0;
        while (n5 <= 5) {
            int n14 = n5++;
            dArray3[n14] = dArray3[n14] / d20;
        }
        for (n5 = 3; n5 <= 5; ++n5) {
            dArray3[n5] = 0.0;
            dArray2[n5] = 0.0;
        }
        if ((n2 & 0x800) == 0) {
            this.sl.swi_coortrf2(dArray2, dArray2, epsilon.seps, epsilon.ceps);
            if ((n2 & 0x100) != 0) {
                this.sl.swi_coortrf2(dArray2, 3, dArray2, 3, epsilon.seps, epsilon.ceps);
            }
            if ((n2 & 0x40) == 0) {
                this.sl.swi_coortrf2(dArray2, dArray2, this.swed.nut.snut, this.swed.nut.cnut);
                if ((n2 & 0x100) != 0) {
                    this.sl.swi_coortrf2(dArray2, 3, dArray2, 3, this.swed.nut.snut, this.swed.nut.cnut);
                }
            }
        }
        if ((n2 & 0x10000) != 0) {
            if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                if (this.swi_trop_ra2sid_lon(dArray3, dArray2, dArray3, n2, stringBuffer) != 0) {
                    return -1;
                }
                if ((n2 & 0x800) != 0) {
                    for (n5 = 0; n5 <= 5; ++n5) {
                        dArray2[n5] = dArray3[n5];
                    }
                }
            } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                if (this.swi_trop_ra2sid_lon_sosy(dArray3, dArray2, dArray3, n2, stringBuffer) != 0) {
                    return -1;
                }
                if ((n2 & 0x800) != 0) {
                    for (n5 = 0; n5 <= 5; ++n5) {
                        dArray2[n5] = dArray3[n5];
                    }
                }
            } else {
                this.sl.swi_cartpol_sp(dArray2, dArray2);
                dArray2[0] = dArray2[0] - this.swe_get_ayanamsa(d) * 0.0174532925199433;
                this.sl.swi_polcart_sp(dArray2, dArray2);
            }
        }
        if ((n2 & 0x1000) == 0) {
            this.sl.swi_cartpol_sp(dArray2, dArray2);
        }
        if ((n2 & 0x2000) == 0 && (n2 & 0x1000) == 0) {
            for (n5 = 0; n5 < 2; ++n5) {
                int n15 = n5;
                dArray2[n15] = dArray2[n15] * 57.2957795130823;
                int n16 = n5 + 3;
                dArray2[n16] = dArray2[n16] * 57.2957795130823;
            }
        }
        for (n5 = 0; n5 <= 5; ++n5) {
            dArray[n5] = dArray2[n5];
        }
        if ((n3 & 7) == 0) {
            n2 &= 0xFFFFFFFD;
        }
        return n2 &= 0xFFFFFEFF;
    }

    int swe_fixstar_error(double[] dArray, int n) {
        for (int i = 0; i <= 5; ++i) {
            dArray[i] = 0.0;
        }
        return n;
    }

    public double getFixstarMagnitude(String string) throws SwissephException {
        return this.getFixstarMagnitude(new StringBuffer(string));
    }

    public double getFixstarMagnitude(StringBuffer stringBuffer) throws SwissephException {
        double[] dArray = new double[1];
        StringBuffer stringBuffer2 = new StringBuffer();
        try {
            this.swe_fixstar_mag(stringBuffer, dArray, stringBuffer2);
        }
        catch (SwissephException swissephException) {
            dArray[0] = 0.0;
            throw swissephException;
        }
        return dArray[0];
    }

    protected int swe_fixstar_mag(StringBuffer stringBuffer, double[] dArray, StringBuffer stringBuffer2) throws SwissephException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        String string;
        String[] stringArray;
        boolean bl;
        int n6;
        block25: {
            n6 = 0;
            bl = false;
            stringArray = new String[20];
            string = "";
            n5 = 0;
            n4 = 0;
            n3 = -1;
            dArray[0] = 0.0;
            if (stringBuffer2 != null) {
                stringBuffer2.setLength(0);
            }
            if (this.swed.fixfp == null) {
                int n7 = 9;
                try {
                    this.swed.fixfp = this.swi_fopen(4, "sefstars.txt", this.swed.ephepath, stringBuffer2);
                }
                catch (SwissephException swissephException) {
                    if (stringBuffer2 != null) {
                        stringBuffer2.setLength(0);
                        stringBuffer2.append(swissephException.getMessage());
                        n7 = swissephException.getType();
                    }
                    this.swed.is_old_starfile = true;
                    try {
                        this.swed.fixfp = this.swi_fopen(4, "fixstars.cat", this.swed.ephepath, null);
                    }
                    catch (SwissephException swissephException2) {
                        this.swed.fixfp = null;
                    }
                    if (this.swed.fixfp != null) break block25;
                    throw new SwissephException(Double.NaN, n7, -1, stringBuffer2.toString());
                }
            }
        }
        this.swed.fixfp.seek(0L);
        String string2 = stringBuffer.toString().substring(0, SMath.min(stringBuffer.length(), 256));
        if (string2.length() > 0) {
            if (string2.charAt(0) == ',') {
                bl = true;
            } else if (Character.isDigit(string2.charAt(0))) {
                n6 = Integer.parseInt(string2);
            } else {
                if (string2.indexOf(44) >= 0) {
                    string2 = string2.substring(0, string2.indexOf(44));
                }
                string2 = string2.toLowerCase();
            }
            string2 = string2.trim();
        }
        if ((n2 = string2.length()) == 0) {
            throw new SwissephException(Double.NaN, 5120, n3, "swe_fixstar_mag(): star name empty");
        }
        try {
            while ((string = this.swed.fixfp.readLine()) != null) {
                ++n4;
                if (string.startsWith("#")) continue;
                if (n6 != ++n5) {
                    String string3;
                    if (n6 > 0) continue;
                    if (string.indexOf(44) < 0) {
                        throw new SwissephException(Double.NaN, 65, n3, "star file sefstars.txt damaged at line " + n4);
                    }
                    String string4 = string.substring(string.indexOf(44));
                    if (!(bl ? string4.substring(0, SMath.min(string4.length(), n2)).equals(string2.substring(0, SMath.min(string2.length(), n2))) : (n = (string3 = string.substring(0, SMath.min(string.length(), 256)).trim()).length()) >= n2 && (string3 = string3.toLowerCase()).substring(0, SMath.min(string3.length(), n2)).equals(string2.substring(0, SMath.min(string2.length(), n2))))) continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            string = null;
        }
        if (string == null) {
            String string5 = "star " + stringBuffer + " not found";
            dArray[0] = 0.0;
            throw new SwissephException(Double.NaN, 5120, n3, string5);
        }
        n = this.sl.swi_cutstr(string, ",", stringArray, 20);
        stringArray[0] = stringArray[0].trim();
        stringArray[1] = stringArray[1].trim();
        if (n < 13) {
            String string6 = "data of star '" + stringArray[0] + "," + stringArray[1] + "' incomplete";
            throw new SwissephException(Double.NaN, 65, n3, string6);
        }
        try {
            dArray[0] = Double.parseDouble(stringArray[13].trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SwissephException(Double.NaN, 65, n3, "star file sefstars.txt damaged at line " + n4 + ": field 13 is not a double");
        }
        if (stringArray[0].length() > 256) {
            stringArray[0] = stringArray[0].substring(0, 256);
        }
        if (stringArray[1].length() > 256) {
            stringArray[1] = stringArray[1].substring(0, 256);
        }
        stringBuffer.setLength(0);
        stringBuffer.append(stringArray[0] + "," + stringArray[1]);
        return 0;
    }

    void swi_force_app_pos_etc() {
        int n;
        for (n = 0; n < 18; ++n) {
            this.swed.pldat[n].xflgs = -1;
        }
        for (n = 0; n < 6; ++n) {
            this.swed.nddat[n].xflgs = -1;
        }
        for (n = 0; n < 23; ++n) {
            this.swed.savedat[n].tsave = 0.0;
            this.swed.savedat[n].iflgsave = -1;
        }
    }

    int swi_get_observer(double d, int n, boolean bl, double[] dArray, StringBuffer stringBuffer) {
        double d2;
        double d3;
        double[] dArray2 = new double[2];
        double d4 = 0.003352819697896193;
        double d5 = 6378136.6;
        if (!this.swed.geopos_is_set) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("geographic position has not been set");
            }
            return -1;
        }
        double d6 = SweDate.getDeltaT(d);
        double d7 = d - d6;
        if (this.swed.oec.teps == d && this.swed.nut.tnut == d) {
            d3 = this.swed.oec.eps;
            dArray2[1] = this.swed.nut.nutlo[1];
            dArray2[0] = this.swed.nut.nutlo[0];
        } else {
            d3 = this.sl.swi_epsiln(d, n);
            if ((n & 0x40) == 0) {
                this.sl.swi_nutation(d, n, dArray2);
            }
        }
        if ((n & 0x40) != 0) {
            d2 = 0.0;
        } else {
            d3 += dArray2[1];
            d2 = dArray2[0];
        }
        double d8 = this.sl.swe_sidtime0(d7, d3, d2);
        double d9 = SMath.cos(this.swed.topd.geolat * 0.0174532925199433);
        double d10 = SMath.sin(this.swed.topd.geolat * 0.0174532925199433);
        double d11 = 1.0 / SMath.sqrt(d9 * d9 + (1.0 - d4) * (1.0 - d4) * d10 * d10);
        double d12 = (1.0 - d4) * (1.0 - d4) * d11;
        double d13 = SMath.cos((this.swed.topd.geolon + (d8 *= 15.0)) * 0.0174532925199433);
        double d14 = SMath.sin((this.swed.topd.geolon + d8) * 0.0174532925199433);
        double d15 = this.swed.topd.geoalt;
        dArray[0] = (d5 * d11 + d15) * d9 * d13;
        dArray[1] = (d5 * d11 + d15) * d9 * d14;
        dArray[2] = (d5 * d12 + d15) * d10;
        this.sl.swi_cartpol(dArray, dArray);
        dArray[3] = 6.300387486748799;
        dArray[5] = 0.0;
        dArray[4] = 0.0;
        this.sl.swi_polcart_sp(dArray, dArray);
        int n2 = 0;
        while (n2 <= 5) {
            int n3 = n2++;
            dArray[n3] = dArray[n3] / 1.4959787066E11;
        }
        if ((n & 0x40) == 0) {
            this.sl.swi_coortrf2(dArray, dArray, -this.swed.nut.snut, this.swed.nut.cnut);
            if ((n & 0x100) != 0) {
                this.sl.swi_coortrf2(dArray, 3, dArray, 3, -this.swed.nut.snut, this.swed.nut.cnut);
            }
            this.swi_nutate(dArray, 0, n, true);
        }
        this.sl.swi_precess(dArray, d, n, 1);
        if ((n & 0x100) != 0) {
            this.swi_precess_speed(dArray, d, n, 1);
        }
        if (bl) {
            for (n2 = 0; n2 <= 5; ++n2) {
                this.swed.topd.xobs[n2] = dArray[n2];
            }
            this.swed.topd.teval = d;
            this.swed.topd.tjd_ut = d7;
        }
        return 0;
    }

    public int swe_time_equ(double d, double[] dArray, StringBuffer stringBuffer) {
        double[] dArray2 = new double[6];
        double d2 = this.sl.swe_sidtime(d);
        int n = 2048;
        if (this.swed.jpl_file_is_open) {
            n |= 1;
        }
        double d3 = d + 0.5;
        double d4 = d3 - SMath.floor(d3);
        d2 -= d4 * 24.0;
        d2 *= 15.0;
        int n2 = this.swe_calc_ut(d, 0, n, dArray2, stringBuffer);
        if (n2 == -1) {
            return -1;
        }
        d4 = this.sl.swe_degnorm(d2 - dArray2[0] - 180.0);
        if (d4 > 180.0) {
            d4 -= 360.0;
        }
        dArray[0] = (d4 *= 4.0) / 1440.0;
        return 0;
    }

    public int swe_lmt_to_lat(double d, double d2, double[] dArray, StringBuffer stringBuffer) {
        double[] dArray2 = new double[1];
        double d3 = d - d2 / 360.0;
        int n = this.swe_time_equ(d3, dArray2, stringBuffer);
        dArray[0] = d + dArray2[0];
        return n;
    }

    public int swe_lat_to_lmt(double d, double d2, double[] dArray, StringBuffer stringBuffer) {
        double[] dArray2 = new double[1];
        double d3 = d - d2 / 360.0;
        int n = this.swe_time_equ(d3, dArray2, stringBuffer);
        n = this.swe_time_equ(d3 - dArray2[0], dArray2, stringBuffer);
        n = this.swe_time_equ(d3 - dArray2[0], dArray2, stringBuffer);
        dArray[0] = d - dArray2[0];
        return n;
    }

    private int open_jpl_file(double[] dArray, String string, String string2, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = this.sj.swi_open_jpl_file(dArray, string, string2, stringBuffer);
        if (n != 0 && string.indexOf("de431.eph") >= 0 && stringBuffer != null && (n = this.sj.swi_open_jpl_file(dArray, "de406.eph", string2, stringBuffer2)) == 0) {
            this.swed.jplfnam = "de406.eph";
            if (stringBuffer != null) {
                stringBuffer2.setLength(0);
                stringBuffer2.append("Error with JPL ephemeris file ");
                if (stringBuffer2.length() + "de431.eph".length() < 256) {
                    stringBuffer2.append("de431.eph");
                }
                if (stringBuffer2.length() + stringBuffer.length() + 2 < 256) {
                    stringBuffer2.append(": " + stringBuffer);
                }
                if (stringBuffer2.length() + 17 < 256) {
                    stringBuffer2.append(". Defaulting to ");
                }
                if (stringBuffer2.length() + "de406.eph".length() < 256) {
                    stringBuffer2.append("de406.eph");
                }
                stringBuffer.setLength(0);
                stringBuffer.append(stringBuffer2);
            }
        }
        if (n == 0) {
            this.swed.jpldenum = this.sj.swi_get_jpl_denum();
            this.swed.jpl_file_is_open = true;
            SweDate.swi_set_tid_acc(0.0, 0, this.swed.jpldenum);
        }
        return n;
    }

    double dot_prod(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2];
    }

    double dot_prod(double[] dArray, double[] dArray2, int n) {
        return dArray[0] * dArray2[n] + dArray[1] * dArray2[1 + n] + dArray[2] * dArray2[2 + n];
    }
}

