/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.IOException;
import java.io.Serializable;
import swisseph.DblObj;
import swisseph.FilePtr;
import swisseph.IntObj;
import swisseph.PlanData;
import swisseph.Plantbl;
import swisseph.SMath;
import swisseph.SweDate;
import swisseph.Swemmoon;
import swisseph.SwemptabEar;
import swisseph.SwemptabJup;
import swisseph.SwemptabMar;
import swisseph.SwemptabMer;
import swisseph.SwemptabNep;
import swisseph.SwemptabPlu;
import swisseph.SwemptabSat;
import swisseph.SwemptabUra;
import swisseph.SwemptabVen;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;

class SwephMosh
implements Serializable {
    SwissLib sl = null;
    SwissEph sw = null;
    SwissData swed = null;
    Swemmoon sm = null;
    SweDate sd = null;
    private static final double TIMESCALE = 3652500.0;
    private static final int FICT_GEO = 1;
    private static final int[] pnoint2msh = new int[]{2, 2, 0, 1, 3, 4, 5, 6, 7, 8};
    private static final double[] freqs = new double[]{5.38101628688982E10, 2.10664136433548E10, 1.29597742283429E10, 6.8905077493988E9, 1.0925660377991E9, 4.399609855372E8, 1.542481193933E8, 7.86550320744E7, 5.22722451795E7};
    private static final double[] phases = new double[]{908103.259872, 655127.28306, 361679.244588, 1279558.798488, 123665.46746400002, 180278.79948000002, 1130598.0183960001, 1095655.195728, 860492.1546};
    double[][] ss = new double[9][24];
    double[][] cc = new double[9][24];
    static final String[] plan_fict_nam = new String[]{"Cupido", "Hades", "Zeus", "Kronos", "Apollon", "Admetos", "Vulkanus", "Poseidon", "Isis-Transpluto", "Nibiru", "Harrington", "Leverrier", "Adams", "Lowell", "Pickering"};
    private static final double[][] plan_oscu_elem = new double[][]{{2415020.0, 2415020.0, 163.7409, 40.99837, 0.0046, 171.4333, 129.8325, 1.0833}, {2415020.0, 2415020.0, 27.6496, 50.66744, 0.00245, 148.1796, 161.3339, 1.05}, {2415020.0, 2415020.0, 165.1232, 59.21436, 0.0012, 299.044, 0.0, 0.0}, {2415020.0, 2415020.0, 169.0193, 64.8196, 0.00305, 208.8801, 0.0, 0.0}, {2415020.0, 2415020.0, 138.0533, 70.29949, 0.0, 0.0, 0.0, 0.0}, {2415020.0, 2415020.0, 351.335, 73.62765, 0.0, 0.0, 0.0, 0.0}, {2415020.0, 2415020.0, 55.8983, 77.25568, 0.0, 0.0, 0.0, 0.0}, {2415020.0, 2415020.0, 165.5163, 83.66907, 0.0, 0.0, 0.0, 0.0}, {2368547.66, 2431456.5, 0.0, 77.775, 0.3, 0.7, 0.0, 0.0}, {1856113.380954, 1856113.380954, 0.0, 234.8921, 0.981092, 103.966, -44.567, 158.708}, {2374696.5, 2451545.0, 0.0, 101.2, 0.411, 208.5, 275.4, 32.4}, {2395662.5, 2395662.5, 34.05, 36.15, 0.10761, 284.75, 0.0, 0.0}, {2395662.5, 2395662.5, 24.28, 37.25, 0.12062, 299.11, 0.0, 0.0}, {2425977.5, 2425977.5, 281.0, 43.0, 0.202, 204.9, 0.0, 0.0}, {2425977.5, 2425977.5, 48.95, 55.1, 0.31, 280.1, 100.0, 15.0}};
    private Plantbl[] planets = new Plantbl[]{SwemptabMer.mer404, SwemptabVen.ven404, SwemptabEar.ear404, SwemptabMar.mar404, SwemptabJup.jup404, SwemptabSat.sat404, SwemptabUra.ura404, SwemptabNep.nep404, SwemptabPlu.plu404};

    SwephMosh(SwissLib swissLib, SwissEph swissEph, SwissData swissData) {
        this.sl = swissLib;
        this.sw = swissEph;
        this.swed = swissData;
        if (this.sl == null) {
            this.sl = new SwissLib();
        }
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        if (this.swed == null) {
            this.swed = new SwissData();
        }
        this.sm = new Swemmoon(swissData, swissLib);
    }

    private int swi_moshplan2(double d, int n, double[] dArray) {
        int n2;
        double d2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Plantbl plantbl = this.planets[n];
        double d3 = (d - 2451545.0) / 3652500.0;
        for (int i = 0; i < 9; ++i) {
            n3 = plantbl.max_harmonic[i];
            if (n3 <= 0) continue;
            d2 = (this.sm.mods3600(freqs[i] * d3) + phases[i]) * 4.84813681109536E-6;
            this.sscc(i, d2, n3);
        }
        byte[] byArray = plantbl.arg_tbl;
        double[] dArray2 = plantbl.lon_tbl;
        double[] dArray3 = plantbl.lat_tbl;
        double[] dArray4 = plantbl.rad_tbl;
        double d4 = 0.0;
        double d5 = 0.0;
        d2 = 0.0;
        while ((n2 = byArray[n4++]) >= 0) {
            double d6;
            int n8;
            double d7;
            int n9;
            if (n2 == 0) {
                n9 = byArray[n4++];
                d7 = dArray2[n5++];
                for (n8 = 0; n8 < n9; ++n8) {
                    d7 = d7 * d3 + dArray2[n5++];
                }
                d4 += this.sm.mods3600(d7);
                d7 = dArray3[n6++];
                for (n8 = 0; n8 < n9; ++n8) {
                    d7 = d7 * d3 + dArray3[n6++];
                }
                d5 += d7;
                d7 = dArray4[n7++];
                for (n8 = 0; n8 < n9; ++n8) {
                    d7 = d7 * d3 + dArray4[n7++];
                }
                d2 += d7;
                continue;
            }
            boolean bl = false;
            double d8 = 0.0;
            double d9 = 0.0;
            for (n8 = 0; n8 < n2; ++n8) {
                n3 = byArray[n4++];
                int n10 = byArray[n4++] - 1;
                if (n3 == 0) continue;
                int n11 = n3;
                if (n3 < 0) {
                    n11 = -n11;
                }
                d6 = this.ss[n10][--n11];
                if (n3 < 0) {
                    d6 = -d6;
                }
                d7 = this.cc[n10][n11];
                if (!bl) {
                    d9 = d6;
                    d8 = d7;
                    bl = true;
                    continue;
                }
                double d10 = d6 * d8 + d7 * d9;
                d8 = d7 * d8 - d6 * d9;
                d9 = d10;
            }
            n9 = byArray[n4++];
            d7 = dArray2[n5++];
            d6 = dArray2[n5++];
            for (n8 = 0; n8 < n9; ++n8) {
                d7 = d7 * d3 + dArray2[n5++];
                d6 = d6 * d3 + dArray2[n5++];
            }
            d4 += d7 * d8 + d6 * d9;
            d7 = dArray3[n6++];
            d6 = dArray3[n6++];
            for (n8 = 0; n8 < n9; ++n8) {
                d7 = d7 * d3 + dArray3[n6++];
                d6 = d6 * d3 + dArray3[n6++];
            }
            d5 += d7 * d8 + d6 * d9;
            d7 = dArray4[n7++];
            d6 = dArray4[n7++];
            for (n8 = 0; n8 < n9; ++n8) {
                d7 = d7 * d3 + dArray4[n7++];
                d6 = d6 * d3 + dArray4[n7++];
            }
            d2 += d7 * d8 + d6 * d9;
        }
        dArray[0] = 4.84813681109536E-6 * d4;
        dArray[1] = 4.84813681109536E-6 * d5;
        dArray[2] = 4.84813681109536E-6 * plantbl.distance * d2 + plantbl.distance;
        return 0;
    }

    int swi_moshplan(double d, int n, boolean bl, double[] dArray, double[] dArray2, StringBuffer stringBuffer) {
        int n2;
        double[] dArray3;
        double[] dArray4;
        boolean bl2 = false;
        double[] dArray5 = new double[3];
        double[] dArray6 = new double[3];
        double[] dArray7 = new double[6];
        double[] dArray8 = new double[6];
        int n3 = pnoint2msh[n];
        PlanData planData = this.swed.pldat[n];
        PlanData planData2 = this.swed.pldat[0];
        double d2 = this.swed.oec2000.seps;
        double d3 = this.swed.oec2000.ceps;
        if (bl) {
            dArray4 = planData.x;
            dArray3 = planData2.x;
        } else {
            dArray4 = dArray8;
            dArray3 = dArray7;
        }
        if (bl || n == 0 || dArray2 != null) {
            bl2 = true;
        }
        if (d < 625000.2 || d > 2818000.8) {
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                String string = "jd " + d + " outside Moshier planet range " + 625000.5 + " .. " + 2818000.5 + " ";
                if (stringBuffer.length() + string.length() < 256) {
                    stringBuffer.append(string);
                }
            }
            return -1;
        }
        if (bl2) {
            if (d == planData2.teval && planData2.iephe == 4) {
                dArray3 = planData2.x;
            } else {
                this.swi_moshplan2(d, pnoint2msh[0], dArray3);
                this.sl.swi_polcart(dArray3, dArray3);
                this.sl.swi_coortrf2(dArray3, dArray3, -d2, d3);
                this.embofs_mosh(d, dArray3);
                if (bl) {
                    planData2.teval = d;
                    planData2.xflgs = -1;
                    planData2.iephe = 4;
                }
                this.swi_moshplan2(d - 1.0E-4, pnoint2msh[0], dArray6);
                this.sl.swi_polcart(dArray6, dArray6);
                this.sl.swi_coortrf2(dArray6, dArray6, -d2, d3);
                this.embofs_mosh(d - 1.0E-4, dArray6);
                for (n2 = 0; n2 <= 2; ++n2) {
                    dArray5[n2] = (dArray3[n2] - dArray6[n2]) / 1.0E-4;
                }
                for (n2 = 0; n2 <= 2; ++n2) {
                    dArray3[n2 + 3] = dArray5[n2];
                }
            }
            if (dArray2 != null) {
                for (n2 = 0; n2 <= 5; ++n2) {
                    dArray2[n2] = dArray3[n2];
                }
            }
        }
        if (n == 0) {
            dArray4 = dArray3;
        } else {
            if (d == planData.teval && planData.iephe == 4) {
                dArray4 = planData.x;
            } else {
                this.swi_moshplan2(d, n3, dArray4);
                this.sl.swi_polcart(dArray4, dArray4);
                this.sl.swi_coortrf2(dArray4, dArray4, -d2, d3);
                if (bl) {
                    planData.teval = d;
                    planData.xflgs = -1;
                    planData.iephe = 4;
                }
                double d4 = 1.0E-4;
                this.swi_moshplan2(d - d4, n3, dArray6);
                this.sl.swi_polcart(dArray6, dArray6);
                this.sl.swi_coortrf2(dArray6, dArray6, -d2, d3);
                for (n2 = 0; n2 <= 2; ++n2) {
                    dArray5[n2] = (dArray4[n2] - dArray6[n2]) / d4;
                }
                for (n2 = 0; n2 <= 2; ++n2) {
                    dArray4[n2 + 3] = dArray5[n2];
                }
            }
            if (dArray != null) {
                for (n2 = 0; n2 <= 5; ++n2) {
                    dArray[n2] = dArray4[n2];
                }
            }
        }
        return 0;
    }

    private void sscc(int n, double d, int n2) {
        double d2 = SMath.sin(d);
        double d3 = SMath.cos(d);
        this.ss[n][0] = d2;
        this.cc[n][0] = d3;
        double d4 = 2.0 * d2 * d3;
        double d5 = d3 * d3 - d2 * d2;
        this.ss[n][1] = d4;
        this.cc[n][1] = d5;
        for (int i = 2; i < n2; ++i) {
            double d6 = d2 * d5 + d3 * d4;
            d5 = d3 * d5 - d2 * d4;
            this.ss[n][i] = d4 = d6;
            this.cc[n][i] = d5;
        }
    }

    private void embofs_mosh(double d, double[] dArray) {
        double[] dArray2 = new double[6];
        double d2 = this.swed.oec.seps;
        double d3 = this.swed.oec.ceps;
        double d4 = (d - 2415020.0) / 36525.0;
        double d5 = this.sl.swe_degnorm(((1.44E-5 * d4 + 0.009192) * d4 + 477198.8491) * d4 + 296.104608);
        double d6 = SMath.sin(d5 *= 0.0174532925199433);
        double d7 = SMath.cos(d5);
        double d8 = 2.0 * d6 * d7;
        double d9 = d7 * d7 - d6 * d6;
        d5 = this.sl.swe_degnorm(((1.9E-6 * d4 - 0.001436) * d4 + 445267.1142) * d4 + 350.737486);
        d5 = 0.0349065850398866 * d5;
        double d10 = SMath.sin(d5);
        double d11 = SMath.cos(d5);
        d5 = this.sl.swe_degnorm(((-3.0E-7 * d4 - 0.003211) * d4 + 483202.0251) * d4 + 11.250889);
        double d12 = SMath.sin(d5 *= 0.0174532925199433);
        double d13 = SMath.cos(d5);
        double d14 = 2.0 * d12 * d13;
        double d15 = d10 * d7 - d11 * d6;
        double d16 = d11 * d7 + d10 * d6;
        double d17 = ((1.9E-6 * d4 - 0.001133) * d4 + 481267.8831) * d4 + 270.434164;
        double d18 = this.sl.swe_degnorm(((-3.3E-6 * d4 - 1.5E-4) * d4 + 35999.0498) * d4 + 358.475833);
        d17 = d17 + 6.28875 * d6 + 1.274018 * d15 + 0.658309 * d10 + 0.213616 * d8 - 0.185596 * SMath.sin(0.0174532925199433 * d18) - 0.114336 * d14;
        d5 = d6 * d13;
        d15 = d7 * d12;
        double d19 = 5.128189 * d12 + 0.280606 * (d5 + d15) + 0.277693 * (d5 - d15) + 0.173238 * (d10 * d13 - d11 * d12);
        double d20 = 0.950724 + 0.051818 * d7 + 0.009531 * d16 + 0.007843 * d11 + 0.002824 * d9;
        d17 = this.sl.swe_degnorm(d17);
        d5 = 4.263523E-5 / SMath.sin(d20 *= 0.0174532925199433);
        dArray2[0] = d17 *= 0.0174532925199433;
        dArray2[1] = d19 *= 0.0174532925199433;
        dArray2[2] = d5;
        this.sl.swi_polcart(dArray2, dArray2);
        this.sl.swi_coortrf2(dArray2, dArray2, -d2, d3);
        this.sl.swi_precess(dArray2, d, 0, 1);
        for (int i = 0; i <= 2; ++i) {
            int n = i;
            dArray[n] = dArray[n] - dArray2[i] / 82.30055985272827;
        }
    }

    String swi_get_fict_name(int n, String string) {
        StringBuffer stringBuffer;
        if (string == null) {
            string = "";
        }
        if (this.read_elements_file(n, 0.0, null, null, null, null, null, null, null, null, stringBuffer = new StringBuffer(string), null, null) == -1) {
            return "name not found";
        }
        return stringBuffer.toString();
    }

    int swi_osc_el_plan(double d, double[] dArray, int n, int n2, double[] dArray2, double[] dArray3, StringBuffer stringBuffer) {
        double d2;
        double[] dArray4 = new double[9];
        double[] dArray5 = new double[6];
        DblObj dblObj = new DblObj();
        DblObj dblObj2 = new DblObj();
        DblObj dblObj3 = new DblObj();
        DblObj dblObj4 = new DblObj();
        DblObj dblObj5 = new DblObj();
        DblObj dblObj6 = new DblObj();
        DblObj dblObj7 = new DblObj();
        DblObj dblObj8 = new DblObj();
        PlanData planData = this.swed.pldat[0];
        PlanData planData2 = this.swed.pldat[n2];
        IntObj intObj = new IntObj();
        intObj.val = 0;
        if (this.read_elements_file(n, d, dblObj, dblObj2, dblObj3, dblObj4, dblObj5, dblObj6, dblObj7, dblObj8, null, intObj, stringBuffer) == -1) {
            return -1;
        }
        double d3 = 0.017202098949975136 / dblObj4.val / SMath.sqrt(dblObj4.val);
        if ((intObj.val & 1) != 0) {
            d3 /= SMath.sqrt(332946.050895);
        }
        double d4 = SMath.cos(dblObj7.val);
        double d5 = SMath.sin(dblObj7.val);
        double d6 = SMath.cos(dblObj8.val);
        double d7 = SMath.sin(dblObj8.val);
        double d8 = SMath.cos(dblObj6.val);
        double d9 = SMath.sin(dblObj6.val);
        dArray4[0] = d8 * d4 - d9 * d6 * d5;
        dArray4[1] = -d9 * d4 - d8 * d6 * d5;
        dArray4[2] = d7 * d5;
        dArray4[3] = d8 * d5 + d9 * d6 * d4;
        dArray4[4] = -d9 * d5 + d8 * d6 * d4;
        dArray4[5] = -d7 * d4;
        dArray4[6] = d9 * d7;
        dArray4[7] = d8 * d7;
        dArray4[8] = d6;
        double d10 = d2 = this.sl.swi_mod2PI(dblObj3.val + (d - dblObj.val) * d3);
        if (dblObj5.val > 0.975) {
            double d11;
            double d12;
            double d13 = d2 * 57.2957795130823;
            if (d13 > 150.0 && d13 < 210.0) {
                d13 -= 180.0;
                d12 = 180.0;
            } else {
                d12 = 0.0;
            }
            if (d13 > 330.0) {
                d13 -= 360.0;
            }
            if (d13 < 0.0) {
                d13 = -d13;
                d11 = -1.0;
            } else {
                d11 = 1.0;
            }
            if (d13 < 30.0) {
                double d14 = (1.0 - dblObj5.val) / (4.0 * dblObj5.val + 0.5);
                double d15 = (d13 *= 0.0174532925199433) / (8.0 * dblObj5.val + 1.0);
                double d16 = SMath.pow(d15 + SMath.sqrt(d15 * d15 + d14 * d14), 0.0);
                double d17 = d16 - d14 / 2.0;
                d17 -= 0.078 * d17 * d17 * d17 * d17 * d17 / (1.0 + dblObj5.val);
                d10 = d11 * (d13 + dblObj5.val * (3.0 * d17 - 4.0 * d17 * d17 * d17)) + d12;
            }
        }
        d10 = this.sl.swi_kepler(d10, d2, dblObj5.val);
        double d18 = (intObj.val & 1) != 0 ? 2.98122353216E-5 / SMath.sqrt(dblObj4.val) : 0.01720209895 / SMath.sqrt(dblObj4.val);
        double d19 = SMath.cos(d10);
        double d20 = SMath.sin(d10);
        double d21 = SMath.sqrt((1.0 - dblObj5.val) * (1.0 + dblObj5.val));
        double d22 = 1.0 - dblObj5.val * d19;
        dArray5[0] = dblObj4.val * (d19 - dblObj5.val);
        dArray5[1] = dblObj4.val * d21 * d20;
        dArray5[3] = -d18 * d20 / d22;
        dArray5[4] = d18 * d21 * d19 / d22;
        dArray[0] = dArray4[0] * dArray5[0] + dArray4[1] * dArray5[1];
        dArray[1] = dArray4[3] * dArray5[0] + dArray4[4] * dArray5[1];
        dArray[2] = dArray4[6] * dArray5[0] + dArray4[7] * dArray5[1];
        dArray[3] = dArray4[0] * dArray5[3] + dArray4[1] * dArray5[4];
        dArray[4] = dArray4[3] * dArray5[3] + dArray4[4] * dArray5[4];
        dArray[5] = dArray4[6] * dArray5[3] + dArray4[7] * dArray5[4];
        double d23 = this.sl.swi_epsiln(dblObj2.val, 0);
        this.sl.swi_coortrf(dArray, dArray, -d23);
        this.sl.swi_coortrf(dArray, 3, dArray, 3, -d23);
        if (dblObj2.val != 2451545.0) {
            this.sl.swi_precess(dArray, dblObj2.val, 0, 1);
            this.sl.swi_precess(dArray, 3, dblObj2.val, 0, 1);
        }
        if ((intObj.val & 1) != 0) {
            for (int i = 0; i <= 5; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] + dArray2[i];
            }
        } else {
            for (int i = 0; i <= 5; ++i) {
                int n4 = i;
                dArray[n4] = dArray[n4] + dArray3[i];
            }
        }
        if (planData2.x == dArray) {
            planData2.teval = d;
            planData2.iephe = planData.iephe;
        }
        return 0;
    }

    private int read_elements_file(int n, double d, DblObj dblObj, DblObj dblObj2, DblObj dblObj3, DblObj dblObj4, DblObj dblObj5, DblObj dblObj6, DblObj dblObj7, DblObj dblObj8, StringBuffer stringBuffer, IntObj intObj, StringBuffer stringBuffer2) {
        FilePtr filePtr = null;
        int n2 = 0;
        String[] stringArray = new String[20];
        String string = "";
        boolean bl = false;
        double d2 = 0.0;
        try {
            filePtr = this.sw.swi_fopen(-1, "seorbel.txt", this.swed.ephepath, stringBuffer2);
        }
        catch (SwissephException swissephException) {
            if (n >= 15) {
                if (stringBuffer2 != null) {
                    stringBuffer2.setLength(0);
                    stringBuffer2.append("error no elements for fictitious body no ").append(n);
                }
                return -1;
            }
            if (dblObj != null) {
                dblObj.val = plan_oscu_elem[n][0];
            }
            if (dblObj2 != null) {
                dblObj2.val = plan_oscu_elem[n][1];
            }
            if (dblObj3 != null) {
                dblObj3.val = plan_oscu_elem[n][2] * 0.0174532925199433;
            }
            if (dblObj4 != null) {
                dblObj4.val = plan_oscu_elem[n][3];
            }
            if (dblObj5 != null) {
                dblObj5.val = plan_oscu_elem[n][4];
            }
            if (dblObj6 != null) {
                dblObj6.val = plan_oscu_elem[n][5] * 0.0174532925199433;
            }
            if (dblObj7 != null) {
                dblObj7.val = plan_oscu_elem[n][6] * 0.0174532925199433;
            }
            if (dblObj8 != null) {
                dblObj8.val = plan_oscu_elem[n][7] * 0.0174532925199433;
            }
            if (stringBuffer != null) {
                stringBuffer.setLength(0);
                stringBuffer.append(plan_fict_nam[n]);
            }
            return 0;
        }
        int n3 = 0;
        int n4 = -1;
        try {
            String string2;
            while ((string2 = filePtr.readLine()) != null) {
                int n5;
                String string3 = string2 = string2.trim();
                n2 = 0;
                char c = string2.charAt(n2);
                if (c == '#' || c == '\r' || c == '\n' || c == '\u0000') continue;
                string3 = null;
                n2 = string2.indexOf(35);
                if (n2 >= 0) {
                    string2 = string2.substring(0, string2.indexOf(35));
                    string3 = "";
                }
                int n6 = this.sl.swi_cutstr(string2, ",", stringArray, 20);
                string = "error in file seorbel.txt, line " + n3 + ":";
                if (n6 < 9) {
                    if (stringBuffer2 != null) {
                        stringBuffer2.setLength(0);
                        stringBuffer2.append(string).append(" nine elements required");
                    }
                    return -1;
                }
                if (++n4 != n) continue;
                bl = true;
                if (dblObj != null) {
                    string3 = stringArray[0];
                    String string4 = string3 = string3.length() <= 5 ? string3.toLowerCase() : string3.substring(0, 5).toLowerCase() + string3.substring(5);
                    if (string3.startsWith("j2000")) {
                        dblObj.val = 2451545.0;
                    } else if (string3.startsWith("b1950")) {
                        dblObj.val = 2433282.42345905;
                    } else if (string3.startsWith("j1900")) {
                        dblObj.val = 2415020.0;
                    } else {
                        if (string3.charAt(0) == 'j' || string3.charAt(0) == 'b') {
                            if (stringBuffer2 != null) {
                                stringBuffer2.setLength(0);
                                stringBuffer2.append(string).append(" invalid epoch");
                            }
                            filePtr.close();
                            return -1;
                        }
                        dblObj.val = SwissLib.atof(string3);
                    }
                    d2 = d - dblObj.val;
                }
                if (dblObj2 != null) {
                    string3 = stringArray[1];
                    n2 = 0;
                    while (string3.charAt(n2) == ' ' || string3.charAt(n2) == '\t') {
                        ++n2;
                    }
                    String string5 = string3 = (string3 = string3.substring(n2)).length() < 5 ? string3.toLowerCase() : string3.substring(0, 5).toLowerCase() + string3.substring(5);
                    if (string3.startsWith("j2000")) {
                        dblObj2.val = 2451545.0;
                    } else if (string3.startsWith("b1950")) {
                        dblObj2.val = 2433282.42345905;
                    } else if (string3.startsWith("j1900")) {
                        dblObj2.val = 2415020.0;
                    } else if (string3.startsWith("jdate")) {
                        dblObj2.val = d;
                    } else {
                        if (string3.charAt(0) == 'j' || string3.charAt(0) == 'b') {
                            if (stringBuffer2 != null) {
                                stringBuffer2.setLength(0);
                                stringBuffer2.append(string).append(" invalid equinox");
                            }
                            filePtr.close();
                            return -1;
                        }
                        dblObj2.val = SwissLib.atof(string3);
                    }
                }
                if (dblObj3 != null) {
                    n5 = this.check_t_terms(d2, stringArray[2], dblObj3);
                    dblObj3.val = this.sl.swe_degnorm(dblObj3.val);
                    if (n5 == -1) {
                        if (stringBuffer2 != null) {
                            stringBuffer2.append(string).append(" mean anomaly value invalid");
                        }
                        filePtr.close();
                        return -1;
                    }
                    if (n5 == 1) {
                        dblObj.val = d;
                    }
                    dblObj3.val *= 0.0174532925199433;
                }
                if (dblObj4 != null) {
                    n5 = this.check_t_terms(d2, stringArray[3], dblObj4);
                    if (dblObj4.val <= 0.0 || n5 == -1) {
                        if (stringBuffer2 != null) {
                            stringBuffer2.append(string).append(" semi-axis value invalid");
                        }
                        filePtr.close();
                        return -1;
                    }
                }
                if (dblObj5 != null) {
                    n5 = this.check_t_terms(d2, stringArray[4], dblObj5);
                    if (dblObj5.val >= 1.0 || dblObj5.val < 0.0 || n5 == -1) {
                        if (stringBuffer2 != null) {
                            stringBuffer2.setLength(0);
                            stringBuffer2.append(string).append(" eccentricity invalid (no parabolic or hyperbolic or bits allowed)");
                        }
                        filePtr.close();
                        return -1;
                    }
                }
                if (dblObj6 != null) {
                    n5 = this.check_t_terms(d2, stringArray[5], dblObj6);
                    dblObj6.val = this.sl.swe_degnorm(dblObj6.val);
                    if (n5 == -1) {
                        if (stringBuffer2 != null) {
                            stringBuffer2.setLength(0);
                            stringBuffer2.append(string).append(" perihelion argument value invalid");
                        }
                        filePtr.close();
                        return -1;
                    }
                    dblObj6.val *= 0.0174532925199433;
                }
                if (dblObj7 != null) {
                    n5 = this.check_t_terms(d2, stringArray[6], dblObj7);
                    dblObj7.val = this.sl.swe_degnorm(dblObj7.val);
                    if (n5 == -1) {
                        if (stringBuffer2 != null) {
                            stringBuffer2.setLength(0);
                            stringBuffer2.append(string).append(" node value invalid");
                        }
                        filePtr.close();
                        return -1;
                    }
                    dblObj7.val *= 0.0174532925199433;
                }
                if (dblObj8 != null) {
                    n5 = this.check_t_terms(d2, stringArray[7], dblObj8);
                    dblObj8.val = this.sl.swe_degnorm(dblObj8.val);
                    if (n5 == -1) {
                        if (stringBuffer2 != null) {
                            stringBuffer2.setLength(0);
                            stringBuffer2.append(string).append(" inclination value invalid");
                        }
                        filePtr.close();
                        return -1;
                    }
                    dblObj8.val *= 0.0174532925199433;
                }
                if (stringBuffer != null) {
                    string3 = stringArray[8];
                    n2 = 0;
                    while (string3.charAt(n2) == ' ' || string3.charAt(n2) == '\t') {
                        ++n2;
                    }
                    string3 = string3.substring(n2);
                    string3 = string3.trim();
                    stringBuffer.setLength(0);
                    stringBuffer.append(string3);
                }
                if (intObj == null || n6 <= 9) break;
                string3 = string3.substring(0, SMath.min(string3.length(), n2 + 9)) + string3.substring(SMath.min(string3.length(), n2 + 9)).toLowerCase();
                if (stringArray[9].indexOf("geo") < 0) break;
                intObj.val |= 1;
                break;
            }
            if (!bl) {
                if (stringBuffer2 != null) {
                    stringBuffer2.append(string).append(" elements for planet ").append(n).append(" not found");
                }
                filePtr.close();
                return -1;
            }
            filePtr.close();
            return 0;
        }
        catch (IOException iOException) {
            if (filePtr != null) {
                try {
                    filePtr.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    private int check_t_terms(double d, String string, DblObj dblObj) {
        double[] dArray;
        int n = 1;
        int n2 = 0;
        dArray = new double[]{d / 36525.0, dArray[0], dArray[1] * dArray[1], dArray[2] * dArray[1], dArray[3] * dArray[1]};
        if (string.indexOf(43) + string.indexOf(45) > -2) {
            n2 = 1;
        }
        int n3 = 0;
        dblObj.val = 0.0;
        double d2 = 1.0;
        int n4 = 0;
        while (true) {
            if (n3 < string.length() && (string.charAt(n3) == ' ' || string.charAt(n3) == '\t')) {
                ++n3;
                continue;
            }
            if (n3 == string.length() || string.charAt(n3) == '+' || string.charAt(n3) == '-') {
                if (n4 > 0) {
                    dblObj.val += d2;
                }
                n = 1;
                if (n3 != string.length() && string.charAt(n3) == '-') {
                    n = -1;
                }
                d2 = 1 * n;
                if (n3 == string.length()) {
                    return n2;
                }
                ++n3;
            } else {
                while (n3 < string.length() && (string.charAt(n3) == '*' || string.charAt(n3) == ' ' || string.charAt(n3) == '\t')) {
                    ++n3;
                }
                if (n3 < string.length() && (string.charAt(n3) == 't' || string.charAt(n3) == 'T')) {
                    if (++n3 < string.length() && (string.charAt(n3) == '+' || string.charAt(n3) == '-')) {
                        d2 *= dArray[0];
                    } else {
                        int n5 = SwissLib.atoi(string.substring(SMath.min(string.length(), n3)));
                        if (n5 <= 4 && n5 >= 0) {
                            d2 *= dArray[n5];
                        }
                    }
                } else {
                    double d3 = SwissLib.atof(string.substring(n3));
                    if (d3 != 0.0 || string.charAt(n3) == '0') {
                        d2 *= d3;
                    }
                }
                while (n3 < string.length() && (Character.isDigit(string.charAt(n3)) || string.charAt(n3) == '.')) {
                    ++n3;
                }
            }
            ++n4;
        }
    }
}

