/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import swisseph.FilePtr;
import swisseph.IDate;
import swisseph.SDate;
import swisseph.SMath;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;

public class SweDate
implements Serializable {
    private static SwissEph sw = new SwissEph();
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final boolean SE_JUL_CAL = false;
    public static final boolean SE_GREG_CAL = true;
    public static final boolean SE_KEEP_DATE = true;
    public static final boolean SE_KEEP_JD = false;
    private boolean init_leapseconds_done = false;
    public static final double JD0 = 2440587.5;
    private static double tid_acc = -25.8;
    private static boolean is_tid_acc_manual = false;
    private static boolean init_dt_done = false;
    private double jd;
    private double jdCO = 2299160.5;
    private boolean calType;
    private int year;
    private int month;
    private int day;
    private double hour;
    private double deltaT;
    private boolean deltatIsValid = false;
    private static final int TABSTART = 1620;
    private static final int TABEND = 2019;
    private static final int TABSIZ = 400;
    private static final int TABSIZ_SPACE = 500;
    private static double[] dt = new double[]{124.0, 119.0, 115.0, 110.0, 106.0, 102.0, 98.0, 95.0, 91.0, 88.0, 85.0, 82.0, 79.0, 77.0, 74.0, 72.0, 70.0, 67.0, 65.0, 63.0, 62.0, 60.0, 58.0, 57.0, 55.0, 54.0, 53.0, 51.0, 50.0, 49.0, 48.0, 47.0, 46.0, 45.0, 44.0, 43.0, 42.0, 41.0, 40.0, 38.0, 37.0, 36.0, 35.0, 34.0, 33.0, 32.0, 31.0, 30.0, 28.0, 27.0, 26.0, 25.0, 24.0, 23.0, 22.0, 21.0, 20.0, 19.0, 18.0, 17.0, 16.0, 15.0, 14.0, 14.0, 13.0, 12.0, 12.0, 11.0, 11.0, 10.0, 10.0, 10.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 9.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 10.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 11.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 12.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 13.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 14.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0, 15.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 16.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 17.0, 16.0, 16.0, 16.0, 16.0, 15.0, 15.0, 14.0, 14.0, 13.7, 13.4, 13.1, 12.9, 12.7, 12.6, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.5, 12.4, 12.3, 12.2, 12.0, 11.7, 11.4, 11.1, 10.6, 10.2, 9.6, 9.1, 8.6, 8.0, 7.5, 7.0, 6.6, 6.3, 6.0, 5.8, 5.7, 5.6, 5.6, 5.6, 5.7, 5.8, 5.9, 6.1, 6.2, 6.3, 6.5, 6.6, 6.8, 6.9, 7.1, 7.2, 7.3, 7.4, 7.5, 7.6, 7.7, 7.7, 7.8, 7.8, 7.88, 7.82, 7.54, 6.97, 6.4, 6.02, 5.41, 4.1, 2.92, 1.82, 1.61, 0.1, -1.02, -1.28, -2.69, -3.24, -3.64, -4.54, -4.71, -5.11, -5.4, -5.42, -5.2, -5.46, -5.46, -5.79, -5.63, -5.64, -5.8, -5.66, -5.87, -6.01, -6.19, -6.64, -6.44, -6.47, -6.09, -5.76, -4.66, -3.74, -2.72, -1.54, -0.02, 1.24, 2.64, 3.86, 5.37, 6.14, 7.75, 9.13, 10.46, 11.53, 13.36, 14.65, 16.01, 17.2, 18.24, 19.06, 20.25, 20.95, 21.16, 22.25, 22.41, 23.03, 23.49, 23.62, 23.86, 24.49, 24.34, 24.08, 24.02, 24.0, 23.87, 23.95, 23.86, 23.93, 23.73, 23.92, 23.96, 24.02, 24.33, 24.83, 25.3, 25.7, 26.24, 26.77, 27.28, 27.78, 28.25, 28.71, 29.15, 29.57, 29.97, 30.36, 30.72, 31.07, 31.35, 31.68, 32.18, 32.68, 33.15, 33.59, 34.0, 34.47, 35.03, 35.73, 36.54, 37.43, 38.29, 39.2, 40.18, 41.17, 42.23, 43.37, 44.49, 45.48, 46.46, 47.52, 48.53, 49.59, 50.54, 51.38, 52.17, 52.96, 53.79, 54.34, 54.87, 55.32, 55.82, 56.3, 56.86, 57.57, 58.31, 59.12, 59.98, 60.78, 61.63, 62.3, 62.97, 63.47, 63.83, 64.09, 64.3, 64.47, 64.57, 64.69, 64.85, 65.15, 65.46, 65.78, 66.07, 66.32, 66.6, 66.907, 67.281, 67.644, 68.01, 68.5, 69.0, 69.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final int TAB2_SIZ = 27;
    private static final int TAB2_START = -1000;
    private static final int TAB2_END = 1600;
    private static final int TAB2_STEP = 100;
    private static final int LTERM_EQUATION_YSTART = 1820;
    private static final int LTERM_EQUATION_COEFF = 32;
    private static short[] dt2 = new short[]{25400, 23700, 22000, 21000, 19040, 17190, 15530, 14080, 12790, 11640, 10580, 9600, 8640, 7680, 6700, 5710, 4740, 3810, 2960, 2200, 1570, 1090, 740, 490, 320, 200, 120};
    private static final int NLEAP_SECONDS = 26;
    private static final int NLEAP_SECONDS_SPACE = 100;
    private static final int[] leap_seconds = new int[]{19720630, 19721231, 19731231, 19741231, 19751231, 19761231, 19771231, 19781231, 19791231, 19810630, 19820630, 19830630, 19850630, 19871231, 19891231, 19901231, 19920630, 19930630, 19940630, 19951231, 19970630, 19981231, 20051231, 20081231, 20120630, 20150630, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final double J1972 = 2441317.5;
    private static final int NLEAP_INIT = 10;

    public SweDate() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        this.setFields(calendar.get(1), calendar.get(2) + 1, calendar.get(5), (double)calendar.get(11) + (double)calendar.get(12) / 60.0 + (double)calendar.get(13) / 3600.0 + (double)calendar.get(14) / 3600000.0, true);
    }

    public SweDate(double d) {
        this.initDateFromJD(d, this.jdCO <= d);
    }

    public SweDate(double d, boolean bl) {
        this.initDateFromJD(d, bl);
    }

    public SweDate(int n, int n2, int n3, double d) {
        this.setFields(n, n2, n3, d);
    }

    public SweDate(int n, int n2, int n3, double d, boolean bl) {
        this.setFields(n, n2, n3, d, bl);
    }

    public double getJulDay() {
        return this.jd;
    }

    public static double getJulDay(int n, int n2, int n3, double d) {
        double d2 = SweDate.swe_julday(n, n2, n3, d, true);
        return d2;
    }

    public static double getJulDay(int n, int n2, int n3, double d, boolean bl) {
        double d2 = SweDate.swe_julday(n, n2, n3, d, bl);
        return d2;
    }

    public int getDayOfWeekNr() {
        return (int)(this.jd - 5.5) % 7;
    }

    public static synchronized int getDayOfWeekNr(double d) {
        return (int)(d - 5.5) % 7;
    }

    public static int getDayOfWeekNr(int n, int n2, int n3) {
        int n4 = (int)(SweDate.swe_julday(n, n2, n3, 0.0, true) - 5.5) % 7;
        return n4;
    }

    public static int getDayOfWeekNr(int n, int n2, int n3, boolean bl) {
        int n4 = (int)(SweDate.swe_julday(n, n2, n3, 0.0, bl) - 5.5) % 7;
        return n4;
    }

    public boolean getCalendarType() {
        return this.calType;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public double getHour() {
        return this.hour;
    }

    public double getDeltaT() {
        if (this.deltatIsValid) {
            return this.deltaT;
        }
        this.deltaT = SweDate.calc_deltaT(this.getJulDay());
        this.deltatIsValid = true;
        return this.deltaT;
    }

    public static double getDeltaT(double d) {
        double d2 = SweDate.calc_deltaT(d);
        return d2;
    }

    public Date getDate(long l) {
        long l2 = (long)((this.getJulDay() - 2440587.5) * 24.0 * 3600.0 * 1000.0) + l;
        return new Date(l2);
    }

    public static Date getDate(double d) {
        long l = (long)((d - 2440587.5) * 24.0 * 3600.0 * 1000.0);
        return new Date(l);
    }

    public void setJulDay(double d) {
        this.jd = d;
        this.deltatIsValid = false;
        IDate iDate = this.swe_revjul(d, this.calType);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    public void setCalendarType(boolean bl, boolean bl2) {
        if (this.calType != bl) {
            this.calType = bl;
            this.deltatIsValid = false;
            if (bl2) {
                this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
            } else {
                IDate iDate = this.swe_revjul(this.jd, bl);
                this.year = iDate.year;
                this.month = iDate.month;
                this.day = iDate.day;
                this.hour = iDate.hour;
            }
        }
    }

    public void updateCalendarType() {
        this.calType = this.jdCO <= this.jd;
    }

    public boolean setDate(int n, int n2, int n3, double d) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setDate(int n, int n2, int n3, double d, boolean bl) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            double d2 = n2;
            double d3 = n3;
            double d4 = d;
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return this.year == n && (double)this.month == d2 && (double)this.day == d3 && Math.abs(this.hour - d4) < 1.0E-6;
        }
        return true;
    }

    public boolean setYear(int n) {
        this.year = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setYear(int n, boolean bl) {
        this.year = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            double d = this.month;
            double d2 = this.day;
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return this.year == n && (double)this.month == d && (double)this.day == d2;
        }
        return true;
    }

    public boolean setMonth(int n) {
        this.month = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setMonth(int n, boolean bl) {
        this.month = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            double d = this.year;
            double d2 = this.day;
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return (double)this.year == d && this.month == n && (double)this.day == d2;
        }
        return true;
    }

    public boolean setDay(int n) {
        this.day = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean setDay(int n, boolean bl) {
        this.day = n;
        this.deltatIsValid = false;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        if (bl) {
            double d = this.year;
            double d2 = this.month;
            IDate iDate = this.swe_revjul(this.jd, this.calType);
            this.year = iDate.year;
            this.month = iDate.month;
            this.day = iDate.day;
            this.hour = iDate.hour;
            return (double)this.year == d && (double)this.month == d2 && this.day == n;
        }
        return true;
    }

    public boolean setHour(double d) {
        this.hour = d;
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
        return true;
    }

    public boolean checkDate() {
        boolean bl = this.checkDate(this.year, this.month, this.day, this.hour);
        return bl;
    }

    public boolean checkDate(int n, int n2, int n3) {
        boolean bl = this.checkDate(n, n2, n3, 0.0);
        return bl;
    }

    public boolean checkDate(int n, int n2, int n3, double d) {
        double d2 = SweDate.swe_julday(n, n2, n3, d, true);
        IDate iDate = this.swe_revjul(d2, true);
        return iDate.year == n && iDate.month == n2 && iDate.day == n3;
    }

    public void makeValidDate() {
        double d = SweDate.swe_julday(this.year, this.month, this.day, this.hour, true);
        IDate iDate = this.swe_revjul(d, true);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    public double getGregorianChange() {
        return this.jdCO;
    }

    public void setGregorianChange(int n, int n2, int n3) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.deltatIsValid = false;
        this.calType = true;
        if (this.year < n || this.year == n && this.month < n2 || this.year == n && this.month == n2 && this.day < n3) {
            this.calType = false;
        }
        this.jdCO = SweDate.swe_julday(n, n2, n3, 0.0, true);
        this.jd = SweDate.swe_julday(this.year, this.month, this.day, this.hour, this.calType);
    }

    public void setGregorianChange(double d) {
        this.jdCO = d;
        this.calType = this.jd >= this.jdCO;
        IDate iDate = this.swe_revjul(this.jd, this.calType);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    public static double getGlobalTidalAcc() {
        return tid_acc;
    }

    static void swe_set_tid_acc(double d) {
        SweDate.setGlobalTidalAcc(d);
    }

    public static void setGlobalTidalAcc(double d) {
        if (d == 999999.0) {
            tid_acc = -25.8;
            is_tid_acc_manual = false;
            return;
        }
        tid_acc = d;
        is_tid_acc_manual = true;
    }

    static void swi_set_tid_acc(double d, int n, int n2) {
        SweDate.setGlobalTidalAcc(d, n, n2);
    }

    static void setGlobalTidalAcc(double d, int n, int n2) {
        double[] dArray = new double[6];
        int n3 = 0;
        if (is_tid_acc_manual) {
            return;
        }
        if (n2 == 0) {
            double d2;
            if ((n & 4) != 0) {
                tid_acc = -25.58;
                return;
            }
            if ((n & 1) != 0) {
                if (SweDate.sw.swed.jpl_file_is_open) {
                    n2 = SweDate.sw.swed.jpldenum;
                } else {
                    d2 = d + SweDate.getDeltaT(d);
                    n = 147505;
                    n3 = sw.swe_calc(d2, 5, n, dArray, null);
                    if (SweDate.sw.swed.jpl_file_is_open && (n3 & 1) != 0) {
                        n2 = SweDate.sw.swed.jpldenum;
                    }
                }
            }
            if (n2 == 0) {
                d2 = d + SweDate.getDeltaT(d);
                if (SweDate.sw.swed.fidat[1].fptr == null || d2 < SweDate.sw.swed.fidat[1].tfstart + 1.0 || d2 > SweDate.sw.swed.fidat[1].tfend - 1.0) {
                    n = 131122;
                    sw.swe_calc(d2, 1, n, dArray, null);
                }
                n2 = SweDate.sw.swed.fidat[1].fptr != null ? SweDate.sw.swed.fidat[1].sweph_denum : 404;
            }
        }
        switch (n2) {
            case 200: {
                tid_acc = -23.8946;
                break;
            }
            case 403: {
                tid_acc = -25.58;
                break;
            }
            case 404: {
                tid_acc = -25.58;
                break;
            }
            case 405: {
                tid_acc = -25.826;
                break;
            }
            case 406: {
                tid_acc = -25.826;
                break;
            }
            case 421: {
                tid_acc = -25.85;
                break;
            }
            case 430: {
                tid_acc = -25.82;
                break;
            }
            case 431: {
                tid_acc = -25.8;
                break;
            }
            default: {
                tid_acc = -25.8;
            }
        }
    }

    protected static void setSwissEphObject(SwissEph swissEph) {
        sw = swissEph;
    }

    public String toString() {
        double d = this.getHour();
        String string = (d < 10.0 ? " " : "") + (int)d + ":";
        d = 60.0 * (d - (double)((int)d));
        string = string + (d < 10.0 ? "0" : "") + (int)d + ":";
        d = 60.0 * (d - (double)((int)d));
        string = string + (d < 10.0 ? "0" : "") + (double)((int)(d * 100.0)) / 100.0;
        return "(YYYY/MM/DD) " + this.getYear() + "/" + (this.getMonth() < 10 ? "0" : "") + this.getMonth() + "/" + (this.getDay() < 10 ? "0" : "") + this.getDay() + ", " + string + "h " + (this.getCalendarType() ? "(greg)" : "(jul)") + "\nJul. Day: " + this.getJulDay() + "; DeltaT: " + this.getDeltaT();
    }

    private static synchronized double swe_julday(int n, int n2, int n3, double d, boolean bl) {
        double d2 = n;
        if (n2 < 3) {
            d2 -= 1.0;
        }
        double d3 = d2 + 4712.0;
        double d4 = (double)n2 + 1.0;
        if (d4 < 4.0) {
            d4 += 12.0;
        }
        double d5 = SMath.floor(d3 * 365.25) + SMath.floor(30.6 * d4 + 1.0E-6) + (double)n3 + d / 24.0 - 63.5;
        if (bl) {
            double d6 = SMath.floor(SMath.abs(d2) / 100.0) - SMath.floor(SMath.abs(d2) / 400.0);
            if (d2 < 0.0) {
                d6 = -d6;
            }
            d5 = d5 - d6 + 2.0;
            if (d2 < 0.0 && d2 / 100.0 == SMath.floor(d2 / 100.0) && d2 / 400.0 != SMath.floor(d2 / 400.0)) {
                d5 -= 1.0;
            }
        }
        return d5;
    }

    private synchronized IDate swe_revjul(double d, boolean bl) {
        IDate iDate = new IDate();
        double d2 = d + 32082.5;
        if (bl) {
            double d3 = d2 + SMath.floor(d2 / 36525.0) - SMath.floor(d2 / 146100.0) - 38.0;
            if (d >= 1830691.5) {
                d3 += 1.0;
            }
            d2 = d2 + SMath.floor(d3 / 36525.0) - SMath.floor(d3 / 146100.0) - 38.0;
        }
        double d4 = SMath.floor(d2 + 123.0);
        double d5 = SMath.floor((d4 - 122.2) / 365.25);
        double d6 = SMath.floor((d4 - SMath.floor(365.25 * d5)) / 30.6001);
        iDate.month = (int)(d6 - 1.0);
        if (iDate.month > 12) {
            iDate.month -= 12;
        }
        iDate.day = (int)(d4 - SMath.floor(365.25 * d5) - SMath.floor(30.6001 * d6));
        iDate.year = (int)(d5 + SMath.floor((d6 - 2.0) / 12.0) - 4800.0);
        iDate.hour = (d - SMath.floor(d + 0.5) + 0.5) * 24.0;
        return iDate;
    }

    private static synchronized double calc_deltaT(double d) {
        double d2 = 0.0;
        int n = SweDate.sw.swed.astro_models[7];
        if (n == 0) {
            n = 1;
        }
        double d3 = 2000.0 + (d - 2451545.0) / 365.25;
        double d4 = 2000.0 + (d - 2451545.0) / 365.2425;
        if (n == 1 && d < 2317746.130902778) {
            return SweDate.deltat_espenak_meeus_1620(d);
        }
        if (d3 < 1620.0) {
            if (d3 < 1600.0) {
                return SweDate.deltat_stephenson_morrison_1600(d);
            }
            if (d3 >= 1600.0) {
                double d5 = 20.0;
                int n2 = 26;
                double d6 = (d3 - 1600.0) / d5;
                d2 = (double)dt2[n2] + d6 * (dt[0] - (double)dt2[n2]);
                d2 = SweDate.adjust_for_tidacc(d2, d4);
                return d2 / 86400.0;
            }
        }
        if (d3 >= 1620.0) {
            return SweDate.deltat_aa(d);
        }
        return d2 / 86400.0;
    }

    private static double deltat_aa(double d) {
        double d2 = 0.0;
        double[] dArray = new double[6];
        double d3 = 2000.0 + (d - 2451545.0) / 365.2425;
        int n = SweDate.init_dt();
        int n2 = 1620 + n - 1;
        if (d3 <= (double)n2) {
            int n3;
            double d4 = SMath.floor(d3);
            int n4 = (int)(d4 - 1620.0);
            d2 = dt[n4];
            int n5 = n4 + 1;
            if (n5 >= n) {
                return SweDate.deltat_aa_label_done(d2, d3);
            }
            d4 = d3 - d4;
            d2 += d4 * (dt[n5] - dt[n4]);
            if (n4 - 1 < 0 || n4 + 2 >= n) {
                return SweDate.deltat_aa_label_done(d2, d3);
            }
            n5 = n4 - 2;
            for (n3 = 0; n3 < 5; ++n3) {
                dArray[n3] = n5 < 0 || n5 + 1 >= n ? 0.0 : dt[n5 + 1] - dt[n5];
                ++n5;
            }
            for (n3 = 0; n3 < 4; ++n3) {
                dArray[n3] = dArray[n3 + 1] - dArray[n3];
            }
            double d5 = 0.25 * d4 * (d4 - 1.0);
            d2 += d5 * (dArray[1] + dArray[2]);
            if (n4 + 2 >= n) {
                return SweDate.deltat_aa_label_done(d2, d3);
            }
            for (n3 = 0; n3 < 3; ++n3) {
                dArray[n3] = dArray[n3 + 1] - dArray[n3];
            }
            d5 = 2.0 * d5 / 3.0;
            d2 += (d4 - 0.5) * d5 * dArray[1];
            if (n4 - 2 < 0 || n4 + 3 > n) {
                return SweDate.deltat_aa_label_done(d2, d3);
            }
            for (n3 = 0; n3 < 2; ++n3) {
                dArray[n3] = dArray[n3 + 1] - dArray[n3];
            }
            d5 = 0.125 * d5 * (d4 + 1.0) * (d4 - 2.0);
            return SweDate.deltat_aa_label_done(d2 += d5 * (dArray[0] + dArray[1]), d3);
        }
        double d6 = 0.01 * (d3 - 1820.0);
        d2 = -20.0 + 31.0 * d6 * d6;
        if (d3 <= (double)(n2 + 100)) {
            double d7 = 0.01 * (double)(n2 - 1820);
            double d8 = -20.0 + 31.0 * d7 * d7;
            double d9 = dt[n - 1];
            double d10 = d8 - d9;
            d2 += d10 * (d3 - (double)(n2 + 100)) * 0.01;
        }
        return d2 / 86400.0;
    }

    private static double deltat_longterm_morrison_stephenson(double d) {
        double d2 = 2000.0 + (d - 2451545.0) / 365.2425;
        double d3 = (d2 - 1820.0) / 100.0;
        return -20.0 + 32.0 * d3 * d3;
    }

    private static double deltat_stephenson_morrison_1600(double d) {
        double d2;
        double d3 = 0.0;
        double d4 = 2000.0 + (d - 2451545.0) / 365.2425;
        if (d4 < -1000.0) {
            d3 = SweDate.deltat_longterm_morrison_stephenson(d);
            d3 = SweDate.adjust_for_tidacc(d3, d4);
            if (d4 >= -1100.0) {
                double d5 = SweDate.adjust_for_tidacc(dt2[0], -1000.0);
                double d6 = 1355817.5;
                double d7 = SweDate.deltat_longterm_morrison_stephenson(d6);
                d7 = SweDate.adjust_for_tidacc(d7, d4);
                d2 = d7 - d5;
                double d8 = (d4 - -1100.0) * 0.01;
                d3 -= d2 * d8;
            }
        }
        if (d4 >= -1000.0 && d4 < 1600.0) {
            double d9 = 2000.0 + (d - 2451557.5) / 365.25;
            double d10 = SMath.floor(d9);
            int n = (int)((d10 - -1000.0) / 100.0);
            d2 = (d9 - (double)(-1000 + 100 * n)) / 100.0;
            d3 = (double)dt2[n] + (double)(dt2[n + 1] - dt2[n]) * d2;
            d3 = SweDate.adjust_for_tidacc(d3, d4);
        }
        return d3 /= 86400.0;
    }

    private static double deltat_espenak_meeus_1620(double d) {
        double d2 = 0.0;
        double d3 = 2000.0 + (d - 2451545.0) / 365.2425;
        if (d3 < -500.0) {
            d2 = SweDate.deltat_longterm_morrison_stephenson(d);
        } else if (d3 < 500.0) {
            double d4 = d3 / 100.0;
            d2 = (((((0.0090316521 * d4 + 0.022174192) * d4 - 0.1798452) * d4 - 5.952053) * d4 + 33.78311) * d4 - 1014.41) * d4 + 10583.6;
        } else if (d3 < 1600.0) {
            double d5 = (d3 - 1000.0) / 100.0;
            d2 = (((((0.0083572073 * d5 - 0.005050998) * d5 - 0.8503463) * d5 + 0.319781) * d5 + 71.23472) * d5 - 556.01) * d5 + 1574.2;
        } else if (d3 < 1700.0) {
            double d6 = d3 - 1600.0;
            d2 = 120.0 - 0.9808 * d6 - 0.01532 * d6 * d6 + d6 * d6 * d6 / 7129.0;
        } else if (d3 < 1800.0) {
            double d7 = d3 - 1700.0;
            d2 = (((-d7 / 1174000.0 + 1.3336E-4) * d7 - 0.0059285) * d7 + 0.1603) * d7 + 8.83;
        } else if (d3 < 1860.0) {
            double d8 = d3 - 1800.0;
            d2 = ((((((8.75E-10 * d8 - 1.699E-7) * d8 + 1.21272E-5) * d8 - 3.7436E-4) * d8 + 0.0041116) * d8 + 0.0068612) * d8 - 0.332447) * d8 + 13.72;
        } else if (d3 < 1900.0) {
            double d9 = d3 - 1860.0;
            d2 = ((((d9 / 233174.0 - 4.473624E-4) * d9 + 0.01680668) * d9 - 0.251754) * d9 + 0.5737) * d9 + 7.62;
        } else if (d3 < 1920.0) {
            double d10 = d3 - 1900.0;
            d2 = (((-1.97E-4 * d10 + 0.0061966) * d10 - 0.0598939) * d10 + 1.494119) * d10 - 2.79;
        } else if (d3 < 1941.0) {
            double d11 = d3 - 1920.0;
            d2 = 21.2 + 0.84493 * d11 - 0.0761 * d11 * d11 + 0.0020936 * d11 * d11 * d11;
        } else if (d3 < 1961.0) {
            double d12 = d3 - 1950.0;
            d2 = 29.07 + 0.407 * d12 - d12 * d12 / 233.0 + d12 * d12 * d12 / 2547.0;
        } else if (d3 < 1986.0) {
            double d13 = d3 - 1975.0;
            d2 = 45.45 + 1.067 * d13 - d13 * d13 / 260.0 - d13 * d13 * d13 / 718.0;
        } else if (d3 < 2005.0) {
            double d14 = d3 - 2000.0;
            d2 = ((((2.373599E-5 * d14 + 6.51814E-4) * d14 + 0.0017275) * d14 - 0.060374) * d14 + 0.3345) * d14 + 63.86;
        }
        d2 = SweDate.adjust_for_tidacc(d2, d3);
        return d2 /= 86400.0;
    }

    private static synchronized double deltat_aa_label_done(double d, double d2) {
        d = SweDate.adjust_for_tidacc(d, d2);
        return d / 86400.0;
    }

    private static int init_dt() {
        FilePtr filePtr = null;
        if (!init_dt_done) {
            init_dt_done = true;
            try {
                filePtr = sw.swi_fopen(-1, "swe_deltat.txt", SweDate.sw.swed.ephepath, null);
                if (filePtr == null && (filePtr = sw.swi_fopen(-1, "sedeltat.txt", SweDate.sw.swed.ephepath, null)) == null) {
                    return 400;
                }
            }
            catch (SwissephException swissephException) {
                try {
                    filePtr = sw.swi_fopen(-1, "sedeltat.txt", SweDate.sw.swed.ephepath, null);
                    if (filePtr == null) {
                        return 400;
                    }
                }
                catch (SwissephException swissephException2) {
                    return 400;
                }
            }
            try {
                String string;
                while ((string = filePtr.readLine()) != null) {
                    int n;
                    int n2;
                    string.trim();
                    if (string.length() == 0 || string.charAt(0) == '#' || (n2 = (n = SwissLib.atoi(string)) - 1620) >= 500) continue;
                    if (string.length() > 4) {
                        string = string.substring(4).trim();
                    }
                    SweDate.dt[n2] = (short)SwissLib.atof(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                filePtr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int n = 382;
        for (int i = n - 1; i < 500 && dt[i] != 0.0; ++i) {
            ++n;
        }
        return --n;
    }

    private static double adjust_for_tidacc(double d, double d2) {
        if (d2 < 1955.0) {
            double d3 = d2 - 1955.0;
            d += -9.1E-5 * (tid_acc + 26.0) * d3 * d3;
        }
        return d;
    }

    private void initDateFromJD(double d, boolean bl) {
        this.jd = d;
        this.calType = bl;
        IDate iDate = this.swe_revjul(d, bl);
        this.year = iDate.year;
        this.month = iDate.month;
        this.day = iDate.day;
        this.hour = iDate.hour;
    }

    private void setFields(int n, int n2, int n3, double d) {
        IDate iDate = this.swe_revjul(this.jdCO, true);
        boolean bl = true;
        if (iDate.year > n || iDate.year == n && iDate.month > n2 || iDate.year == n && iDate.month == n2 && iDate.day > n3) {
            bl = false;
        }
        this.setFields(n, n2, n3, d, bl);
    }

    private void setFields(int n, int n2, int n3, double d, boolean bl) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = d;
        this.calType = bl;
        this.jd = SweDate.swe_julday(n, n2, n3, d, bl);
    }

    public SDate getUTCFromLocalTime(int n, int n2, int n3, int n4, int n5, double d, double d2) {
        return this.getLocalTimeFromUTC(n, n2, n3, n4, n5, d, -d2);
    }

    public SDate getLocalTimeFromUTC(int n, int n2, int n3, int n4, int n5, double d, double d2) {
        boolean bl = false;
        if (d >= 60.0) {
            bl = true;
            d -= 1.0;
        }
        double d3 = (double)n4 + (double)n5 / 60.0 + d / 3600.0;
        double d4 = SweDate.swe_julday(n, n2, n3, 0.0, true);
        if ((d3 -= d2) < 0.0) {
            d4 -= 1.0;
            d3 += 24.0;
        }
        if (d3 >= 24.0) {
            d4 += 1.0;
            d3 -= 24.0;
        }
        IDate iDate = this.swe_revjul(d4 + 0.001, true);
        int n6 = iDate.year;
        int n7 = iDate.month;
        int n8 = iDate.day;
        int n9 = (int)d3;
        double d5 = (d3 - (double)n9) * 60.0;
        int n10 = (int)d5;
        double d6 = (d5 - (double)n10) * 60.0;
        if (bl) {
            d6 += 1.0;
        }
        return new SDate(n6, n7, n8, n9, n10, d6);
    }

    private int init_leapsec() {
        FilePtr filePtr = null;
        int n = 0;
        if (!this.init_leapseconds_done) {
            this.init_leapseconds_done = true;
            n = 26;
            int n2 = leap_seconds[25];
            try {
                String string;
                filePtr = sw.swi_fopen(-1, "seleapsec.txt", SweDate.sw.swed.ephepath, null);
                if (filePtr == null) {
                    return 26;
                }
                while ((string = filePtr.readLine()) != null) {
                    int n3;
                    string.trim();
                    if (string.startsWith("#") || string.length() == 0 || (n3 = SwissLib.atoi(string)) <= n2) continue;
                    if (n >= 100) {
                        return n;
                    }
                    SweDate.leap_seconds[n] = n3;
                    ++n;
                }
                if (n > 26) {
                    SweDate.leap_seconds[n] = 0;
                }
                filePtr.close();
            }
            catch (IOException iOException) {
            }
            catch (SwissephException swissephException) {
                return n;
            }
            try {
                filePtr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return n;
        }
        n = 0;
        for (int i = 0; i < 100 && leap_seconds[i] != 0; ++i) {
            ++n;
        }
        return n;
    }

    public boolean isValidUTCDate(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        return this.getInvalidUTCDateError(n, n2, n3, n4, n5, d, bl) == null;
    }

    public String getInvalidUTCDateError(int n, int n2, int n3, int n4, int n5, double d, boolean bl) {
        double[] dArray = new double[2];
        double d2 = SweDate.swe_julday(n, n2, n3, 0.0, bl);
        IDate iDate = this.swe_revjul(d2, bl);
        if (n != iDate.year || n2 != iDate.month || n3 != iDate.day) {
            return "invalid date: year = " + n + ", month = " + n2 + ", day = " + n + n3;
        }
        if (n4 < 0 || n4 > 23 || n5 < 0 || n5 > 59 || d < 0.0 || d >= 61.0 || d >= 60.0 && (n5 < 59 || n4 < 23 || d2 < 2441317.5)) {
            return "invalid time: " + n4 + ":" + n5 + ":" + d;
        }
        int n6 = this.init_leapsec();
        int n7 = n * 10000 + n2 * 100 + n3;
        if (d >= 60.0) {
            boolean bl2 = false;
            for (int i = 0; i < n6; ++i) {
                if (n7 != leap_seconds[i]) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                return "invalid time (no leap second!): " + n4 + ":" + n5 + ":" + d;
            }
        }
        return null;
    }

    public double[] getJDfromUTC(int n, int n2, int n3, int n4, int n5, double d, boolean bl, boolean bl2) throws SwissephException {
        Object object;
        double[] dArray = new double[2];
        if (bl2 && (object = this.getInvalidUTCDateError(n, n2, n3, n4, n5, d, bl)) != null) {
            double d2 = SweDate.swe_julday(n, n2, n3, (double)n4 + (double)n5 / 60.0 + d / 3600.0, bl);
            throw new SwissephException(d2, 17408, (String)object);
        }
        double d3 = SweDate.swe_julday(n, n2, n3, 0.0, bl);
        double d4 = (double)n4 + (double)n5 / 60.0 + d / 3600.0;
        if (d3 < 2441317.5) {
            dArray[1] = SweDate.swe_julday(n, n2, n3, d4, bl);
            dArray[0] = dArray[1] + SweDate.getDeltaT(dArray[1]);
            return dArray;
        }
        if (!bl) {
            bl = true;
            object = this.swe_revjul(d3, bl);
        }
        int n6 = this.init_leapsec();
        int n7 = 10;
        int n8 = n * 10000 + n2 * 100 + n3;
        for (int i = 0; i < n6 && n8 > leap_seconds[i]; ++i) {
            ++n7;
        }
        double d5 = SweDate.getDeltaT(d3) * 86400.0;
        if (d5 - (double)n7 - 32.184 >= 1.0) {
            dArray[1] = d3 + d4 / 24.0;
            dArray[0] = dArray[1] + SweDate.getDeltaT(dArray[1]);
            return dArray;
        }
        d5 = d3 - 2441317.5;
        double d6 = 2441317.5004882407;
        double d7 = d6 + (d5 += (double)n4 / 24.0 + (double)n5 / 1440.0 + d / 86400.0) + (double)(n7 - 10) / 86400.0;
        d5 = SweDate.getDeltaT(d7);
        d3 = d7 - SweDate.getDeltaT(d7 - d5);
        d3 = d7 - SweDate.getDeltaT(d3);
        dArray[0] = d7;
        dArray[1] = d3;
        return dArray;
    }

    public SDate getUTCfromJDET(double d, boolean bl) {
        double d2;
        int n;
        boolean bl2 = false;
        double[] dArray = new double[10];
        double d3 = 2441317.5004882407;
        double d4 = SweDate.getDeltaT(d);
        double d5 = d - SweDate.getDeltaT(d - d4);
        d5 = d - SweDate.getDeltaT(d5);
        if (d < d3) {
            IDate iDate = this.swe_revjul(d5, bl);
            return new SDate(iDate.year, iDate.month, iDate.day, iDate.hour);
        }
        int n2 = this.init_leapsec();
        IDate iDate = this.swe_revjul(d5 - 1.0, true);
        int n3 = iDate.year;
        int n4 = iDate.month;
        int n5 = iDate.day;
        d4 = iDate.hour;
        int n6 = n3 * 10000 + n4 * 100 + n5;
        int n7 = 0;
        for (n = 0; n < n2 && n6 > leap_seconds[n]; ++n) {
            ++n7;
        }
        if (n7 < n2) {
            n = leap_seconds[n7];
            n3 = n / 10000;
            n4 = n % 10000 / 100;
            n5 = n % 100;
            d2 = SweDate.swe_julday(n3, n4, n5, 0.0, true);
            iDate = this.swe_revjul(d5 + 1.0, true);
            n3 = iDate.year;
            n4 = iDate.month;
            n5 = iDate.day;
            d4 = iDate.hour;
            dArray = this.getJDfromUTC(n3, n4, n5, 0, 0, 0.0, true, false);
            d4 = d - dArray[0];
            if (d4 >= 0.0) {
                ++n7;
            } else if (d4 < 0.0 && d4 > -1.1574074074074073E-5) {
                bl2 = true;
            }
        }
        d2 = 2441317.5 + (d - d3) - ((double)n7 + (double)bl2) / 86400.0;
        iDate = this.swe_revjul(d2, true);
        int n8 = iDate.year;
        int n9 = iDate.month;
        int n10 = iDate.day;
        d4 = iDate.hour;
        int n11 = (int)d4;
        d4 -= (double)n11;
        int n12 = (int)(d4 *= 60.0);
        double d6 = (d4 - (double)n12) * 60.0 + (double)bl2;
        d4 = SweDate.getDeltaT(d);
        if ((d4 = SweDate.getDeltaT(d - d4)) * 86400.0 - (double)(n7 + 10) - 32.184 >= 1.0) {
            iDate = this.swe_revjul(d - d4, true);
            n8 = iDate.year;
            n9 = iDate.month;
            n10 = iDate.day;
            d4 = iDate.hour;
            n11 = (int)d4;
            d4 -= (double)n11;
            n12 = (int)(d4 *= 60.0);
            d6 = (d4 - (double)n12) * 60.0;
        }
        if (!bl) {
            d2 = SweDate.swe_julday(n8, n9, n10, 0.0, true);
            iDate = this.swe_revjul(d2, true);
            return new SDate(iDate.year, iDate.month, iDate.day, iDate.hour);
        }
        return new SDate(n8, n9, n10, n11, n12, d6);
    }

    public SDate getUTCfromJDUT1(double d, boolean bl) {
        double d2 = d + SweDate.getDeltaT(d);
        return this.getUTCfromJDET(d2, bl);
    }

    public LocalDateTime getLocalDateTime() {
        return SweDate.getLocalDateTime(this);
    }

    public static LocalDateTime getLocalDateTime(SweDate sweDate) {
        double d = sweDate.getHour();
        double d2 = d % 1.0 * 60.0;
        double d3 = d2 % 1.0 * 60.0;
        double d4 = d3 % 1.0 * 1000000.0;
        return LocalDateTime.of(sweDate.getYear(), sweDate.getMonth(), sweDate.getDay(), (int)d, (int)d2, (int)d3, (int)d4);
    }
}

