/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import swisseph.Extlib;
import swisseph.SMath;
import swisseph.SweDate;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;
import swisseph.SwissephException;
import swisseph.TCHouses;
import swisseph.TCPlanet;
import swisseph.TCPlanetHouse;
import swisseph.TCPlanetPlanet;
import swisseph.TransitCalculator;

public class Transits
implements Serializable {
    static final double MIN_TIME_DIFF = 5.787037037037037E-6;
    static final String infocmd0 = "\n  'Transits' computes planetary transits over specified longitudes,\n  latitudes, distances, speeds in any of these directions or\n  in any above variation over other planets.\n\n";
    static final String infocmd1 = "\n  You can calculate several kinds of transits:\n\n    - When do planets transit a certain longitude,\n      latitude or distance:\n         -p.. -b... -lon... [other options]\n         -p.. -b... -lat... [other options]\n         -p.. -b... -dist... [other options]\n    - When do planets transit a certain speed in\n      longitude, latitude or distance:\n         -p.. -b... -s -lon... [other options]\n         -p.. -b... -s -lat... [other options]\n         -p.. -b... -s -dist... [other options]\n    - When do planets transit other planet's\n      longitude, latitude or distance (or speed with -s):\n         -p.. -P.. -b... -lon... [other options])\n         -p.. -P.. -b... -lat... [other options])\n         -p.. -P.. -b... -dist... [other options])\n    - When does the SUM (==Yoga) of two planet's positions\n      (or speeds with -s option) reach a certain value:\n         -p.. -P.. -b... +lon... [other options])\n         -p.. -P.. -b... +lat... [other options])\n         -p.. -P.. -b... +dist... [other options])\n    - When do house objects (house cusps, ascendant\n      et. al.) transit a certain longitude:\n         -o.. -b... -lon... [other options]\n    - When do house objects transit other planet's\n      longitude or vice versa:\n         -p.. -O.. -b... -lon... [other options])\n         -o.. -P.. -b... -lon... [other options])\n    - When do two planets have partile aspects to each other:\n         -p.. -P.. -b... -partile... [other options])\n    - When do two planets lose partile aspect status\n      to each other:\n         -p.. -P.. -b... -nonpartile... [other options])\n    - When do two planet change their partile aspect status\n      to each other:\n         -p.. -P.. -b... +partile... [other options])\n\n    Other options:\n    - List a fixed number of consecutive transits:\n         [base options] -n...\n         [base options] -N...\n    - List all transits in a date range by giving a second date:\n         [base options] -b... -b...\n         [base options] -b... -B...\n    - Give an exact starting and / or end time:\n         [base options] -et... (or: -t...)\n         [base options] -ut...\n         [base options] -lt...\n         [base options] -ET... (or: -T...)\n         [base options] -UT...\n         [base options] -LT...\n    - Search backwards (\"reverse\"):\n         [base options] -r\n    - Calculate in the sidereal zodiac:\n         [base options] -sid.\n    - Calculate true positions instead of apparent positions:\n         [base options] -true.\n    - Calculate topocentric or heliocentric instead of geocentric:\n         [base options] -topo...\n         [base options] -hel...\n    - Calculate rectascension or declination instead of longitude or latitude:\n         [base options] -equ...\n    - Modify the input parsing:\n         [base options] -loc... (input parsing AND output formatting)\n         [base options] -iloc...\n         [base options] -Dloc[...]\n         [base options] -Nloc[...]\n    - Modify the output and output formatting:\n         [base options] -head, -q\n         [base options] -f...\n         [base options] -loc... (input parsing AND output formatting)\n         [base options] -oloc...\n         [base options] -dloc[...]\n         [base options] -nloc[...]\n    - Modify calculation precision:\n         [base options] -rf...\n    - Give the path to the ephemeris data files:\n         [base options] -edir...\n    - List all availables Locales for use with -loc etc. options:\n         -locales\n    - Convert between Julian day numbers and dates and vice versa:\n         -b... -cv [other options]\n";
    static final String infodate = "\n  Date entry:\n  You can enter the start date entry (option '-b') and the end date\n  entry (if required, option '-b' or '-B') in one of the following formats:\n\n        2-27-1991       three integers separated by a nondigit character for\n                        day month year. Dates are interpreted as Gregorian\n                        after October 4, 1582 and as Julian Calender before.\n                        Time is always set to midnight. Use -et, -ut or -lt\n                        to set the time.\n                        The sequence of year, month and day is determined\n                        by the locale settings, see options -loc etc.. With\n                        -locde 5.8.2000 would be interpreted as a date in\n                        August 2000, -locen would see a date in May 2000.\n                        Use -et / -ut / -lt without any following time to\n                        force times to be interpreted as ET (-et), UT (-ut)\n                        or local time (LT, -lt). Default ist ET.\n                        If the three letters 'jul' are appended to the date,\n                        the Julian calendar is used even after 1582.\n                        If the four letters 'greg' are appended to the date,\n                        the Gregorian calendar is used even before 1582.\n\n        j2400123.67     the letter j followed by a real number, for\n                        the absolute Julian daynumber of the start date.\n                        Fraction .5 indicates midnight, fraction .0\n                        indicates noon, other times of the day can be\n                        chosen accordingly.\n        today           this will use the current date.\n  You can enter any time entry (options -et / -ET / -ut / -UT / -lt / -LT)\n  in the following formats:\n        hh:mm:ss        three integers representing hour, minutes and\n                        seconds separated by non-digits\n        now             (String) use current time.\n";
    String infocmd2 = null;
    String infoexamples = null;
    SwissEph sw = new SwissEph();
    SwissLib sl = new SwissLib();
    Extlib el = new Extlib();
    SwissData swed = new SwissData();
    Locale[] locs = Locale.getAvailableLocales();
    String locale = null;
    String Nlocale = null;
    String Dlocale = null;
    String nlocale = null;
    String dlocale = null;
    boolean force24hSystem = false;
    String dateFracSeparator = ".";
    String numIFracSeparator = ".";
    String numOFracSeparator = ".";
    SimpleDateFormat dif = null;
    SimpleDateFormat dof = null;
    NumberFormat dnof = null;
    NumberFormat nnif = null;
    NumberFormat nnof = null;
    int secondsIdx = 0;
    double tzOffset = 0.0;
    int randomCount = 0;
    double randomFactor = 0.0;

    private void initHelpTexts() {
        this.infocmd2 = "\n  Command line options:\n    Main options:\n        -bDATE    use this date; use format -b3/24/1993 or -bj2400000.5,\n                  to express the date as absolute Julian day number.\n                  Use option -hdate for more information.\n                  You can use two -b... options to give a starting and\n                  an end date.\n                  NOTE: the date format is year/month/day by default.\n        -j....    Same as -bj....\n        -BDATE    use this date as the end date for a time range, use\n                  -Bj..... for a julian day number\n                  Same as a second -b... option, but it searches for\n                  transits over ANY of the adjacent transit points instead\n                  of looking for the NEXT transit point only, when giving\n                  more than one longitude etc.. See the -n / -N options\n                  for similar considerations.\n        -J....    Same as -Bj....\n        -uthh:mm:ss hour in UT for -b... date\n        -UThh:mm:ss hour in UT for -B... date. If -UT is not given, it\n                    defaults to the value of -ut\n                    You can use the String 'now' for the current UTC time.\n        -ethh:mm:ss hour in ET for -b... date, it defaults to 0.0\n        -EThh:mm:ss hour in ET for -B... date. Default: the value of -et\n        -lthh:mm:ss hour in local time in the timezone as it is setup on\n                    your computer for -b... date.\n        -LThh:mm:ss hour in local time in the timezone as it is setup on\n                    your computer for -B... date. Defaults to time of -lt\n                    Be aware that the local time offset will be constant\n                    for all times being output. E.g.: when daylight\n                    saving time is in effect NOW but not on the transit\n                    time, the output time will appear to be incorrect by\n                    the daylight saving offset.\n        -utnow (etc.): The String 'now' uses the current time.\n        -p.\n        -p...     One or more planets for which to calculate the transit.\n                  Supported planet numbers are:\n                    0 Sun        8 Neptune            D Chiron\n                    1 Moon       9 Pluto              E Pholus\n                    2 Mercury    m Mean node          F Ceres\n                    3 Venus      t True node          G Pallas\n                    4 Mars       A mean lunar apogee  H Juno\n                    5 Jupiter      (Lilith)           I Vesta\n                    6 Saturn     B osculating lunar   c Interpolated lunar apogee\n                    7 Uranus       apogee             g Interpolated lunar perigee\n                  To calculate other minor planets, use -p/.../, e.g., -p/3633/ to\n                  find a transit of the asteroid 3633 (Mira).\n                  You may combine /.../ notation with other planets, e.g.\n                  -p4/27//3633/8 to find any transit over Mars, Neptune, or\n                  asteroids 27 or 3633.\n                  ATTENTION: calculating other planets than the 22 planets above\n                  is still in beta status and may be much slower, as first I'm\n                  calculating some (about 100 or 200) random speed values to get an\n                  idea of the speed of the object before trying to find the transit.\n        -P.\n        -P...     Calculate transits relative to this or these planets.\n                  When giving more than one planet here, it will calculate\n                  the next or previous transit(s) over any of these\n                  planets.\n        -o.\n        -o...     (Small letter o) One or more of the house cusps or ascendants.\n                  Separate multiple objects by slash or comma (e.g. -oasc,mc/house7).\n                  Supported objects are:\n                    house1\n                    ...\n                    house12\n                    asc         (ascendant)\n                    mc          (MC)\n                    armc        (sidereal time)\n                    vertex      (vertex)\n                    equasc      (equatorial ascendant)\n                    coasc1      (co-ascendant, method Walter Koch)\n                    coasc2      (co-ascendant, method Michael Munkasey)\n                    polasc      (polar ascendant of Michael Munkasey)\n                    -o / -O require parameter -house.\n        -O.\n        -O...     (Capital letter O) Calculate transits relative to this or these\n                  house objects. See option -o for more information. When giving\n                  more than one house object here, it will calculate the next or\n                  previous transit(s) over any of these objects.\n        -house[long,lat,hsys]\n                  If using option -o / -O, you have to specify a location\n                  and a house system. Longitude and latitude are given as\n                  degrees with decimal fraction; house system is one of the\n                  following characters:\n                    B       (Alcabitius)\n                    C       (Campanus)\n                    E       (Equal)\n                    H       (Horizontal)\n                    K       (Koch)\n                    M       (Morinus)\n                    O       (Porphyrius)\n                    P       (Placidus)\n                    R       (Regiomontanus)\n                    T       (Polich/Page)\n                    U       (Krusinski-Pisa-Goelzer)\n                    V       (Equal Vehlow)\n                    W       (Equal, whole sign houses)\n                    X       (Axial rotation system/Meridian houses)\n                  Use any non digit character to separate the single fields.\n        -lon...   longitude or longitudinal speed, over which the transit\n                  has to occur. If two planets are given, this means the\n                  position (or speed) of planet -px after planet -Px\n        -lat...   latitude or latitudinal speed, over which the transit\n                  has to occur. If two planets are given, this means the\n                  position (or speed) of planet -px after planet -Px\n        -dist...  distance or speed in distance movement in AU, over which\n                  the transit has to occur. If two planets are given, this\n                  means the distance position (or speed) of planet -px\n                  after planet -Py\n        +lon...   same as -lon for transits of one planet over another\n                  planet with the difference that the SUM (Yoga) of the\n                  positions or speeds of both planets will be calculated\n        +lat...   same as -lat for transits of one planet over another\n                  planet with the difference that the SUM (Yoga) of the\n                  positions or speeds of both planets will be calculated\n        +dist...  same as -dist for transits of one planet over another\n                  planet with the difference that the SUM (Yoga) of the\n                  positions or speeds of both planets will be calculated\n        -partile...\n                  calculate next partile transit which is the next time, when\n                  the two planets change to an identical integer value\n                  of their respective longitudinal 30 degree subsection (== sign):\n                  (int)(lon1%30) +- (int)offset == (int)(lon2%30)\n        -nonpartile...\n                  calculate, when two planets lose partile aspect status\n                  next time. See -partile\n                  (int)(lon1%30) + (int)offset != (int)(lon2%30)\n                  See -partile.\n        +partile...  calculate next status change in partile aspects between\n                  two planets. See -partile for the definition of a partile\n                  aspect.\n        -lon, -lat, -dist, +lon, +lat, +dist can all take a  form that\n                  increases the given value on each iteration by an offset.\n                  Alternatively, you can give multiple values separated by\n                  a forward slash (\"/\").\n                  The correct syntax is:\n                  {\"-\"|\"+\"}{\"lon\"|\"lat\"|\"dist\"}STARTVAL[\"+\"|\"-\"OFFSET]\n                  or:\n                  {\"-\"|\"+\"}{\"lon\"|\"lat\"|\"dist\"}VAL[\"/\"VAL]\n                  STARTVAL, OFFSET and VAL are normal floating point numbers.\n                  Use with option -n / -N or with -b -b / -b -B. Example:\n                  -lon0+30.0 -n12\n                  searches for 12 consecutive transits with the degree\n                  changing from one step to the other by 30 degrees.\n                  -lat0/0.1/-0.1 -b1-1-2005 -B1-1-2006\n                  searches for any transits over 0, 0.1 and -0.1\n                  latitudinal degree in the year 2005.\n        -s        Calculate the transit over a given speed instead of\n                  a given position\n\n    Additional options:\n        -r        search backward\n        -topo[long,lat,elev]\n                  Calculate related to a position on the surface of the\n                  earth, default is geocentric calculation. Longitude,\n                  latitude (degrees with decimal fraction) and elevation\n                  (meters) are optional. Default is Z\u00fcrich: 8.55;47.38;400\n                  Use any non digit character to separate the single fields.\n        -hel\n        -helio    Perform heliocentric calculations instead of geocentric\n        -equ\n        -equatorial Calculate rectascension (with -lon) or declination (with\n                  -lat option). Ignored when used together with -dist.\n        -sid.     a sidereal mode, if sidereal calculation is wanted.\n                  Valid modes are:\n                     0 Fagan/Bradley           10 Babylonian, Kugler2\n                     1 Lahiri                  11 Babylonian, Kugler3\n                     2 DeLuce                  12 Babylonian, Huber\n                     3 Raman                   13 Babylonian, Mercier\n                     4 Ushashashi              14 t0=Aldebaran, 15" + this.swed.ODEGREE_STRING + " taurus\n                     5 Krishnamurti            15 Hipparchos\n                     6 Djwhal Khul             16 Sassanian\n                     7 Sri Yukteshwar          17 Galactic center=0" + this.swed.ODEGREE_STRING + " sagitt.\n                     8 JN Bhasin               18 J2000\n                     9 Babylonian, Kugler1     19 J1900\n                                               20 B1950\n        -true     calculate true positions, this is, positions of the planet(s)\n                  at that time, when the light STARTS travelling to the earth.\n        -n...     search for <n> transits instead of just one. If you want\n                  all transits in a time range, use option -B... to give a\n                  second date\n        -N...     search for <N> transits instead of just one. Differently\n                  to the -n option, this searches for the next OR(!) the\n                  same OR(!) the previous transit position value, when you\n                  give an increment value to the -lon etc. options. This\n                  is useful ONLY, when a planet can move both direct and\n                  retrograde, so you will not miss any transit point.\n                  ATTENTION: the first transit will be calculated for the first\n                  value given ONLY.\n                  Notice the difference between the two commands:\n                    java Transits -p5 -b01/01/2012 -lon60+10 -n6 -oloc24\n                    java Transits -p5 -b01/01/2012 -lon60+10 -N6 -oloc24\n        -random_factors...\n        -rf...    When no extreme speeds of a planet or object are available\n                  those speeds will be estimated by 200 random speed calculations\n                  and then mulitplied by a factor of 1.4.\n                  This is mostly true for asteroids, but in some other cases\n                  as well like topocentric planets with a height of more than\n                  50,000 km or the like.\n                  Ignored, when extreme speeds are available.\n\n                  Use -rf<count>/<factor> to override the default, e.g.\n                    -rf1000/1.3\n\n                  This is necessary, as we need to have an idea of how fast\n                  and slow the object may move, when calculating transits.\n                  Increasing the count will give more exact results, but\n                  it will increase startup time.\n                  Increasing the 'safety factor' will slow down each single\n                  calculation. Decreasing the factor will increase the\n                  chance of missed transits or unprecise dates.\n        -f...     Output format options, default is -fdt or -fvdt, if we\n                  calculate consecutive transits with changing degrees.\n        -f+...    Same as -f, but append the following options to the\n                  default options instead of replacing them all.\n                  Available options:\n          n         The name of the planet(s).\n          d, d..    Output transit date and time with a given number of\n                    decimal places in the seconds part.\n                    'd5' might give you a time output like 20:26:46.80099,\n                    'd' (or 'd0') will result in 20:26:47\n                    All date output is localized to the 'iso' locale (YYYY-MM-DD)\n                    if not specified differently by the -loc etc. options.\n          t         Postfix the dates with 'ET' (Ephemeris Time) or 'UT'\n                    (Universal Time) as appropriate.\n          j, j..    Output transit date and time as julian day numbers with\n                    the given numbers of decimal places. Saying 'j' is\n                    identical to saying 'j8': 8 decimal places.\n          v, v..    Output the transit degree or distance or speed value\n                    with the given number of decimal places. 'v' is equal\n                    to 'v2'\n          p, p..    Output the actual position (or speed) on the found date\n                    with the given number of decimal places. 'p' is equal\n                    to 'p8', which means, eight decimal places.\n                 Only when calculating relative transits:\n          P, P..    (Capital P) adds the real difference or sum (for yoga\n                    transits) of the planets positions to the output. 'P'\n                    means 'P8', which means, output the number with eight\n                    decimal places.\n\n  Localization (internationalization):\n  ====================================\n  Input parsing and output formatting of numbers is done using the 'en_US'\n  locale, dates are parsed and output in 'ISO' style (YYYY-MM-DD).\n  Localization knows about two different fields: numbers and dates. You\n  can give both localization information for input parsing and output\n  formatting. The default is 'iso' (YYYY-MM-DD), you can change it to\n  your current system locale by giving the option -loc without any locale\n  string added.\n  The -loc option will change all patterns at the same time, all other\n  options will just care for some aspects.\n    -loc  is for input parsing and output formatting of numbers and dates\n\n    -iloc is for input parsing of numbers and dates\n    -oloc is for output formatting of numbers and dates\n\n    -Dloc is for input parsing of dates only\n    -Nloc is for input parsing of numbers only\n    -dloc is for output formatting of dates only\n    -nloc is for output formatting of numbers like degrees or speed or JD\n\n    The locale parameter without any locale string added to it (-loc /\n    -iloc / -oloc etc.pp.) will use the default system locale. Add the\n    locale String to use a specific locale, e.g. -dlocro for romanian\n    date output formatting or -olochi_IN to use the indian hindi style\n    in output. Use -locswiss to revert to the default behaviour of\n    Swetest.java and the original C versions of swiss ephemeris, which\n    is a short form for -locen_US -Dlocde -dlocde.\n\n    You can append '24' to -loc etc., to use 24 hours date formats on\n    output, even when the localization would use AM/PM formats. E.g.:\n    -loc24hi_IN (24 hour time format in Hindi) or: -loc24 or -loc24en\n    ATTENTION: input parsing of time is ALWAYS done in the 24 hour format\n    hh:mm:ss only!\n    -locales  List all available locales. Does not compute anything.\n\n  Other options:\n  ==============\n        -ejpl...  calculate with JPL ephemeris. Append filename of JPL\n                  data file. If the filename is not appended, the\n                  default SweConst.SE_FNAME_DE406 (de406.eph) is used.\n        -eswe     calculate with swiss ephemeris\n        -emos     calculate with moshier ephemeris\n        -edirPATH change the directory of the ephemeris data files \n        -q\n        -head     don't print the header before the planet data\n\n    Output of informations only:\n        -locales  List all available locales. Does not compute anything.\n\n        -b... -cv Convert between julian day numbers and dates back and\n                  forth and exit. Does not compute anything. May be\n                  combined with -ut / -et option. Default is ET. See\n                  option -hdate for info about the possible date\n                  parameters.\n\n    Help options:\n        -?, -h    display info\n        -hdate    display date info\n        -hex      display examples\n";
        this.infoexamples = "\n  Examples:\n\n  Simple transits:\n     Next transit of the moon over 123.4702 degrees:\n       java Transits -p1 -lon123.4702 -btoday -utnow\n\n     Last transit over alcabitius-MC over 180 degrees at D-Helmstedt:\n       java Transits -omc -house11,52.22,b -lon180 -btoday -utnow -r\n\n     The first complete Nakshatras cycle in year 2006 starting with\n     Ashvini (0" + this.swed.ODEGREE_STRING + " in sidereal zodiac) and Lahiri ayanamsh related to a\n     topocentric position somewhere in Germany:\n       java Transits -b1/1/2006 -ut -topo11.0/52.22/160 -p1 -lon0+13.3333333333333 -n27 -sid1 -fv6dtj -ilocen -oloc\n\n     Transits of pluto or uranus or neptune over 0 degrees/day of\n     latitudinal speed before 1998 with output of real speed on that\n     date, formatted in your current Locale:\n       java Transits -p789 -lat0 -s -b12/31/1997 -utnow -n10 -r -fdtjp -oloc\n\n     When will be mercury's next 10 stationary states (speed = 0) in\n     it's longitudinal direction of movement (\"when does mercury change\n     it's motion from or to retrograde\"):\n       java Transits -p2 -btoday -utnow -lon0 -s -n10 -oloc\n\n     When did Pluto cross a very far distance of 50.2 AU between year 0:\n     and today with additional output of the julian day number:\n       java Transits -p9 -b1/1/0 -Btoday -dist50.2 -f+j5p\n\n  Transits relative to other planets:\n     All full, half and new moons in year 2008 in local time zone:\n     BE AWARE: All times will have an identical offset to UTC time,\n               even though this offset may change probably due to\n               daylight savings in effect or not in effect!\n       java Transits -p0 -P1 -lon0+90 -b1/1/2007 -lt -B12/31/2008 -LT23:59:59 -loc24en\n\n     Conjunctions of jupiter with saturn since 2000 until 2050:\n       java Transits -p5 -P6 -lon0 -b1/1/2000 -b12/31/2050 -fdtjpP -oloc24\n\n     The next 20 transits of mars over any of the major planets with any\n     of the major aspect angles in western astrology:\n       java Transits -p4 -P0123456789 -lon0/30/45/60/90/120/150/180 -btoday -utnow -n20 -f+pP\n\n     The next 30 tithis starting with the next purnima (full moon):\n       java Transits -btoday -ut -p1 -P0 -lon180+12 -n30 -sid1\n\n       Note: you have to use:\n       -lon0/12/24/36/48/60/72/84/96/108/120/132/144/156/168/180/192/204/216/228/240/252/264/276/288/300/312/324/336/348\n       if you like to start with ANY of the tithis and not with 180 degrees.\n\n     The first 12 yogas starting from January 1, 2006:\n       java Transits -p0 -P1 +lon0+13.33333333333333 -sid1 -b1/1/2006 -ut -n12 -ilocen -f+P\n\n     Past Sade Sadhi for a moon in Kanya since April 1957:\n       java Transits -p6 -lon120/210 -b4/13/1957 -btoday -ut -sid1 -oloc\n\n     All trigon aspects between any of the major planets during the time\n     of January 1, 2006 and January 1, 2008.\n       java Transits -b1/1/2006 -B1/1/2008 -p0123456789 -P0123456789 -lon120 -oloc\n\n\n     IMPORTANT NOTE: this kind of calculation may take a LONG(!) time to\n           complete, as it will try to find transits of planets not being\n           able to have that distance to each other, e.g., Sun and Mercury.\n           Those kind of transits will be calculated up to the end of the\n           calculable time, which might be far beyond the year 5000.\n     So, you will not get any results from the following one, but it will\n     take a rather long time to complete:\n       java Transits -p23 -P23 -btoday -lon75 -n10 -oloc\n\n     If you add another planet or degree, for which a transit will be found,\n     the problem will disappear:\n       java Transits -p23 -P235 -btoday -lon75 -n10 -oloc\n       java Transits -p23 -P23 -btoday -lon75/0 -n10 -oloc\n\n  Transits of planets relative to house objects:\n     Last transit of Sun 90 degrees ahead of MC in Koch house system:\n       java Transits -p0 -Omc -btoday -utnow -lon90 -house88,22.17,K -utnow -r -f+p -oloc\n\n     Transit of sidereal Mercury 30 degrees ahead of sidereal cusp of house 7:\n       java Transits -p2 -Ohouse7 -btoday -utnow -lon30 -sid1 -house83.4,17.81,P -oloc\n\n     The next 10 transits of venus with square or opposition aspect to the ascendant:\n       java Transits -oASC -P3 -btoday -utnow -lon90/180/270/0 -n10 -house11,52.26,P -f+p -oloc\n\n";
    }

    public static void main(String[] stringArray) {
        Transits transits = new Transits();
        Calendar calendar = Calendar.getInstance();
        transits.tzOffset = (double)(calendar.get(15) + calendar.get(16)) / 1000.0 / 3600.0 / 24.0;
        System.exit(transits.startCalculations(stringArray, true));
    }

    public int startCalculations(String[] stringArray) {
        return this.startCalculations(stringArray, false);
    }

    private int startCalculations(String[] stringArray, boolean bl) {
        TransitArguments transitArguments = null;
        TransitCalculator[] transitCalculatorArray = null;
        try {
            transitArguments = this.parseArgs(stringArray);
            if (transitArguments == null) {
                return 0;
            }
            if (!transitArguments.convert) {
                transitCalculatorArray = this.initCalculators(transitArguments);
            }
            this.writeCmdLine(stringArray, transitArguments.withHeader);
            if (!transitArguments.convert) {
                this.writeHeader(transitArguments);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println(nullPointerException);
            return 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                System.err.println(illegalArgumentException.getMessage());
            }
            return -1;
        }
        if (transitArguments.convert) {
            if (transitArguments.isUt) {
                transitArguments.sde1.setJulDay(transitArguments.sde1.getJulDay() - transitArguments.sde1.getDeltaT());
            }
            System.out.println(this.printFormatted(transitArguments, null));
            return 0;
        }
        TransitResult transitResult = null;
        boolean bl2 = true;
        boolean bl3 = transitArguments.duplicateTransitPoints;
        while (transitArguments.count > 0.0 || transitArguments.enddate != null && !transitArguments.back && transitArguments.tjde1 < transitArguments.jdET2 || transitArguments.enddate != null && transitArguments.back && transitArguments.tjde1 > transitArguments.jdET2) {
            transitArguments.duplicateTransitPoints = bl2 ? false : bl3;
            transitResult = this.calcNextTransit(transitArguments, transitCalculatorArray);
            if (Double.isNaN(transitResult.jdET) || transitResult.jdET == Double.MAX_VALUE || transitResult.jdET == -1.7976931348623157E308) {
                if (!bl2) break;
                transitResult.pl1 = transitArguments.pl1;
                transitResult.pl2 = transitArguments.pl2;
                System.err.println(this.getPlanetnameString(transitArguments, transitResult) + (transitArguments.mpp1 ? " etc.: " : "") + " no transit");
                break;
            }
            bl2 = false;
            transitArguments.sde1.setJulDay(transitResult.jdET);
            if (transitArguments.rollover) {
                while (transitArguments.to.values[0] < 0.0) {
                    transitArguments.to.values[0] = new Double(transitArguments.to.values[0] + transitArguments.rolloverVal);
                }
                if (transitArguments.to.values[0] > transitArguments.rolloverVal) {
                    transitArguments.to.values[0] = new Double(transitArguments.to.values[0] % transitArguments.rolloverVal);
                }
            }
            System.out.println(this.printFormatted(transitArguments, transitResult));
            transitArguments.tjde1 = transitArguments.sde1.getJulDay() + (transitArguments.back ? -5.787037037037037E-6 : 5.787037037037037E-6);
            for (int i = 0; i < transitArguments.to.values.length; ++i) {
                if (transitArguments.duplicateTransitPoints) {
                    transitArguments.to.values[i] = new Double(transitResult.transitValue);
                    continue;
                }
                if (!transitArguments.varyingTransitPoints) continue;
                transitArguments.to.values[i] = new Double(transitArguments.to.values[i] + transitArguments.to.offset);
            }
            transitArguments.count -= 1.0;
        }
        if (transitArguments.v.outOfTimeRange) {
            System.err.println("\nCalculation(s) exceed(s) available time range.");
        }
        this.sw.swe_close();
        return 0;
    }

    TransitResult calcNeighbouringTransits(TransitArguments transitArguments) {
        TransitResult transitResult = new TransitResult();
        transitResult.jdET = transitArguments.v.jdEnd;
        double[] dArray = null;
        dArray = transitArguments.v.tvOffset == 0.0 ? new double[]{transitArguments.v.transitVal} : new double[]{transitArguments.v.transitVal, (transitArguments.v.transitVal - transitArguments.v.tvOffset + transitArguments.v.rolloverVal) % transitArguments.v.rolloverVal, (transitArguments.v.transitVal + transitArguments.v.tvOffset) % transitArguments.v.rolloverVal};
        boolean[] blArray = new boolean[]{true, transitArguments.v.duplicateTransitPoints && transitArguments.v.rollover, transitArguments.v.duplicateTransitPoints};
        double d = Double.NaN;
        int n = 0;
        int n2 = 0;
        transitArguments.v.outOfTimeRange = false;
        boolean bl = false;
        transitResult.transitValue = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            block12: {
                if (!blArray[i]) continue;
                try {
                    boolean bl2 = bl = transitArguments.v.tcIndex >= transitArguments.idxDuplicates && (dArray[i] == 0.0 || transitArguments.to.idxOffset == 0 && dArray[i] == 180.0);
                    if (bl) {
                        transitResult.jdET = d = transitArguments.v.back ? -1.7976931348623157E308 : Double.MAX_VALUE;
                        ++n2;
                    } else {
                        d = this.calcTransit(transitArguments.v.tc, dArray[i], transitArguments.v.jdStart, transitResult.jdET, transitArguments.v.back);
                    }
                }
                catch (SwissephException swissephException) {
                    ++n;
                    if ((swissephException.getType() & 0xC0000) != 0) break block12;
                    if ((swissephException.getType() & 0xC00) != 0 || (swissephException.getType() & 0xC0000) != 0) {
                        transitArguments.v.outOfTimeRange = true;
                    }
                    if (swissephException.toString().indexOf("not found in the paths of:") > 0) {
                        transitArguments.v.outOfTimeRange = true;
                    }
                    if (swissephException.toString().indexOf(" outside ") > 0 && swissephException.toString().indexOf(" range ") > 0 && swissephException.toString().indexOf(" range ") > swissephException.toString().indexOf(" outside ")) {
                        transitArguments.v.outOfTimeRange = true;
                    }
                    if (swissephException.toString().indexOf(" is restricted to ") > 0) {
                        transitArguments.v.outOfTimeRange = true;
                    }
                    if ((swissephException.getType() & 0xC0000) != 0) {
                        d = transitArguments.v.back ? -1.7976931348623157E308 : Double.MAX_VALUE;
                    }
                    System.err.println("ERROR: " + swissephException.getMessage());
                }
            }
            if (transitArguments.v.back) {
                if (!(d > transitResult.jdET)) continue;
                transitResult.transitValue = dArray[i];
                transitResult.jdET = d;
                continue;
            }
            if (!(d < transitResult.jdET)) continue;
            transitResult.transitValue = dArray[i];
            transitResult.jdET = d;
        }
        if (n == 1 && !transitArguments.v.duplicateTransitPoints || n == 3 && transitArguments.v.duplicateTransitPoints) {
            transitResult.jdET = transitArguments.v.back ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        return transitResult;
    }

    double calcTransit(TransitCalculator transitCalculator, double d, double d2, double d3, boolean bl) throws SwissephException {
        transitCalculator.setOffset(d);
        double d4 = this.sw.getTransitET(transitCalculator, d2, bl, d3);
        return d4;
    }

    String getPlanetCombinations(String string, String string2) {
        String string3 = "";
        String string4 = "";
        for (int i = 0; i < string.length(); ++i) {
            String string5 = string.substring(i, i + 1);
            if (string5.charAt(0) == '/') {
                string5 = string.substring(i, string.indexOf(47, i + 1) + 1);
                i = string.indexOf(47, i + 1);
            }
            for (int j = 0; j < string2.length(); ++j) {
                String string6 = string2.substring(j, j + 1);
                if (string6.charAt(0) == '/') {
                    string6 = string2.substring(j, string2.indexOf(47, j + 1) + 1);
                    j = string2.indexOf(47, j + 1);
                }
                if (string5.equals(string6)) continue;
                String string7 = string5 + string6;
                String string8 = string6 + string5;
                int n = string3.indexOf(string8);
                int n2 = string3.indexOf(string7);
                if ((n2 < 0 || n2 >= 0 && (n2 & 1) == 1) && (n < 0 || n >= 0 && (n & 1) == 1)) {
                    if (string7.indexOf(48) >= 0 || string7.indexOf(49) >= 0 || "23".equals(string7) || "32".equals(string7)) {
                        string3 = string3 + string7;
                        continue;
                    }
                    string3 = string7 + string3;
                    continue;
                }
                n = string4.indexOf(string8);
                if (n >= 0 && (n < 0 || (n & 1) != 1)) continue;
                string4 = string7.indexOf(48) >= 0 || string7.indexOf(49) >= 0 || "23".equals(string7) || "32".equals(string7) ? string4 + string7 : string7 + string4;
            }
        }
        return string3 + "@" + string4;
    }

    String getHouseobjectCombinations(String string, String string2) {
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            String string4 = string.substring(i, i + 1);
            if (string4.charAt(0) == '/') {
                string4 = string.substring(i, string.indexOf(47, i + 1) + 1);
                i = string.indexOf(47, i + 1);
            }
            String[] stringArray = string2.split("[,/]");
            for (int j = 0; j < stringArray.length; ++j) {
                int n = this.string_to_houseobject(stringArray[j]);
                String string5 = string4 + "" + n;
                string3 = string3 + string5 + " ";
            }
        }
        return string3;
    }

    String group(ObjFormatter objFormatter, int n, String string) {
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            string2 = string2 + string + objFormatter.format(i);
        }
        return string2.substring(string.length());
    }

    double readLocalizedDouble(String string, String string2) {
        if (string != null && string.length() > 0) {
            String string3 = string.substring(string.indexOf("@") + 1);
            String string4 = string.substring(0, string.indexOf("@")) + string3;
            String string5 = "";
            int n = 32;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < string3.length(); ++i) {
                char c = string3.charAt(i);
                if (!Character.isDigit(c)) {
                    if (c == this.numIFracSeparator.charAt(0)) {
                        if (bl) {
                            return this.invalidValue(string4, string.indexOf(64));
                        }
                        if (this.numIFracSeparator.length() > 1) {
                            // empty if block
                        }
                        c = '.';
                        bl = true;
                    } else if (c == '+' || c == '-') {
                        if (i != 0 || n == 69 && string5.length() == 0) {
                            return this.invalidValue(string4, string.indexOf(64));
                        }
                    } else if (c == 'E') {
                        if (bl2 || string5.length() == 0) {
                            return this.invalidValue(string4, string.indexOf(64));
                        }
                        bl2 = true;
                    } else {
                        return this.invalidValue(string4, string.indexOf(64), string2);
                    }
                }
                string5 = string5 + (char)c;
                n = c;
            }
            if (string5.length() > 0) {
                return Double.valueOf(string5);
            }
        }
        return Double.NaN;
    }

    String printFormatted(TransitArguments transitArguments, TransitResult transitResult) {
        String string = "";
        Object var4_4 = null;
        Object var5_5 = null;
        boolean bl = false;
        int n = 0;
        block9: for (int i = 0; i < transitArguments.outputFormat.length(); ++i) {
            if (i > 0) {
                string = string + "   ";
            }
            switch (transitArguments.outputFormat.charAt(i)) {
                case 'n': {
                    string = string + this.getPlanetnameString(transitArguments, transitResult);
                    continue block9;
                }
                case 'd': {
                    int n2;
                    n = 0;
                    for (n2 = i + 1; n2 < transitArguments.outputFormat.length() && Character.isDigit(transitArguments.outputFormat.charAt(n2)); ++n2) {
                        n = n * 10 + Character.getNumericValue(transitArguments.outputFormat.charAt(n2));
                        ++i;
                    }
                    string = string + this.jdToDate(transitArguments.sde1, transitArguments.isUt, transitArguments.isLt, n);
                    continue block9;
                }
                case 't': {
                    n = 0;
                    if (i != 0) {
                        string = string.substring(0, string.length() - 2);
                    }
                    string = string + (transitArguments.isLt ? "LT" : (transitArguments.isUt ? "UT" : "ET"));
                    continue block9;
                }
                case 'j': {
                    int n2;
                    n = 0;
                    bl = false;
                    for (n2 = i + 1; n2 < transitArguments.outputFormat.length() && Character.isDigit(transitArguments.outputFormat.charAt(n2)); ++n2) {
                        bl = true;
                        n = n * 10 + Character.getNumericValue(transitArguments.outputFormat.charAt(n2));
                        ++i;
                    }
                    if (!bl) {
                        n = 8;
                    }
                    string = string + this.printJD(transitArguments.sde1.getJulDay(), transitArguments.isUT, transitArguments.isLT, n);
                    continue block9;
                }
                case 'v': {
                    int n2;
                    n = 0;
                    bl = false;
                    for (n2 = i + 1; n2 < transitArguments.outputFormat.length() && Character.isDigit(transitArguments.outputFormat.charAt(n2)); ++n2) {
                        bl = true;
                        n = n * 10 + Character.getNumericValue(transitArguments.outputFormat.charAt(n2));
                        ++i;
                    }
                    if (!bl) {
                        n = 2;
                    }
                    string = string + this.printFloat(transitResult.transitValue, 3, n, transitArguments.rollover ? transitArguments.rolloverVal : 0.0) + this.swed.ODEGREE_STRING + "";
                    if ((transitArguments.iflag & 0x100000) == 0) continue block9;
                    string = string + "/day";
                    continue block9;
                }
                case 'p': {
                    int n2;
                    n = 0;
                    bl = false;
                    for (n2 = i + 1; n2 < transitArguments.outputFormat.length() && Character.isDigit(transitArguments.outputFormat.charAt(n2)); ++n2) {
                        bl = true;
                        n = n * 10 + Character.getNumericValue(transitArguments.outputFormat.charAt(n2));
                        ++i;
                    }
                    if (!bl) {
                        n = 8;
                    }
                    if (transitArguments.pls1 != null) {
                        string = string + this.verifyPlanet(transitArguments, transitResult, 1, n);
                    }
                    if (transitArguments.objects1 != null) {
                        string = string + this.verifyHouseobject(transitArguments, transitResult, 1, n);
                    }
                    if (transitArguments.pls2 != null) {
                        string = string + this.verifyPlanet(transitArguments, transitResult, 2, n);
                    }
                    if (transitArguments.objects2 == null) continue block9;
                    string = string + this.verifyHouseobject(transitArguments, transitResult, 2, n);
                    continue block9;
                }
                case 'P': {
                    int n2;
                    if (transitResult.pl2 < 0 && transitResult.obj2 < 0) continue block9;
                    n = 0;
                    bl = false;
                    for (n2 = i + 1; n2 < transitArguments.outputFormat.length() && Character.isDigit(transitArguments.outputFormat.charAt(n2)); ++n2) {
                        bl = true;
                        n = n * 10 + Character.getNumericValue(transitArguments.outputFormat.charAt(n2));
                        ++i;
                    }
                    if (!bl) {
                        n = 8;
                    }
                    string = transitArguments.pls1 != null ? string + this.verifyPlanet(transitArguments, transitResult, 1, n, true) : string + this.verifyPlanet(transitArguments, transitResult, 2, n, true);
                }
            }
        }
        return string;
    }

    String verifyPlanet(TransitArguments transitArguments, TransitResult transitResult, int n, int n2) {
        return this.verifyPlanet(transitArguments, transitResult, n, n2, false);
    }

    String verifyPlanet(TransitArguments transitArguments, TransitResult transitResult, int n, int n2, boolean bl) {
        int n3;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[6];
        int n4 = 0;
        if ((transitArguments.iflag & 0x40000) != 0) {
            n4 = 1;
        } else if ((transitArguments.iflag & 0x80000) != 0) {
            n4 = 2;
        }
        int n5 = transitArguments.iflag;
        if ((transitArguments.iflag & 0x100000) != 0) {
            n4 += 3;
            n5 |= 0x100;
        }
        if ((n3 = this.sw.swe_calc(transitArguments.sde1.getJulDay(), n == 1 ? transitResult.pl1 : transitResult.pl2, n5 &= 0xFFE1FFFF, dArray, stringBuffer)) < 0) {
            string = string + stringBuffer.toString().substring(0, 10) + "...";
            if (bl) {
                return string;
            }
        } else if (!bl) {
            string = string + this.printFloat(dArray[n4], 4, n2, transitArguments.rollover ? transitArguments.rolloverVal : 0.0);
        }
        if (bl) {
            if (transitArguments.pls1 != null && transitArguments.pls2 != null) {
                double d = dArray[n4];
                n3 = this.sw.swe_calc(transitArguments.sde1.getJulDay(), transitResult.pl2, n5, dArray, stringBuffer);
                if (n3 < 0) {
                    string = string + stringBuffer.toString().substring(0, 10) + "...";
                    return string;
                }
                string = n4 >= 1 ? string + this.printFloat(d, 3, n2, transitArguments.rollover ? transitArguments.rolloverVal : 0.0) : string + this.printFloat(((d += transitArguments.yogaTransit ? dArray[n4] : -dArray[n4]) + transitArguments.rolloverVal) % transitArguments.rolloverVal, 3, n2, transitArguments.rollover ? transitArguments.rolloverVal : 0.0);
            } else {
                int n6;
                double[] dArray2 = new double[transitArguments.hsys == 'G' ? 37 : 13];
                double[] dArray3 = new double[10];
                int n7 = n6 = n == 1 ? transitResult.obj2 : transitResult.obj1;
                if (n6 <= -1000) {
                    return "";
                }
                int n8 = transitArguments.house_flags;
                if ((transitArguments.iflag & 0x100000) != 0) {
                    n8 |= 0x100;
                }
                if ((n3 = this.sw.swe_houses(transitArguments.sde1.getJulDay() - SweDate.getDeltaT(transitArguments.sde1.getJulDay()), n8 &= 0xFFEDFFFF, transitArguments.house_lat, transitArguments.house_lon, transitArguments.hsys, dArray2, dArray3)) < 0) {
                    throw new SwissephException(transitArguments.sde1.getJulDay() - SweDate.getDeltaT(transitArguments.sde1.getJulDay()), 0, "Calculation failed with return code " + n3 + ".");
                }
                double d = 0.0;
                d = n6 < 0 ? dArray2[Math.abs(n6)] : dArray3[n6];
                int n9 = n4;
                dArray[n9] = dArray[n9] - d;
                string = n4 >= 1 ? string + this.printFloat(dArray[n4], 3, n2, transitArguments.rollover ? transitArguments.rolloverVal : 0.0) : string + this.printFloat((dArray[n4] + transitArguments.rolloverVal) % transitArguments.rolloverVal, 3, n2, transitArguments.rollover ? transitArguments.rolloverVal : 0.0);
            }
        }
        return string;
    }

    String verifyHouseobject(TransitArguments transitArguments, TransitResult transitResult, int n, int n2) {
        int n3;
        int n4;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = new double[transitArguments.hsys == 'G' ? 37 : 13];
        double[] dArray2 = new double[10];
        int n5 = n4 = n == 1 ? transitResult.obj1 : transitResult.obj2;
        if (n4 <= -1000) {
            return "";
        }
        int n6 = transitArguments.house_flags;
        if ((transitArguments.iflag & 0x100000) != 0) {
            n6 |= 0x100;
        }
        if ((n3 = this.sw.swe_houses(transitArguments.sde1.getJulDay() - SweDate.getDeltaT(transitArguments.sde1.getJulDay()), n6 &= 0xFFEDFFFF, transitArguments.house_lat, transitArguments.house_lon, transitArguments.hsys, dArray, dArray2)) < 0) {
            throw new SwissephException(transitArguments.sde1.getJulDay() - SweDate.getDeltaT(transitArguments.sde1.getJulDay()), 0, "Calculation failed with return code " + n3 + ".");
        }
        double d = 0.0;
        d = n4 < 0 ? dArray[Math.abs(n4)] : dArray2[n4];
        return this.printFloat(d, 4, n2, transitArguments.rollover ? transitArguments.rolloverVal : 0.0);
    }

    TransitOffsets parseTransitValString(String string) {
        int n;
        if ("".equals(string.trim())) {
            return null;
        }
        TransitOffsets transitOffsets = new TransitOffsets();
        int n2 = n = string.startsWith("-l") ? 4 : 5;
        if (string.startsWith("-partile") || string.startsWith("+partile")) {
            n = 8;
        } else if (string.startsWith("-nonpartile")) {
            n = 11;
        }
        String string2 = string.substring(1, n);
        String string3 = string.substring(n).toUpperCase();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Vector<Double> vector = new Vector<Double>();
        String string4 = "";
        char c = '\u0000';
        for (int i = 0; i < string3.length(); ++i) {
            char c2 = string3.charAt(i);
            if (!Character.isDigit(c2)) {
                if (c2 == this.numIFracSeparator.charAt(0)) {
                    if (this.numIFracSeparator.length() > 1) {
                        // empty if block
                    }
                } else if (c2 == '+' || c2 == '-') {
                    if (c != 'E' && string4.length() != 0) {
                        bl = true;
                    }
                    if (c != 'E' && bl2 && c != '/') {
                        this.invalidValue(string, n);
                        return null;
                    }
                } else if (c2 == '/') {
                    bl = true;
                    bl2 = true;
                } else if (c2 == 'E') {
                    if (bl3 || string4.length() == 0) {
                        this.invalidValue(string, n);
                        return null;
                    }
                    bl3 = true;
                } else {
                    this.invalidValue(string, n, this.Nlocale);
                    return null;
                }
            }
            if (c2 != 'E' && (bl || i == string3.length() - 1)) {
                if (i == string3.length() - 1) {
                    string4 = string4 + c2;
                }
                if (bl2 || vector.size() == 0) {
                    try {
                        vector.addElement(this.nnif.parse(string4).doubleValue());
                    }
                    catch (Exception exception) {
                        this.invalidValue(string, n, this.Nlocale);
                        return null;
                    }
                }
                try {
                    transitOffsets.offset = this.nnif.parse(string4).doubleValue();
                }
                catch (Exception exception) {
                    this.invalidValue(string, n, this.Nlocale);
                    return null;
                }
                string4 = "";
                bl = false;
                bl3 = false;
            } else {
                if (c2 == 'E' && (bl || i == string3.length() - 1)) {
                    System.err.println(4);
                    this.invalidValue(string, n, this.Nlocale);
                    return null;
                }
                if (c2 != '/') {
                    string4 = string4 + c2;
                }
            }
            c = c2;
        }
        if (string4.length() > 0) {
            vector.addElement(Double.valueOf(string4));
        }
        if (vector.size() == 0) {
            return null;
        }
        transitOffsets.values = new Double[vector.size()];
        transitOffsets.values = vector.toArray(transitOffsets.values);
        if (string2.equals("lon")) {
            transitOffsets.idxOffset = 0;
        } else if (string2.equals("lat")) {
            transitOffsets.idxOffset = 1;
        } else if (string2.equals("dist")) {
            transitOffsets.idxOffset = 2;
        }
        return transitOffsets;
    }

    double parseHour(String string) {
        if (string.equals("now")) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            return (double)calendar.get(11) + (double)calendar.get(12) / 60.0 + (double)calendar.get(13) / 3600.0;
        }
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        int n = 0;
        boolean bl = false;
        double d = 1.0;
        int n2 = 0;
        while (n2 < string.length()) {
            if (Character.isDigit(string.charAt(n2))) {
                if (bl) {
                    int n3 = n;
                    dArray[n3] = dArray[n3] + (double)(string.charAt(n2) - 48) / (d *= 10.0);
                } else {
                    int n4 = n;
                    dArray[n4] = dArray[n4] * 10.0;
                    int n5 = n;
                    dArray[n5] = dArray[n5] + (double)(string.charAt(n2) - 48);
                }
                ++n2;
                continue;
            }
            if (++n == dArray.length) {
                --n;
                if (string.charAt(n2) != this.dateFracSeparator.charAt(0) || string.indexOf(this.dateFracSeparator) != n2) break;
                n2 += this.dateFracSeparator.length();
                bl = true;
                continue;
            }
            while (n2 < string.length() - 1 && !Character.isDigit(string.charAt(++n2))) {
            }
        }
        return dArray[0] + dArray[1] / 60.0 + dArray[2] / 3600.0;
    }

    int invalidValue(String string, int n) {
        return this.invalidValue(string, n, null);
    }

    int invalidValue(String string, int n, String string2) {
        if (string.length() == n) {
            System.err.println("\nMissing argument to parameter '" + string + "'.\nTry option -h for a syntax description.");
            System.exit(1);
        } else {
            System.err.println("\nInvalid argument (" + string.substring(n) + ") to parameter '" + string.substring(0, n) + "'.\n" + (string2 != null ? "Maybe the locale (" + this.Nlocale + ") requires a different format.\nAlso t" : "\nT") + "ry option -h for a syntax description.");
            System.exit(1);
        }
        return 1;
    }

    String invalidArgument(String string, int n) {
        return this.invalidArgument(string, n, null);
    }

    String invalidArgument(String string, int n, String string2) {
        if (string.length() == n) {
            return "Missing argument to parameter '" + string + "'.\nTry option -h for a syntax description.";
        }
        return "Invalid argument (" + string.substring(n) + ") to parameter '" + string.substring(0, n) + "'.\n" + (string2 != null ? "Maybe the locale (" + this.Nlocale + ") requires a different format.\nAlso t" : "\nT") + "ry option -h for a syntax description.";
    }

    String checkLocale(String string, String string2) {
        return this.checkLocale(string, string2, false);
    }

    String checkLocale(String string, String string2, boolean bl) {
        if (string2 == null) {
            string2 = bl ? "iso" : "en_US";
        } else if ("".equals(string2)) {
            string2 = Locale.getDefault().toString();
        }
        if (string == null) {
            return string2;
        }
        if ("".equals(string)) {
            return Locale.getDefault().toString();
        }
        if ("ja_JP_JP".equals(string)) {
            return "ja_JP_JP_#u-ca-japanese";
        }
        if ("th_TH_TH".equals(string)) {
            return "th_TH_TH_#u-nu-thai";
        }
        if ("iso".equals(string)) {
            return string;
        }
        for (int i = 0; i < this.locs.length; ++i) {
            if (!this.locs[i].toString().equals(string)) continue;
            return string;
        }
        System.err.println("Warning: Locale '" + string + "' not found, using default locale '" + string2 + "'");
        System.err.println("Use option -locales to list all available Locales.");
        return string2;
    }

    String jdToDate(SweDate sweDate, boolean bl, boolean bl2, int n) {
        int n2;
        if (n > 18) {
            n = 18;
        }
        SweDate sweDate2 = new SweDate(sweDate.getJulDay() - (bl ? sweDate.getDeltaT() : 0.0) + (bl2 ? this.tzOffset : 0.0) + 5.787037037037037E-6 / SMath.pow(10.0, n));
        double d = sweDate2.getHour();
        double d2 = d * 3600.0 % 1.0;
        String string = "";
        String string2 = "";
        String string3 = null;
        String string4 = this.dof.toPattern();
        sweDate2.setJulDay(sweDate2.getJulDay() - d2 / 24.0 / 3600.0 + 5.787037037037037E-6);
        if (sweDate2.getYear() == 0) {
            string3 = this.dof.format(sweDate2.getDate(0L));
            n2 = this.el.getPatternLastIdx(string4, "yyyy", this.dof);
            string3 = string3.substring(0, n2 + 2) + string3.substring(n2, n2 + 1) + string3.substring(n2 + 3);
        } else if (sweDate2.getYear() < 0) {
            sweDate2.setYear(sweDate2.getYear() + 1);
            n2 = string4.indexOf("y");
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)this.dof.clone();
            String string5 = n2 > 0 && string4.charAt(n2 - 1) == '-' ? " " : "";
            string4 = string4.substring(0, n2) + string5 + "'-'" + string4.substring(n2);
            simpleDateFormat.applyPattern(string4);
            string3 = simpleDateFormat.format(sweDate2.getDate(0L));
        } else {
            string3 = this.dof.format(sweDate2.getDate(0L));
        }
        if (n > 0) {
            this.secondsIdx = this.el.getPatternLastIdx(string4, "ss", this.dof);
            string = string3.substring(0, this.secondsIdx + 1);
            string2 = string3.substring(this.secondsIdx + 1);
            string3 = this.dateFracSeparator;
            for (n2 = n; n2 > 0; --n2) {
                d2 = d2 * 10.0 % 10.0;
                string3 = string3 + this.dnof.format((int)d2);
            }
        }
        return string + string3 + string2;
    }

    String printFloat(double d, int n, int n2) {
        return this.printFloat(d, n, n2, 0.0);
    }

    String printFloat(double d, int n, int n2, double d2) {
        if (n2 > 18) {
            n2 = 18;
        }
        if (n > 61) {
            n = 61;
        }
        String string = "                                                            ";
        if (d < 0.0) {
            d = -d;
            string = string + "-";
        }
        d += 0.5 / SMath.pow(10.0, n2);
        if (d2 != 0.0 && d >= d2) {
            d -= d2;
        }
        while (d < 0.0) {
            d += d2;
        }
        int n3 = String.valueOf((int)d).length();
        string = string + this.nnof.format((int)d);
        string = string.substring(SMath.max(n3, string.length() - n));
        if (n2 > 0) {
            string = string + this.numOFracSeparator;
            double d3 = d - (double)((int)d);
            for (int i = n2; i > 0; --i) {
                d3 = d3 * 10.0 % 10.0;
                string = string + this.nnof.format((int)d3);
            }
        }
        return string;
    }

    String printJD(double d, boolean bl, boolean bl2, int n) {
        if (n > 18) {
            n = 18;
        }
        SweDate sweDate = new SweDate(d - (bl ? SweDate.getDeltaT(d) : 0.0) + (bl2 ? this.tzOffset : 0.0) + 0.5 / SMath.pow(10.0, n));
        d = sweDate.getJulDay();
        String string = this.nnof.format((int)d);
        if (n > 0) {
            string = string + this.numOFracSeparator;
            double d2 = SMath.abs(d - (double)((int)d));
            for (int i = n; i > 0; --i) {
                d2 = d2 * 10.0 % 10.0;
                string = string + this.nnof.format((int)d2);
            }
        }
        return string;
    }

    String doubleToDMS(double d) {
        int n = (int)d;
        int n2 = (int)(d % 1.0 * 60.0);
        int n3 = (int)(d * 60.0 % 1.0 * 60.0);
        return (n < 10 ? " " : "") + this.nnof.format(n) + this.swed.ODEGREE_STRING + "" + (n2 < 10 ? this.nnof.format(0L) : "") + this.nnof.format(n2) + "'" + (n3 < 10 ? this.nnof.format(0L) : "") + this.nnof.format(n3) + "\"";
    }

    SweDate makeDate(String string, double d, boolean bl, boolean bl2, String string2) {
        if (string == null) {
            return null;
        }
        SweDate sweDate = new SweDate();
        boolean bl3 = true;
        if (string.charAt(0) == 'j') {
            double d2 = 0.0;
            d2 = this.readLocalizedDouble("-b' or '-B@" + string.substring(1), string2);
            if (bl) {
                d2 += SweDate.getDeltaT(d2);
                if (bl2) {
                    d2 -= this.tzOffset;
                }
            }
            bl3 = !(d2 < sweDate.getGregorianChange());
            if (string.indexOf("jul") >= 0) {
                bl3 = false;
            } else if (string.indexOf("greg") >= 0) {
                bl3 = true;
            }
            sweDate.setJulDay(d2);
            sweDate.setCalendarType(bl3, false);
        } else {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            if (string.equals("today")) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                string = this.dif.format(calendar.getTime());
                return this.makeDate(string, d, bl, bl2, string2);
            }
            int[] nArray = new int[]{0, 0, 0};
            int n6 = 0;
            boolean bl4 = false;
            try {
                for (n5 = 0; n5 < 3; ++n5) {
                    boolean bl5 = false;
                    nArray[n5] = 0;
                    boolean bl6 = bl4 = string.charAt(n6) == '-';
                    if (bl4) {
                        ++n6;
                    }
                    while (Character.isDigit(string.charAt(n6))) {
                        bl5 = true;
                        nArray[n5] = nArray[n5] * 10 + Character.digit(string.charAt(n6++), 10);
                    }
                    if (!bl5) {
                        return null;
                    }
                    if (bl4) {
                        nArray[n5] = -nArray[n5];
                    }
                    n4 = 0;
                    while (!Character.isDigit(string.charAt(n6))) {
                        ++n4;
                        ++n6;
                    }
                    if (string.charAt(n6 - 1) != '-' || n4 <= 1) continue;
                    --n6;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (bl4) {
                    nArray[n5] = -nArray[n5];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            String string3 = this.dif.toPattern().toLowerCase();
            n4 = string3.indexOf("d");
            int n7 = string3.indexOf("m");
            int n8 = string3.indexOf("y");
            if (n7 < n4 && n7 < n8) {
                n3 = nArray[0];
                if (n8 < n4) {
                    n2 = nArray[1];
                    n = nArray[2];
                } else {
                    n = nArray[1];
                    n2 = nArray[2];
                }
            } else if (n8 < n4 && n8 < n7) {
                n2 = nArray[0];
                if (n7 < n4) {
                    n3 = nArray[1];
                    n = nArray[2];
                } else {
                    n = nArray[1];
                    n3 = nArray[2];
                }
            } else {
                n = nArray[0];
                if (n7 < n8) {
                    n3 = nArray[1];
                    n2 = nArray[2];
                } else {
                    n2 = nArray[1];
                    n3 = nArray[2];
                }
            }
            sweDate.setDate(n2, n3, n, d, true);
            if (bl) {
                double d3 = sweDate.getJulDay() + sweDate.getDeltaT();
                if (bl2) {
                    d3 -= this.tzOffset;
                }
                sweDate.setJulDay(d3);
            }
            bl3 = !(sweDate.getJulDay() < sweDate.getGregorianChange());
            if (string.indexOf("jul") >= 0) {
                bl3 = false;
            } else if (string.indexOf("greg") >= 0) {
                bl3 = true;
            }
            sweDate.setCalendarType(bl3, true);
        }
        return sweDate;
    }

    int make_ephemeris_path(int n, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = SwissData.DIR_GLUE;
        int n2 = 0;
        if ((n & 4) != 0) {
            return 0;
        }
        string2 = ".;:";
        int n3 = string.lastIndexOf(string4);
        if (n3 >= 0) {
            n2 = n3;
            if (string2.length() + n2 < 255) {
                string3 = string.substring(0, n2);
                string2 = string2 + string3 + ";:";
            }
        }
        if (string2.length() + n2 < 255) {
            string2 = string2 + ".:./ephe:/users/ephe2/:/users/ephe/";
        }
        return 0;
    }

    String remove_ipl(String string, int n) {
        if (string.startsWith("/")) {
            try {
                string = string.substring(0, n) + string.substring(string.indexOf(47, n + 1) + 1);
            }
            catch (Exception exception) {}
        } else {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    int string_to_ipl(String string) {
        if (string.startsWith("/")) {
            boolean bl = false;
            try {
                string = string.substring(1, string.indexOf(47, 1));
                return Integer.parseInt(string) + 10000;
            }
            catch (Exception exception) {
                return -2;
            }
        }
        return this.letter_to_ipl(string.charAt(0));
    }

    int letter_to_ipl(char c) {
        if (Character.isDigit(c)) {
            try {
                return Integer.parseInt("" + c) + 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (c >= 'A' && c <= 'I') {
            return c - 65 + 12;
        }
        if (c >= 'J' && c <= 'Z') {
            return c - 74 + 40;
        }
        switch (c) {
            case 'm': {
                return 10;
            }
            case 'c': {
                return 21;
            }
            case 'g': {
                return 22;
            }
            case 't': {
                return 11;
            }
            case 'w': {
                return 58;
            }
        }
        return -1;
    }

    int string_to_houseobject(String string) {
        if ("house1".equals(string = string.toLowerCase())) {
            return -1;
        }
        if ("house2".equals(string)) {
            return -2;
        }
        if ("house3".equals(string)) {
            return -3;
        }
        if ("house4".equals(string)) {
            return -4;
        }
        if ("house5".equals(string)) {
            return -5;
        }
        if ("house6".equals(string)) {
            return -6;
        }
        if ("house7".equals(string)) {
            return -7;
        }
        if ("house8".equals(string)) {
            return -8;
        }
        if ("house9".equals(string)) {
            return -9;
        }
        if ("house10".equals(string)) {
            return -10;
        }
        if ("house11".equals(string)) {
            return -11;
        }
        if ("house12".equals(string)) {
            return -12;
        }
        if ("asc".equals(string)) {
            return 0;
        }
        if ("mc".equals(string)) {
            return 1;
        }
        if ("armc".equals(string)) {
            return 2;
        }
        if ("vertex".equals(string)) {
            return 3;
        }
        if ("equasc".equals(string)) {
            return 4;
        }
        if ("coasc1".equals(string)) {
            return 5;
        }
        if ("coasc2".equals(string)) {
            return 6;
        }
        if ("polasc".equals(string)) {
            return 7;
        }
        return 0;
    }

    String limitLineLength(String string, int n, String string2) {
        String string3 = "";
        n -= string2.length();
        while (string.length() > 0) {
            if (string.length() > n) {
                int n2;
                String string4 = string.substring(0, n + 1);
                for (n2 = string4.length() - 1; n2 >= 0; --n2) {
                    if (!Character.isWhitespace(string4.charAt(n2))) continue;
                    string4 = string4.substring(0, n2);
                    string = string.substring(n2 + 1);
                    break;
                }
                if (string4.length() > n) {
                    for (n2 = string4.length() - 1; n2 >= 0; --n2) {
                        if (!Character.isLetterOrDigit(string4.charAt(n2))) continue;
                        string4 = string4.substring(0, n2);
                        string = string.substring(n2);
                        break;
                    }
                }
                if (string4.length() > n) {
                    string4 = string.substring(0, n);
                    string = string.substring(n);
                }
                string3 = string3 + "\n" + string2 + string4;
                continue;
            }
            string3 = string3 + "\n" + string2 + string;
            break;
        }
        return string3.substring(("\n" + string2).length());
    }

    String getPlanetNames(String string, String string2) {
        String string3 = "";
        for (int i = 0; i < string.length(); ++i) {
            int n = this.string_to_ipl(string.substring(i));
            if (n > 10000) {
                i += ("//" + (n - 10000)).length() - 1;
            }
            string3 = string3 + string2 + this.sw.swe_get_planet_name(n);
        }
        return string3.substring(string2.length());
    }

    String getHouseobjectNames(String string, String string2) {
        String string3 = "";
        String[] stringArray = string.split("[,/]");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = this.string_to_houseobject(stringArray[i]);
            string3 = string3 + string2 + SwissEph.getHouseobjectname(n);
        }
        return string3.substring(string2.length());
    }

    TransitArguments parseArgs(String[] stringArray) throws IllegalArgumentException {
        int n;
        TransitArguments transitArguments = new TransitArguments();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-hdate")) {
                System.out.println(infodate);
                this.sw.swe_close();
                return null;
            }
            if (stringArray[i].equals("-hex")) {
                if (this.infoexamples == null) {
                    this.initHelpTexts();
                }
                System.out.println(this.infoexamples);
                this.sw.swe_close();
                return null;
            }
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help") || stringArray[i].equals("-?") || stringArray[i].equals("/?")) {
                System.out.println(infocmd0);
                System.out.println(infocmd1);
                if (this.infoexamples == null) {
                    this.initHelpTexts();
                }
                System.out.println(this.infocmd2);
                System.out.println(this.infoexamples);
                this.sw.swe_close();
                return null;
            }
            if (stringArray[i].equals("-head") || stringArray[i].equals("-q")) {
                transitArguments.withHeader = false;
                continue;
            }
            if (stringArray[i].equals("-r")) {
                transitArguments.back = true;
                continue;
            }
            if (stringArray[i].startsWith("-lon") || stringArray[i].startsWith("-lat") || stringArray[i].startsWith("-dist") || stringArray[i].startsWith("+lon") || stringArray[i].startsWith("+lat") || stringArray[i].startsWith("+dist") || stringArray[i].startsWith("-partile") || stringArray[i].startsWith("-nonpartile") || stringArray[i].startsWith("+partile")) {
                if (!"".equals(transitArguments.transitValString)) {
                    throw new IllegalArgumentException("Only one of -lon / -lat / -dist / +lon / +lat / +dist /\n-partile / -nonpartile / +partile may be given. Use the\n-h option for more information.");
                }
                boolean bl = transitArguments.yogaTransit = stringArray[i].charAt(0) == '+' && !stringArray[i].startsWith("+partile");
                if (stringArray[i].substring(1).startsWith("partile") || stringArray[i].startsWith("-nonpartile")) {
                    n = stringArray[i].charAt(0) == '+' ? 1 : 0;
                    transitArguments.partileStart = stringArray[i].startsWith("-partile") || n != 0;
                    transitArguments.partileEnd = stringArray[i].startsWith("-nonpartile") || n != 0;
                }
                stringArray[i] = "-" + stringArray[i].substring(1);
                transitArguments.transitValString = stringArray[i];
                continue;
            }
            if (stringArray[i].startsWith("-topo")) {
                transitArguments.iflag |= 0x8000;
                transitArguments.topoS = stringArray[i].substring(5);
                continue;
            }
            if (stringArray[i].equals("-hel") || stringArray[i].equals("-helio")) {
                transitArguments.helio = true;
                transitArguments.iflag |= 8;
                transitArguments.iflag |= 0x400;
                transitArguments.iflag |= 0x200;
                continue;
            }
            if (stringArray[i].equals("-equ") || stringArray[i].equals("-equatorial")) {
                transitArguments.equatorial = true;
                transitArguments.iflag |= 0x800;
                continue;
            }
            if (stringArray[i].startsWith("-sid")) {
                try {
                    transitArguments.sidmode = Integer.parseInt(stringArray[i].substring(4));
                    if (transitArguments.sidmode >= 0 && transitArguments.sidmode <= 20) continue;
                    throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 4));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 4));
                }
            }
            if (stringArray[i].equals("-true")) {
                transitArguments.iflag |= 0x10;
                continue;
            }
            if (stringArray[i].startsWith("-ejpl")) {
                transitArguments.whicheph = 1;
                if (stringArray[i].length() <= 5) continue;
                transitArguments.fname = stringArray[i].substring(5);
                continue;
            }
            if (stringArray[i].equals("-eswe")) {
                transitArguments.whicheph = 2;
                continue;
            }
            if (stringArray[i].equals("-emos")) {
                transitArguments.whicheph = 4;
                continue;
            }
            if (stringArray[i].startsWith("-edir")) {
                if (stringArray[i].length() <= 5) continue;
                transitArguments.ephepath = stringArray[i].substring(5);
                continue;
            }
            if (stringArray[i].startsWith("-ut") || stringArray[i].startsWith("-et") || stringArray[i].startsWith("-lt") || stringArray[i].startsWith("-t")) {
                n = stringArray[i].startsWith("-t") ? 2 : 3;
                transitArguments.isLt = stringArray[i].startsWith("-lt");
                boolean bl = transitArguments.isUt = stringArray[i].startsWith("-ut") || transitArguments.isLt;
                if (stringArray[i].length() <= n) continue;
                transitArguments.sBeginhour = stringArray[i].substring(n);
                if (transitArguments.sBeginhour.equals("now") || transitArguments.sBeginhour.matches("[0-9][0-9]*:[0-9][0-9]*:[0-9][0-9]*")) continue;
                throw new IllegalArgumentException("Unrecognized option '" + stringArray[i] + "'");
            }
            if (stringArray[i].startsWith("-UT") || stringArray[i].startsWith("-ET") || stringArray[i].startsWith("-LT") || stringArray[i].startsWith("-T")) {
                n = stringArray[i].startsWith("-T") ? 2 : 3;
                transitArguments.isLT = stringArray[i].startsWith("-LT");
                transitArguments.isUT = stringArray[i].startsWith("-UT") || transitArguments.isLT;
                transitArguments.sEndhour = stringArray[i].substring(n);
                transitArguments.endTimeIsSet = true;
                continue;
            }
            if (stringArray[i].equals("-s")) {
                transitArguments.calcSpeed = true;
                continue;
            }
            if (stringArray[i].startsWith("-b") || stringArray[i].startsWith("-j")) {
                if (stringArray[i].length() < 3) {
                    throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
                }
                n = stringArray[i].startsWith("-j") ? 1 : 0;
                if (transitArguments.begindate == null) {
                    transitArguments.begindate = (n != 0 ? "j" : "") + stringArray[i].substring(2);
                    continue;
                }
                if (transitArguments.enddate == null) {
                    transitArguments.enddate = (n != 0 ? "j" : "") + stringArray[i].substring(2);
                    continue;
                }
                throw new IllegalArgumentException("Invalid parameter combination:\nExcess -b options.\nUse option '-h' for additional help.");
            }
            if (stringArray[i].startsWith("-B") || stringArray[i].startsWith("-J")) {
                if (stringArray[i].length() < 3) {
                    throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
                }
                n = stringArray[i].startsWith("-J") ? 1 : 0;
                transitArguments.enddate = (n != 0 ? "j" : "") + stringArray[i].substring(2);
                transitArguments.duplicateTransitPoints = true;
                continue;
            }
            if (stringArray[i].startsWith("-p")) {
                if (stringArray[i].length() >= 3) {
                    transitArguments.pls1 = stringArray[i].substring(2);
                    continue;
                }
                throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
            }
            if (stringArray[i].startsWith("-o") && !stringArray[i].startsWith("-oloc")) {
                if (stringArray[i].length() >= 3) {
                    transitArguments.objects1 = stringArray[i].substring(2);
                    continue;
                }
                throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
            }
            if (stringArray[i].startsWith("-P")) {
                if (stringArray[i].length() >= 3) {
                    transitArguments.pls2 = stringArray[i].substring(2);
                    continue;
                }
                throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
            }
            if (stringArray[i].startsWith("-O")) {
                if (stringArray[i].length() >= 3) {
                    transitArguments.objects2 = stringArray[i].substring(2);
                    continue;
                }
                throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
            }
            if (stringArray[i].startsWith("-house")) {
                if (stringArray[i].length() >= 8) {
                    transitArguments.htopoS = stringArray[i].substring(6);
                    continue;
                }
                throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 6));
            }
            if (stringArray[i].startsWith("-f")) {
                if (stringArray[i].length() > 2) {
                    transitArguments.outputFormat = stringArray[i].substring(2);
                    transitArguments.outputFormatIsSet = true;
                    continue;
                }
                throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
            }
            if (stringArray[i].equals("-cv")) {
                transitArguments.convert = true;
                continue;
            }
            if (stringArray[i].equals("-locales")) {
                String[] stringArray2 = this.el.getLocales();
                for (int j = 0; j < stringArray2.length; ++j) {
                    System.out.println(stringArray2[j]);
                }
                return null;
            }
            if (stringArray[i].startsWith("-loc")) {
                this.locale = stringArray[i].substring(4);
                n = this.locale.indexOf("24");
                if (n >= 0) {
                    this.force24hSystem = true;
                    this.locale = this.locale.substring(0, n) + this.locale.substring(n + 2);
                }
                if (!this.locale.equals("swiss")) continue;
                this.locale = "de_DE";
                this.Nlocale = "en_US";
                this.nlocale = "en_US";
                continue;
            }
            if (stringArray[i].startsWith("-iloc")) {
                this.Nlocale = stringArray[i].substring(5);
                n = this.Nlocale.indexOf("24");
                if (n >= 0) {
                    this.force24hSystem = true;
                    this.Nlocale = this.Nlocale.substring(0, n) + this.Nlocale.substring(n + 2);
                }
                this.Dlocale = this.Nlocale;
                continue;
            }
            if (stringArray[i].startsWith("-Dloc")) {
                this.Dlocale = stringArray[i].substring(5);
                n = this.Dlocale.indexOf("24");
                if (n < 0) continue;
                this.force24hSystem = true;
                this.Dlocale = this.Dlocale.substring(0, n) + this.Dlocale.substring(n + 2);
                continue;
            }
            if (stringArray[i].startsWith("-Nloc")) {
                this.Nlocale = stringArray[i].substring(5);
                n = this.Nlocale.indexOf("24");
                if (n < 0) continue;
                this.force24hSystem = true;
                this.Nlocale = this.Nlocale.substring(0, n) + this.Nlocale.substring(n + 2);
                continue;
            }
            if (stringArray[i].startsWith("-oloc")) {
                this.dlocale = stringArray[i].substring(5);
                n = this.dlocale.indexOf("24");
                if (n >= 0) {
                    this.force24hSystem = true;
                    this.dlocale = this.dlocale.substring(0, n) + this.dlocale.substring(n + 2);
                }
                this.nlocale = this.dlocale;
                continue;
            }
            if (stringArray[i].startsWith("-dloc")) {
                this.dlocale = stringArray[i].substring(5);
                n = this.dlocale.indexOf("24");
                if (n < 0) continue;
                this.force24hSystem = true;
                this.dlocale = this.dlocale.substring(0, n) + this.dlocale.substring(n + 2);
                continue;
            }
            if (stringArray[i].startsWith("-nloc")) {
                this.nlocale = stringArray[i].substring(5);
                n = this.nlocale.indexOf("24");
                if (n < 0) continue;
                this.force24hSystem = true;
                this.nlocale = this.nlocale.substring(0, n) + this.nlocale.substring(n + 2);
                continue;
            }
            if (stringArray[i].startsWith("-n")) {
                try {
                    transitArguments.count = Integer.parseInt(stringArray[i].substring(2));
                    transitArguments.countIsSet = true;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
                }
            }
            if (stringArray[i].startsWith("-N")) {
                try {
                    transitArguments.count = Integer.parseInt(stringArray[i].substring(2));
                    transitArguments.duplicateTransitPoints = true;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(this.invalidArgument(stringArray[i], 2));
                }
            }
            if (stringArray[i].startsWith("-rf") || stringArray[i].startsWith("-random_factors")) {
                string = stringArray[i];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized option '" + stringArray[i] + "'");
        }
        TransitArguments transitArguments2 = this.initArgs(transitArguments);
        if (string != null) {
            n = string.startsWith("-rf") ? 3 : 15;
            String string2 = string.substring(n).replace(this.numIFracSeparator, ".");
            if (!string2.matches("[0-9]+/[0-9.]+")) {
                throw new IllegalArgumentException(this.invalidArgument(string, n));
            }
            this.randomCount = Integer.parseInt(string2.substring(0, string2.indexOf(47)));
            this.randomFactor = Double.parseDouble(string2.substring(string2.indexOf(47) + 1));
        }
        return transitArguments2;
    }

    TransitArguments initArgs(TransitArguments transitArguments) {
        int n;
        String string;
        Object object;
        int n2;
        String string2 = this.locale;
        this.locale = this.checkLocale(this.locale, null);
        this.Dlocale = this.checkLocale(this.Dlocale, string2, true);
        this.Nlocale = this.checkLocale(this.Nlocale, string2);
        this.dlocale = this.checkLocale(this.dlocale, string2, true);
        this.nlocale = this.checkLocale(this.nlocale, string2);
        this.dif = this.el.createLocDateTimeFormatter(this.Dlocale, true);
        this.dof = this.el.createLocDateTimeFormatter(this.dlocale, this.force24hSystem);
        this.dnof = NumberFormat.getInstance(this.el.getLocale(this.nlocale));
        this.dateFracSeparator = this.el.getDecimalSeparator(this.dnof);
        this.nnif = NumberFormat.getInstance(this.el.getLocale(this.Nlocale));
        this.nnif.setGroupingUsed(false);
        this.numIFracSeparator = this.el.getDecimalSeparator(this.nnif);
        this.nnof = NumberFormat.getInstance(this.el.getLocale(this.nlocale));
        this.nnof.setGroupingUsed(false);
        this.nnof.setMaximumFractionDigits(12);
        this.numOFracSeparator = this.el.getDecimalSeparator(this.nnof);
        this.secondsIdx = this.el.getPatternLastIdx(this.dof.toPattern(), "s", this.dof);
        transitArguments.to = this.parseTransitValString(transitArguments.transitValString);
        if (transitArguments.to == null) {
            throw new IllegalArgumentException("Specify a longitude, latitude or distance value to be transited\nwith the -lon, -lat, -dist, +lon, +lat or +dist option!\nUse the -h option for more information.");
        }
        transitArguments.beginhour = this.parseHour(transitArguments.sBeginhour);
        if (transitArguments.endTimeIsSet) {
            transitArguments.endhour = this.parseHour(transitArguments.sEndhour);
        } else {
            transitArguments.endhour = transitArguments.beginhour;
            transitArguments.isUT = transitArguments.isUt;
            transitArguments.isLT = transitArguments.isLt;
        }
        String string3 = transitArguments.outputFormat;
        boolean bl = transitArguments.outputFormat.startsWith("+");
        transitArguments.varyingTransitPoints = transitArguments.to.offset != 0.0;
        transitArguments.duplicateTransitPoints &= transitArguments.varyingTransitPoints;
        if (!transitArguments.outputFormatIsSet || bl) {
            transitArguments.outputFormat = transitArguments.convert ? "jdt" : (transitArguments.varyingTransitPoints || transitArguments.to.values.length > 1 ? "vdt" : "dt");
        }
        if (bl) {
            transitArguments.outputFormat = transitArguments.outputFormat + string3.substring(1);
        }
        transitArguments.sde1 = this.makeDate(transitArguments.begindate, transitArguments.beginhour, transitArguments.isUt, transitArguments.isLt, this.Dlocale);
        transitArguments.sde2 = this.makeDate(transitArguments.enddate, transitArguments.endhour, transitArguments.isUT, transitArguments.isLT, this.Dlocale);
        if (transitArguments.sde1 == null) {
            throw new IllegalArgumentException("Specify a valid date with the -b option!\nUse the -h or -hdate option for more information.");
        }
        if (transitArguments.enddate != null && transitArguments.sde2 == null) {
            throw new IllegalArgumentException("Specify a valid date with the -b / -B option!\nUse the -h or -hdate option for more information.");
        }
        if (transitArguments.convert) {
            String string4 = "npP";
            for (int i = 0; i < string4.length(); ++i) {
                char c = string4.charAt(i);
                int n3 = transitArguments.outputFormat.indexOf(c);
                while (n3 >= 0) {
                    System.out.println("Info: ignoring output format character '" + c + "' on date conversions.");
                    transitArguments.outputFormat = transitArguments.outputFormat.substring(0, n3) + transitArguments.outputFormat.substring(n3 + 1);
                    n3 = transitArguments.outputFormat.indexOf(c);
                }
            }
            if (transitArguments.begindate == null) {
                throw new IllegalArgumentException("Specify a date with the -b option!\nUse the -h option for more information.");
            }
            if (transitArguments.enddate != null || !"".equals(transitArguments.sEndhour)) {
                System.err.println("Warning: Ignoring a second date on -cv option.");
            }
            if (transitArguments.back) {
                System.err.println("Warning: Ignoring option -r with -cv.");
            }
            if (transitArguments.calcSpeed) {
                System.err.println("Warning: Ignoring option -s with -cv.");
            }
            if (transitArguments.sidmode != -1) {
                System.err.println("Warning: Ignoring option -sid... with -cv.");
            }
            if (transitArguments.pl1 != -2 || transitArguments.pl2 != -2) {
                System.err.println("Warning: Ignoring options -p... / -P... options with -cv.");
            }
            if (transitArguments.countIsSet) {
                System.err.println("Warning: Ignoring options -n... / -N... with -cv.");
            }
            return transitArguments;
        }
        if (transitArguments.to.values.length > 1 && transitArguments.to.idxOffset == 0) {
            this.bubbleSort(transitArguments.to.values);
        }
        if (transitArguments.topoS != null) {
            if (transitArguments.topoS.length() == 0) {
                transitArguments.topoS = "8" + this.numIFracSeparator + "55;47" + this.numIFracSeparator + "38;400";
            }
            try {
                int n4 = 0;
                for (int i = 0; i < transitArguments.topoS.length(); ++i) {
                    if (Character.isDigit(transitArguments.topoS.charAt(i)) || (n2 = transitArguments.topoS.charAt(i)) == 45 || n2 == 43 || this.numIFracSeparator.equals("" + (char)n2)) continue;
                    transitArguments.topoS = transitArguments.topoS.substring(0, i) + ";" + transitArguments.topoS.substring(i + 1);
                    ++n4;
                }
                if (n4 != 2) {
                    throw new IllegalArgumentException(this.invalidArgument("-topo" + transitArguments.topoS, 5, this.Nlocale));
                }
                object = transitArguments.topoS;
                transitArguments.top_lon = this.nnif.parse(((String)object).substring(0, ((String)object).indexOf(59))).doubleValue();
                object = ((String)object).substring(((String)object).indexOf(59) + 1);
                transitArguments.top_lat = this.nnif.parse(((String)object).substring(0, ((String)object).indexOf(59))).doubleValue();
                object = ((String)object).substring(((String)object).indexOf(59) + 1);
                transitArguments.top_elev = this.nnif.parse((String)object).doubleValue();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(this.invalidArgument("-topo" + transitArguments.topoS, 5, this.Nlocale));
            }
        }
        if (transitArguments.htopoS != null && transitArguments.objects1 == null && transitArguments.objects2 == null) {
            throw new IllegalArgumentException("-house is a house object parameter and cannot\nbe used on pure planet transit calculations.\nUse the -h option for more information.");
        }
        if (transitArguments.htopoS != null) {
            try {
                String[] stringArray = transitArguments.htopoS.split("[^0-9a-zA-Z" + this.numIFracSeparator + "]");
                if (stringArray.length != 3 || stringArray[2].length() != 1) {
                    throw new NumberFormatException();
                }
                transitArguments.house_lon = Double.parseDouble(stringArray[0]);
                transitArguments.house_lat = Double.parseDouble(stringArray[1]);
                transitArguments.hsys = stringArray[2].toUpperCase().charAt(0);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Expecting -houselon,lat,H with 'H' as the character\nof the house system. lon, lat have to be numbers.\nUse the -h option for more information.");
            }
        }
        if (transitArguments.sidmode != -1) {
            transitArguments.house_flags = 65536;
        }
        transitArguments.iflag = transitArguments.iflag & 0xFFFFFFF8 | transitArguments.whicheph;
        String string5 = System.getProperties().getProperty("user.dir");
        if (transitArguments.ephepath.length() > 0) {
            this.sw.swe_set_ephe_path(transitArguments.ephepath);
        } else if (this.make_ephemeris_path(transitArguments.iflag, string5) == -1) {
            transitArguments.iflag = transitArguments.iflag & 0xFFFFFFF8 | 4;
            transitArguments.whicheph = 4;
        }
        if ((transitArguments.whicheph & 1) != 0) {
            this.sw.swe_set_jpl_file(transitArguments.fname);
        }
        if (transitArguments.pls1 == null && transitArguments.objects1 == null) {
            throw new IllegalArgumentException("Specify one or more planets or other objects with the -p option\nor ask for a house- or ascendant transit with -o...!\nUse the -h option for more information.");
        }
        if (transitArguments.pls1 != null && transitArguments.objects1 != null || transitArguments.pls2 != null && transitArguments.objects2 != null) {
            throw new IllegalArgumentException("Use -p -O or -o -P for relative transits over a planet\nand a house object (mind the capitalization).\n");
        }
        if (transitArguments.objects1 != null && transitArguments.objects2 != null) {
            throw new IllegalArgumentException("You may search for transits of house objects over\nplanets, but not for house transits over other house\nobjects.");
        }
        if (transitArguments.begindate == null) {
            throw new IllegalArgumentException("Specify a (starting) date with the -b option!\nUse the -h option for more information.");
        }
        if (transitArguments.to.offset != 0.0 && transitArguments.to.values.length != 1) {
            throw new IllegalArgumentException("Specify one or more transit values separated by\nthe \"/\" character, OR(!!!) give an offset to a\nstart value, but not both.\nExamples:\n  ... -lon30+10 ...\n  ... -lat0/-0.3/0.3 ...\nUse the -h option for more information.");
        }
        if ((transitArguments.objects1 != null || transitArguments.objects2 != null) && transitArguments.htopoS == null) {
            throw new IllegalArgumentException("Longitude, latitude, and house system for the house\nobject calculation missing.\nUse -house<lon>,<lat>,<house system> to add this info.");
        }
        if (Double.isInfinite(transitArguments.endhour)) {
            transitArguments.endhour = transitArguments.beginhour;
            transitArguments.isUT = transitArguments.isUt;
            transitArguments.isLT = transitArguments.isLt;
        }
        transitArguments.cflag = transitArguments.iflag;
        if (transitArguments.to.idxOffset == 0) {
            transitArguments.iflag |= 0x20000;
        } else if (transitArguments.to.idxOffset == 1) {
            transitArguments.iflag |= 0x40000;
        } else if (transitArguments.to.idxOffset == 2) {
            transitArguments.iflag |= 0x80000;
        }
        if (transitArguments.calcSpeed) {
            transitArguments.iflag |= 0x100000;
            transitArguments.to.idxOffset += 3;
        }
        if (transitArguments.yogaTransit) {
            transitArguments.iflag |= 0x200000;
        }
        if (transitArguments.partileStart) {
            transitArguments.iflag = transitArguments.partileEnd ? (transitArguments.iflag |= 0xC00000) : (transitArguments.iflag |= 0x400000);
        } else if (transitArguments.partileEnd) {
            transitArguments.iflag |= 0x800000;
        }
        if (transitArguments.sde2 != null && (!transitArguments.back && transitArguments.sde1.getJulDay() > transitArguments.sde2.getJulDay() || transitArguments.back && transitArguments.sde1.getJulDay() < transitArguments.sde2.getJulDay())) {
            object = transitArguments.sde1;
            transitArguments.sde1 = transitArguments.sde2;
            transitArguments.sde2 = object;
        }
        if (transitArguments.pls2 == null && transitArguments.objects2 == null && transitArguments.outputFormat.indexOf(80) >= 0) {
            System.out.println("Info: ignoring output format character 'P' on non-relative transits.");
        }
        boolean bl2 = false;
        if (transitArguments.enddate != null && transitArguments.countIsSet) {
            bl2 = true;
        }
        if (bl2) {
            throw new IllegalArgumentException("Invalid parameter combination.\n\n  You can calculate several kinds of transits:\n\n    - When do planets transit a certain longitude,\n      latitude or distance:\n         -p.. -b... -lon... [other options]\n         -p.. -b... -lat... [other options]\n         -p.. -b... -dist... [other options]\n    - When do planets transit a certain speed in\n      longitude, latitude or distance:\n         -p.. -b... -s -lon... [other options]\n         -p.. -b... -s -lat... [other options]\n         -p.. -b... -s -dist... [other options]\n    - When do planets transit other planet's\n      longitude, latitude or distance (or speed with -s):\n         -p.. -P.. -b... -lon... [other options])\n         -p.. -P.. -b... -lat... [other options])\n         -p.. -P.. -b... -dist... [other options])\n    - When does the SUM (==Yoga) of two planet's positions\n      (or speeds with -s option) reach a certain value:\n         -p.. -P.. -b... +lon... [other options])\n         -p.. -P.. -b... +lat... [other options])\n         -p.. -P.. -b... +dist... [other options])\n    - When do house objects (house cusps, ascendant\n      et. al.) transit a certain longitude:\n         -o.. -b... -lon... [other options]\n    - When do house objects transit other planet's\n      longitude or vice versa:\n         -p.. -O.. -b... -lon... [other options])\n         -o.. -P.. -b... -lon... [other options])\n    - When do two planets have partile aspects to each other:\n         -p.. -P.. -b... -partile... [other options])\n    - When do two planets lose partile aspect status\n      to each other:\n         -p.. -P.. -b... -nonpartile... [other options])\n    - When do two planet change their partile aspect status\n      to each other:\n         -p.. -P.. -b... +partile... [other options])\n\n    Other options:\n    - List a fixed number of consecutive transits:\n         [base options] -n...\n         [base options] -N...\n    - List all transits in a date range by giving a second date:\n         [base options] -b... -b...\n         [base options] -b... -B...\n    - Give an exact starting and / or end time:\n         [base options] -et... (or: -t...)\n         [base options] -ut...\n         [base options] -lt...\n         [base options] -ET... (or: -T...)\n         [base options] -UT...\n         [base options] -LT...\n    - Search backwards (\"reverse\"):\n         [base options] -r\n    - Calculate in the sidereal zodiac:\n         [base options] -sid.\n    - Calculate true positions instead of apparent positions:\n         [base options] -true.\n    - Calculate topocentric or heliocentric instead of geocentric:\n         [base options] -topo...\n         [base options] -hel...\n    - Calculate rectascension or declination instead of longitude or latitude:\n         [base options] -equ...\n    - Modify the input parsing:\n         [base options] -loc... (input parsing AND output formatting)\n         [base options] -iloc...\n         [base options] -Dloc[...]\n         [base options] -Nloc[...]\n    - Modify the output and output formatting:\n         [base options] -head, -q\n         [base options] -f...\n         [base options] -loc... (input parsing AND output formatting)\n         [base options] -oloc...\n         [base options] -dloc[...]\n         [base options] -nloc[...]\n    - Modify calculation precision:\n         [base options] -rf...\n    - Give the path to the ephemeris data files:\n         [base options] -edir...\n    - List all availables Locales for use with -loc etc. options:\n         -locales\n    - Convert between Julian day numbers and dates and vice versa:\n         -b... -cv [other options]\n\nUse option '-h' for additional help.");
        }
        transitArguments.pls2_cnt = 0;
        transitArguments.pls1_cnt = 0;
        if (transitArguments.pls1 != null) {
            for (n2 = 0; n2 < transitArguments.pls1.length(); ++n2) {
                string = transitArguments.pls1.substring(n2);
                n = this.string_to_ipl(string);
                if (n > 10000) {
                    n2 += ("//" + (n - 10000)).length() - 1;
                }
                if (n == -1) {
                    throw new IllegalArgumentException("Unsupported planet " + (Character.isDigit(string.charAt(n2)) ? "number" : "character") + ": '" + string + "'.\nCheck for valid planets with the '-h' option.");
                }
                if (n == -2) {
                    throw new IllegalArgumentException("Syntax error on -p option: check for balanced /.../ parameters on asteroids.'.\nCheck for valid planets with the '-h' option.");
                }
                ++transitArguments.pls1_cnt;
            }
        }
        if (transitArguments.pls2 != null) {
            for (n2 = 0; n2 < transitArguments.pls2.length(); ++n2) {
                string = transitArguments.pls2.substring(n2);
                n = this.string_to_ipl(string);
                if (n > 10000) {
                    n2 += ("//" + (n - 10000)).length() - 1;
                }
                if (n == -1) {
                    throw new IllegalArgumentException("Unsupported planet " + (Character.isDigit(string.charAt(n2)) ? "number" : "character") + ": '" + string + "'.\nCheck for valid planets with the '-h' option.");
                }
                if (n == -2) {
                    throw new IllegalArgumentException("Syntax error on -p option: check for balanced /.../ parameters on asteroids.'.\nCheck for valid planets with the '-h' option.");
                }
                ++transitArguments.pls2_cnt;
            }
        }
        transitArguments.mpp1 = transitArguments.pls1_cnt > 1;
        boolean bl3 = transitArguments.mpp2 = transitArguments.pls2_cnt > 1;
        if (transitArguments.objects1 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(transitArguments.objects1.replace(',', '/'), "/");
            boolean bl4 = transitArguments.mpo1 = stringTokenizer.countTokens() > 1;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (this.isValidHouseObject(string)) continue;
                throw new IllegalArgumentException("Unknown house or ascendent object '" + string + "' in '-o" + transitArguments.objects1 + "'.\nCheck for valid objects with the '-h' option.");
            }
            transitArguments.objects1 = transitArguments.objects1.replace(',', '/');
            if (transitArguments.hsys == ' ') {
                throw new IllegalArgumentException("Missing house system, use -house parameter for this.\nCheck for valid house systems with the '-h' option.");
            }
            if (transitArguments.hsys != 'B' && transitArguments.hsys != 'C' && transitArguments.hsys != 'E' && transitArguments.hsys != 'H' && transitArguments.hsys != 'K' && transitArguments.hsys != 'M' && transitArguments.hsys != 'O' && transitArguments.hsys != 'P' && transitArguments.hsys != 'R' && transitArguments.hsys != 'T' && transitArguments.hsys != 'U' && transitArguments.hsys != 'V' && transitArguments.hsys != 'W' && transitArguments.hsys != 'X') {
                throw new IllegalArgumentException("Invalid house system '" + transitArguments.hsys + "'.\nCheck for valid house systems with the '-h' option.");
            }
        } else if (transitArguments.objects2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(transitArguments.objects2.replace(',', '/'), "/");
            boolean bl5 = transitArguments.mpo2 = stringTokenizer.countTokens() > 1;
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (this.isValidHouseObject(string)) continue;
                throw new IllegalArgumentException("Unknown house or ascendent object '" + string + "' in '-O" + transitArguments.objects2 + "'.\nCheck for valid objects with the '-h' option.");
            }
            transitArguments.objects2 = transitArguments.objects2.replace(',', '/');
            if (transitArguments.hsys == ' ') {
                throw new IllegalArgumentException("Missing house system, use -hsys parameter for this.\nCheck for valid house systems with the '-h' option.");
            }
            if (transitArguments.hsys != 'B' && transitArguments.hsys != 'C' && transitArguments.hsys != 'E' && transitArguments.hsys != 'H' && transitArguments.hsys != 'K' && transitArguments.hsys != 'M' && transitArguments.hsys != 'O' && transitArguments.hsys != 'P' && transitArguments.hsys != 'R' && transitArguments.hsys != 'T' && transitArguments.hsys != 'U' && transitArguments.hsys != 'V' && transitArguments.hsys != 'W' && transitArguments.hsys != 'X') {
                throw new IllegalArgumentException("Invalid house system '" + transitArguments.hsys + "'.\nCheck for valid house systems with the '-h' option.");
            }
        }
        if ((transitArguments.mpp1 || transitArguments.mpp2 || transitArguments.mpo1 || transitArguments.mpo2) && transitArguments.outputFormat.indexOf("n") < 0 && (!transitArguments.outputFormatIsSet || bl)) {
            transitArguments.outputFormat = "n" + transitArguments.outputFormat;
        }
        if (transitArguments.yogaTransit && (transitArguments.pls2 == null || transitArguments.objects1 != null || transitArguments.objects2 != null)) {
            throw new IllegalArgumentException("Yoga transits can only be computed over two planets.\nUse '-h' option for valid parameter combinations.");
        }
        if ((transitArguments.partileStart || transitArguments.partileEnd) && transitArguments.pls2 == null) {
            throw new IllegalArgumentException("Partile transits can only be computed over two planets.\nUse '-h' option for valid parameter combinations.");
        }
        if (transitArguments.calcSpeed && (transitArguments.objects1 != null || transitArguments.objects2 != null)) {
            throw new IllegalArgumentException("Speed transits aren't available for transits over house\nobjects so far.");
        }
        if (!(transitArguments.transitValString.startsWith("-lon") || transitArguments.objects1 == null && transitArguments.objects2 == null)) {
            throw new IllegalArgumentException("Only transits over a longitudinal value are available for\ntransits over house objects.");
        }
        if (transitArguments.equatorial && (transitArguments.transitValString.startsWith("-dist") || transitArguments.transitValString.startsWith("+dist"))) {
            transitArguments.equatorial = false;
            transitArguments.iflag &= 0xFFFFF7FF;
        }
        this.sw.swe_set_topo(transitArguments.top_lon, transitArguments.top_lat, transitArguments.top_elev);
        if (transitArguments.sidmode >= 0) {
            this.sw.swe_set_sid_mode(transitArguments.sidmode, 0.0, 0.0);
            transitArguments.iflag |= 0x10000;
        }
        transitArguments.tjde1 = transitArguments.sde1.getJulDay();
        if (transitArguments.sde2 != null) {
            transitArguments.tjde2 = transitArguments.sde2.getJulDay();
        }
        double d = transitArguments.jdET2 = transitArguments.back ? -1.7976931348623157E308 : Double.MAX_VALUE;
        if (transitArguments.sde2 != null) {
            transitArguments.jdET2 = transitArguments.sde2.getJulDay();
        }
        return transitArguments;
    }

    void writeCmdLine(String[] stringArray, boolean bl) {
        if (bl) {
            for (int i = 0; i < stringArray.length; ++i) {
                System.out.print(stringArray[i] + " ");
            }
            System.out.println();
        }
    }

    boolean isValidHouseObject(String string) {
        if (string.startsWith("house")) {
            try {
                int n = Integer.parseInt(string.substring(5));
                return n >= 1 && n <= 12;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return "asc".equals(string = string.toLowerCase()) || "mc".equals(string) || "armc".equals(string) || "vertex".equals(string) || "equasc".equals(string) || "coasc1".equals(string) || "coasc2".equals(string) || "polasc".equals(string);
    }

    void writeHeader(TransitArguments transitArguments) {
        Object object;
        if (!transitArguments.withHeader) {
            return;
        }
        String string = "";
        if (transitArguments.sidmode >= 0) {
            System.out.print("Ayanamsha");
            if (transitArguments.enddate == null) {
                System.out.print(":         " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "") + this.doubleToDMS(this.sw.swe_get_ayanamsa(transitArguments.tjde1)));
            } else {
                System.out.println("\n on starting date: " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "") + this.doubleToDMS(this.sw.swe_get_ayanamsa(transitArguments.tjde1)));
                System.out.println(" on end date:      " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "") + this.doubleToDMS(this.sw.swe_get_ayanamsa(transitArguments.tjde2)));
            }
        }
        System.out.println();
        if (transitArguments.isLt) {
            System.out.println("Using localtime:   UTC+" + this.nnof.format(this.tzOffset * 24.0) + "h");
        }
        System.out.println("Starting date:     " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "") + this.jdToDate(transitArguments.sde1, transitArguments.isUt, transitArguments.isLt, 0) + (transitArguments.isLt ? " LT" : (transitArguments.isUT ? " UT" : " ET")));
        if (transitArguments.enddate != null) {
            System.out.println("End date:          " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "") + this.jdToDate(transitArguments.sde2, transitArguments.isUT, transitArguments.isLT, 0) + (transitArguments.isLT ? " LT" : (transitArguments.isUT ? " UT" : " ET")));
        }
        if (!(transitArguments.yogaTransit || transitArguments.partileStart || transitArguments.partileEnd)) {
            if (transitArguments.pls1 != null) {
                System.out.println("Transiting planet" + (transitArguments.mpp1 ? "s" : "") + ": " + this.limitLineLength(this.getPlanetNames(transitArguments.pls1, " or "), 70, "                    "));
            } else if (transitArguments.objects1 != null) {
                object = " at " + this.doubleToDMS(SMath.abs(transitArguments.house_lon)) + (transitArguments.house_lon < 0.0 ? "W" : "E") + "/" + this.doubleToDMS(SMath.abs(transitArguments.house_lat)) + (transitArguments.house_lat < 0.0 ? "S" : "N") + " in " + this.sw.swe_house_name(transitArguments.hsys) + " house system";
                System.out.println("Transiting object" + (transitArguments.mpo1 ? "s" : "") + ": " + this.limitLineLength(this.getHouseobjectNames(transitArguments.objects1, " or ") + (String)object, 70, "                    "));
            }
        }
        System.out.print("Reference point:   " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : ""));
        if (transitArguments.calcSpeed) {
            object = new ObjFormatter(transitArguments.to.values, this.swed.ODEGREE_STRING + "/day", this.nnof);
            if (transitArguments.pls2 != null) {
                string = transitArguments.yogaTransit ? "combined " + (transitArguments.helio ? "heliocentric " : "") + " speed of " + this.group((ObjFormatter)object, transitArguments.to.values.length, " or ") + " of " + (transitArguments.mpp1 ? "the planets " : "planet ") + this.getPlanetNames(transitArguments.pls1, " or ") + (transitArguments.mpp1 || transitArguments.mpo1 ? " with " : " and ") + (transitArguments.mpp2 ? "any of " : "") + this.getPlanetNames(transitArguments.pls2, ", ") : (transitArguments.helio ? "heliocentric " : "") + "speed of " + this.group((ObjFormatter)object, transitArguments.to.values.length, " or ") + " " + (transitArguments.to.values.length != 1 ? "higher than" : (transitArguments.to.values[0] < 0.0 ? "lower than" : "higher than")) + " speed of " + this.getPlanetNames(transitArguments.pls2, " or ");
                string = string + " in " + (transitArguments.equatorial ? (transitArguments.to.idxOffset == 0 ? "right ascension" : "declination") : (transitArguments.to.idxOffset == 3 ? "longitudinal" : (transitArguments.to.idxOffset == 4 ? "latitudinal" : "distance"))) + " direction";
                if (transitArguments.varyingTransitPoints) {
                    string = string + " with varying transit points";
                }
                System.out.println(this.limitLineLength(string, 70, "                   " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "")));
            } else {
                string = this.group((ObjFormatter)object, transitArguments.to.values.length, " or ") + " in " + (transitArguments.helio ? "heliocentric " : "") + (transitArguments.equatorial ? (transitArguments.to.idxOffset == 0 ? "right ascension" : "declination") : (transitArguments.to.idxOffset == 3 ? "longitudinal" : (transitArguments.to.idxOffset == 4 ? "latitudinal" : "distance"))) + " direction" + (transitArguments.sidmode >= 0 ? " in the sidereal zodiac" : "");
                if (transitArguments.varyingTransitPoints) {
                    string = string + " with varying transit points";
                }
                System.out.println(this.limitLineLength(string, 70, "                   " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "")));
            }
            System.out.println();
            if ((transitArguments.iflag & 0x8000) != 0) {
                System.out.println("Topographic pos.:  " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "") + this.doubleToDMS(SMath.abs(transitArguments.top_lon)) + (transitArguments.top_lon < 0.0 ? "W" : "E") + "/" + this.doubleToDMS(SMath.abs(transitArguments.top_lat)) + (transitArguments.top_lat < 0.0 ? "S" : "N") + "/" + this.nnof.format(transitArguments.top_elev) + "m");
            }
        } else {
            object = new ObjFormatter(transitArguments.to.values, transitArguments.to.idxOffset == 2 ? " AU" : "" + this.swed.ODEGREE_STRING, this.nnof);
            if (transitArguments.pls2 != null) {
                if (transitArguments.yogaTransit) {
                    string = "combined " + (transitArguments.helio ? "heliocentric " : "") + (transitArguments.equatorial ? (transitArguments.to.idxOffset == 0 ? "right ascension" : "declination") : (transitArguments.to.idxOffset == 0 ? "longitudinal" : (transitArguments.to.idxOffset == 1 ? "latitudinal" : "distance"))) + " positions of " + (transitArguments.mpp1 ? "the planets " : "planet ") + this.getPlanetNames(transitArguments.pls1, " or ") + (transitArguments.mpp1 ? " with " : " and ") + (transitArguments.mpp2 ? "any of " : "") + this.getPlanetNames(transitArguments.pls2, ", ") + " reach " + this.group((ObjFormatter)object, transitArguments.to.values.length, " or ") + (transitArguments.sidmode >= 0 ? " in the sidereal zodiac" : "");
                } else if (transitArguments.partileStart) {
                    string = transitArguments.partileEnd ? "starting and ending partile aspect of " + this.getPlanetNames(transitArguments.pls1, ", ") + " with " + this.getPlanetNames(transitArguments.pls2, ", ") : "starting partile aspect of " + this.getPlanetNames(transitArguments.pls1, ", ") + " with " + this.getPlanetNames(transitArguments.pls2, ", ");
                } else if (transitArguments.partileEnd) {
                    string = "ending partile aspect of " + this.getPlanetNames(transitArguments.pls1, ", ") + " with " + this.getPlanetNames(transitArguments.pls2, ", ");
                } else {
                    string = this.group((ObjFormatter)object, transitArguments.to.values.length, " or ") + " ";
                    string = transitArguments.to.idxOffset == 2 ? string + "farther away than " + this.getPlanetNames(transitArguments.pls2, " or ") + (transitArguments.helio ? " (heliocentric)" : "") : string + (transitArguments.to.values.length != 1 ? "ahead of" : (transitArguments.to.values[0] < 0.0 ? "before" : "after")) + " " + (transitArguments.helio ? "heliocentric " : "") + (transitArguments.equatorial ? (transitArguments.to.idxOffset == 0 ? "right ascension" : "declination") : (transitArguments.to.idxOffset == 0 ? "longitudinal" : (transitArguments.to.idxOffset == 1 ? "latitudinal" : "distance"))) + " position of " + this.getPlanetNames(transitArguments.pls2, " or ");
                }
            } else if (transitArguments.objects2 != null) {
                String string2 = " at " + this.doubleToDMS(SMath.abs(transitArguments.house_lon)) + (transitArguments.house_lon < 0.0 ? "W" : "E") + "/" + this.doubleToDMS(SMath.abs(transitArguments.house_lat)) + (transitArguments.house_lat < 0.0 ? "S" : "N") + " in " + this.sw.swe_house_name(transitArguments.hsys) + " house system";
                string = this.group((ObjFormatter)object, transitArguments.to.values.length, " or ") + " ";
                string = transitArguments.to.idxOffset == 2 ? string + "farther away than " + this.getHouseobjectNames(transitArguments.objects2, " or ") + (transitArguments.helio ? " (heliocentric)" : "") : string + (transitArguments.to.values.length != 1 ? "ahead of" : (transitArguments.to.values[0] < 0.0 ? "before" : "after")) + " " + (transitArguments.helio ? "heliocentric " : "") + (transitArguments.equatorial ? (transitArguments.to.idxOffset == 0 ? "right ascension" : "declination") : (transitArguments.to.idxOffset == 0 ? "longitudinal" : (transitArguments.to.idxOffset == 1 ? "latitudinal" : "distance"))) + " position of " + this.getHouseobjectNames(transitArguments.objects2, " or ") + string2;
            } else {
                string = this.group((ObjFormatter)object, transitArguments.to.values.length, " or ") + " " + (transitArguments.to.idxOffset == 2 ? "of " : "") + (transitArguments.helio ? "heliocentric " : "") + (transitArguments.equatorial ? (transitArguments.to.idxOffset == 0 ? "right ascension" : "declination") : (transitArguments.to.idxOffset == 0 ? "longitude" : (transitArguments.to.idxOffset == 1 ? "latitude" : "distance"))) + (transitArguments.sidmode >= 0 ? " in the sidereal zodiac" : "");
            }
            if (transitArguments.varyingTransitPoints) {
                string = string + " with varying transit points";
            }
            System.out.println(this.limitLineLength(string, 70, "                   " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "")));
            if ((transitArguments.iflag & 0x8000) != 0) {
                if (transitArguments.objects1 != null) {
                    System.out.println("Topographic pos.:  " + (transitArguments.mpp1 ? " " : "") + this.doubleToDMS(SMath.abs(transitArguments.house_lon)) + (transitArguments.house_lon < 0.0 ? "W" : "E") + "/" + this.doubleToDMS(SMath.abs(transitArguments.house_lat)) + (transitArguments.house_lat < 0.0 ? "S" : "N") + "/" + this.nnof.format(transitArguments.top_elev) + "m");
                } else {
                    System.out.println("Topographic pos.:  " + (transitArguments.mpp1 || transitArguments.mpo1 ? " " : "") + this.doubleToDMS(SMath.abs(transitArguments.top_lon)) + (transitArguments.top_lon < 0.0 ? "W" : "E") + "/" + this.doubleToDMS(SMath.abs(transitArguments.top_lat)) + (transitArguments.top_lat < 0.0 ? "S" : "N") + "/" + this.nnof.format(transitArguments.top_elev) + "m");
                }
            }
        }
        if (transitArguments.partileEnd && transitArguments.outputFormat.indexOf("p") >= 0) {
            string = "Attention: calculated values may appear to be incorrect due to rounding!";
            System.out.println(string);
        }
        System.out.println();
    }

    TransitCalculator[] initCalculators(TransitArguments transitArguments) throws IllegalArgumentException {
        TransitCalculator[] transitCalculatorArray = null;
        transitArguments.idxDuplicates = Integer.MAX_VALUE;
        if (transitArguments.pls1 != null && transitArguments.pls2 != null) {
            int n;
            int n2;
            String string = this.getPlanetCombinations(transitArguments.pls1, transitArguments.pls2);
            if ("@".equals(string)) {
                throw new IllegalArgumentException("Planets for relative, yoga or partile transits have to be different!\nUse the -h option for more information.");
            }
            transitArguments.idxDuplicates = string.indexOf(64);
            string = string.substring(0, transitArguments.idxDuplicates) + string.substring(transitArguments.idxDuplicates + 1);
            transitArguments.pls_cnt = 0;
            boolean bl = false;
            for (n2 = 0; n2 < string.length(); ++n2) {
                n = string.charAt(n2);
                if (!bl) {
                    ++transitArguments.pls_cnt;
                }
                if (string.charAt(n2) != '/') continue;
                bl = !bl;
            }
            transitArguments.pls_cnt /= 2;
            transitArguments.idxDuplicates /= 2;
            transitCalculatorArray = new TransitCalculator[transitArguments.pls_cnt];
            transitArguments.plNumbers = new int[transitArguments.pls_cnt][2];
            transitArguments.objNumbers = new int[transitArguments.pls_cnt][2];
            n2 = 0;
            for (n = 0; n < transitCalculatorArray.length; ++n) {
                block28: {
                    String string2;
                    String string3 = string.substring(n2, n2 + 1);
                    if ("/".equals(string3)) {
                        string3 = string.substring(n2, string.indexOf("/", n2 + 1) + 1);
                        n2 = string.indexOf("/", n2 + 1);
                    }
                    transitArguments.pl1 = this.string_to_ipl(string3);
                    if ("/".equals(string2 = string.substring(++n2, n2 + 1))) {
                        string2 = string.substring(n2, string.indexOf("/", n2 + 1) + 1);
                        n2 = string.indexOf("/", n2 + 1);
                    }
                    transitArguments.pl2 = this.string_to_ipl(string2);
                    ++n2;
                    try {
                        transitCalculatorArray[n] = this.randomCount == 0 ? new TCPlanetPlanet(this.sw, transitArguments.pl1, transitArguments.pl2, transitArguments.iflag, transitArguments.to.values[0]) : new TCPlanetPlanet(this.sw, transitArguments.pl1, transitArguments.pl2, transitArguments.iflag, transitArguments.to.values[0], this.randomCount, this.randomFactor);
                    }
                    catch (SwissephException swissephException) {
                        System.err.println(string3 + " / " + string2);
                        if (swissephException.getType() != 9) break block28;
                        System.err.println(swissephException.getMessage());
                        throw new IllegalArgumentException("Planet not found");
                    }
                }
                transitArguments.plNumbers[n][0] = transitArguments.pl1;
                transitArguments.plNumbers[n][1] = transitArguments.pl2;
                transitArguments.objNumbers[n][1] = -1000;
                transitArguments.objNumbers[n][0] = -1000;
            }
        } else if (transitArguments.pls1 != null && transitArguments.objects2 != null || transitArguments.objects1 != null && transitArguments.pls2 != null) {
            boolean bl = transitArguments.pls1 != null;
            String string = transitArguments.pls1 != null ? transitArguments.pls1 : transitArguments.pls2;
            String string4 = transitArguments.objects1 != null ? transitArguments.objects1 : transitArguments.objects2;
            String string5 = this.getHouseobjectCombinations(string, string4);
            transitArguments.obj_cnt = string5.split(" ").length;
            transitCalculatorArray = new TransitCalculator[transitArguments.obj_cnt];
            transitArguments.plNumbers = new int[transitArguments.obj_cnt][2];
            transitArguments.objNumbers = new int[transitArguments.obj_cnt][2];
            String[] stringArray = string5.split(" ");
            for (int i = 0; i < transitCalculatorArray.length; ++i) {
                int n;
                block29: {
                    int n3 = 0;
                    String string6 = stringArray[i].substring(0, 1);
                    if ("/".equals(string6)) {
                        string6 = stringArray[i].substring(0, stringArray[i].indexOf("/", 1) + 1);
                        n3 = stringArray[i].indexOf("/", 1);
                    }
                    transitArguments.pl1 = this.string_to_ipl(string6);
                    n = Integer.parseInt(stringArray[i].substring(++n3));
                    try {
                        transitCalculatorArray[i] = this.randomCount == 0 ? new TCPlanetHouse(this.sw, transitArguments.pl1, transitArguments.iflag, n, transitArguments.hsys, transitArguments.house_flags, transitArguments.house_lon, transitArguments.house_lat, transitArguments.to.values[0]) : new TCPlanetHouse(this.sw, transitArguments.pl1, transitArguments.iflag, n, transitArguments.hsys, transitArguments.house_flags, transitArguments.house_lon, transitArguments.house_lat, transitArguments.to.values[0], this.randomCount, this.randomFactor);
                    }
                    catch (SwissephException swissephException) {
                        if (swissephException.getType() != 9) break block29;
                        System.err.println(swissephException.getMessage());
                        throw new IllegalArgumentException("Planet not found");
                    }
                }
                transitArguments.plNumbers[i][0] = bl ? transitArguments.pl1 : -1;
                transitArguments.plNumbers[i][1] = bl ? -1 : transitArguments.pl1;
                transitArguments.objNumbers[i][0] = bl ? -1000 : n;
                transitArguments.objNumbers[i][1] = bl ? n : -1000;
            }
        } else if (transitArguments.objects1 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(transitArguments.objects1, "/");
            transitCalculatorArray = new TransitCalculator[stringTokenizer.countTokens()];
            transitArguments.plNumbers = new int[stringTokenizer.countTokens()][2];
            transitArguments.objNumbers = new int[stringTokenizer.countTokens()][2];
            for (int i = 0; i < transitCalculatorArray.length; ++i) {
                int n = this.getObjectFromString(stringTokenizer.nextToken());
                transitCalculatorArray[i] = new TCHouses(this.sw, n, transitArguments.hsys, transitArguments.house_lon, transitArguments.house_lat, transitArguments.house_flags, transitArguments.to.values[0]);
                transitArguments.plNumbers[i][0] = -1;
                transitArguments.plNumbers[i][1] = -1;
                transitArguments.objNumbers[i][0] = n;
                transitArguments.objNumbers[i][1] = -1;
            }
        } else {
            int n;
            transitCalculatorArray = new TransitCalculator[transitArguments.pls1_cnt];
            transitArguments.plNumbers = new int[transitArguments.pls1_cnt][2];
            transitArguments.objNumbers = new int[transitArguments.pls1_cnt][2];
            int n4 = transitArguments.pls1.indexOf(109);
            if (n4 >= 0) {
                transitArguments.pls1 = transitArguments.pls1.substring(0, n4) + transitArguments.pls1.substring(n4 + 1) + 'm';
            }
            boolean bl = false;
            for (n4 = 0; n4 < transitArguments.pls1.length(); ++n4) {
                n = transitArguments.pls1.charAt(n4);
                if (n == 47) {
                    bl = !bl;
                    continue;
                }
                if (n != 49 || bl) continue;
                transitArguments.pls1 = transitArguments.pls1.substring(0, n4) + transitArguments.pls1.substring(n4 + 1) + '1';
                break;
            }
            n = 0;
            int n5 = 0;
            while (n < transitCalculatorArray.length) {
                block30: {
                    transitArguments.pl1 = this.string_to_ipl(transitArguments.pls1.substring(n5));
                    try {
                        transitCalculatorArray[n] = this.randomCount == 0 ? new TCPlanet(this.sw, transitArguments.pl1, transitArguments.iflag, transitArguments.to.values[0]) : new TCPlanet(this.sw, transitArguments.pl1, transitArguments.iflag, transitArguments.to.values[0], this.randomCount, this.randomFactor);
                    }
                    catch (SwissephException swissephException) {
                        if (swissephException.getType() != 9) break block30;
                        System.err.println(swissephException.getMessage() + "\nSkipping planet " + transitArguments.pl1 + ".");
                        transitArguments.pls1 = this.remove_ipl(transitArguments.pls1, n5);
                        --transitArguments.pls1_cnt;
                        if (transitArguments.pls1.length() > 0) {
                            return this.initCalculators(transitArguments);
                        }
                        throw new IllegalArgumentException("No planets found");
                    }
                }
                transitArguments.plNumbers[n][0] = transitArguments.pl1;
                transitArguments.plNumbers[n][1] = -1;
                transitArguments.objNumbers[n][1] = -1000;
                transitArguments.objNumbers[n][0] = -1000;
                if (transitArguments.pl1 > 10000) {
                    n5 += ("//" + (transitArguments.pl1 - 10000)).length() - 1;
                }
                ++n;
                ++n5;
            }
        }
        transitArguments.rollover = transitCalculatorArray[0].getRollover();
        transitArguments.rolloverVal = transitCalculatorArray[0].getRolloverVal();
        if (transitArguments.rollover && transitArguments.duplicateTransitPoints) {
            transitArguments.to.offset = SMath.abs(transitArguments.to.offset) % transitArguments.rolloverVal;
        }
        return transitCalculatorArray;
    }

    int getObjectFromString(String string) {
        if ("asc".equals(string)) {
            return 0;
        }
        if ("mc".equals(string)) {
            return 1;
        }
        if ("armc".equals(string)) {
            return 2;
        }
        if ("vertex".equals(string)) {
            return 3;
        }
        if ("equasc".equals(string)) {
            return 4;
        }
        if ("coasc1".equals(string)) {
            return 5;
        }
        if ("coasc2".equals(string)) {
            return 6;
        }
        if ("polasc".equals(string)) {
            return 7;
        }
        try {
            int n = Integer.parseInt(string.substring(5));
            return -n;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    TransitResult calcNextTransit(TransitArguments transitArguments, TransitCalculator[] transitCalculatorArray) {
        TransitResult transitResult = new TransitResult();
        TransitResult transitResult2 = null;
        transitResult.jdET = transitArguments.back ? -1.7976931348623157E308 : Double.MAX_VALUE;
        transitArguments.v.jdStart = transitArguments.tjde1;
        transitArguments.v.jdEnd = transitArguments.jdET2;
        transitArguments.v.rollover = transitArguments.rollover;
        transitArguments.v.rolloverVal = transitArguments.rolloverVal;
        transitArguments.v.varyingTransitPoints = transitArguments.varyingTransitPoints;
        transitArguments.v.duplicateTransitPoints = transitArguments.duplicateTransitPoints;
        transitArguments.v.tvOffset = transitArguments.to.offset;
        transitArguments.v.back = transitArguments.back;
        transitArguments.v.tcIndex = 0;
        while (transitArguments.v.tcIndex < transitCalculatorArray.length) {
            transitArguments.v.tc = transitCalculatorArray[transitArguments.v.tcIndex];
            for (int i = 0; i < transitArguments.to.values.length; ++i) {
                transitArguments.v.transitVal = transitArguments.to.values[i];
                transitResult2 = this.calcNeighbouringTransits(transitArguments);
                if (!(transitArguments.back && transitResult2.jdET > transitResult.jdET) && (transitArguments.back || !(transitResult2.jdET < transitResult.jdET))) continue;
                transitResult.tcsNo = transitArguments.v.tcIndex;
                transitResult.transitValue = transitResult2.transitValue;
                transitResult.jdET = transitResult2.jdET;
                transitArguments.v.jdEnd = transitResult2.jdET;
                transitResult.pl1 = transitArguments.plNumbers[transitResult.tcsNo][0];
                transitResult.pl2 = transitArguments.plNumbers[transitResult.tcsNo][1];
                transitResult.obj1 = transitArguments.objNumbers[transitResult.tcsNo][0];
                transitResult.obj2 = transitArguments.objNumbers[transitResult.tcsNo][1];
            }
            ++transitArguments.v.tcIndex;
        }
        return transitResult;
    }

    void bubbleSort(Double[] doubleArray) {
        if (doubleArray.length < 2) {
            return;
        }
        boolean bl = true;
        Double d = null;
        do {
            bl = true;
            for (int i = 0; i < doubleArray.length - 1; ++i) {
                if (!(SMath.abs(doubleArray[i]) > SMath.abs(doubleArray[i + 1]))) continue;
                d = doubleArray[i + 1];
                doubleArray[i + 1] = doubleArray[i];
                doubleArray[i] = d;
                bl = false;
            }
        } while (!bl);
    }

    String getPlanetnameString(TransitArguments transitArguments, TransitResult transitResult) {
        Object object;
        int n = 9;
        if (transitArguments.pls1 != null) {
            if (transitArguments.pls1.indexOf("g") > 0 || transitArguments.pls1.indexOf("c") > 0) {
                n += 4;
            }
        } else if (transitArguments.objects1 != null) {
            object = transitArguments.objects1.toLowerCase().split(",");
            for (int i = 0; i < ((String[])object).length; ++i) {
                n = Math.max(n, SwissEph.getHouseobjectname(this.string_to_houseobject(object[i])).length());
            }
        }
        object = "";
        if (transitResult.pl1 >= 0) {
            object = this.sw.swe_get_planet_name(transitResult.pl1);
        } else if (transitResult.obj1 > -1000) {
            object = SwissEph.getHouseobjectname(transitResult.obj1);
        }
        object = ((String)object + "             ").substring(0, n);
        if (transitResult.pl2 >= 0 && transitArguments.pls2 != null) {
            n += 12;
            if (transitArguments.pls2.indexOf("g") > 0 || transitArguments.pls2.indexOf("c") > 0) {
                n += 4;
            }
            object = (String)object + " - " + this.sw.swe_get_planet_name(transitResult.pl2);
        } else if (transitResult.obj2 > -1000 && transitArguments.objects2 != null) {
            String[] stringArray = transitArguments.objects2.toLowerCase().split("/");
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                n2 = Math.max(n2, SwissEph.getHouseobjectname(this.string_to_houseobject(stringArray[i])).length());
            }
            n += n2 + 3;
            object = (String)object + " - " + SwissEph.getHouseobjectname(transitResult.obj2);
        }
        return ((String)object + "                      ").substring(0, n);
    }
}

