/*
 * Decompiled with CFR 0.152.
 */
package de.jollyday.parser.impl;

import de.jollyday.Holiday;
import de.jollyday.HolidayType;
import de.jollyday.config.Holidays;
import de.jollyday.config.RelativeToFixed;
import de.jollyday.config.When;
import de.jollyday.parser.AbstractHolidayParser;
import java.util.Set;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeToFixedParser
extends AbstractHolidayParser {
    @Override
    public void parse(int year, Set<Holiday> holidays, Holidays config) {
        for (RelativeToFixed rf : config.getRelativeToFixed()) {
            if (!this.isValid(rf, year)) continue;
            LocalDate fixed = this.calendarUtil.create(year, rf.getDate());
            if (rf.getWeekday() != null) {
                int direction;
                int day = this.xmlUtil.getWeekday(rf.getWeekday());
                int n = direction = rf.getWhen() == When.BEFORE ? -1 : 1;
                while ((fixed = fixed.plusDays(direction)).getDayOfWeek() != day) {
                }
            } else if (rf.getDays() != null) {
                fixed = fixed.plusDays(rf.getWhen() == When.BEFORE ? -rf.getDays().intValue() : rf.getDays());
            }
            HolidayType type = this.xmlUtil.getType(rf.getLocalizedType());
            holidays.add(new Holiday(fixed, rf.getDescriptionPropertiesKey(), type));
        }
    }
}

