/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.repo.PersistenceService;
import net.sf.jasperreports.repo.PersistenceUtil;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.Resource;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import net.sf.jasperreports.repo.StandardResourceInfo;
import net.sf.jasperreports.repo.StreamRepositoryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileRepositoryService
implements StreamRepositoryService {
    private static final Log log = LogFactory.getLog(FileRepositoryService.class);
    public static final String EXCEPTION_MESSAGE_KEY_NOT_IMPLEMENTED = "repo.file.not.implemented";
    private JasperReportsContext jasperReportsContext;
    private String root;
    private boolean resolveAbsolutePath;
    private volatile Path rootNormalizedPath;
    private Path rootRealPath;

    public FileRepositoryService(JasperReportsContext jasperReportsContext, String root, boolean resolveAbsolutePath) {
        this.jasperReportsContext = jasperReportsContext;
        this.root = root;
        this.resolveAbsolutePath = resolveAbsolutePath;
        this.setRootRealPath();
    }

    public void setRoot(String root) {
        this.root = root;
        this.setRootRealPath();
    }

    public String getRoot() {
        return this.root;
    }

    protected Path rootNormalizedPath() {
        Path rootPath = this.rootNormalizedPath;
        if (rootPath == null) {
            Path path = Paths.get(this.root, new String[0]);
            rootPath = this.rootNormalizedPath = path.normalize();
        }
        return rootPath;
    }

    @Override
    public InputStream getInputStream(String uri) {
        return this.getInputStream(SimpleRepositoryContext.of(this.jasperReportsContext), uri);
    }

    public File getFile(RepositoryContext context, String uri) {
        File file = null;
        if (uri != null && (file = JRResourcesUtil.resolveFile(context, uri, this::locateFile)) != null && !file.isFile()) {
            file = null;
        }
        return file;
    }

    @Override
    public InputStream getInputStream(RepositoryContext context, String uri) {
        FileInputStream is = null;
        File file = this.getFile(context, uri);
        if (file != null) {
            try {
                is = new FileInputStream(file);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return is;
    }

    protected File locateFile(String location) {
        File file = new File(this.getRoot(), location);
        if (file.exists()) {
            Path rootPath = this.rootNormalizedPath();
            Path filePath = file.toPath().normalize();
            if (!filePath.startsWith(rootPath)) {
                log.warn((Object)("Requested path " + location + " normalized to " + filePath + ", which falls outside repository root path " + rootPath));
                file = null;
            }
        } else if (this.resolveAbsolutePath) {
            file = new File(location);
            if (!file.exists()) {
                file = null;
            }
        } else {
            file = null;
        }
        return file;
    }

    @Override
    public OutputStream getOutputStream(String uri) {
        File file = null;
        if (uri != null) {
            file = new File(this.getRoot(), uri);
        }
        FileOutputStream os = null;
        if (file != null) {
            try {
                os = new FileOutputStream(file);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        return os;
    }

    @Override
    public Resource getResource(String uri) {
        throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_NOT_IMPLEMENTED, (Object[])null);
    }

    @Override
    public void saveResource(String uri, Resource resource) {
        PersistenceService persistenceService = PersistenceUtil.getInstance(this.jasperReportsContext).getService(FileRepositoryService.class, resource.getClass());
        if (persistenceService != null) {
            persistenceService.save(resource, uri, this);
        }
    }

    @Override
    public <K extends Resource> K getResource(String uri, Class<K> resourceType) {
        return this.getResource(SimpleRepositoryContext.of(this.jasperReportsContext), uri, resourceType);
    }

    @Override
    public <K extends Resource> K getResource(RepositoryContext context, String uri, Class<K> resourceType) {
        PersistenceService persistenceService = PersistenceUtil.getInstance(this.jasperReportsContext).getService(FileRepositoryService.class, resourceType);
        if (persistenceService != null) {
            return (K)persistenceService.load(context, uri, this);
        }
        return null;
    }

    private void setRootRealPath() {
        Path path = Paths.get(this.root, new String[0]);
        try {
            this.rootRealPath = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            log.warn((Object)("Failed to resolve real path for root " + this.root), (Throwable)e);
            this.rootRealPath = null;
        }
    }

    @Override
    public ResourceInfo getResourceInfo(RepositoryContext context, String location) {
        File file = this.getFile(context, location);
        if (file != null) {
            try {
                Path filePath = file.toPath().toRealPath(new LinkOption[0]);
                if (this.rootRealPath != null && filePath.startsWith(this.rootRealPath)) {
                    Path relativePath = this.rootRealPath.relativize(filePath);
                    return StandardResourceInfo.from(relativePath);
                }
                if (this.resolveAbsolutePath) {
                    return StandardResourceInfo.from(filePath);
                }
            }
            catch (IOException e) {
                log.warn((Object)("Failed to resolve real path for file " + file), (Throwable)e);
            }
        }
        return null;
    }
}

