/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.type.SortOrderEnum;

public class DatasetSortInfo {
    private JRDataSource originalDataSource;
    private List<RecordField> recordFields = new ArrayList<RecordField>();
    private List<SortFieldInfo> sortFields = new ArrayList<SortFieldInfo>();

    public void addSortField(JRSortField sortField, int recordIndex, boolean collatorFlag) {
        SortFieldInfo info = new SortFieldInfo(sortField, recordIndex, collatorFlag);
        this.sortFields.add(info);
    }

    public List<SortFieldInfo> getSortFields() {
        return this.sortFields;
    }

    public void addRecordField(String name) {
        RecordField recordField = new RecordField(name, false);
        this.recordFields.add(recordField);
    }

    public int addRecordVariable(String name) {
        int index = this.recordFields.size();
        RecordField recordField = new RecordField(name, true);
        this.recordFields.add(recordField);
        return index;
    }

    public List<RecordField> getRecordFields() {
        return this.recordFields;
    }

    public JRDataSource getOriginalDataSource() {
        return this.originalDataSource;
    }

    public void setOriginalDataSource(JRDataSource originalDataSource) {
        this.originalDataSource = originalDataSource;
    }

    public static class RecordField {
        private final String name;
        private final boolean isVariable;

        protected RecordField(String name, boolean isVariable) {
            this.name = name;
            this.isVariable = isVariable;
        }

        public String getName() {
            return this.name;
        }

        public boolean isVariable() {
            return this.isVariable;
        }
    }

    public static class SortFieldInfo {
        private final JRSortField sortField;
        private final int recordIndex;
        private final boolean collatorFlag;

        protected SortFieldInfo(JRSortField sortField, int recordIndex, boolean collatorFlag) {
            this.sortField = sortField;
            this.recordIndex = recordIndex;
            this.collatorFlag = collatorFlag;
        }

        public int getRecordIndex() {
            return this.recordIndex;
        }

        public boolean isDescending() {
            return SortOrderEnum.DESCENDING == this.sortField.getOrderValue();
        }

        public boolean useCollator() {
            return this.collatorFlag;
        }
    }
}

