/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;
import net.sf.jasperreports.repo.RepositoryUtil;

public class XlsxZip
extends FileBufferedZip {
    public static final String EXCEPTION_MESSAGE_KEY_MACRO_TEMPLATE_NOT_FOUND = "export.xlsx.macro.template.not.found";
    private final JasperReportsContext jasperReportsContext;
    private final RepositoryUtil repository;
    private ExportZipEntry workbookEntry;
    private ExportZipEntry stylesEntry;
    private ExportZipEntry relsEntry;
    private ExportZipEntry contentTypesEntry;
    private ExportZipEntry appEntry;
    private ExportZipEntry coreEntry;

    public XlsxZip(JasperReportsContext jasperReportsContext) throws IOException {
        this(jasperReportsContext, null);
    }

    public XlsxZip(JasperReportsContext jasperReportsContext, Integer memoryThreshold) throws IOException {
        this(jasperReportsContext, RepositoryUtil.getInstance(jasperReportsContext), memoryThreshold);
    }

    public XlsxZip(JasperReportsContext jasperReportsContext, RepositoryUtil repository, Integer memoryThreshold) throws IOException {
        super(memoryThreshold);
        this.jasperReportsContext = jasperReportsContext;
        this.repository = repository;
        this.workbookEntry = this.createEntry("xl/workbook.xml");
        this.stylesEntry = this.createEntry("xl/styles.xml");
        this.relsEntry = this.createEntry("xl/_rels/workbook.xml.rels");
        this.contentTypesEntry = this.createEntry("[Content_Types].xml");
        this.appEntry = this.createEntry("docProps/app.xml");
        this.coreEntry = this.createEntry("docProps/core.xml");
        this.addEntry("_rels/.rels", "net/sf/jasperreports/engine/export/ooxml/xlsx/_rels/xml.rels");
    }

    public ExportZipEntry getWorkbookEntry() {
        return this.workbookEntry;
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public ExportZipEntry getRelsEntry() {
        return this.relsEntry;
    }

    public ExportZipEntry getContentTypesEntry() {
        return this.contentTypesEntry;
    }

    public ExportZipEntry getAppEntry() {
        return this.appEntry;
    }

    public ExportZipEntry getCoreEntry() {
        return this.coreEntry;
    }

    public ExportZipEntry addSheet(int index) {
        return this.createEntry("xl/worksheets/sheet" + index + ".xml");
    }

    public ExportZipEntry addSheetRels(int index) {
        return this.createEntry("xl/worksheets/_rels/sheet" + index + ".xml.rels");
    }

    public ExportZipEntry addDrawing(int index) {
        return this.createEntry("xl/drawings/drawing" + index + ".xml");
    }

    public ExportZipEntry addDrawingRels(int index) {
        return this.createEntry("xl/drawings/_rels/drawing" + index + ".xml.rels");
    }

    public void addMacro(String template) {
        InputStream templateIs = null;
        ZipInputStream templateZipIs = null;
        try {
            templateIs = this.repository.getInputStreamFromLocation(template);
            if (templateIs == null) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_MACRO_TEMPLATE_NOT_FOUND, new Object[]{template});
            }
            templateZipIs = new ZipInputStream(templateIs);
            ZipEntry entry = null;
            while ((entry = templateZipIs.getNextEntry()) != null && !"xl/vbaProject.bin".equals(entry.getName())) {
            }
            if (entry != null) {
                ExportZipEntry macroEntry = this.createEntry("xl/vbaProject.bin");
                OutputStream entryOs = macroEntry.getOutputStream();
                long entryLength = entry.getSize();
                byte[] bytes = new byte[10000];
                int ln = 0;
                for (long readBytesLength = 0L; readBytesLength < entryLength && (ln = templateZipIs.read(bytes)) >= 0; readBytesLength += (long)ln) {
                    entryOs.write(bytes, 0, ln);
                }
            }
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (templateZipIs != null) {
                try {
                    templateZipIs.close();
                }
                catch (IOException iOException) {}
            }
            if (templateIs != null) {
                try {
                    templateIs.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

