/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.oasis;

import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.oasis.Style;
import net.sf.jasperreports.engine.export.oasis.WriterHelper;
import net.sf.jasperreports.engine.type.HorizontalTextAlignEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;
import net.sf.jasperreports.engine.type.VerticalTextAlignEnum;

public class ParagraphStyle
extends Style {
    protected static final String HORIZONTAL_ALIGN_LEFT = "start";
    protected static final String HORIZONTAL_ALIGN_RIGHT = "end";
    protected static final String HORIZONTAL_ALIGN_CENTER = "center";
    protected static final String HORIZONTAL_ALIGN_JUSTIFY = "justified";
    private static final String VERTICAL_ALIGN_TOP = "top";
    private static final String VERTICAL_ALIGN_MIDDLE = "middle";
    private static final String VERTICAL_ALIGN_BOTTOM = "bottom";
    protected static final String TAB_STOP_ALIGN_LEFT = "left";
    protected static final String TAB_STOP_ALIGN_RIGHT = "right";
    protected static final String TAB_STOP_ALIGN_CENTER = "center";
    protected static final String ROTATION_ALIGN_NONE = "none";
    protected static final String ROTATION_ALIGN_TOP = "top";
    protected static final String ROTATION_ALIGN_CENTER = "center";
    protected static final String ROTATION_ALIGN_BOTTOM = "bottom";
    private String verticalAlignment;
    private String horizontalAlignment;
    private String runDirection;
    private String textRotation = "0";
    private JRParagraph paragraph;

    public ParagraphStyle(WriterHelper styleWriter, JRPrintText text, boolean isIgnoreTextFormatting) {
        super(styleWriter);
        this.horizontalAlignment = ParagraphStyle.getHorizontalAlignment(text.getHorizontalTextAlign(), text.getVerticalTextAlign(), isIgnoreTextFormatting ? RotationEnum.NONE : text.getRotationValue());
        this.verticalAlignment = ParagraphStyle.getVerticalAlignment(text.getHorizontalTextAlign(), text.getVerticalTextAlign(), isIgnoreTextFormatting ? RotationEnum.NONE : text.getRotationValue());
        if (isIgnoreTextFormatting) {
            this.textRotation = "0";
        } else {
            switch (text.getRotationValue()) {
                case LEFT: {
                    this.textRotation = "90";
                    break;
                }
                case RIGHT: {
                    this.textRotation = "270";
                    break;
                }
                default: {
                    this.textRotation = "0";
                }
            }
        }
        this.runDirection = null;
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.runDirection = "rl";
        }
        this.paragraph = text.getParagraph();
    }

    public static String getVerticalAlignment(HorizontalTextAlignEnum horizontalAlignment, VerticalTextAlignEnum verticalAlignment, RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        return "top";
                    }
                    case CENTER: {
                        return VERTICAL_ALIGN_MIDDLE;
                    }
                    case JUSTIFIED: {
                        return HORIZONTAL_ALIGN_JUSTIFY;
                    }
                }
                return "bottom";
            }
            case RIGHT: {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        return "bottom";
                    }
                    case CENTER: {
                        return VERTICAL_ALIGN_MIDDLE;
                    }
                    case JUSTIFIED: {
                        return HORIZONTAL_ALIGN_JUSTIFY;
                    }
                }
                return "top";
            }
        }
        switch (verticalAlignment) {
            case BOTTOM: {
                return "bottom";
            }
            case MIDDLE: {
                return VERTICAL_ALIGN_MIDDLE;
            }
        }
        return "top";
    }

    public static String getHorizontalAlignment(HorizontalTextAlignEnum horizontalAlignment, VerticalTextAlignEnum verticalAlignment, RotationEnum rotation) {
        switch (rotation) {
            case LEFT: {
                switch (verticalAlignment) {
                    case BOTTOM: {
                        return HORIZONTAL_ALIGN_RIGHT;
                    }
                    case MIDDLE: {
                        return "center";
                    }
                }
                return HORIZONTAL_ALIGN_LEFT;
            }
            case RIGHT: {
                switch (verticalAlignment) {
                    case BOTTOM: {
                        return HORIZONTAL_ALIGN_LEFT;
                    }
                    case MIDDLE: {
                        return "center";
                    }
                }
                return HORIZONTAL_ALIGN_RIGHT;
            }
        }
        switch (horizontalAlignment) {
            case RIGHT: {
                return HORIZONTAL_ALIGN_RIGHT;
            }
            case CENTER: {
                return "center";
            }
            case JUSTIFIED: {
                return HORIZONTAL_ALIGN_JUSTIFY;
            }
        }
        return HORIZONTAL_ALIGN_LEFT;
    }

    public static String getTabStopAlignment(TabStopAlignEnum tabStopAlignment) {
        switch (tabStopAlignment) {
            case RIGHT: {
                return TAB_STOP_ALIGN_RIGHT;
            }
            case CENTER: {
                return "center";
            }
        }
        return TAB_STOP_ALIGN_LEFT;
    }

    @Override
    public String getId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.verticalAlignment).append("|").append(this.horizontalAlignment).append("|").append(this.runDirection).append("|").append(this.textRotation).append("|").append(this.paragraph.getLineSpacing().getName()).append("|").append(this.paragraph.getLineSpacingSize()).append("|").append(this.paragraph.getFirstLineIndent()).append("|").append(this.paragraph.getLeftIndent()).append("|").append(this.paragraph.getRightIndent()).append("|").append(this.paragraph.getSpacingBefore()).append("|").append(this.paragraph.getSpacingAfter());
        TabStop[] tabStops = this.paragraph.getTabStops();
        if (tabStops != null && tabStops.length > 0) {
            for (int i = 0; i < tabStops.length; ++i) {
                TabStop tabStop = tabStops[i];
                sb.append("|").append(tabStop.getPosition()).append("|").append(tabStop.getAlignment().getName());
            }
        }
        return sb.toString();
    }

    @Override
    public void write(String paragraphStyleName) {
        this.styleWriter.write("<style:style style:name=\"" + paragraphStyleName + "\"");
        this.styleWriter.write(" style:family=\"paragraph\">\n");
        this.styleWriter.write("<style:paragraph-properties");
        switch (this.paragraph.getLineSpacing()) {
            default: {
                this.styleWriter.write(" fo:line-height=\"100%\"");
                break;
            }
            case ONE_AND_HALF: {
                this.styleWriter.write(" fo:line-height=\"150%\"");
                break;
            }
            case DOUBLE: {
                this.styleWriter.write(" fo:line-height=\"200%\"");
                break;
            }
            case AT_LEAST: {
                this.styleWriter.write(" style:line-height-at-least=\"" + LengthUtil.inchFloor4Dec(this.paragraph.getLineSpacingSize().floatValue()) + "in\"");
                break;
            }
            case FIXED: {
                this.styleWriter.write(" fo:line-height=\"" + LengthUtil.inchFloor4Dec(this.paragraph.getLineSpacingSize().floatValue()) + "in\"");
                break;
            }
            case PROPORTIONAL: {
                this.styleWriter.write(" fo:line-height=\"" + 100.0f * this.paragraph.getLineSpacingSize().floatValue() + "%\"");
            }
        }
        this.styleWriter.write(" fo:text-align=\"" + this.horizontalAlignment + "\"");
        this.styleWriter.write(" fo:text-indent=\"" + LengthUtil.inchFloor4Dec(this.paragraph.getFirstLineIndent().intValue()) + "in\"");
        this.styleWriter.write(" fo:margin-left=\"" + LengthUtil.inchFloor4Dec(this.paragraph.getLeftIndent().intValue()) + "in\"");
        this.styleWriter.write(" fo:margin-right=\"" + LengthUtil.inchFloor4Dec(this.paragraph.getRightIndent().intValue()) + "in\"");
        this.styleWriter.write(" fo:margin-top=\"" + LengthUtil.inchFloor4Dec(this.paragraph.getSpacingBefore().intValue()) + "in\"");
        this.styleWriter.write(" fo:margin-bottom=\"" + LengthUtil.inchFloor4Dec(this.paragraph.getSpacingAfter().intValue()) + "in\"");
        this.styleWriter.write(" style:vertical-align=\"" + this.verticalAlignment + "\"");
        if (this.runDirection != null) {
            this.styleWriter.write(" style:writing-mode=\"" + this.runDirection + "\"");
        }
        this.styleWriter.write(">\n");
        TabStop[] tabStops = this.paragraph.getTabStops();
        if (tabStops != null && tabStops.length > 0) {
            this.styleWriter.write("<style:tab-stops>");
            for (int i = 0; i < tabStops.length; ++i) {
                TabStop tabStop = tabStops[i];
                this.styleWriter.write("<style:tab-stop style:type=\"" + ParagraphStyle.getTabStopAlignment(tabStop.getAlignment()) + "\" style:position=\"" + LengthUtil.inchFloor4Dec(tabStop.getPosition()) + "in\"/>");
            }
            this.styleWriter.write("</style:tab-stops>");
        }
        this.styleWriter.write("</style:paragraph-properties>\n");
        this.styleWriter.write("<style:text-properties");
        this.styleWriter.write(" style:text-rotation-angle=\"" + this.textRotation + "\"");
        this.styleWriter.write(">\n");
        this.styleWriter.write("</style:text-properties>\n");
        this.styleWriter.write("</style:style>\n");
    }
}

