/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.export.ExporterFilter;

public class ElementPropertyExporterFilter
implements ExporterFilter {
    private String exportExcludeProperty;

    public ElementPropertyExporterFilter(String exportExcludeProperty) {
        this.exportExcludeProperty = exportExcludeProperty;
    }

    @Override
    public boolean isToExport(JRPrintElement element) {
        if (!element.hasProperties()) {
            return true;
        }
        JRPropertiesMap properties = element.getPropertiesMap();
        String exclude = properties.getProperty(this.exportExcludeProperty);
        if (exclude != null) {
            return !JRPropertiesUtil.asBoolean(exclude);
        }
        String defaultExclude = properties.getProperty("net.sf.jasperreports.export.default.exclude");
        if (defaultExclude != null) {
            return !JRPropertiesUtil.asBoolean(defaultExclude);
        }
        return true;
    }
}

