/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.pdf.PdfContentByte;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class AbstractPdfTextRenderer
extends AbstractTextRenderer {
    protected JRPdfExporter pdfExporter;
    protected PdfContentByte pdfContentByte;
    protected int horizontalAlignment;
    protected float leftOffsetFactor;
    protected float rightOffsetFactor;

    public AbstractPdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        this(jasperReportsContext, ignoreMissingFont, true, false);
    }

    public AbstractPdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        super(jasperReportsContext, false, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
    }

    public void initialize(JRPdfExporter pdfExporter, PdfContentByte pdfContentByte, JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        this.pdfExporter = pdfExporter;
        this.pdfContentByte = pdfContentByte;
        this.horizontalAlignment = 0;
        this.leftOffsetFactor = 0.0f;
        this.rightOffsetFactor = 0.0f;
        switch (text.getHorizontalTextAlign()) {
            case JUSTIFIED: {
                this.horizontalAlignment = 3;
                this.leftOffsetFactor = 0.0f;
                this.rightOffsetFactor = 0.0f;
                break;
            }
            case RIGHT: {
                this.horizontalAlignment = text.getRunDirectionValue() == RunDirectionEnum.LTR ? 2 : 0;
                this.leftOffsetFactor = -0.2f;
                this.rightOffsetFactor = 0.0f;
                break;
            }
            case CENTER: {
                this.horizontalAlignment = 1;
                this.leftOffsetFactor = -0.1f;
                this.rightOffsetFactor = 0.1f;
                break;
            }
            default: {
                this.horizontalAlignment = text.getRunDirectionValue() == RunDirectionEnum.LTR ? 0 : 2;
                this.leftOffsetFactor = 0.0f;
                this.rightOffsetFactor = 0.2f;
            }
        }
        super.initialize(text, styledText, offsetX, offsetY);
    }
}

