/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.compilers.ConstantExpressionEvaluation;
import net.sf.jasperreports.compilers.DirectExpressionEvaluation;
import net.sf.jasperreports.compilers.FieldEvaluation;
import net.sf.jasperreports.compilers.ParameterEvaluation;
import net.sf.jasperreports.compilers.ReportExpressionsCompilation;
import net.sf.jasperreports.compilers.ResourceEvaluation;
import net.sf.jasperreports.compilers.SimpleTextEvaluation;
import net.sf.jasperreports.compilers.VariableEvaluation;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.type.ExpressionTypeEnum;

public class ReportExpressionsCompiler {
    private static final ReportExpressionsCompiler INSTANCE = new ReportExpressionsCompiler();
    private Map<String, DirectExpressionEvaluation> constantExpressionEvaluations = this.constantEvaluations();

    public static ReportExpressionsCompiler instance() {
        return INSTANCE;
    }

    protected Map<String, DirectExpressionEvaluation> constantEvaluations() {
        HashMap<String, DirectExpressionEvaluation> constantEvaluations = new HashMap<String, DirectExpressionEvaluation>();
        constantEvaluations.put("new java.lang.Integer(0)", new ConstantExpressionEvaluation(0));
        constantEvaluations.put("new java.lang.Integer(1)", new ConstantExpressionEvaluation(1));
        constantEvaluations.put("false", new ConstantExpressionEvaluation(Boolean.FALSE));
        constantEvaluations.put("true", new ConstantExpressionEvaluation(Boolean.TRUE));
        constantEvaluations.put("Boolean.FALSE", new ConstantExpressionEvaluation(Boolean.FALSE));
        constantEvaluations.put("Boolean.TRUE", new ConstantExpressionEvaluation(Boolean.TRUE));
        constantEvaluations.put("\"\"", new ConstantExpressionEvaluation(""));
        return constantEvaluations;
    }

    public ReportExpressionsCompilation getExpressionsCompilation(JRExpressionCollector expressionCollector) {
        ArrayList<JRExpression> sourceExpressions = new ArrayList<JRExpression>();
        HashMap<Integer, DirectExpressionEvaluation> directEvaluations = new HashMap<Integer, DirectExpressionEvaluation>();
        List<JRExpression> expressions = expressionCollector.getExpressions();
        for (JRExpression expression : expressions) {
            DirectExpressionEvaluation directEvaluation = this.directEvaluation(expression);
            if (directEvaluation == null) {
                sourceExpressions.add(expression);
                continue;
            }
            Integer expressionId = expressionCollector.getExpressionId(expression);
            directEvaluations.put(expressionId, directEvaluation);
        }
        return new ReportExpressionsCompilation(sourceExpressions, directEvaluations);
    }

    protected DirectExpressionEvaluation directEvaluation(JRExpression expression) {
        DirectExpressionEvaluation directEvaluation = null;
        if (expression.getType() == ExpressionTypeEnum.SIMPLE_TEXT) {
            directEvaluation = new SimpleTextEvaluation(expression.getChunks());
        } else {
            JRExpressionChunk[] chunks = expression.getChunks();
            if (chunks == null || chunks.length == 0) {
                directEvaluation = ConstantExpressionEvaluation.nullEvaluation();
            } else if (chunks.length == 1) {
                JRExpressionChunk chunk = chunks[0];
                switch (chunk.getType()) {
                    case 2: {
                        directEvaluation = new ParameterEvaluation(chunk.getText());
                        break;
                    }
                    case 3: {
                        directEvaluation = new FieldEvaluation(chunk.getText());
                        break;
                    }
                    case 4: {
                        directEvaluation = new VariableEvaluation(chunk.getText());
                        break;
                    }
                    case 5: {
                        directEvaluation = new ResourceEvaluation(chunk.getText());
                        break;
                    }
                    case 1: {
                        directEvaluation = this.constantExpressionEvaluations.get(chunk.getText());
                    }
                }
            }
        }
        return directEvaluation;
    }
}

