/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.services.ChromeDevToolsService;
import com.github.kklisura.cdt.services.types.ChromeTab;
import java.util.function.Function;
import net.sf.jasperreports.chrome.ChromeInstanceHandle;
import net.sf.jasperreports.chrome.PageCreator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardPageCreator
implements PageCreator {
    private static final Log log = LogFactory.getLog(StandardPageCreator.class);
    private static final StandardPageCreator INSTANCE = new StandardPageCreator();

    public static StandardPageCreator instance() {
        return INSTANCE;
    }

    @Override
    public <T> T runInPage(ChromeInstanceHandle chromeInstance, Function<ChromeDevToolsService, T> tabAction) {
        return (T)chromeInstance.runWithChromeInstance(chromeService -> {
            ChromeTab tab = null;
            try {
                tab = chromeService.createTab();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created tab " + tab.getId()));
                }
                try (ChromeDevToolsService devToolsService = chromeService.createDevToolsService(tab);){
                    Object r = tabAction.apply(devToolsService);
                    return r;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (tab != null) {
                    chromeService.closeTab(tab);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("closed tab " + tab.getId()));
                    }
                }
            }
        });
    }
}

