/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.SwephData;
import swisseph.SwissEph;
import swisseph.SwissephException;
import swisseph.TransitCalculator;

public class TCPlanetPlanet
extends TransitCalculator {
    private int pl1;
    private int pl2;
    private int idx = 0;
    private int tflags = 0;
    private int flags = 0;
    private boolean calcYoga = false;
    private double maxSpeed1;
    private double minSpeed1;
    private double maxSpeed2;
    private double minSpeed2;
    private double minSpeed;
    private double maxSpeed;
    private double offset = 0.0;
    double minVal = 0.0;
    double maxVal = 0.0;

    public TCPlanetPlanet(SwissEph sw, int pl1, int pl2, int flags, double offset) {
        this.sw = sw;
        if (this.sw == null) {
            this.sw = new SwissEph();
        }
        this.tflags = flags;
        int vFlags = 4161543;
        if ((flags & ~vFlags) != 0) {
            throw new IllegalArgumentException("Invalid flag(s): " + (flags & ~vFlags));
        }
        int type = flags & 0xE0000;
        if (type != 131072 && type != 262144 && type != 524288) {
            throw new IllegalArgumentException("Invalid flag combination '" + flags + "': specify at least exactly one of SEFLG_TRANSIT_LONGITUDE (" + 131072 + "), SEFLG_TRANSIT_LATITUDE (" + 262144 + "), SEFLG_TRANSIT_DISTANCE (" + 524288 + ").");
        }
        if (pl1 < 0 || pl1 > 20 || pl1 == 14 || pl2 < 0 || pl2 > 20 || pl2 == 14) {
            throw new IllegalArgumentException("Unsupported planet: " + sw.swe_get_planet_name(pl1));
        }
        if (pl1 == pl2) {
            throw new IllegalArgumentException("Transiting and referred planet have to be different!");
        }
        this.pl1 = pl1;
        this.pl2 = pl2;
        boolean bl = this.calcYoga = (flags & 0x200000) != 0;
        if ((flags & 0x40000) != 0) {
            this.idx = 1;
        } else if ((flags & 0x80000) != 0) {
            this.idx = 2;
        }
        if ((flags & 0x100000) != 0) {
            this.idx += 3;
            flags |= 0x100;
        }
        this.flags = flags &= 0xFFC1FFFF;
        this.rollover = this.idx == 0;
        this.offset = this.checkOffset(offset);
        double[] xxr = new double[6];
        double[] xxt = new double[6];
        double max = 0.0;
        double min = 0.0;
        this.maxSpeed1 = this.getSpeed(false, pl1);
        this.minSpeed1 = this.getSpeed(true, pl1);
        this.maxSpeed2 = this.getSpeed(false, pl2);
        this.minSpeed2 = this.getSpeed(true, pl2);
        if (this.calcYoga) {
            this.minSpeed = this.minSpeed1 + this.minSpeed2;
            this.maxSpeed = this.maxSpeed1 + this.maxSpeed2;
        } else if (this.rollover) {
            this.minSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.minSpeed1 - this.maxSpeed2 : this.minSpeed2 - this.maxSpeed1;
            this.maxSpeed = this.maxSpeed1 > this.maxSpeed2 ? this.maxSpeed1 - this.minSpeed2 : this.maxSpeed2 - this.minSpeed1;
        } else {
            this.minSpeed = Math.max(this.minSpeed1 - this.maxSpeed2, this.minSpeed2 - this.maxSpeed1);
            this.maxSpeed = Math.max(this.maxSpeed1 - this.minSpeed2, this.maxSpeed2 - this.minSpeed1);
        }
    }

    @Override
    public boolean getRollover() {
        return this.rollover;
    }

    @Override
    public void setOffset(double value) {
        this.offset = this.checkOffset(value);
    }

    @Override
    public double getOffset() {
        return this.offset;
    }

    @Override
    protected double getMaxSpeed() {
        return this.maxSpeed;
    }

    @Override
    protected double getMinSpeed() {
        return this.minSpeed;
    }

    @Override
    protected double calc(double jdET) {
        StringBuffer serr = new StringBuffer();
        double[] xx1 = new double[6];
        double[] xx2 = new double[6];
        int ret = this.sw.swe_calc(jdET, this.pl1, this.flags, xx1, serr);
        if (ret < 0) {
            throw new SwissephException(jdET, 0, "Calculation failed with return code " + ret + ":\n" + serr.toString());
        }
        ret = this.sw.swe_calc(jdET, this.pl2, this.flags, xx2, serr);
        if (ret < 0) {
            throw new SwissephException(jdET, 0, "Calculation failed with return code " + ret + ":\n" + serr.toString());
        }
        return xx1[this.idx] + (this.calcYoga ? xx2[this.idx] : -xx2[this.idx]);
    }

    @Override
    protected double getTimePrecision(double degPrec) {
        double amin = Math.min(Math.abs(this.minSpeed1), Math.abs(this.minSpeed2));
        double amax = Math.min(Math.abs(this.maxSpeed1), Math.abs(this.maxSpeed2));
        double maxVal = Math.max(Math.abs(amin), Math.abs(amax));
        if (maxVal != 0.0) {
            return degPrec / maxVal;
        }
        return 1.0E-9;
    }

    @Override
    protected double getDegreePrecision(double jd) {
        double degPrec = 0.005;
        if (this.idx > 2) {
            degPrec = 0.002;
        } else {
            if (this.pl1 >= 0 && this.pl1 <= 5) {
                if (jd < 1980.0 || jd > 2099.0) {
                    degPrec = 0.08;
                }
            } else if (jd >= 1900.0 && jd < 1980.0) {
                degPrec = 0.08;
            } else if (jd < 1900.0 || jd > 2099.0) {
                degPrec = 1.0;
            }
            if (this.pl2 >= 0 && this.pl2 <= 5) {
                if (jd < 1980.0 || jd > 2099.0) {
                    degPrec = Math.max(0.08, degPrec);
                }
            } else if (jd >= 1900.0 && jd < 1980.0) {
                degPrec = Math.max(0.08, degPrec);
            } else if (jd < 1900.0 || jd > 2099.0) {
                degPrec = Math.max(1.0, degPrec);
            }
        }
        degPrec /= 3600.0;
        degPrec *= 0.5;
        switch (this.idx) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: 
            case 5: {
                degPrec *= Math.max(this.sw.ext.maxBaryDist[this.pl1], this.sw.ext.maxBaryDist[this.pl2]);
            }
        }
        return degPrec;
    }

    private double checkOffset(double val) {
        if (this.rollover) {
            while (val < 0.0) {
                val += 360.0;
            }
            val %= 360.0;
            this.minVal = 0.0;
            this.maxVal = 360.0;
        } else if (this.idx == 1) {
            while (val < -90.0) {
                val += 180.0;
            }
            while (val > 90.0) {
                val -= 180.0;
            }
            this.minVal = -90.0;
            this.maxVal = 90.0;
        }
        return val;
    }

    private double getSpeed(boolean min, int planet) {
        boolean topo;
        boolean lat = (this.tflags & 0x40000) != 0;
        boolean dist = (this.tflags & 0x80000) != 0;
        boolean lon = !lat && !dist;
        boolean speed = (this.tflags & 0x100000) != 0;
        boolean bl = topo = (this.tflags & 0x8000) != 0;
        if (topo) {
            if (!this.sw.swed.geopos_is_set) {
                throw new IllegalArgumentException("Geographic position is not set for requested topocentric calculations.");
            }
            if (this.sw.swed.topd.geoalt > 50000.0) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a maximum altitude of 50km so far.");
            }
            if (this.sw.swed.topd.geoalt < -1.2E7) {
                throw new IllegalArgumentException("Topocentric transit calculations are restricted to a minimum altitude of -12000km so far.");
            }
            if (speed) {
                if (lat) {
                    return min ? SwephData.minTopoLatAccel[planet] : SwephData.maxTopoLatAccel[planet];
                }
                if (dist) {
                    return min ? SwephData.minTopoDistAccel[planet] : SwephData.maxTopoDistAccel[planet];
                }
                return min ? SwephData.minTopoLonAccel[planet] : SwephData.maxTopoLonAccel[planet];
            }
            if (lat) {
                return min ? SwephData.minTopoLatSpeed[planet] : SwephData.maxTopoLatSpeed[planet];
            }
            if (dist) {
                return min ? SwephData.minTopoDistSpeed[planet] : SwephData.maxTopoDistSpeed[planet];
            }
            return min ? SwephData.minTopoLonSpeed[planet] : SwephData.maxTopoLonSpeed[planet];
        }
        if (speed) {
            if (lat) {
                return min ? SwephData.minLatAccel[planet] : SwephData.maxLatAccel[planet];
            }
            if (dist) {
                return min ? SwephData.minDistAccel[planet] : SwephData.maxDistAccel[planet];
            }
            return min ? SwephData.minLonAccel[planet] : SwephData.maxLonAccel[planet];
        }
        if (lat) {
            return min ? SwephData.minLatSpeed[planet] : SwephData.maxLatSpeed[planet];
        }
        if (dist) {
            return min ? SwephData.minDistSpeed[planet] : SwephData.maxDistSpeed[planet];
        }
        return min ? SwephData.minLonSpeed[planet] : SwephData.maxLonSpeed[planet];
    }

    public String toString() {
        return "[Planets:" + this.pl1 + "/" + this.pl2 + "]";
    }
}

