/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.DblObj;
import swisseph.SwissData;
import swisseph.SwissLib;

class Swemmoon {
    SwissData swed;
    SwissLib sl;
    static final double[] z = new double[]{-13.12045233711, -0.00113821591258, -9.646018347184E-6, 31.46734198839, 0.0476835758578, -3.421689790404E-4, -6.84707090541, -0.005834100476561, -2.905334122698E-4, -5.663161722088, 0.005722859298199, -8.466472828815E-5, -84.29817796435, -207.2552484689, 7.876842214863, 1.836463749022, -15.57471855361, -20.06969124724, 21.52670284757, -6.179946916139, -0.9070028191196, -12.70848233038, -2.145589319058, 13.81936399935, -1.999840061168};
    double LP;
    double M;
    double MP;
    double D;
    double NF;
    double T;
    double T2;

    Swemmoon() {
        this(null, null);
    }

    Swemmoon(SwissData swed, SwissLib sl) {
        this.swed = swed;
        this.sl = sl;
        if (this.swed == null) {
            this.swed = new SwissData();
        }
        if (this.sl == null) {
            this.sl = new SwissLib();
        }
    }

    int swi_mean_node(double J, double[] pol, StringBuffer serr) {
        return this.swi_mean_node(J, pol, 0, serr);
    }

    int swi_mean_node(double J, double[] pol, int offs, StringBuffer serr) {
        this.T = (J - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        if (J < -254900.5 || J > 3697000.5) {
            if (serr != null) {
                String s = "jd " + J + " outside mean node range " + -254900.5 + " .. " + 3697000.5 + " ";
                serr.append(s);
            }
            return -1;
        }
        this.mean_elements();
        pol[offs] = this.sl.swi_mod2PI((this.LP - this.NF) * 4.84813681109536E-6);
        pol[offs + 1] = 0.0;
        pol[offs + 2] = 0.002569555290487047;
        return 0;
    }

    int swi_mean_apog(double J, double[] pol, StringBuffer serr) {
        return this.swi_mean_apog(J, pol, 0, serr);
    }

    int swi_mean_apog(double J, double[] pol, int offs, StringBuffer serr) {
        this.T = (J - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        if (J < -254900.5 || J > 3697000.5) {
            if (serr != null) {
                String s = "jd " + J + " outside mean apogee range " + -254900.5 + " .. " + 3697000.5 + " ";
                if (serr.length() + s.length() < 256) {
                    serr.append(s);
                }
            }
            return -1;
        }
        this.mean_elements();
        pol[offs] = this.sl.swi_mod2PI((this.LP - this.MP) * 4.84813681109536E-6 + Math.PI);
        pol[offs + 1] = 0.0;
        pol[offs + 2] = 0.002710625132447323;
        double node = (this.LP - this.NF) * 4.84813681109536E-6;
        pol[offs] = this.sl.swi_mod2PI(pol[offs] - node);
        this.sl.swi_polcart(pol, offs, pol, offs);
        this.sl.swi_coortrf(pol, offs, pol, offs, -0.08980410850026319);
        this.sl.swi_cartpol(pol, offs, pol, offs);
        pol[offs] = this.sl.swi_mod2PI(pol[offs] + node);
        return 0;
    }

    double mods3600(double x) {
        double lx = x;
        lx -= 1296000.0 * Math.floor(lx / 1296000.0);
        return lx;
    }

    void swi_mean_lunar_elements(double tjd, DblObj node, DblObj dnode, DblObj peri, DblObj dperi) {
        this.T = (tjd - 2451545.0) / 36525.0;
        this.T2 = this.T * this.T;
        this.mean_elements();
        node.val = this.sl.swe_degnorm((this.LP - this.NF) * 4.84813681109536E-6 * 57.2957795130823);
        peri.val = this.sl.swe_degnorm((this.LP - this.MP) * 4.84813681109536E-6 * 57.2957795130823);
        this.T -= 2.7378507871321012E-5;
        this.mean_elements();
        dnode.val = this.sl.swe_degnorm(node.val - (this.LP - this.NF) * 4.84813681109536E-6 * 57.2957795130823);
        dnode.val -= 360.0;
        dperi.val = this.sl.swe_degnorm(peri.val - (this.LP - this.MP) * 4.84813681109536E-6 * 57.2957795130823);
    }

    void mean_elements() {
        double fracT = this.T % 1.0;
        this.M = this.mods3600(1.296E8 * fracT - 3418.961646 * this.T + 1287104.76154);
        this.M += ((((((((1.62E-20 * this.T - 1.039E-17) * this.T - 3.83508E-15) * this.T + 4.237343E-13) * this.T + 8.8555011E-11) * this.T - 4.77258489E-8) * this.T - 1.1297037031E-5) * this.T + 1.4732069041E-4) * this.T - 0.552891801772) * this.T2;
        this.NF = this.mods3600(1.739232E9 * fracT + 295263.0983 * this.T - 0.207941990176 * this.T + 335779.55755);
        this.MP = this.mods3600(1.7172E9 * fracT + 715923.4728 * this.T - 0.2035946368532 * this.T + 485868.28096);
        this.D = this.mods3600(1.601856E9 * fracT + 1105601.4603 * this.T + 0.3962893294503 * this.T + 1072260.73512);
        this.LP = this.mods3600(1.731456E9 * fracT + 1108372.83264 * this.T - 0.6784914260953 * this.T + 785939.95571);
        this.NF += ((z[2] * this.T + z[1]) * this.T + z[0]) * this.T2;
        this.MP += ((z[5] * this.T + z[4]) * this.T + z[3]) * this.T2;
        this.D += ((z[8] * this.T + z[7]) * this.T + z[6]) * this.T2;
        this.LP += ((z[11] * this.T + z[10]) * this.T + z[9]) * this.T2;
    }
}

