/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import swisseph.DblObj;
import swisseph.Epsilon;
import swisseph.PlanData;
import swisseph.SweDate;
import swisseph.Swemmoon;
import swisseph.SwephData;
import swisseph.SwissData;
import swisseph.SwissEph;
import swisseph.SwissLib;

class Swecl {
    SwissEph sw = null;
    SwissLib sl = null;
    SweDate sd = null;
    Swemmoon sm = null;
    SwissData swed = null;
    private static final double DSUN = 0.009304945276685664;
    private static final double DMOON = 2.3237630219355155E-5;
    private static final double DEARTH = 8.527046503885043E-5;
    private static final double RSUN = 0.004652472638342832;
    private static final double RMOON = 1.1618815109677577E-5;
    private static final double REARTH = 4.263523251942522E-5;
    private static final int SEI_OCC_FAST = 16384;
    private static final double lnlog = Math.log(10.0);
    private static final double EULER = 2.718281828459;
    private static final int NMAG_ELEM = 21;
    private static final double[][] mag_elem = new double[][]{{-26.86, 0.0, 0.0, 0.0}, {-12.55, 0.0, 0.0, 0.0}, {-0.42, 3.8, -2.73, 2.0}, {-4.4, 0.09, 2.39, -0.65}, {-1.52, 1.6, 0.0, 0.0}, {-9.4, 0.5, 0.0, 0.0}, {-8.88, -2.6, 1.25, 0.044}, {-7.19, 0.0, 0.0, 0.0}, {-6.87, 0.0, 0.0, 0.0}, {-1.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {99.0, 0.0, 0.0, 0.0}, {6.5, 0.15, 0.0, 0.0}, {7.0, 0.15, 0.0, 0.0}, {3.34, 0.12, 0.0, 0.0}, {4.13, 0.11, 0.0, 0.0}, {5.33, 0.32, 0.0, 0.0}, {3.2, 0.32, 0.0, 0.0}};
    private static final double[][] el_node = new double[][]{{48.330893, 1.186189, 1.7587E-4, 2.11E-7}, {76.67992, 0.901119, 4.0665E-4, -8.0E-8}, {0.0, 0.0, 0.0, 0.0}, {49.558093, 0.7720923, 1.605E-5, 2.325E-6}, {100.464441, 1.020955, 4.0117E-4, 5.69E-7}, {113.665524, 0.877097, -1.2067E-4, -2.38E-6}, {74.005947, 0.5211258, 0.00133982, 1.8516E-5}, {131.784057, 1.1022057, 2.6006E-4, -6.36E-7}};
    private static final double[][] el_peri = new double[][]{{77.456119, 1.5564775, 2.9589E-4, 5.6E-8}, {131.563707, 1.4022188, -0.00107337, -5.315E-6}, {102.937348, 1.7195269, 4.5962E-4, 4.99E-7}, {336.060234, 1.8410331, 1.3515E-4, 3.18E-7}, {14.331309, 1.6126668, 0.00103127, -4.569E-6}, {93.056787, 1.9637694, 8.3757E-4, 4.899E-6}, {173.005159, 1.4863784, 2.145E-4, 4.33E-7}, {48.123691, 1.4262677, 3.7918E-4, -3.0E-9}};
    private static final double[][] el_incl = new double[][]{{7.004986, 0.0018215, -1.809E-5, 5.3E-8}, {3.394662, 0.0010037, -8.8E-7, -7.0E-9}, {0.0, 0.0, 0.0, 0.0}, {1.849726, -6.01E-4, 1.276E-5, -6.0E-9}, {1.30327, -0.0054966, 4.65E-6, -4.0E-9}, {2.488878, -0.0037363, -1.516E-5, 8.9E-8}, {0.773196, 7.744E-4, 3.749E-5, -9.2E-8}, {1.769952, -0.0093082, -7.08E-6, 2.8E-8}};
    private static final double[][] el_ecce = new double[][]{{0.20563175, 2.0406E-5, -2.84E-8, -1.7E-10}, {0.00677188, -4.7766E-5, 9.75E-8, 4.4E-10}, {0.01670862, -4.2037E-5, -1.236E-7, 4.0E-11}, {0.09340062, 9.0483E-5, -8.06E-8, -3.5E-10}, {0.04849485, 1.63244E-4, -4.719E-7, -1.97E-9}, {0.05550862, -3.46818E-4, -6.456E-7, 3.38E-9}, {0.0462959, -2.7337E-5, 7.9E-8, 2.5E-10}, {0.00898809, 6.408E-6, -8.0E-10, -5.0E-11}};
    private static final double[][] el_sema = new double[][]{{0.38709831, 0.0, 0.0, 0.0}, {0.72332982, 0.0, 0.0, 0.0}, {1.000001018, 0.0, 0.0, 0.0}, {1.523679342, 0.0, 0.0, 0.0}, {5.202603191, 1.913E-7, 0.0, 0.0}, {9.554909596, 2.1389E-6, 0.0, 0.0}, {19.218446062, -3.72E-8, 9.8E-10, 0.0}, {30.110386869, -1.663E-7, 6.9E-10, 0.0}};
    private static final double[] plmass = new double[]{6023600.0, 408523.5, 328900.5, 3098710.0, 1047.35, 3498.0, 22960.0, 19314.0, 1.3E8};
    private static final int[] ipl_to_elem = new int[]{2, 0, 0, 1, 3, 4, 5, 6, 7, 0, 0, 0, 0, 0, 2};

    private double log10(double x) {
        return Math.log(x) / lnlog;
    }

    Swecl() {
        this(null, null, null, null, null);
        this.sw = new SwissEph();
        this.sl = new SwissLib();
        this.sd = new SweDate();
        this.sm = new Swemmoon();
        this.swed = new SwissData();
    }

    Swecl(SwissEph sw, SwissLib sl, Swemmoon sm, SweDate sd, SwissData swed) {
        this.sw = sw;
        this.sl = sl;
        this.sd = sd;
        this.sm = sm;
        this.swed = swed;
        if (sw == null) {
            this.sw = new SwissEph();
        }
        if (sl == null) {
            this.sl = new SwissLib();
        }
        if (sd == null) {
            this.sd = new SweDate();
        }
        if (sm == null) {
            this.sm = new Swemmoon();
        }
        if (swed == null) {
            this.swed = new SwissData();
        }
    }

    int swe_sol_eclipse_where(double tjd_ut, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        double[] dcore = new double[10];
        int retflag = this.eclipse_where(tjd_ut, 0, null, ifl &= 7, geopos, dcore, serr);
        if (retflag < 0) {
            return retflag;
        }
        int retflag2 = this.eclipse_how(tjd_ut, 0, null, ifl, geopos[0], geopos[1], 0.0, attr, serr);
        if (retflag2 == -1) {
            return retflag2;
        }
        attr[3] = dcore[0];
        return retflag;
    }

    int swe_lun_occult_where(double tjd_ut, int ipl, StringBuffer starname, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        double[] dcore = new double[10];
        int retflag = this.eclipse_where(tjd_ut, ipl, starname, ifl &= 7, geopos, dcore, serr);
        if (retflag < 0) {
            return retflag;
        }
        int retflag2 = this.eclipse_how(tjd_ut, ipl, starname, ifl, geopos[0], geopos[1], 0.0, attr, serr);
        if (retflag2 == -1) {
            return retflag2;
        }
        attr[3] = dcore[0];
        return retflag;
    }

    private int eclipse_where(double tjd_ut, int ipl, StringBuffer starname, int ifl, double[] geopos, double[] dcore, StringBuffer serr) {
        int retc;
        block26: {
            double s;
            double cosf2;
            double cosf1;
            double dsmt;
            int i;
            retc = 0;
            int niter = 0;
            double[] e = new double[6];
            double[] et = new double[6];
            double[] erm = new double[6];
            double[] rm = new double[6];
            double[] rs = new double[6];
            double[] rmt = new double[6];
            double[] rst = new double[6];
            double[] xs = new double[6];
            double[] xst = new double[6];
            double[] xssv = new double[16];
            double[] x = new double[6];
            double[] lm = new double[6];
            double[] ls = new double[6];
            double[] lx = new double[6];
            double de = 4.263523251942522E-5;
            double earthobl = 0.9966471893352525;
            boolean no_eclipse = false;
            Epsilon oe = this.swed.oec;
            for (i = 0; i < 10; ++i) {
                dcore[i] = 0.0;
            }
            int iflag = 0x900 | ifl;
            int iflag2 = iflag | 0x2000;
            double deltat = SweDate.getDeltaT(tjd_ut);
            double tjd = tjd_ut + deltat;
            retc = this.sw.swe_calc(tjd, 1, iflag |= 0x1000, rm, serr);
            if (retc == -1) {
                return retc;
            }
            retc = this.sw.swe_calc(tjd, 1, iflag2, lm, serr);
            if (retc == -1) {
                return retc;
            }
            retc = this.calc_planet_star(tjd, ipl, starname, iflag, rs, serr);
            if (retc == -1) {
                return retc;
            }
            retc = this.calc_planet_star(tjd, ipl, starname, iflag2, ls, serr);
            if (retc == -1) {
                return retc;
            }
            for (i = 0; i <= 2; ++i) {
                rst[i] = rs[i];
            }
            for (i = 0; i <= 2; ++i) {
                rmt[i] = rm[i];
            }
            double sidt = (iflag & 0x40) != 0 ? this.sl.swe_sidtime0(tjd_ut, oe.eps * 57.2957795130823, 0.0) * 15.0 * 0.0174532925199433 : this.sl.swe_sidtime(tjd_ut) * 15.0 * 0.0174532925199433;
            double drad = starname != null && starname.length() > 0 ? 0.0 : (ipl < 21 ? SwephData.pla_diam[ipl] / 2.0 / 1.4959787066E11 : (ipl > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            while (true) {
                double ss;
                double d;
                for (i = 0; i <= 2; ++i) {
                    rs[i] = rst[i];
                    rm[i] = rmt[i];
                }
                for (i = 0; i <= 2; ++i) {
                    lx[i] = lm[i];
                }
                this.sl.swi_polcart(lx, rm);
                rm[2] = rm[2] / earthobl;
                double dm = Math.sqrt(this.sl.square_sum(rm));
                for (i = 0; i <= 2; ++i) {
                    lx[i] = ls[i];
                }
                this.sl.swi_polcart(lx, rs);
                rs[2] = rs[2] / earthobl;
                for (i = 0; i <= 2; ++i) {
                    e[i] = rm[i] - rs[i];
                    et[i] = rmt[i] - rst[i];
                }
                double dsm = Math.sqrt(this.sl.square_sum(e));
                dsmt = Math.sqrt(this.sl.square_sum(et));
                for (i = 0; i <= 2; ++i) {
                    int n = i;
                    e[n] = e[n] / dsm;
                    int n2 = i;
                    et[n2] = et[n2] / dsmt;
                    erm[i] = rm[i] / dm;
                }
                double sinf1 = (drad - 1.1618815109677577E-5) / dsm;
                cosf1 = Math.sqrt(1.0 - sinf1 * sinf1);
                double sinf2 = (drad + 1.1618815109677577E-5) / dsm;
                cosf2 = Math.sqrt(1.0 - sinf2 * sinf2);
                double s0 = -this.sw.dot_prod(rm, e);
                double r0 = Math.sqrt(dm * dm - s0 * s0);
                double d0 = (s0 / dsm * (drad * 2.0 - 2.3237630219355155E-5) - 2.3237630219355155E-5) / cosf1;
                double D0 = (s0 / dsm * (drad * 2.0 + 2.3237630219355155E-5) + 2.3237630219355155E-5) / cosf2;
                dcore[2] = r0;
                dcore[3] = d0;
                dcore[4] = D0;
                dcore[5] = cosf1;
                dcore[6] = cosf2;
                i = 2;
                while (i < 5) {
                    int n = i++;
                    dcore[n] = dcore[n] * 1.4959787066E8;
                }
                retc = 0;
                if (de * cosf1 >= r0) {
                    retc |= 1;
                } else if (r0 <= de * cosf1 + Math.abs(d0) / 2.0) {
                    retc |= 2;
                } else if (r0 <= de * cosf2 + D0 / 2.0) {
                    retc |= 0x12;
                } else {
                    if (serr != null) {
                        serr.setLength(0);
                        serr.append("no solar eclipse at tjd = " + tjd);
                    }
                    for (i = 0; i < 10; ++i) {
                        geopos[i] = 0.0;
                    }
                    dcore[0] = 0.0;
                    retc = 0;
                    d = 0.0;
                    no_eclipse = true;
                }
                d = s0 * s0 + de * de - dm * dm;
                d = d > 0.0 ? Math.sqrt(d) : 0.0;
                s = s0 - d;
                for (i = 0; i <= 2; ++i) {
                    xs[i] = rm[i] + s * e[i];
                }
                for (i = 0; i <= 2; ++i) {
                    xst[i] = xs[i];
                }
                xst[2] = xst[2] * earthobl;
                this.sl.swi_cartpol(xst, xst);
                if (niter > 0) break;
                double cosfi = Math.cos(xst[1]);
                double sinfi = Math.sin(xst[1]);
                double eobl = 0.0033528106647474805;
                double cc = 1.0 / Math.sqrt(cosfi * cosfi + (1.0 - eobl) * (1.0 - eobl) * sinfi * sinfi);
                earthobl = ss = (1.0 - eobl) * (1.0 - eobl) * cc;
                ++niter;
            }
            this.sl.swi_polcart(xst, xst);
            this.sl.swi_cartpol(xs, xs);
            xs[0] = xs[0] - sidt;
            xs[0] = xs[0] * 57.2957795130823;
            xs[1] = xs[1] * 57.2957795130823;
            xs[0] = this.sl.swe_degnorm(xs[0]);
            if (xs[0] > 180.0) {
                xs[0] = xs[0] - 360.0;
            }
            xssv[0] = xs[0];
            xssv[1] = xs[1];
            geopos[0] = xs[0];
            geopos[1] = xs[1];
            for (i = 0; i <= 2; ++i) {
                x[i] = rmt[i] - xst[i];
            }
            s = Math.sqrt(this.sl.square_sum(x));
            dcore[0] = (s / dsmt * (drad * 2.0 - 2.3237630219355155E-5) - 2.3237630219355155E-5) * cosf1;
            dcore[0] = dcore[0] * 1.4959787066E8;
            dcore[1] = (s / dsmt * (drad * 2.0 + 2.3237630219355155E-5) + 2.3237630219355155E-5) * cosf2;
            dcore[1] = dcore[1] * 1.4959787066E8;
            if ((retc & 0x10) != 0 || no_eclipse) break block26;
            retc = dcore[0] > 0.0 ? (retc |= 8) : (retc |= 4);
        }
        return retc;
    }

    private int calc_planet_star(double tjd_et, int ipl, StringBuffer starname, int iflag, double[] x, StringBuffer serr) {
        int retc = 0;
        if (starname == null || starname.length() == 0) {
            retc = this.sw.swe_calc(tjd_et, ipl, iflag, x, serr);
        } else {
            retc = this.sw.swe_fixstar(starname, tjd_et, iflag, x, serr);
            if (retc == 0) {
                if ((iflag & 0x1000) != 0) {
                    int i = 0;
                    while (i < 3) {
                        int n = i++;
                        x[n] = x[n] * 1.0E8;
                    }
                } else {
                    x[2] = x[2] * 1.0E8;
                }
            }
        }
        return retc;
    }

    int swe_sol_eclipse_how(double tjd_ut, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        double[] dcore = new double[10];
        double[] geopos2 = new double[20];
        int retflag = this.eclipse_how(tjd_ut, 0, null, ifl &= 7, geopos[0], geopos[1], geopos[2], attr, serr);
        if (retflag == -1) {
            return retflag;
        }
        int retflag2 = this.eclipse_where(tjd_ut, 0, null, ifl, geopos2, dcore, serr);
        if (retflag2 == -1) {
            return retflag2;
        }
        if (retflag != 0) {
            retflag |= retflag2 & 3;
        }
        attr[3] = dcore[0];
        return retflag;
    }

    private int eclipse_how(double tjd_ut, int ipl, StringBuffer starname, int ifl, double geolon, double geolat, double geohgt, double[] attr, StringBuffer serr) {
        int i;
        int retc = 0;
        double[] xs = new double[6];
        double[] xm = new double[6];
        double[] ls = new double[6];
        double[] lm = new double[6];
        double[] x1 = new double[6];
        double[] x2 = new double[6];
        int iflag = 0x8800 | ifl;
        int iflagcart = iflag | 0x1000;
        double[] xh = new double[6];
        for (i = 0; i < 10; ++i) {
            attr[i] = 0.0;
        }
        double te = tjd_ut + SweDate.getDeltaT(tjd_ut);
        this.sw.swe_set_topo(geolon, geolat, geohgt);
        if (this.calc_planet_star(te, ipl, starname, iflag, ls, serr) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(te, 1, iflag, lm, serr) == -1) {
            return -1;
        }
        if (this.calc_planet_star(te, ipl, starname, iflagcart, xs, serr) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(te, 1, iflagcart, xm, serr) == -1) {
            return -1;
        }
        double drad = starname != null && starname.length() > 0 ? 0.0 : (ipl < 21 ? SwephData.pla_diam[ipl] / 2.0 / 1.4959787066E11 : (ipl > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
        double eps = this.sl.swi_epsiln(te);
        double sidt = (iflag & 0x40) != 0 ? this.sl.swe_sidtime0(tjd_ut, eps * 57.2957795130823, 0.0) * 15.0 : this.sl.swe_sidtime(tjd_ut) * 15.0;
        double armc = sidt + geolon;
        double mdd = this.sl.swe_degnorm(ls[0] - armc);
        xh[0] = this.sl.swe_degnorm(mdd - 90.0);
        xh[1] = ls[1];
        xh[2] = ls[2];
        this.sl.swe_cotrans(xh, 0, xh, 0, 90.0 - geolat);
        double rmoon = Math.asin(1.1618815109677577E-5 / lm[2]) * 57.2957795130823;
        double rsun = Math.asin(drad / ls[2]) * 57.2957795130823;
        double rsplusrm = rsun + rmoon;
        double rsminusrm = rsun - rmoon;
        for (i = 0; i < 3; ++i) {
            x1[i] = xs[i] / ls[2];
            x2[i] = xm[i] / lm[2];
        }
        double dctr = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
        if (dctr < rsminusrm) {
            retc = 8;
        } else if (dctr < Math.abs(rsminusrm)) {
            retc = 4;
        } else if (dctr < rsplusrm) {
            retc = 16;
        } else {
            retc = 0;
            if (serr != null) {
                serr.setLength(0);
                serr.append("no solar eclipse at tjd = " + tjd_ut);
            }
        }
        double lsun = Math.asin(rsun / 2.0 * 0.0174532925199433) * 2.0;
        double lmoon = Math.asin(rmoon / 2.0 * 0.0174532925199433) * 2.0;
        double lctr = Math.asin(dctr / 2.0 * 0.0174532925199433) * 2.0;
        double lsunleft = Math.asin((-dctr + rsun + rmoon) * 0.0174532925199433 / 2.0) * 2.0;
        attr[0] = lsun > 0.0 ? lsunleft / lsun / 2.0 : 100.0;
        attr[1] = lsun > 0.0 ? lmoon / lsun : 0.0;
        if (retc == 0 || lsun == 0.0) {
            attr[2] = 100.0;
        } else if (retc == 4 || retc == 8) {
            attr[2] = lmoon * lmoon / lsun / lsun;
        } else {
            double a = 2.0 * lctr * lmoon;
            double b = 2.0 * lctr * lsun;
            if (a < 1.0E-9) {
                attr[2] = lmoon * lmoon / lsun / lsun;
            } else {
                if ((a = (lctr * lctr + lmoon * lmoon - lsun * lsun) / a) > 1.0) {
                    a = 1.0;
                }
                if (a < -1.0) {
                    a = -1.0;
                }
                if ((b = (lctr * lctr + lsun * lsun - lmoon * lmoon) / b) > 1.0) {
                    b = 1.0;
                }
                if (b < -1.0) {
                    b = -1.0;
                }
                a = Math.acos(a);
                b = Math.acos(b);
                double sc1 = a * lmoon * lmoon / 2.0;
                double sc2 = b * lsun * lsun / 2.0;
                attr[2] = ((sc1 -= Math.cos(a) * Math.sin(a) * lmoon * lmoon / 2.0) + (sc2 -= Math.cos(b) * Math.sin(b) * lsun * lsun / 2.0)) * 2.0 / Math.PI / lsun / lsun;
            }
        }
        attr[7] = dctr;
        double hmin_appr = -(34.4556 + 2.12 * Math.sqrt(geohgt)) / 60.0;
        if (xh[1] + rsun + Math.abs(hmin_appr) >= 0.0 && retc != 0) {
            retc |= 0x80;
        }
        attr[4] = this.sl.swe_degnorm(90.0 - xh[0]);
        attr[5] = xh[1];
        return retc;
    }

    int swe_sol_eclipse_when_glob(double tjd_start, int ifl, int ifltype, double[] tret, int backward, StringBuffer serr) {
        int retflag;
        block67: {
            double tt;
            int j;
            double tjds;
            double t;
            double dt;
            double tjd;
            int i;
            int i1 = 0;
            int i2 = 0;
            retflag = 0;
            int retflag2 = 0;
            double de = 6378.14;
            DblObj dtint = new DblObj();
            double[] xs = new double[6];
            double[] xm = new double[6];
            double[] ls = new double[6];
            double[] lm = new double[6];
            double[] dcore = new double[10];
            double[] dc = new double[3];
            DblObj dctr = new DblObj();
            double twohr = 0.08333333333333333;
            double tenmin = 0.006944444444444445;
            DblObj dt1 = new DblObj();
            DblObj dt2 = new DblObj();
            double[] geopos = new double[20];
            double[] attr = new double[20];
            double[] xa = new double[6];
            double[] xb = new double[6];
            int direction = 1;
            boolean dont_times = false;
            int iflag = 0x800 | (ifl &= 7);
            int iflagcart = iflag | 0x1000;
            if (ifltype == 17) {
                if (serr != null) {
                    serr.setLength(0);
                    serr.append("central partial eclipses do not exist");
                }
                return -1;
            }
            if (ifltype == 0) {
                ifltype = 63;
            }
            if (backward != 0) {
                direction = -1;
            }
            double K = (int)((tjd_start - 2451545.0) / 365.2425 * 12.3685);
            K -= (double)direction;
            while (true) {
                int m;
                retflag = 0;
                dont_times = false;
                for (i = 0; i <= 9; ++i) {
                    tret[i] = 0.0;
                }
                double T = K / 1236.85;
                double T2 = T * T;
                double T3 = T2 * T;
                double T4 = T3 * T;
                double Ff = this.sl.swe_degnorm(160.7108 + 390.67050274 * K - 0.0016341 * T2 - 2.27E-6 * T3 + 1.1E-8 * T4);
                if (Ff > 180.0) {
                    Ff -= 180.0;
                }
                if (Ff > 21.0 && Ff < 159.0) {
                    K += (double)direction;
                    continue;
                }
                tjd = 2451550.09765 + 29.530588853 * K + 1.337E-4 * T2 - 1.5E-7 * T3 + 7.3E-10 * T4;
                double M = this.sl.swe_degnorm(2.5534 + 29.10535669 * K - 2.18E-5 * T2 - 1.1E-7 * T3);
                double Mm = this.sl.swe_degnorm(201.5643 + 385.81693528 * K + 0.1017438 * T2 + 1.239E-5 * T3 + 5.8E-8 * T4);
                double E = 1.0 - 0.002516 * T - 7.4E-6 * T2;
                tjd = tjd - 0.4075 * Math.sin(Mm *= 0.0174532925199433) + 0.1721 * E * Math.sin(M *= 0.0174532925199433);
                double dtstart = 1.0;
                if (tjd < 2000000.0) {
                    dtstart = 5.0;
                }
                double dtdiv = 4.0;
                for (dt = dtstart; dt > 1.0E-4; dt /= dtdiv) {
                    i = 0;
                    t = tjd - dt;
                    while (i <= 2) {
                        if (this.sw.swe_calc(t, 0, iflag, ls, serr) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(t, 1, iflag, lm, serr) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(t, 0, iflagcart, xs, serr) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                            return -1;
                        }
                        for (m = 0; m < 3; ++m) {
                            xa[m] = xs[m] / ls[2];
                            xb[m] = xm[m] / lm[2];
                        }
                        dc[i] = Math.acos(this.sl.swi_dot_prod_unit(xa, xb)) * 57.2957795130823;
                        double rmoon = Math.asin(1.1618815109677577E-5 / lm[2]) * 57.2957795130823;
                        double rsun = Math.asin(0.004652472638342832 / ls[2]) * 57.2957795130823;
                        int n = i++;
                        dc[n] = dc[n] - (rmoon + rsun);
                        t += dt;
                    }
                    this.find_maximum(dc[0], dc[1], dc[2], dt, dtint, dctr);
                    tjd += dtint.val + dt;
                }
                tjd -= SweDate.getDeltaT(tjd);
                tjds = tjd;
                retflag = this.eclipse_where(tjd, 0, null, ifl, geopos, dcore, serr);
                if (retflag == -1) {
                    return retflag;
                }
                retflag2 = retflag;
                retflag2 = this.eclipse_how(tjd, 0, null, ifl, geopos[0], geopos[1], 0.0, attr, serr);
                if (retflag2 == -1) {
                    return retflag2;
                }
                if (retflag2 == 0) {
                    K += (double)direction;
                    continue;
                }
                tret[0] = tjd;
                if (backward != 0 && tret[0] >= tjd_start - 1.0E-4 || backward == 0 && tret[0] <= tjd_start + 1.0E-4) {
                    K += (double)direction;
                    continue;
                }
                retflag = this.eclipse_where(tjd, 0, null, ifl, geopos, dcore, serr);
                if (retflag == -1) {
                    return retflag;
                }
                if (retflag == 0) {
                    retflag = 18;
                    tret[4] = tret[5] = tjd;
                    dont_times = true;
                }
                if ((ifltype & 2) == 0 && (retflag & 2) != 0) {
                    K += (double)direction;
                    continue;
                }
                if ((ifltype & 1) == 0 && (retflag & 1) != 0) {
                    K += (double)direction;
                    continue;
                }
                if ((ifltype & 8) == 0 && (retflag & 8) != 0) {
                    K += (double)direction;
                    continue;
                }
                if ((ifltype & 0x10) == 0 && (retflag & 0x10) != 0) {
                    K += (double)direction;
                    continue;
                }
                if ((ifltype & 0x24) == 0 && (retflag & 4) != 0) {
                    K += (double)direction;
                    continue;
                }
                if (dont_times) break block67;
                int o = (retflag & 0x10) != 0 ? 0 : ((retflag & 2) != 0 ? 1 : 2);
                double dta = twohr;
                double dtb = tenmin;
                for (int n = 0; n <= o; ++n) {
                    if (n == 0) {
                        i1 = 2;
                        i2 = 3;
                    } else if (n == 1) {
                        if ((retflag & 0x10) != 0) continue;
                        i1 = 4;
                        i2 = 5;
                    } else if (n == 2) {
                        if ((retflag & 2) != 0) continue;
                        i1 = 6;
                        i2 = 7;
                    }
                    i = 0;
                    t = tjd - dta;
                    while (i <= 2) {
                        retflag2 = this.eclipse_where(t, 0, null, ifl, geopos, dcore, serr);
                        if (retflag2 == -1) {
                            return retflag2;
                        }
                        if (n == 0) {
                            dc[i] = dcore[4] / 2.0 + de / dcore[5] - dcore[2];
                        } else if (n == 1) {
                            dc[i] = Math.abs(dcore[3]) / 2.0 + de / dcore[6] - dcore[2];
                        } else if (n == 2) {
                            dc[i] = de / dcore[6] - dcore[2];
                        }
                        ++i;
                        t += dta;
                    }
                    this.find_zero(dc[0], dc[1], dc[2], dta, dt1, dt2);
                    tret[i1] = tjd + dt1.val + dta;
                    tret[i2] = tjd + dt2.val + dta;
                    m = 0;
                    dt = dtb;
                    while (m < 3) {
                        for (j = i1; j <= i2; j += i2 - i1) {
                            i = 0;
                            t = tret[j] - dt;
                            while (i < 2) {
                                retflag2 = this.eclipse_where(t, 0, null, ifl, geopos, dcore, serr);
                                if (retflag2 == -1) {
                                    return retflag2;
                                }
                                if (n == 0) {
                                    dc[i] = dcore[4] / 2.0 + de / dcore[5] - dcore[2];
                                } else if (n == 1) {
                                    dc[i] = Math.abs(dcore[3]) / 2.0 + de / dcore[6] - dcore[2];
                                } else if (n == 2) {
                                    dc[i] = de / dcore[6] - dcore[2];
                                }
                                ++i;
                                t += dt;
                            }
                            dt1.val = dc[1] / ((dc[1] - dc[0]) / dt);
                            int n2 = j;
                            tret[n2] = tret[n2] - dt1.val;
                        }
                        ++m;
                        dt /= 3.0;
                    }
                }
                if ((retflag & 4) != 0) {
                    retflag2 = this.eclipse_where(tret[0], 0, null, ifl, geopos, dcore, serr);
                    if (retflag2 == -1) {
                        return retflag2;
                    }
                    dc[0] = dcore[0];
                    retflag2 = this.eclipse_where(tret[4], 0, null, ifl, geopos, dcore, serr);
                    if (retflag2 == -1) {
                        return retflag2;
                    }
                    dc[1] = dcore[0];
                    retflag2 = this.eclipse_where(tret[5], 0, null, ifl, geopos, dcore, serr);
                    if (retflag2 == -1) {
                        return retflag2;
                    }
                    dc[2] = dcore[0];
                    if (dc[0] * dc[1] < 0.0 || dc[0] * dc[2] < 0.0) {
                        retflag |= 0x20;
                        retflag &= 0xFFFFFFFB;
                    }
                }
                if ((ifltype & 4) == 0 && (retflag & 4) != 0) {
                    K += (double)direction;
                    continue;
                }
                if ((ifltype & 0x20) != 0 || (retflag & 0x20) == 0) break;
                K += (double)direction;
            }
            int k = 2;
            for (i = 0; i < 2; ++i) {
                j = i + k;
                tt = tret[j] + SweDate.getDeltaT(tret[j]);
                if (this.sw.swe_calc(tt, 0, iflag, ls, serr) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(tt, 1, iflag, lm, serr) == -1) {
                    return -1;
                }
                dc[i] = this.sl.swe_degnorm(ls[0] - lm[0]);
                if (!(dc[i] > 180.0)) continue;
                int n = i;
                dc[n] = dc[n] - 360.0;
            }
            if (dc[0] * dc[1] >= 0.0) {
                tret[1] = 0.0;
            } else {
                tjd = tjds;
                dt = 0.1;
                dt1.val = (tret[3] - tret[2]) / 2.0;
                if (dt1.val < dt) {
                    dt = dt1.val / 2.0;
                }
                j = 0;
                while (dt > 0.01) {
                    i = 0;
                    t = tjd;
                    while (i <= 1) {
                        tt = t + SweDate.getDeltaT(t);
                        if (this.sw.swe_calc(tt, 0, iflag, ls, serr) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(tt, 1, iflag, lm, serr) == -1) {
                            return -1;
                        }
                        dc[i] = this.sl.swe_degnorm(ls[0] - lm[0]);
                        if (dc[i] > 180.0) {
                            int n = i;
                            dc[n] = dc[n] - 360.0;
                        }
                        if (dc[i] > 180.0) {
                            int n = i;
                            dc[n] = dc[n] - 360.0;
                        }
                        ++i;
                        t -= dt;
                    }
                    double a = (dc[1] - dc[0]) / dt;
                    if (a < 1.0E-10) break;
                    dt1.val = dc[0] / a;
                    tjd += dt1.val;
                    ++j;
                    dt /= 3.0;
                }
                tret[1] = tjd;
            }
        }
        return retflag;
    }

    int swe_lun_occult_when_glob(double tjd_start, int ipl, StringBuffer starname, int ifl, int ifltype, double[] tret, int backward, StringBuffer serr) {
        double tt;
        double tjds;
        double dt;
        int j;
        int i;
        int i1 = 0;
        int i2 = 0;
        int retflag = 0;
        int retflag2 = 0;
        double de = 6378.14;
        double tjd = 0.0;
        DblObj dtint = new DblObj();
        double[] xs = new double[6];
        double[] xm = new double[6];
        double[] ls = new double[6];
        double[] lm = new double[6];
        double[] dcore = new double[10];
        double[] dc = new double[20];
        DblObj dctr = new DblObj();
        double twohr = 0.08333333333333333;
        double tenmin = 0.006944444444444445;
        DblObj dt1 = new DblObj();
        DblObj dt2 = new DblObj();
        double dadd = 10.0;
        double dadd2 = 6.0;
        int nstartpos = 10;
        double[] geopos = new double[20];
        int direction = 1;
        boolean dont_times = false;
        int one_try = backward & 0x8000;
        int iflag = 0x800 | (ifl &= 7);
        int iflagcart = iflag | 0x1000;
        backward = (int)((long)backward & 1L);
        if (ifltype == 17) {
            if (serr != null) {
                serr.setLength(0);
                serr.append("central partial eclipses do not exist");
            }
            return -1;
        }
        if (ifltype == 0) {
            ifltype = 63;
        }
        retflag = 0;
        dont_times = false;
        if ((backward & 0x4000) != 0) {
            dont_times = true;
        }
        for (i = 0; i <= 9; ++i) {
            tret[i] = 0.0;
        }
        if (backward != 0) {
            direction = -1;
        }
        double t = tjd_start - (double)direction * 0.001;
        while (true) {
            i = 0;
            while (i < nstartpos) {
                if (this.calc_planet_star(t, ipl, starname, iflagcart, xs, serr) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                    return -1;
                }
                dc[i] = Math.acos(this.sl.swi_dot_prod_unit(xs, xm)) * 57.2957795130823;
                if (i > 1 && dc[i] > dc[i - 1] && dc[i - 2] > dc[i - 1]) {
                    tjd = t - (double)direction * dadd2;
                    break;
                }
                if (i == nstartpos - 1) {
                    for (j = 0; j < nstartpos; ++j) {
                        System.out.print(dc[j] + " ");
                    }
                    System.err.println("problem planet");
                    System.exit(0);
                }
                ++i;
                t += (double)direction * dadd2;
            }
            double drad = starname != null && starname.length() > 0 ? 0.0 : (ipl < 21 ? SwephData.pla_diam[ipl] / 2.0 / 1.4959787066E11 : (ipl > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            double dtstart = dadd2;
            double dtdiv = 3.0;
            for (dt = dtstart; dt > 1.0E-4; dt /= dtdiv) {
                i = 0;
                t = tjd - dt;
                while (i <= 2) {
                    if (this.calc_planet_star(t, ipl, starname, iflag, ls, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflag, lm, serr) == -1) {
                        return -1;
                    }
                    if (this.calc_planet_star(t, ipl, starname, iflagcart, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                        return -1;
                    }
                    dc[i] = Math.acos(this.sl.swi_dot_prod_unit(xs, xm)) * 57.2957795130823;
                    double rmoon = Math.asin(1.1618815109677577E-5 / lm[2]) * 57.2957795130823;
                    double rsun = Math.asin(drad / ls[2]) * 57.2957795130823;
                    int n = i++;
                    dc[n] = dc[n] - (rmoon + rsun);
                    t += dt;
                }
                this.find_maximum(dc[0], dc[1], dc[2], dt, dtint, dctr);
                tjd += dtint.val + dt;
            }
            tjd -= SweDate.getDeltaT(tjd);
            tjds = tjd;
            retflag = this.eclipse_where(tjd, ipl, starname, ifl, geopos, dcore, serr);
            if (retflag == -1) {
                return retflag;
            }
            retflag2 = retflag;
            if (retflag2 == 0) {
                if (one_try != 0) {
                    tret[0] = tjd;
                    return 0;
                }
                t = tjd + (double)direction * dadd;
                continue;
            }
            tret[0] = tjd;
            if (backward != 0 && tret[0] >= tjd_start - 1.0E-4 || backward == 0 && tret[0] <= tjd_start + 1.0E-4) {
                t = tjd + (double)direction * dadd;
                continue;
            }
            retflag = this.eclipse_where(tjd, ipl, starname, ifl, geopos, dcore, serr);
            if (retflag == -1) {
                return retflag;
            }
            if (retflag == 0) {
                retflag = 18;
                tret[4] = tret[5] = tjd;
                retflag = 18;
                tret[4] = tret[5] = tjd;
                dont_times = true;
            }
            if ((ifltype & 2) == 0 && (retflag & 2) != 0) {
                t = tjd + (double)direction * dadd;
                continue;
            }
            if ((ifltype & 1) == 0 && (retflag & 1) != 0) {
                t = tjd + (double)direction * dadd;
                continue;
            }
            if ((ifltype & 8) == 0 && (retflag & 8) != 0) {
                t = tjd + (double)direction * dadd;
                continue;
            }
            if ((ifltype & 0x10) == 0 && (retflag & 0x10) != 0) {
                t = tjd + (double)direction * dadd;
                continue;
            }
            if ((ifltype & 0x24) == 0 && (retflag & 4) != 0) {
                t = tjd + (double)direction * dadd;
                continue;
            }
            if (dont_times) {
                return retflag;
            }
            int o = (retflag & 0x10) != 0 ? 0 : ((retflag & 2) != 0 ? 1 : 2);
            double dta = twohr;
            double dtb = tenmin;
            for (int n = 0; n <= o; ++n) {
                if (n == 0) {
                    i1 = 2;
                    i2 = 3;
                } else if (n == 1) {
                    if ((retflag & 0x10) != 0) continue;
                    i1 = 4;
                    i2 = 5;
                } else if (n == 2) {
                    if ((retflag & 2) != 0) continue;
                    i1 = 6;
                    i2 = 7;
                }
                i = 0;
                t = tjd - dta;
                while (i <= 2) {
                    retflag2 = this.eclipse_where(t, ipl, starname, ifl, geopos, dcore, serr);
                    if (retflag2 == -1) {
                        return retflag2;
                    }
                    if (n == 0) {
                        dc[i] = dcore[4] / 2.0 + de / dcore[5] - dcore[2];
                    } else if (n == 1) {
                        dc[i] = Math.abs(dcore[3]) / 2.0 + de / dcore[6] - dcore[2];
                    } else if (n == 2) {
                        dc[i] = de / dcore[6] - dcore[2];
                    }
                    ++i;
                    t += dta;
                }
                this.find_zero(dc[0], dc[1], dc[2], dta, dt1, dt2);
                tret[i1] = tjd + dt1.val + dta;
                tret[i2] = tjd + dt2.val + dta;
                int m = 0;
                dt = dtb;
                while (m < 3) {
                    for (j = i1; j <= i2; j += i2 - i1) {
                        i = 0;
                        t = tret[j] - dt;
                        while (i < 2) {
                            retflag2 = this.eclipse_where(t, ipl, starname, ifl, geopos, dcore, serr);
                            if (retflag2 == -1) {
                                return retflag2;
                            }
                            if (n == 0) {
                                dc[i] = dcore[4] / 2.0 + de / dcore[5] - dcore[2];
                            } else if (n == 1) {
                                dc[i] = Math.abs(dcore[3]) / 2.0 + de / dcore[6] - dcore[2];
                            } else if (n == 2) {
                                dc[i] = de / dcore[6] - dcore[2];
                            }
                            ++i;
                            t += dt;
                        }
                        dt1.val = dc[1] / ((dc[1] - dc[0]) / dt);
                        int n2 = j;
                        tret[n2] = tret[n2] - dt1.val;
                    }
                    ++m;
                    dt /= 3.0;
                }
            }
            if ((retflag & 4) != 0) {
                retflag2 = this.eclipse_where(tret[0], ipl, starname, ifl, geopos, dcore, serr);
                if (retflag2 == -1) {
                    return retflag2;
                }
                dc[0] = dcore[0];
                retflag2 = this.eclipse_where(tret[4], ipl, starname, ifl, geopos, dcore, serr);
                if (retflag2 == -1) {
                    return retflag2;
                }
                dc[1] = dcore[0];
                retflag2 = this.eclipse_where(tret[5], ipl, starname, ifl, geopos, dcore, serr);
                if (retflag2 == -1) {
                    return retflag2;
                }
                dc[2] = dcore[0];
                if (dc[0] * dc[1] < 0.0 || dc[0] * dc[2] < 0.0) {
                    retflag |= 0x20;
                    retflag &= 0xFFFFFFFB;
                }
            }
            if ((ifltype & 4) == 0 && (retflag & 4) != 0) {
                t = tjd + (double)direction * dadd;
                continue;
            }
            if ((ifltype & 0x20) != 0 || (retflag & 0x20) == 0) break;
            t = tjd + (double)direction * dadd;
        }
        int k = 2;
        for (i = 0; i < 2; ++i) {
            j = i + k;
            tt = tret[j] + SweDate.getDeltaT(tret[j]);
            if (this.calc_planet_star(tt, ipl, starname, iflag, ls, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tt, 1, iflag, lm, serr) == -1) {
                return -1;
            }
            dc[i] = this.sl.swe_degnorm(ls[0] - lm[0]);
            if (!(dc[i] > 180.0)) continue;
            int n = i;
            dc[n] = dc[n] - 360.0;
        }
        if (dc[0] * dc[1] >= 0.0) {
            tret[1] = 0.0;
        } else {
            tjd = tjds;
            dt = 0.1;
            dt1.val = (tret[3] - tret[2]) / 2.0;
            if (dt1.val < dt) {
                dt = dt1.val / 2.0;
            }
            j = 0;
            while (dt > 0.01) {
                i = 0;
                t = tjd;
                while (i <= 1) {
                    tt = t + SweDate.getDeltaT(t);
                    if (this.calc_planet_star(tt, ipl, starname, iflag, ls, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(tt, 1, iflag, lm, serr) == -1) {
                        return -1;
                    }
                    dc[i] = this.sl.swe_degnorm(ls[0] - lm[0]);
                    if (dc[i] > 180.0) {
                        int n = i;
                        dc[n] = dc[n] - 360.0;
                    }
                    if (dc[i] > 180.0) {
                        int n = i;
                        dc[n] = dc[n] - 360.0;
                    }
                    ++i;
                    t -= dt;
                }
                double a = (dc[1] - dc[0]) / dt;
                if (a < 1.0E-10) break;
                dt1.val = dc[0] / a;
                tjd += dt1.val;
                ++j;
                dt /= 3.0;
            }
            tret[1] = tjd;
        }
        return retflag;
    }

    int swe_sol_eclipse_when_loc(double tjd_start, int ifl, double[] geopos, double[] tret, double[] attr, int backward, StringBuffer serr) {
        int retflag = 0;
        int retflag2 = 0;
        double[] geopos2 = new double[20];
        double[] dcore = new double[10];
        retflag = this.eclipse_when_loc(tjd_start, ifl &= 7, geopos, tret, attr, backward, serr);
        if (retflag <= 0) {
            return retflag;
        }
        retflag2 = this.eclipse_where(tret[0], 0, null, ifl, geopos2, dcore, serr);
        if (retflag2 == -1) {
            return retflag2;
        }
        attr[3] = dcore[0];
        return retflag |= retflag2 & 2;
    }

    int swe_lun_occult_when_loc(double tjd_start, int ipl, StringBuffer starname, int ifl, double[] geopos, double[] tret, double[] attr, int backward, StringBuffer serr) {
        int retflag = 0;
        int retflag2 = 0;
        double[] geopos2 = new double[20];
        double[] dcore = new double[10];
        retflag = this.occult_when_loc(tjd_start, ipl, starname, ifl &= 7, geopos, tret, attr, backward, serr);
        if (retflag <= 0) {
            return retflag;
        }
        retflag2 = this.eclipse_where(tret[0], ipl, starname, ifl, geopos2, dcore, serr);
        if (retflag2 == -1) {
            return retflag2;
        }
        attr[3] = dcore[0];
        return retflag |= retflag2 & 2;
    }

    private int eclipse_when_loc(double tjd_start, int ifl, double[] geopos, double[] tret, double[] attr, int backward, StringBuffer serr) {
        int retflag = 0;
        DblObj dtint = new DblObj();
        double[] xs = new double[6];
        double[] xm = new double[6];
        double[] ls = new double[6];
        double[] lm = new double[6];
        double[] x1 = new double[6];
        double[] x2 = new double[6];
        double[] dc = new double[3];
        DblObj dctr = new DblObj();
        double twomin = 0.0013888888888888887;
        double tensec = 1.1574074074074075E-4;
        double twohr = 0.08333333333333333;
        double tenmin = 0.006944444444444445;
        DblObj dt1 = new DblObj();
        DblObj dt2 = new DblObj();
        int iflag = 0x8800 | ifl;
        int iflagcart = iflag | 0x1000;
        this.sw.swe_set_topo(geopos[0], geopos[1], geopos[2]);
        double K = (int)((tjd_start - 2451545.0) / 365.2425 * 12.3685);
        K = backward != 0 ? (K += 1.0) : (K -= 1.0);
        while (true) {
            int j;
            int m;
            int k;
            double ds;
            double dm;
            double t;
            int i;
            double dt;
            double T4;
            double T3;
            double T;
            double T2;
            double F;
            double Ff;
            if ((Ff = (F = this.sl.swe_degnorm(160.7108 + 390.67050274 * K - 0.0016341 * (T2 = (T = K / 1236.85) * T) - 2.27E-6 * (T3 = T2 * T) + 1.1E-8 * (T4 = T3 * T)))) > 180.0) {
                Ff -= 180.0;
            }
            if (Ff > 21.0 && Ff < 159.0) {
                if (backward != 0) {
                    K -= 1.0;
                    continue;
                }
                K += 1.0;
                continue;
            }
            double tjd = 2451550.09765 + 29.530588853 * K + 1.337E-4 * T2 - 1.5E-7 * T3 + 7.3E-10 * T4;
            double M = this.sl.swe_degnorm(2.5534 + 29.10535669 * K - 2.18E-5 * T2 - 1.1E-7 * T3);
            double Mm = this.sl.swe_degnorm(201.5643 + 385.81693528 * K + 0.1017438 * T2 + 1.239E-5 * T3 + 5.8E-8 * T4);
            double Om = this.sl.swe_degnorm(124.7746 - 1.5637558 * K + 0.0020691 * T2 + 2.15E-6 * T3);
            double E = 1.0 - 0.002516 * T - 7.4E-6 * T2;
            double A1 = this.sl.swe_degnorm(299.77 + 0.107408 * K - 0.009173 * T2);
            F *= 0.0174532925199433;
            Om *= 0.0174532925199433;
            A1 *= 0.0174532925199433;
            tjd = tjd - 0.4075 * Math.sin(Mm *= 0.0174532925199433) + 0.1721 * E * Math.sin(M *= 0.0174532925199433);
            this.sw.swe_set_topo(geopos[0], geopos[1], geopos[2]);
            double dtdiv = 2.0;
            double dtstart = 0.5;
            if (tjd < 1900000.0) {
                dtstart = 2.0;
            }
            for (dt = dtstart; dt > 1.0E-5; dt /= dtdiv) {
                if (dt < 0.1) {
                    dtdiv = 3.0;
                }
                i = 0;
                t = tjd - dt;
                while (i <= 2) {
                    if (this.sw.swe_calc(t, 0, iflagcart, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 0, iflag, ls, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflag, lm, serr) == -1) {
                        return -1;
                    }
                    dm = Math.sqrt(this.sl.square_sum(xm));
                    ds = Math.sqrt(this.sl.square_sum(xs));
                    for (k = 0; k < 3; ++k) {
                        x1[k] = xs[k] / ds;
                        x2[k] = xm[k] / dm;
                    }
                    dc[i] = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                    ++i;
                    t += dt;
                }
                this.find_maximum(dc[0], dc[1], dc[2], dt, dtint, dctr);
                tjd += dtint.val + dt;
            }
            if (this.sw.swe_calc(tjd, 0, iflagcart, xs, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tjd, 0, iflag, ls, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tjd, 1, iflagcart, xm, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tjd, 1, iflag, lm, serr) == -1) {
                return -1;
            }
            dctr.val = Math.acos(this.sl.swi_dot_prod_unit(xs, xm)) * 57.2957795130823;
            double rmoon = Math.asin(1.1618815109677577E-5 / lm[2]) * 57.2957795130823;
            double rsun = Math.asin(0.004652472638342832 / ls[2]) * 57.2957795130823;
            double rsplusrm = rsun + rmoon;
            double rsminusrm = rsun - rmoon;
            if (dctr.val > rsplusrm) {
                if (backward != 0) {
                    K -= 1.0;
                    continue;
                }
                K += 1.0;
                continue;
            }
            tret[0] = tjd - SweDate.getDeltaT(tjd);
            if (backward != 0 && tret[0] >= tjd_start - 1.0E-4 || backward == 0 && tret[0] <= tjd_start + 1.0E-4) {
                if (backward != 0) {
                    K -= 1.0;
                    continue;
                }
                K += 1.0;
                continue;
            }
            if (dctr.val < rsminusrm) {
                retflag = 8;
            } else if (dctr.val < Math.abs(rsminusrm)) {
                retflag = 4;
            } else if (dctr.val <= rsplusrm) {
                retflag = 16;
            }
            double dctrmin = dctr.val;
            if (dctr.val > Math.abs(rsminusrm)) {
                tret[3] = 0.0;
                tret[2] = 0.0;
            } else {
                dc[1] = Math.abs(rsminusrm) - dctrmin;
                t = tjd - twomin;
                for (i = 0; i <= 2; i += 2) {
                    if (this.sw.swe_calc(t, 0, iflagcart, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                        return -1;
                    }
                    dm = Math.sqrt(this.sl.square_sum(xm));
                    ds = Math.sqrt(this.sl.square_sum(xs));
                    rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                    rsun = Math.asin(0.004652472638342832 / ds) * 57.2957795130823;
                    rsminusrm = rsun - rmoon;
                    for (k = 0; k < 3; ++k) {
                        x1[k] = xs[k] / ds;
                        x2[k] = xm[k] / dm;
                    }
                    dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                    dc[i] = Math.abs(rsminusrm) - dctr.val;
                    t = tjd + twomin;
                }
                this.find_zero(dc[0], dc[1], dc[2], twomin, dt1, dt2);
                tret[2] = tjd + dt1.val + twomin;
                tret[3] = tjd + dt2.val + twomin;
                m = 0;
                dt = tensec;
                while (m < 2) {
                    j = 2;
                    while (j <= 3) {
                        if (this.sw.swe_calc(tret[j], 0, iflagcart | 0x100, xs, serr) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(tret[j], 1, iflagcart | 0x100, xm, serr) == -1) {
                            return -1;
                        }
                        for (i = 0; i < 2; ++i) {
                            if (i == 1) {
                                for (k = 0; k < 3; ++k) {
                                    int n = k;
                                    xs[n] = xs[n] - xs[k + 3] * dt;
                                    int n2 = k;
                                    xm[n2] = xm[n2] - xm[k + 3] * dt;
                                }
                            }
                            dm = Math.sqrt(this.sl.square_sum(xm));
                            ds = Math.sqrt(this.sl.square_sum(xs));
                            rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                            rsun = Math.asin(0.004652472638342832 / ds) * 57.2957795130823;
                            rsminusrm = rsun - rmoon;
                            for (k = 0; k < 3; ++k) {
                                x1[k] = xs[k] / ds;
                                x2[k] = xm[k] / dm;
                            }
                            dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                            dc[i] = Math.abs(rsminusrm) - dctr.val;
                        }
                        dt1.val = -dc[0] / ((dc[0] - dc[1]) / dt);
                        int n = j++;
                        tret[n] = tret[n] + dt1.val;
                    }
                    ++m;
                    dt /= 10.0;
                }
                tret[2] = tret[2] - SweDate.getDeltaT(tret[2]);
                tret[3] = tret[3] - SweDate.getDeltaT(tret[3]);
            }
            dc[1] = rsplusrm - dctrmin;
            t = tjd - twohr;
            for (i = 0; i <= 2; i += 2) {
                if (this.sw.swe_calc(t, 0, iflagcart, xs, serr) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                    return -1;
                }
                dm = Math.sqrt(this.sl.square_sum(xm));
                ds = Math.sqrt(this.sl.square_sum(xs));
                rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                rsun = Math.asin(0.004652472638342832 / ds) * 57.2957795130823;
                rsplusrm = rsun + rmoon;
                for (k = 0; k < 3; ++k) {
                    x1[k] = xs[k] / ds;
                    x2[k] = xm[k] / dm;
                }
                dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                dc[i] = rsplusrm - dctr.val;
                t = tjd + twohr;
            }
            this.find_zero(dc[0], dc[1], dc[2], twohr, dt1, dt2);
            tret[1] = tjd + dt1.val + twohr;
            tret[4] = tjd + dt2.val + twohr;
            m = 0;
            dt = tenmin;
            while (m < 3) {
                for (j = 1; j <= 4; j += 3) {
                    if (this.sw.swe_calc(tret[j], 0, iflagcart | 0x100, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(tret[j], 1, iflagcart | 0x100, xm, serr) == -1) {
                        return -1;
                    }
                    for (i = 0; i < 2; ++i) {
                        if (i == 1) {
                            for (k = 0; k < 3; ++k) {
                                int n = k;
                                xs[n] = xs[n] - xs[k + 3] * dt;
                                int n3 = k;
                                xm[n3] = xm[n3] - xm[k + 3] * dt;
                            }
                        }
                        dm = Math.sqrt(this.sl.square_sum(xm));
                        ds = Math.sqrt(this.sl.square_sum(xs));
                        rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                        rsun = Math.asin(0.004652472638342832 / ds) * 57.2957795130823;
                        rsplusrm = rsun + rmoon;
                        for (k = 0; k < 3; ++k) {
                            x1[k] = xs[k] / ds;
                            x2[k] = xm[k] / dm;
                        }
                        dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                        dc[i] = Math.abs(rsplusrm) - dctr.val;
                    }
                    dt1.val = -dc[0] / ((dc[0] - dc[1]) / dt);
                    int n = j;
                    tret[n] = tret[n] + dt1.val;
                }
                ++m;
                dt /= 10.0;
            }
            tret[1] = tret[1] - SweDate.getDeltaT(tret[1]);
            tret[4] = tret[4] - SweDate.getDeltaT(tret[4]);
            block25: for (i = 4; i >= 0; --i) {
                if (tret[i] == 0.0) continue;
                if (this.eclipse_how(tret[i], 0, null, ifl, geopos[0], geopos[1], geopos[2], attr, serr) == -1) {
                    return -1;
                }
                if (!(attr[5] > 0.0)) continue;
                retflag |= 0x80;
                switch (i) {
                    case 0: {
                        retflag |= 0x100;
                        continue block25;
                    }
                    case 1: {
                        retflag |= 0x200;
                        continue block25;
                    }
                    case 2: {
                        retflag |= 0x400;
                        continue block25;
                    }
                    case 3: {
                        retflag |= 0x800;
                        continue block25;
                    }
                    case 4: {
                        retflag |= 0x1000;
                        continue block25;
                    }
                }
            }
            if ((retflag & 0x80) != 0) break;
            if (backward != 0) {
                K -= 1.0;
                continue;
            }
            K += 1.0;
        }
        return retflag;
    }

    /*
     * Unable to fully structure code
     */
    private int occult_when_loc(double tjd_start, int ipl, StringBuffer starname, int ifl, double[] geopos, double[] tret, double[] attr, int backward, StringBuffer serr) {
        retflag = 0;
        dtint = new DblObj();
        xs = new double[6];
        xm = new double[6];
        ls = new double[6];
        lm = new double[6];
        x1 = new double[6];
        x2 = new double[6];
        dc = new double[20];
        dctr = new DblObj();
        twomin = 0.0013888888888888887;
        tensec = 1.1574074074074075E-4;
        twohr = 0.08333333333333333;
        tenmin = 0.006944444444444445;
        dt1 = new DblObj();
        dt2 = new DblObj();
        dadd2 = 6.0;
        nstartpos = 10;
        iflag = 32768 | ifl;
        iflaggeo = iflag & -32769;
        iflagcart = iflag | 4096;
        iflagcartgeo = iflaggeo | 4096;
        direction = 1;
        one_try = backward & 32768;
        stop_after_this = false;
        backward = (int)((long)backward & 1L);
        retflag = 0;
        for (i = 0; i <= 9; ++i) {
            tret[i] = 0.0;
        }
        if (backward != 0) {
            direction = -1;
        }
        t = tjd_start - (double)direction * 0.1;
        tjd = tjd_start;
        while (true) {
            i = 0;
            while (i < nstartpos) {
                if (this.calc_planet_star(t, ipl, starname, iflagcartgeo, xs, serr) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(t, 1, iflagcartgeo, xm, serr) == -1) {
                    return -1;
                }
                dc[i] = Math.acos(this.sl.swi_dot_prod_unit(xs, xm)) * 57.2957795130823;
                if (i > 1 && dc[i] > dc[i - 1] && dc[i - 2] > dc[i - 1]) {
                    tjd = t - (double)direction * dadd2;
                    break;
                }
                if (i == nstartpos - 1) {
                    for (j = 0; j < nstartpos; ++j) {
                        System.out.print(dc[j] + " ");
                    }
                    System.out.print("swe_lun_occult_when_loc(): problem planet\n");
                    return -1;
                }
                ++i;
                t += (double)direction * dadd2;
            }
            drad = starname != null && starname.length() > 0 ? 0.0 : (ipl < 21 ? SwephData.pla_diam[ipl] / 2.0 / 1.4959787066E11 : (ipl > 10000 ? this.swed.ast_diam / 2.0 * 1000.0 / 1.4959787066E11 : 0.0));
            dtdiv = 3.0;
            for (dt = dtstart = dadd2; dt > 1.0E-5; dt /= dtdiv) {
                if (dt < 0.01) {
                    dtdiv = 3.0;
                }
                i = 0;
                t = tjd - dt;
                while (i <= 2) {
                    if (this.calc_planet_star(t, ipl, starname, iflagcart, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.calc_planet_star(t, ipl, starname, iflag, ls, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflag, lm, serr) == -1) {
                        return -1;
                    }
                    if (!(dt < 1.0) || !(Math.abs(ls[1] - lm[1]) > 2.0)) ** GOTO lbl76
                    if (one_try == 0) {
                        t = tjd + (double)(direction * 2);
                    } else {
                        stop_after_this = true;
lbl76:
                        // 2 sources

                        dc[i] = Math.acos(this.sl.swi_dot_prod_unit(xs, xm)) * 57.2957795130823;
                        rmoon = Math.asin(1.1618815109677577E-5 / lm[2]) * 57.2957795130823;
                        rsun = Math.asin(drad / ls[2]) * 57.2957795130823;
                        v0 = i;
                        dc[v0] = dc[v0] - (rmoon + rsun);
                    }
                    ++i;
                    t += dt;
                }
                this.find_maximum(dc[0], dc[1], dc[2], dt, dtint, dctr);
                tjd += dtint.val + dt;
            }
            if (stop_after_this) {
                tret[0] = tjd;
                return 0;
            }
            if (this.calc_planet_star(tjd, ipl, starname, iflagcart, xs, serr) == -1) {
                return -1;
            }
            if (this.calc_planet_star(tjd, ipl, starname, iflag, ls, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tjd, 1, iflagcart, xm, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tjd, 1, iflag, lm, serr) == -1) {
                return -1;
            }
            dctr.val = Math.acos(this.sl.swi_dot_prod_unit(xs, xm)) * 57.2957795130823;
            rmoon = Math.asin(1.1618815109677577E-5 / lm[2]) * 57.2957795130823;
            rsun = Math.asin(drad / ls[2]) * 57.2957795130823;
            rsplusrm = rsun + rmoon;
            rsminusrm = rsun - rmoon;
            if (dctr.val > rsplusrm) {
                if (one_try != 0) {
                    tret[0] = tjd;
                    return 0;
                }
                t = tjd + (double)direction;
                continue;
            }
            tret[0] = tjd - SweDate.getDeltaT(tjd);
            if (backward != 0 && tret[0] >= tjd_start - 1.0E-4 || backward == 0 && tret[0] <= tjd_start + 1.0E-4) {
                t = tjd + (double)direction;
                continue;
            }
            if (dctr.val < rsminusrm) {
                retflag = 8;
            } else if (dctr.val < Math.abs(rsminusrm)) {
                retflag = 4;
            } else if (dctr.val <= rsplusrm) {
                retflag = 16;
            }
            dctrmin = dctr.val;
            if (dctr.val > Math.abs(rsminusrm)) {
                tret[3] = 0.0;
                tret[2] = 0.0;
            } else {
                dc[1] = Math.abs(rsminusrm) - dctrmin;
                t = tjd - twomin;
                for (i = 0; i <= 2; i += 2) {
                    if (this.calc_planet_star(t, ipl, starname, iflagcart, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                        return -1;
                    }
                    dm = Math.sqrt(this.sl.square_sum(xm));
                    ds = Math.sqrt(this.sl.square_sum(xs));
                    rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                    rsun = Math.asin(drad / ds) * 57.2957795130823;
                    rsminusrm = rsun - rmoon;
                    for (k = 0; k < 3; ++k) {
                        x1[k] = xs[k] / ds;
                        x2[k] = xm[k] / dm;
                    }
                    dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                    dc[i] = Math.abs(rsminusrm) - dctr.val;
                    t = tjd + twomin;
                }
                this.find_zero(dc[0], dc[1], dc[2], twomin, dt1, dt2);
                tret[2] = tjd + dt1.val + twomin;
                tret[3] = tjd + dt2.val + twomin;
                m = 0;
                dt = tensec;
                while (m < 2) {
                    j = 2;
                    while (j <= 3) {
                        if (this.calc_planet_star(tret[j], ipl, starname, iflagcart | 256, xs, serr) == -1) {
                            return -1;
                        }
                        if (this.sw.swe_calc(tret[j], 1, iflagcart | 256, xm, serr) == -1) {
                            return -1;
                        }
                        for (i = 0; i < 2; ++i) {
                            if (i == 1) {
                                for (k = 0; k < 3; ++k) {
                                    v1 = k;
                                    xs[v1] = xs[v1] - xs[k + 3] * dt;
                                    v2 = k;
                                    xm[v2] = xm[v2] - xm[k + 3] * dt;
                                }
                            }
                            dm = Math.sqrt(this.sl.square_sum(xm));
                            ds = Math.sqrt(this.sl.square_sum(xs));
                            rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                            rsun = Math.asin(drad / ds) * 57.2957795130823;
                            rsminusrm = rsun - rmoon;
                            for (k = 0; k < 3; ++k) {
                                x1[k] = xs[k] / ds;
                                x2[k] = xm[k] / dm;
                            }
                            dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                            dc[i] = Math.abs(rsminusrm) - dctr.val;
                        }
                        dt1.val = -dc[0] / ((dc[0] - dc[1]) / dt);
                        v3 = j++;
                        tret[v3] = tret[v3] + dt1.val;
                    }
                    ++m;
                    dt /= 10.0;
                }
                tret[2] = tret[2] - SweDate.getDeltaT(tret[2]);
                tret[3] = tret[3] - SweDate.getDeltaT(tret[3]);
            }
            dc[1] = rsplusrm - dctrmin;
            t = tjd - twohr;
            for (i = 0; i <= 2; i += 2) {
                if (this.calc_planet_star(t, ipl, starname, iflagcart, xs, serr) == -1) {
                    return -1;
                }
                if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                    return -1;
                }
                dm = Math.sqrt(this.sl.square_sum(xm));
                ds = Math.sqrt(this.sl.square_sum(xs));
                rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                rsun = Math.asin(drad / ds) * 57.2957795130823;
                rsplusrm = rsun + rmoon;
                for (k = 0; k < 3; ++k) {
                    x1[k] = xs[k] / ds;
                    x2[k] = xm[k] / dm;
                }
                dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                dc[i] = rsplusrm - dctr.val;
                t = tjd + twohr;
            }
            this.find_zero(dc[0], dc[1], dc[2], twohr, dt1, dt2);
            tret[1] = tjd + dt1.val + twohr;
            tret[4] = tjd + dt2.val + twohr;
            m = 0;
            dt = tenmin;
            while (m < 3) {
                for (j = 1; j <= 4; j += 3) {
                    if (this.calc_planet_star(tret[j], ipl, starname, iflagcart | 256, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(tret[j], 1, iflagcart | 256, xm, serr) == -1) {
                        return -1;
                    }
                    for (i = 0; i < 2; ++i) {
                        if (i == 1) {
                            for (k = 0; k < 3; ++k) {
                                v4 = k;
                                xs[v4] = xs[v4] - xs[k + 3] * dt;
                                v5 = k;
                                xm[v5] = xm[v5] - xm[k + 3] * dt;
                            }
                        }
                        dm = Math.sqrt(this.sl.square_sum(xm));
                        ds = Math.sqrt(this.sl.square_sum(xs));
                        rmoon = Math.asin(1.1618815109677577E-5 / dm) * 57.2957795130823;
                        rsun = Math.asin(drad / ds) * 57.2957795130823;
                        rsplusrm = rsun + rmoon;
                        for (k = 0; k < 3; ++k) {
                            x1[k] = xs[k] / ds;
                            x2[k] = xm[k] / dm;
                        }
                        dctr.val = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
                        dc[i] = Math.abs(rsplusrm) - dctr.val;
                    }
                    dt1.val = -dc[0] / ((dc[0] - dc[1]) / dt);
                    v6 = j;
                    tret[v6] = tret[v6] + dt1.val;
                }
                ++m;
                dt /= 10.0;
            }
            tret[1] = tret[1] - SweDate.getDeltaT(tret[1]);
            tret[4] = tret[4] - SweDate.getDeltaT(tret[4]);
            block27: for (i = 4; i >= 0; --i) {
                if (tret[i] == 0.0) continue;
                if (this.eclipse_how(tret[i], ipl, starname, ifl, geopos[0], geopos[1], geopos[2], attr, serr) == -1) {
                    return -1;
                }
                if (!(attr[5] > 0.0)) continue;
                retflag |= 128;
                switch (i) {
                    case 0: {
                        retflag |= 256;
                        continue block27;
                    }
                    case 1: {
                        retflag |= 512;
                        continue block27;
                    }
                    case 2: {
                        retflag |= 1024;
                        continue block27;
                    }
                    case 3: {
                        retflag |= 2048;
                        continue block27;
                    }
                    case 4: {
                        retflag |= 4096;
                        continue block27;
                    }
                }
            }
            if ((retflag & 128) != 0) break;
            t = tjd + (double)direction;
        }
        return retflag;
    }

    void swe_azalt(double tjd_ut, int calc_flag, double[] geopos, double atpress, double attemp, double[] xin, double[] xaz) {
        double[] x = new double[6];
        double[] xra = new double[3];
        double armc = this.sl.swe_degnorm(this.sl.swe_sidtime(tjd_ut) * 15.0 + geopos[0]);
        for (int i = 0; i < 2; ++i) {
            xra[i] = xin[i];
        }
        xra[2] = 1.0;
        if (calc_flag == 0) {
            double tjd_et = tjd_ut + SweDate.getDeltaT(tjd_ut);
            this.sw.swe_calc(tjd_et, -1, 0, x, null);
            double eps_true = x[0];
            this.sl.swe_cotrans(xra, 0, xra, 0, -eps_true);
        }
        double mdd = this.sl.swe_degnorm(xra[0] - armc);
        x[0] = this.sl.swe_degnorm(mdd - 90.0);
        x[1] = xra[1];
        x[2] = 1.0;
        this.sl.swe_cotrans(x, 0, x, 0, 90.0 - geopos[1]);
        x[0] = this.sl.swe_degnorm(x[0] + 90.0);
        xaz[0] = 360.0 - x[0];
        xaz[1] = x[1];
        if (atpress == 0.0) {
            atpress = 1013.25 * Math.pow(1.0 - 0.0065 * geopos[2] / 288.0, 5.255);
        }
        xaz[2] = this.swe_refrac(x[1], atpress, attemp, 0);
    }

    void swe_azalt_rev(double tjd_ut, int calc_flag, double[] geopos, double[] xin, double[] xout) {
        double[] x = new double[6];
        double[] xaz = new double[3];
        double geolon = geopos[0];
        double geolat = geopos[1];
        double armc = this.sl.swe_degnorm(this.sl.swe_sidtime(tjd_ut) * 15.0 + geolon);
        for (int i = 0; i < 2; ++i) {
            xaz[i] = xin[i];
        }
        xaz[2] = 1.0;
        xaz[0] = 360.0 - xaz[0];
        xaz[0] = this.sl.swe_degnorm(xaz[0] - 90.0);
        this.sl.swe_cotrans(xaz, 0, xaz, 0, geolat - 90.0);
        xaz[0] = this.sl.swe_degnorm(xaz[0] + armc + 90.0);
        xout[0] = xaz[0];
        xout[1] = xaz[1];
        if (calc_flag == 0) {
            double tjd_et = tjd_ut + SweDate.getDeltaT(tjd_ut);
            this.sw.swe_calc(tjd_et, -1, 0, x, null);
            double eps_true = x[0];
            this.sl.swe_cotrans(xaz, 0, x, 0, eps_true);
            xout[0] = x[0];
            xout[1] = x[1];
        }
    }

    double swe_refrac(double inalt, double atpress, double attemp, int calc_flag) {
        double refr;
        double pt_factor = atpress / 1010.0 * 283.0 / (273.0 + attemp);
        if (calc_flag == 0) {
            double refr2;
            double trualt = inalt;
            if (trualt > 15.0) {
                double a = Math.tan((90.0 - trualt) * 0.0174532925199433);
                refr2 = 58.276 * a - 0.0824 * a * a * a;
                refr2 *= pt_factor / 3600.0;
            } else if (trualt > -5.0) {
                double a = trualt + 10.3 / (trualt + 5.11);
                refr2 = a + 1.0E-10 >= 90.0 ? 0.0 : 1.02 / Math.tan(a * 0.0174532925199433);
                refr2 *= pt_factor / 60.0;
            } else {
                refr2 = 0.0;
            }
            double appalt = trualt;
            if (appalt + refr2 > 0.0) {
                appalt += refr2;
            }
            return appalt;
        }
        double appalt = inalt;
        if (appalt > 15.0) {
            double a = Math.tan((90.0 - appalt) * 0.0174532925199433);
            refr = 58.294 * a - 0.0668 * a * a * a;
            refr *= pt_factor / 3600.0;
        } else {
            double a = appalt + 7.31 / (appalt + 4.4);
            if (a + 1.0E-10 >= 90.0) {
                refr = 0.0;
            } else {
                refr = 1.0 / Math.tan(a * 0.0174532925199433);
                refr -= 0.06 * Math.sin(14.7 * refr + 13.0);
            }
            refr *= pt_factor / 60.0;
        }
        double trualt = appalt;
        if (trualt - refr > 0.0) {
            trualt -= refr;
        }
        return trualt;
    }

    int swe_lun_eclipse_how(double tjd_ut, int ifl, double[] geopos, double[] attr, StringBuffer serr) {
        double[] dcore = new double[10];
        return this.lun_eclipse_how(tjd_ut, ifl &= 0xFFFF7FFF, attr, dcore, serr);
    }

    private int lun_eclipse_how(double tjd_ut, int ifl, double[] attr, double[] dcore, StringBuffer serr) {
        int i;
        int retc = 0;
        double[] e = new double[6];
        double[] rm = new double[6];
        double[] rs = new double[6];
        double[] x1 = new double[6];
        double[] x2 = new double[6];
        for (i = 0; i < 10; ++i) {
            dcore[i] = 0.0;
        }
        for (i = 0; i < 20; ++i) {
            attr[i] = 0.0;
        }
        int iflag = 0x900 | ifl;
        double deltat = SweDate.getDeltaT(tjd_ut);
        double tjd = tjd_ut + deltat;
        if (this.sw.swe_calc(tjd, 1, iflag |= 0x1000, rm, serr) == -1) {
            return -1;
        }
        double dm = Math.sqrt(this.sl.square_sum(rm));
        if (this.sw.swe_calc(tjd, 0, iflag, rs, serr) == -1) {
            return -1;
        }
        double ds = Math.sqrt(this.sl.square_sum(rs));
        for (i = 0; i < 3; ++i) {
            x1[i] = rs[i] / ds;
            x2[i] = rm[i] / dm;
        }
        double dctr = Math.acos(this.sl.swi_dot_prod_unit(x1, x2)) * 57.2957795130823;
        for (i = 0; i <= 2; ++i) {
            int n = i;
            rs[n] = rs[n] - rm[i];
        }
        for (i = 0; i <= 2; ++i) {
            rm[i] = -rm[i];
        }
        for (i = 0; i <= 2; ++i) {
            e[i] = rm[i] - rs[i];
        }
        double dsm = Math.sqrt(this.sl.square_sum(e));
        i = 0;
        while (i <= 2) {
            int n = i++;
            e[n] = e[n] / dsm;
        }
        double f1 = 0.004609837405823407 / dsm;
        double cosf1 = Math.sqrt(1.0 - f1 * f1);
        double f2 = 0.004695107870862257 / dsm;
        double cosf2 = Math.sqrt(1.0 - f2 * f2);
        double s0 = -this.sw.dot_prod(rm, e);
        double r0 = Math.sqrt(dm * dm - s0 * s0);
        double d0 = Math.abs(s0 / dsm * 0.009219674811646815 - 8.527046503885043E-5) * 1.02 / cosf1;
        double D0 = (s0 / dsm * 0.009390215741724514 + 8.527046503885043E-5) * 1.02 / cosf2;
        dcore[0] = r0;
        dcore[1] = d0 /= cosf1;
        dcore[2] = D0 /= cosf2;
        dcore[3] = cosf1;
        dcore[4] = cosf2;
        retc = 0;
        if (d0 / 2.0 >= r0 + 1.1618815109677577E-5 / cosf1) {
            retc = 4;
            attr[0] = (d0 / 2.0 - r0 + 1.1618815109677577E-5) / 2.3237630219355155E-5;
        } else if (d0 / 2.0 >= r0 - 1.1618815109677577E-5 / cosf1) {
            retc = 16;
            attr[0] = (d0 / 2.0 - r0 + 1.1618815109677577E-5) / 2.3237630219355155E-5;
        } else if (D0 / 2.0 >= r0 - 1.1618815109677577E-5 / cosf2) {
            retc = 64;
            attr[0] = 0.0;
        } else if (serr != null) {
            serr.setLength(0);
            serr.append("no lunar eclipse at tjd = " + tjd);
        }
        attr[1] = (D0 / 2.0 - r0 + 1.1618815109677577E-5) / 2.3237630219355155E-5;
        if (retc != 0) {
            attr[7] = 180.0 - Math.abs(dctr);
        }
        return retc;
    }

    int swe_lun_eclipse_when(double tjd_start, int ifl, int ifltype, double[] tret, int backward, StringBuffer serr) {
        int m;
        double t;
        double dt;
        int j;
        double tjd;
        int i;
        int i1 = 0;
        int i2 = 0;
        int retflag = 0;
        int retflag2 = 0;
        DblObj dtint = new DblObj();
        double[] xs = new double[6];
        double[] xm = new double[6];
        double[] dcore = new double[10];
        double[] dc = new double[3];
        DblObj dctr = new DblObj();
        double twohr = 0.08333333333333333;
        double tenmin = 0.006944444444444445;
        DblObj dt1 = new DblObj();
        DblObj dt2 = new DblObj();
        double[] attr = new double[20];
        double[] xa = new double[6];
        double[] xb = new double[6];
        int direction = 1;
        int iflag = 0x800 | (ifl &= 7);
        int iflagcart = iflag | 0x1000;
        if (ifltype == 0) {
            ifltype = 84;
        }
        if (backward != 0) {
            direction = -1;
        }
        double K = (int)((tjd_start - 2451545.0) / 365.2425 * 12.3685);
        K -= (double)direction;
        while (true) {
            retflag = 0;
            for (i = 0; i <= 9; ++i) {
                tret[i] = 0.0;
            }
            double kk = K + 0.5;
            double T = kk / 1236.85;
            double T2 = T * T;
            double T3 = T2 * T;
            double T4 = T3 * T;
            double F = this.sl.swe_degnorm(160.7108 + 390.67050274 * kk - 0.0016341 * T2 - 2.27E-6 * T3 + 1.1E-8 * T4);
            double Ff = F;
            if (Ff > 180.0) {
                Ff -= 180.0;
            }
            if (Ff > 21.0 && Ff < 159.0) {
                K += (double)direction;
                continue;
            }
            tjd = 2451550.09765 + 29.530588853 * kk + 1.337E-4 * T2 - 1.5E-7 * T3 + 7.3E-10 * T4;
            double M = this.sl.swe_degnorm(2.5534 + 29.10535669 * kk - 2.18E-5 * T2 - 1.1E-7 * T3);
            double Mm = this.sl.swe_degnorm(201.5643 + 385.81693528 * kk + 0.1017438 * T2 + 1.239E-5 * T3 + 5.8E-8 * T4);
            double Om = this.sl.swe_degnorm(124.7746 - 1.5637558 * kk + 0.0020691 * T2 + 2.15E-6 * T3);
            double E = 1.0 - 0.002516 * T - 7.4E-6 * T2;
            double A1 = this.sl.swe_degnorm(299.77 + 0.107408 * kk - 0.009173 * T2);
            double F1 = (F *= 0.0174532925199433) - 0.02665 * Math.sin(Om *= 0.0174532925199433) * 0.0174532925199433;
            tjd = tjd - 0.4075 * Math.sin(Mm *= 0.0174532925199433) + 0.1721 * E * Math.sin(M *= 0.0174532925199433) + 0.0161 * Math.sin(2.0 * Mm) - 0.0097 * Math.sin(2.0 * F1) + 0.0073 * E * Math.sin(Mm - M) - 0.005 * E * Math.sin(Mm + M) - 0.0023 * Math.sin(Mm - 2.0 * F1) + 0.0021 * E * Math.sin(2.0 * M) + 0.0012 * Math.sin(Mm + 2.0 * F1) + 6.0E-4 * E * Math.sin(2.0 * Mm + M) - 4.0E-4 * Math.sin(3.0 * Mm) - 3.0E-4 * E * Math.sin(M + 2.0 * F1) + 3.0E-4 * Math.sin(A1 *= 0.0174532925199433) - 2.0E-4 * E * Math.sin(M - 2.0 * F1) - 2.0E-4 * E * Math.sin(2.0 * Mm - M) - 2.0E-4 * Math.sin(Om);
            double dtstart = 0.1;
            if (tjd < 2000000.0) {
                dtstart = 5.0;
            }
            double dtdiv = 4.0;
            j = 0;
            for (dt = dtstart; dt > 0.001; dt /= dtdiv) {
                i = 0;
                t = tjd - dt;
                while (i <= 2) {
                    if (this.sw.swe_calc(t, 0, iflagcart, xs, serr) == -1) {
                        return -1;
                    }
                    if (this.sw.swe_calc(t, 1, iflagcart, xm, serr) == -1) {
                        return -1;
                    }
                    for (m = 0; m < 3; ++m) {
                        int n = m;
                        xs[n] = xs[n] - xm[m];
                        xm[m] = -xm[m];
                    }
                    double ds = Math.sqrt(this.sl.square_sum(xs));
                    double dm = Math.sqrt(this.sl.square_sum(xm));
                    for (m = 0; m < 3; ++m) {
                        xa[m] = xs[m] / ds;
                        xb[m] = xm[m] / dm;
                    }
                    dc[i] = Math.acos(this.sl.swi_dot_prod_unit(xa, xb)) * 57.2957795130823;
                    double rearth = Math.asin(4.263523251942522E-5 / dm) * 57.2957795130823;
                    double rsun = Math.asin(0.004652472638342832 / ds) * 57.2957795130823;
                    int n = i++;
                    dc[n] = dc[n] - (rearth + rsun);
                    t += dt;
                }
                this.find_maximum(dc[0], dc[1], dc[2], dt, dtint, dctr);
                tjd += dtint.val + dt;
                ++j;
            }
            if ((retflag = this.swe_lun_eclipse_how(tjd -= SweDate.getDeltaT(tjd), ifl, null, attr, serr)) == -1) {
                return retflag;
            }
            if (retflag == 0) {
                K += (double)direction;
                continue;
            }
            tret[0] = tjd;
            if (backward != 0 && tret[0] >= tjd_start - 1.0E-4 || backward == 0 && tret[0] <= tjd_start + 1.0E-4) {
                K += (double)direction;
                continue;
            }
            if ((ifltype & 0x40) == 0 && (retflag & 0x40) != 0) {
                K += (double)direction;
                continue;
            }
            if ((ifltype & 0x10) == 0 && (retflag & 0x10) != 0) {
                K += (double)direction;
                continue;
            }
            if ((ifltype & 4) != 0 || (retflag & 4) == 0) break;
            K += (double)direction;
        }
        int o = (retflag & 0x40) != 0 ? 0 : ((retflag & 0x10) != 0 ? 1 : 2);
        double dta = twohr;
        double dtb = tenmin;
        for (int n = 0; n <= o; ++n) {
            if (n == 0) {
                i1 = 6;
                i2 = 7;
            } else if (n == 1) {
                i1 = 2;
                i2 = 3;
            } else if (n == 2) {
                i1 = 4;
                i2 = 5;
            }
            i = 0;
            t = tjd - dta;
            while (i <= 2) {
                retflag2 = this.lun_eclipse_how(t, ifl, attr, dcore, serr);
                if (retflag2 == -1) {
                    return retflag2;
                }
                if (n == 0) {
                    dc[i] = dcore[2] / 2.0 + 1.1618815109677577E-5 / dcore[4] - dcore[0];
                } else if (n == 1) {
                    dc[i] = dcore[1] / 2.0 + 1.1618815109677577E-5 / dcore[3] - dcore[0];
                } else if (n == 2) {
                    dc[i] = dcore[1] / 2.0 - 1.1618815109677577E-5 / dcore[3] - dcore[0];
                }
                ++i;
                t += dta;
            }
            this.find_zero(dc[0], dc[1], dc[2], dta, dt1, dt2);
            dtb = (dt1.val + dta) / 2.0;
            tret[i1] = tjd + dt1.val + dta;
            tret[i2] = tjd + dt2.val + dta;
            m = 0;
            dt = dtb / 2.0;
            while (m < 3) {
                for (j = i1; j <= i2; j += i2 - i1) {
                    i = 0;
                    t = tret[j] - dt;
                    while (i < 2) {
                        retflag2 = this.lun_eclipse_how(t, ifl, attr, dcore, serr);
                        if (retflag2 == -1) {
                            return retflag2;
                        }
                        if (n == 0) {
                            dc[i] = dcore[2] / 2.0 + 1.1618815109677577E-5 / dcore[4] - dcore[0];
                        } else if (n == 1) {
                            dc[i] = dcore[1] / 2.0 + 1.1618815109677577E-5 / dcore[3] - dcore[0];
                        } else if (n == 2) {
                            dc[i] = dcore[1] / 2.0 - 1.1618815109677577E-5 / dcore[3] - dcore[0];
                        }
                        ++i;
                        t += dt;
                    }
                    dt1.val = dc[1] / ((dc[1] - dc[0]) / dt);
                    int n2 = j;
                    tret[n2] = tret[n2] - dt1.val;
                }
                ++m;
                dt /= 2.0;
            }
        }
        return retflag;
    }

    int swe_pheno(double tjd, int ipl, int iflag, double[] attr, StringBuffer serr) {
        int i;
        double[] xx = new double[6];
        double[] xx2 = new double[6];
        double[] xxs = new double[6];
        double[] lbr = new double[6];
        double[] lbr2 = new double[6];
        double dt = 0.0;
        double[] me = new double[2];
        for (i = 0; i < 20; ++i) {
            attr[i] = 0.0;
        }
        if (ipl > 10000 && ipl <= 10004) {
            ipl = ipl - 10000 - 1 + 17;
        }
        int iflagp = (iflag &= 0x8677) & 0x477;
        iflagp |= 8;
        if (this.sw.swe_calc(tjd, ipl, iflag | 0x1000, xx, serr) == -1) {
            return -1;
        }
        if (this.sw.swe_calc(tjd, ipl, iflag, lbr, serr) == -1) {
            return -1;
        }
        if (ipl == 1 && this.sw.swe_calc(tjd, 0, iflag | 0x1000, xxs, serr) == -1) {
            return -1;
        }
        if (ipl != 0 && ipl != 14 && ipl != 10 && ipl != 11 && ipl != 12 && ipl != 13) {
            dt = lbr[2] * 1.4959787066E11 / 2.99792458E8 / 86400.0;
            if ((iflag & 0x10) != 0) {
                dt = 0.0;
            }
            if (this.sw.swe_calc(tjd - dt, ipl, iflagp | 0x1000, xx2, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tjd - dt, ipl, iflagp, lbr2, serr) == -1) {
                return -1;
            }
            attr[0] = Math.acos(this.sl.swi_dot_prod_unit(xx, xx2)) * 57.2957795130823;
            attr[1] = (1.0 + Math.cos(attr[0] * 0.0174532925199433)) / 2.0;
        }
        double dd = ipl < 21 ? SwephData.pla_diam[ipl] : (ipl > 10000 ? this.swed.ast_diam * 1000.0 : 0.0);
        attr[3] = lbr[2] < dd / 2.0 / 1.4959787066E11 ? 180.0 : Math.asin(dd / 2.0 / 1.4959787066E11 / lbr[2]) * 2.0 * 57.2957795130823;
        if (ipl > 10000 || ipl < 21 && mag_elem[ipl][0] < 99.0) {
            if (ipl == 0) {
                double fac = attr[3] / (Math.asin(SwephData.pla_diam[0] / 2.0 / 1.4959787066E11) * 2.0 * 57.2957795130823);
                fac *= fac;
                attr[4] = mag_elem[ipl][0] - 2.5 * this.log10(fac);
            } else if (ipl == 1) {
                double fac = attr[3] / (Math.asin(SwephData.pla_diam[1] / 2.0 / 3.844E8) * 2.0 * 57.2957795130823);
                for (i = 0; i < 3; ++i) {
                    int n = i;
                    xxs[n] = xxs[n] - xx[i];
                }
                double dsm = Math.sqrt(this.sl.square_sum(xxs));
                fac *= fac * attr[1];
                attr[4] = mag_elem[ipl][0] - 2.5 * this.log10(fac *= dsm * dsm);
            } else if (ipl == 6) {
                double u2;
                double T = (tjd - dt - 2451545.0) / 36525.0;
                double in = (28.075216 - 0.012998 * T + 4.0E-6 * T * T) * 0.0174532925199433;
                double om = (169.50847 + 1.394681 * T + 4.12E-4 * T * T) * 0.0174532925199433;
                double sinB = Math.abs(Math.sin(in) * Math.cos(lbr[1] * 0.0174532925199433) * Math.sin(lbr[0] * 0.0174532925199433 - om) - Math.cos(in) * Math.sin(lbr[1] * 0.0174532925199433));
                double u1 = Math.atan2(Math.sin(in) * Math.tan(lbr2[1] * 0.0174532925199433) + Math.cos(in) * Math.sin(lbr2[0] * 0.0174532925199433 - om), Math.cos(lbr2[0] * 0.0174532925199433 - om)) * 57.2957795130823;
                double du = this.sl.swe_degnorm(u1 - (u2 = Math.atan2(Math.sin(in) * Math.tan(lbr[1] * 0.0174532925199433) + Math.cos(in) * Math.sin(lbr[0] * 0.0174532925199433 - om), Math.cos(lbr[0] * 0.0174532925199433 - om)) * 57.2957795130823));
                if (du > 10.0) {
                    du = 360.0 - du;
                }
                attr[4] = 5.0 * this.log10(lbr2[2] * lbr[2]) + mag_elem[ipl][1] * sinB + mag_elem[ipl][2] * sinB * sinB + mag_elem[ipl][3] * du + mag_elem[ipl][0];
            } else if (ipl < 15) {
                attr[4] = 5.0 * this.log10(lbr2[2] * lbr[2]) + mag_elem[ipl][1] * attr[0] / 100.0 + mag_elem[ipl][2] * attr[0] * attr[0] / 10000.0 + mag_elem[ipl][3] * attr[0] * attr[0] * attr[0] / 1000000.0 + mag_elem[ipl][0];
            } else if (ipl < 21 || ipl > 10000) {
                double ph1 = Math.pow(2.718281828459, -3.33 * Math.pow(Math.tan(attr[0] * 0.0174532925199433 / 2.0), 0.63));
                double ph2 = Math.pow(2.718281828459, -1.87 * Math.pow(Math.tan(attr[0] * 0.0174532925199433 / 2.0), 1.22));
                if (ipl < 21) {
                    me[0] = mag_elem[ipl][0];
                    me[1] = mag_elem[ipl][1];
                } else if (ipl == 11566) {
                    me[0] = 16.9;
                    me[1] = 0.15;
                } else {
                    me[0] = this.swed.ast_G;
                    me[1] = this.swed.ast_H;
                }
                attr[4] = 5.0 * this.log10(lbr2[2] * lbr[2]) + me[0] - 2.5 * this.log10((1.0 - me[1]) * ph1 + me[1] * ph2);
            } else {
                attr[4] = 0.0;
            }
        }
        if (ipl != 0 && ipl != 14) {
            if (this.sw.swe_calc(tjd, 0, iflag | 0x1000, xx2, serr) == -1) {
                return -1;
            }
            if (this.sw.swe_calc(tjd, 0, iflag, lbr2, serr) == -1) {
                return -1;
            }
            attr[2] = Math.acos(this.sl.swi_dot_prod_unit(xx, xx2)) * 57.2957795130823;
        }
        return 0;
    }

    int swe_pheno_ut(double tjd_ut, int ipl, int iflag, double[] attr, StringBuffer serr) {
        return this.swe_pheno(tjd_ut + SweDate.getDeltaT(tjd_ut), ipl, iflag, attr, serr);
    }

    private int find_maximum(double y00, double y11, double y2, double dx, DblObj dxret, DblObj yret) {
        double c = y11;
        double b = (y2 - y00) / 2.0;
        double a = (y2 + y00) / 2.0 - c;
        double x = -b / 2.0 / a;
        double y = (4.0 * a * c - b * b) / 4.0 / a;
        dxret.val = (x - 1.0) * dx;
        if (yret != null) {
            yret.val = y;
        }
        return 0;
    }

    private int find_zero(double y00, double y11, double y2, double dx, DblObj dxret, DblObj dxret2) {
        double b = (y2 - y00) / 2.0;
        double c = y11;
        double a = (y2 + y00) / 2.0 - c;
        if (b * b - 4.0 * a * c < 0.0) {
            return -1;
        }
        double x1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / 2.0 / a;
        double x2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / 2.0 / a;
        dxret.val = (x1 - 1.0) * dx;
        dxret2.val = (x2 - 1.0) * dx;
        return 0;
    }

    int swe_rise_trans(double tjd_ut, int ipl, StringBuffer starname, int epheflag, int rsmi, double[] geopos, double atpress, double attemp, DblObj tret, StringBuffer serr) {
        int i;
        double rdi;
        double te;
        int nculm = -1;
        double tjd_et = tjd_ut + SweDate.getDeltaT(tjd_ut);
        double[] xc = new double[6];
        double[][] xh = new double[20][6];
        double[] ah = new double[6];
        double[] tculm = new double[4];
        double[] tc = new double[20];
        double[] h = new double[20];
        double[] t2 = new double[6];
        double[] dc = new double[6];
        DblObj dtint = new DblObj();
        DblObj dx = new DblObj();
        double dd = 0.0;
        int iflag = epheflag;
        int jmax = 14;
        double twohrs = 0.08333333333333333;
        boolean do_fixstar = starname != null && starname.length() > 0;
        iflag &= 7;
        tret.val = 0.0;
        iflag |= 0x8800;
        this.sw.swe_set_topo(geopos[0], geopos[1], geopos[2]);
        if ((rsmi & 0xC) != 0) {
            return this.calc_mer_trans(tjd_ut, ipl, epheflag, rsmi, geopos, starname, tret, serr);
        }
        if ((rsmi & 3) == 0) {
            rsmi |= 1;
        }
        if (do_fixstar && this.sw.swe_fixstar(starname, tjd_et, iflag, xc, serr) == -1) {
            return -1;
        }
        int ii = 0;
        double t = tjd_ut - twohrs;
        while (ii <= jmax) {
            tc[ii] = t;
            if (!do_fixstar && this.sw.swe_calc(te = t + SweDate.getDeltaT(t), ipl, iflag, xc, serr) == -1) {
                return -1;
            }
            if (ii == 0) {
                dd = do_fixstar ? 0.0 : ((rsmi & 0x100) != 0 ? 0.0 : (ipl < 21 ? SwephData.pla_diam[ipl] : (ipl > 10000 ? this.swed.ast_diam * 1000.0 : 0.0)));
            }
            rdi = Math.asin(dd / 2.0 / 1.4959787066E11 / xc[2]) * 57.2957795130823;
            this.swe_azalt(t, 1, geopos, atpress, attemp, xc, xh[ii]);
            double[] dArray = xh[ii];
            dArray[1] = dArray[1] + rdi;
            if ((rsmi & 0x200) != 0) {
                h[ii] = xh[ii][1];
            } else {
                this.swe_azalt_rev(t, 1, geopos, xh[ii], xc);
                this.swe_azalt(t, 1, geopos, atpress, attemp, xc, xh[ii]);
                h[ii] = xh[ii][2];
            }
            int calc_culm = 0;
            if (ii > 1) {
                dc[0] = xh[ii - 2][1];
                dc[1] = xh[ii - 1][1];
                dc[2] = xh[ii][1];
                if (dc[1] > dc[0] && dc[1] > dc[2]) {
                    calc_culm = 1;
                }
                if (dc[1] < dc[0] && dc[1] < dc[2]) {
                    calc_culm = 2;
                }
            }
            if (calc_culm != 0) {
                double dt = twohrs;
                double tcu = t - dt;
                this.find_maximum(dc[0], dc[1], dc[2], dt, dtint, dx);
                tcu += dtint.val + dt;
                dt /= 3.0;
                while (dt > 1.0E-4) {
                    double tt = tcu - dt;
                    for (i = 0; i < 3; ++i) {
                        te = tt + SweDate.getDeltaT(tt);
                        if (!do_fixstar && this.sw.swe_calc(te, ipl, iflag, xc, serr) == -1) {
                            return -1;
                        }
                        this.swe_azalt(tt, 1, geopos, atpress, attemp, xc, ah);
                        dc[i] = ah[1];
                        tt += dt;
                    }
                    this.find_maximum(dc[0], dc[1], dc[2], dt, dtint, dx);
                    tcu += dtint.val + dt;
                    dt /= 3.0;
                }
                tculm[++nculm] = tcu;
            }
            ++ii;
            t += twohrs;
        }
        block3: for (i = 0; i <= nculm; ++i) {
            for (int j = 1; j <= jmax; ++j) {
                if (!(tculm[i] < tc[j])) continue;
                for (int k = jmax; k >= j; --k) {
                    tc[k + 1] = tc[k];
                    h[k + 1] = h[k];
                }
                tc[j] = tculm[i];
                if (!do_fixstar && this.sw.swe_calc(te = tc[j] + SweDate.getDeltaT(tc[j]), ipl, iflag, xc, serr) == -1) {
                    return -1;
                }
                rdi = Math.asin(dd / 2.0 / 1.4959787066E11 / xc[2]) * 57.2957795130823;
                this.swe_azalt(tc[j], 1, geopos, atpress, attemp, xc, ah);
                ah[1] = ah[1] + rdi;
                if ((rsmi & 0x200) != 0) {
                    h[j] = ah[1];
                } else {
                    this.swe_azalt_rev(tc[j], 1, geopos, ah, xc);
                    this.swe_azalt(tc[j], 1, geopos, atpress, attemp, xc, ah);
                    h[j] = ah[2];
                }
                ++jmax;
                continue block3;
            }
        }
        tret.val = 0.0;
        for (ii = 1; ii <= jmax; ++ii) {
            if (h[ii - 1] * h[ii] >= 0.0 || h[ii - 1] < h[ii] && (rsmi & 1) == 0 || h[ii - 1] > h[ii] && (rsmi & 2) == 0) continue;
            dc[0] = h[ii - 1];
            dc[1] = h[ii];
            t2[0] = tc[ii - 1];
            t2[1] = tc[ii];
            for (i = 0; i < 20; ++i) {
                double aha;
                t = (t2[0] + t2[1]) / 2.0;
                if (!do_fixstar && this.sw.swe_calc(te = t + SweDate.getDeltaT(t), ipl, iflag, xc, serr) == -1) {
                    return -1;
                }
                rdi = Math.asin(dd / 2.0 / 1.4959787066E11 / xc[2]) * 57.2957795130823;
                this.swe_azalt(t, 1, geopos, atpress, attemp, xc, ah);
                ah[1] = ah[1] + rdi;
                if ((rsmi & 0x200) != 0) {
                    aha = ah[1];
                } else {
                    this.swe_azalt_rev(t, 1, geopos, ah, xc);
                    this.swe_azalt(t, 1, geopos, atpress, attemp, xc, ah);
                    aha = ah[2];
                }
                if (aha * dc[0] <= 0.0) {
                    dc[1] = aha;
                    t2[1] = t;
                    continue;
                }
                dc[0] = aha;
                t2[0] = t;
            }
            if (!(t > tjd_ut)) continue;
            tret.val = t;
            return 0;
        }
        if (serr != null) {
            serr.append("rise or set not found for planet ").append(ipl);
        }
        return -2;
    }

    private int calc_mer_trans(double tjd_ut, int ipl, int epheflag, int rsmi, double[] geopos, StringBuffer starname, DblObj tret, StringBuffer serr) {
        double tjd_et = tjd_ut + SweDate.getDeltaT(tjd_ut);
        double[] x0 = new double[6];
        double[] x = new double[6];
        int iflag = epheflag;
        boolean do_fixstar = starname != null && starname.length() > 0;
        iflag &= 7;
        tret.val = 0.0;
        iflag |= 0x8800;
        double armc0 = this.sl.swe_sidtime(tjd_ut) + geopos[0] / 15.0;
        if (armc0 >= 24.0) {
            armc0 -= 24.0;
        }
        if (armc0 < 0.0) {
            armc0 += 24.0;
        }
        armc0 *= 15.0;
        if (do_fixstar ? this.sw.swe_fixstar(starname, tjd_et, iflag, x0, serr) == -1 : this.sw.swe_calc(tjd_et, ipl, iflag, x0, serr) == -1) {
            return -1;
        }
        x[0] = x0[0];
        x[1] = x0[1];
        double t = tjd_ut;
        double arxc = armc0;
        if ((rsmi & 8) != 0) {
            arxc = this.sl.swe_degnorm(arxc + 180.0);
        }
        for (int i = 0; i < 4; ++i) {
            double te;
            double armc;
            double mdd = this.sl.swe_degnorm(x[0] - arxc);
            if (i > 0 && mdd > 180.0) {
                mdd -= 360.0;
            }
            if ((armc = this.sl.swe_sidtime(t += mdd / 361.0) + geopos[0] / 15.0) >= 24.0) {
                armc -= 24.0;
            }
            if (armc < 0.0) {
                armc += 24.0;
            }
            arxc = armc *= 15.0;
            if ((rsmi & 8) != 0) {
                arxc = this.sl.swe_degnorm(arxc + 180.0);
            }
            if (do_fixstar || this.sw.swe_calc(te = t + SweDate.getDeltaT(t), ipl, iflag, x, serr) != -1) continue;
            return -1;
        }
        tret.val = t;
        return 0;
    }

    int swe_nod_aps(double tjd_et, int ipl, int iflag, int method, double[] xnasc, double[] xndsc, double[] xperi, double[] xaphe, StringBuffer serr) {
        int j;
        double dt;
        double[] xp;
        double sema;
        double ecce;
        int i;
        double t = (tjd_et - 2451545.0) / 36525.0;
        double[] x = new double[6];
        double[] xx = new double[24];
        double[] xobs = new double[6];
        double[] x2000 = new double[6];
        int xpOffs = 0;
        double[][] xpos = new double[3][6];
        double[] xnorm = new double[6];
        double[] xposm = new double[6];
        double[][] xn = new double[3][6];
        double[][] xs = new double[3][6];
        double[][] xq = new double[3][6];
        double[][] xa = new double[3][6];
        double[] xobs2 = new double[6];
        double[] x2 = new double[6];
        int xndOffs = 6;
        int xpeOffs = 12;
        int xapOffs = 18;
        PlanData pedp = this.swed.pldat[0];
        PlanData psbdp = this.swed.pldat[10];
        PlanData pldat = new PlanData();
        double[] xsun = psbdp.x;
        double[] xear = pedp.x;
        boolean is_true_nodaps = false;
        boolean do_aberr = (iflag & 0x410) == 0;
        boolean do_defl = (iflag & 0x10) == 0 && (iflag & 0x200) == 0;
        boolean do_focal_point = (method & 0x100) != 0;
        boolean ellipse_is_bary = false;
        double[] xna = xx;
        double[] xnd = xx;
        double[] xpe = xx;
        double[] xap = xx;
        this.sw.swi_force_app_pos_etc();
        method %= 256;
        int ipli = ipl;
        if (ipl == 0) {
            ipli = 14;
        }
        if (ipl == 1) {
            do_defl = false;
            if ((iflag & 8) == 0) {
                do_aberr = false;
            }
        }
        int iflg0 = iflag & 0x47 | 0x100 | 0x10;
        if (ipli != 1) {
            iflg0 |= 8;
        }
        if (ipl == 10 || ipl == 11 || ipl == 12 || ipl == 13 || ipl < 0 || ipl >= 21 && ipl <= 10000) {
            int i2;
            if (serr != null) {
                serr.setLength(0);
                serr.append("nodes/apsides for planet " + ipl + " are not implemented");
            }
            if (xnasc != null) {
                for (i2 = 0; i2 <= 5; ++i2) {
                    xnasc[i2] = 0.0;
                }
            }
            if (xndsc != null) {
                for (i2 = 0; i2 <= 5; ++i2) {
                    xndsc[i2] = 0.0;
                }
            }
            if (xaphe != null) {
                for (i2 = 0; i2 <= 5; ++i2) {
                    xaphe[i2] = 0.0;
                }
            }
            if (xperi != null) {
                for (i2 = 0; i2 <= 5; ++i2) {
                    xperi[i2] = 0.0;
                }
            }
            return -1;
        }
        for (i = 0; i < 24; ++i) {
            xx[i] = 0.0;
        }
        if ((method == 0 || (method & 1) != 0) && (ipl >= 0 && ipl <= 8 || ipl == 14)) {
            double vsema;
            double vecce;
            double vincl;
            double incl;
            if (ipl == 1) {
                DblObj xna0 = new DblObj();
                xna0.val = xna[0];
                DblObj xna3 = new DblObj();
                xna3.val = xna[3];
                DblObj xpe0 = new DblObj();
                xpe0.val = xpe[12];
                DblObj xpe3 = new DblObj();
                xpe3.val = xpe[15];
                this.sm.swi_mean_lunar_elements(tjd_et, xna0, xna3, xpe0, xpe3);
                xna[0] = xna0.val;
                xna[3] = xna3.val;
                xpe[12] = xpe0.val;
                xpe[15] = xpe3.val;
                incl = 5.1453964;
                vincl = 0.0;
                ecce = 0.054900489;
                vecce = 0.0;
                sema = 0.002569555290487047;
                vsema = 0.0;
            } else {
                int iplx = ipl_to_elem[ipl];
                double[] ep = el_incl[iplx];
                incl = ep[0] + ep[1] * t + ep[2] * t * t + ep[3] * t * t * t;
                vincl = ep[1] / 36525.0;
                ep = el_sema[iplx];
                sema = ep[0] + ep[1] * t + ep[2] * t * t + ep[3] * t * t * t;
                vsema = ep[1] / 36525.0;
                ep = el_ecce[iplx];
                ecce = ep[0] + ep[1] * t + ep[2] * t * t + ep[3] * t * t * t;
                vecce = ep[1] / 36525.0;
                ep = el_node[iplx];
                xna[0] = ep[0] + ep[1] * t + ep[2] * t * t + ep[3] * t * t * t;
                xna[3] = ep[1] / 36525.0;
                ep = el_peri[iplx];
                xpe[12] = ep[0] + ep[1] * t + ep[2] * t * t + ep[3] * t * t * t;
                xpe[15] = ep[1] / 36525.0;
            }
            xnd[6] = this.sl.swe_degnorm(xna[0] + 180.0);
            xnd[9] = xna[3];
            double parg = xpe[12] = this.sl.swe_degnorm(xpe[12] - xna[0]);
            double pargx = xpe[15] = this.sl.swe_degnorm(xpe[12] + xpe[15] - xna[3]);
            this.sl.swe_cotrans(xpe, 12, xpe, 12, -incl);
            this.sl.swe_cotrans(xpe, 15, xpe, 15, -incl - vincl);
            xpe[12] = this.sl.swe_degnorm(xpe[12] + xna[0]);
            xpe[15] = this.sl.swe_degnorm(xpe[15] + xna[0] + xna[3]);
            xpe[15] = this.sl.swe_degnorm(xpe[15] - xpe[12]);
            xpe[14] = sema * (1.0 - ecce);
            xpe[17] = (sema + vsema) * (1.0 - ecce - vecce) - xpe[14];
            xap[18] = this.sl.swe_degnorm(xpe[12] + 180.0);
            xap[19] = -xpe[13];
            xap[21] = xpe[15];
            xap[22] = -xpe[16];
            if (do_focal_point) {
                xap[20] = sema * ecce * 2.0;
                xap[23] = (sema + vsema) * (ecce + vecce) * 2.0 - xap[20];
            } else {
                xap[20] = sema * (1.0 + ecce);
                xap[23] = (sema + vsema) * (1.0 + ecce + vecce) - xap[20];
            }
            double ea = Math.atan(Math.tan(-parg * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - ecce) / (1.0 + ecce))) * 2.0;
            double eax = Math.atan(Math.tan(-pargx * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - ecce - vecce) / (1.0 + ecce + vecce))) * 2.0;
            xna[2] = sema * (Math.cos(ea) - ecce) / Math.cos(parg * 0.0174532925199433);
            xna[5] = (sema + vsema) * (Math.cos(eax) - ecce - vecce) / Math.cos(pargx * 0.0174532925199433);
            xna[5] = xna[5] - xna[2];
            ea = Math.atan(Math.tan((180.0 - parg) * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - ecce) / (1.0 + ecce))) * 2.0;
            eax = Math.atan(Math.tan((180.0 - pargx) * 0.0174532925199433 / 2.0) * Math.sqrt((1.0 - ecce - vecce) / (1.0 + ecce + vecce))) * 2.0;
            xnd[8] = sema * (Math.cos(ea) - ecce) / Math.cos((180.0 - parg) * 0.0174532925199433);
            xnd[11] = (sema + vsema) * (Math.cos(eax) - ecce - vecce) / Math.cos((180.0 - pargx) * 0.0174532925199433);
            xnd[11] = xnd[11] - xnd[8];
            i = 0;
            xp = xx;
            xpOffs = 0;
            while (i < 4) {
                int n = 0 + xpOffs;
                xp[n] = xp[n] * 0.0174532925199433;
                int n2 = 1 + xpOffs;
                xp[n2] = xp[n2] * 0.0174532925199433;
                int n3 = 3 + xpOffs;
                xp[n3] = xp[n3] * 0.0174532925199433;
                int n4 = 4 + xpOffs;
                xp[n4] = xp[n4] * 0.0174532925199433;
                this.sl.swi_polcart_sp(xp, xpOffs, xp, xpOffs);
                ++i;
                xpOffs += 6;
            }
        } else {
            int iend;
            int istart;
            double Gmsm;
            double dzmin;
            if (this.sw.swe_calc(tjd_et, ipli, iflg0, x, serr) == -1) {
                return -1;
            }
            int iflJ2000 = iflag & 7 | 0x20 | 0x800 | 0x1000 | 0x10 | 0x40 | 0x100;
            ellipse_is_bary = false;
            if (ipli != 1) {
                if ((method & 4) != 0 && x[2] > 6.0) {
                    iflJ2000 |= 0x4000;
                    ellipse_is_bary = true;
                } else {
                    iflJ2000 |= 8;
                }
            }
            if (ipli == 1) {
                dt = 1.0E-4;
                dzmin = 1.0E-15;
                Gmsm = 8.997011655185388E-10;
            } else {
                double plm = ipli >= 2 && ipli <= 9 || ipli == 14 ? 1.0 / plmass[ipl_to_elem[ipl]] : 0.0;
                dt = 0.001 * x[2];
                dzmin = 1.0E-15 * dt / 1.0E-4;
                Gmsm = 1.32712438E20 * (1.0 + plm) / 1.4959787066E11 / 1.4959787066E11 / 1.4959787066E11 * 86400.0 * 86400.0;
            }
            if ((iflag & 0x100) != 0) {
                istart = 0;
                iend = 2;
            } else {
                iend = 0;
                istart = 0;
                dt = 0.0;
            }
            i = istart;
            t = tjd_et - dt;
            while (i <= iend) {
                if (istart == iend) {
                    t = tjd_et;
                }
                if (this.sw.swe_calc(t, ipli, iflJ2000, xpos[i], serr) == -1) {
                    return -1;
                }
                if (ipli == 14) {
                    if (this.sw.swe_calc(t, 1, iflJ2000 & 0xFFFFBFF7, xposm, serr) == -1) {
                        return -1;
                    }
                    for (j = 0; j <= 2; ++j) {
                        double[] dArray = xpos[i];
                        int n = j;
                        dArray[n] = dArray[n] + xposm[j] / 82.30058827479664;
                    }
                }
                this.sw.swi_plan_for_osc_elem(iflg0, t, xpos[i]);
                ++i;
                t += dt;
            }
            for (i = istart; i <= iend; ++i) {
                if (Math.abs(xpos[i][5]) < dzmin) {
                    xpos[i][5] = dzmin;
                }
                double fac = xpos[i][2] / xpos[i][5];
                double sgn = xpos[i][5] / Math.abs(xpos[i][5]);
                for (j = 0; j <= 2; ++j) {
                    xn[i][j] = (xpos[i][j] - fac * xpos[i][j + 3]) * sgn;
                    xs[i][j] = -xn[i][j];
                }
            }
            for (i = istart; i <= iend; ++i) {
                double rxy = Math.sqrt(xn[i][0] * xn[i][0] + xn[i][1] * xn[i][1]);
                double cosnode = xn[i][0] / rxy;
                double sinnode = xn[i][1] / rxy;
                this.sl.swi_cross_prod(xpos[i], 0, xpos[i], 3, xnorm, 0);
                rxy = xnorm[0] * xnorm[0] + xnorm[1] * xnorm[1];
                double c2 = rxy + xnorm[2] * xnorm[2];
                double rxyz = Math.sqrt(c2);
                rxy = Math.sqrt(rxy);
                double sinincl = rxy / rxyz;
                double cosincl = Math.sqrt(1.0 - sinincl * sinincl);
                double cosu = xpos[i][0] * cosnode + xpos[i][1] * sinnode;
                double sinu = xpos[i][2] / sinincl;
                double uu = Math.atan2(sinu, cosu);
                rxyz = Math.sqrt(this.sl.square_sum(xpos[i]));
                double v2 = this.sl.square_sum(xpos[i], 3);
                sema = 1.0 / (2.0 / rxyz - v2 / Gmsm);
                double pp = c2 / Gmsm;
                ecce = Math.sqrt(1.0 - pp / sema);
                double cosE = 1.0 / ecce * (1.0 - rxyz / sema);
                double sinE = 1.0 / ecce / Math.sqrt(sema * Gmsm) * this.sw.dot_prod(xpos[i], xpos[i], 3);
                double ny = 2.0 * Math.atan(Math.sqrt((1.0 + ecce) / (1.0 - ecce)) * sinE / (1.0 + cosE));
                xq[i][0] = this.sl.swi_mod2PI(uu - ny);
                xq[i][1] = 0.0;
                xq[i][2] = sema * (1.0 - ecce);
                this.sl.swi_polcart(xq[i], xq[i]);
                this.sl.swi_coortrf2(xq[i], xq[i], -sinincl, cosincl);
                this.sl.swi_cartpol(xq[i], xq[i]);
                double[] dArray = xq[i];
                dArray[0] = dArray[0] + Math.atan2(sinnode, cosnode);
                xa[i][0] = this.sl.swi_mod2PI(xq[i][0] + Math.PI);
                xa[i][1] = -xq[i][1];
                xa[i][2] = do_focal_point ? sema * ecce * 2.0 : sema * (1.0 + ecce);
                this.sl.swi_polcart(xq[i], xq[i]);
                this.sl.swi_polcart(xa[i], xa[i]);
                ny = this.sl.swi_mod2PI(ny - uu);
                double ny2 = this.sl.swi_mod2PI(ny + Math.PI);
                cosE = Math.cos(2.0 * Math.atan(Math.tan(ny / 2.0) / Math.sqrt((1.0 + ecce) / (1.0 - ecce))));
                double cosE2 = Math.cos(2.0 * Math.atan(Math.tan(ny2 / 2.0) / Math.sqrt((1.0 + ecce) / (1.0 - ecce))));
                double rn = sema * (1.0 - ecce * cosE);
                double rn2 = sema * (1.0 - ecce * cosE2);
                double ro = Math.sqrt(this.sl.square_sum(xn[i]));
                double ro2 = Math.sqrt(this.sl.square_sum(xs[i]));
                j = 0;
                while (j <= 2) {
                    double[] dArray2 = xn[i];
                    int n = j;
                    dArray2[n] = dArray2[n] * (rn / ro);
                    double[] dArray3 = xs[i];
                    int n5 = j++;
                    dArray3[n5] = dArray3[n5] * (rn2 / ro2);
                }
            }
            for (i = 0; i <= 2; ++i) {
                if ((iflag & 0x100) != 0) {
                    xpe[i + 12] = xq[1][i];
                    xpe[i + 3 + 12] = (xq[2][i] - xq[0][i]) / dt / 2.0;
                    xap[i + 18] = xa[1][i];
                    xap[i + 3 + 18] = (xa[2][i] - xa[0][i]) / dt / 2.0;
                    xna[i] = xn[1][i];
                    xna[i + 3] = (xn[2][i] - xn[0][i]) / dt / 2.0;
                    xnd[i + 6] = xs[1][i];
                    xnd[i + 3 + 6] = (xs[2][i] - xs[0][i]) / dt / 2.0;
                    continue;
                }
                xpe[i + 12] = xq[0][i];
                xpe[i + 3 + 12] = 0.0;
                xap[i + 18] = xa[0][i];
                xap[i + 3 + 18] = 0.0;
                xna[i] = xn[0][i];
                xna[i + 3] = 0.0;
                xnd[i + 6] = xs[0][i];
                xnd[i + 3 + 6] = 0.0;
            }
            is_true_nodaps = true;
        }
        if (ipli == 1 && (iflag & 0x4008) != 0) {
            this.sw.swi_force_app_pos_etc();
            if (this.sw.swe_calc(tjd_et, 0, iflg0, x, serr) == -1) {
                return -1;
            }
        } else if (this.sw.swe_calc(tjd_et, ipli, iflg0 | iflag & 0x8000, x, serr) == -1) {
            return -1;
        }
        if ((iflag & 0x8000) != 0) {
            if (this.sw.swi_get_observer(tjd_et, iflag, false, xobs, serr) != 0) {
                return -1;
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = 0.0;
            }
        }
        if ((iflag & 0x4008) != 0) {
            if ((iflag & 8) != 0 && (iflag & 4) == 0) {
                for (i = 0; i <= 5; ++i) {
                    xobs[i] = xsun[i];
                }
            }
        } else if (ipl == 0 && (iflag & 4) == 0) {
            for (i = 0; i <= 5; ++i) {
                xobs[i] = xsun[i];
            }
        } else {
            for (i = 0; i <= 5; ++i) {
                int n = i;
                xobs[n] = xobs[n] + xear[i];
            }
        }
        Epsilon oe = (iflag & 0x20) != 0 ? this.swed.oec2000 : this.swed.oec;
        int ij = 0;
        xp = xx;
        xpOffs = 0;
        while (ij < 4) {
            if (ipli == 14 && ij <= 1) {
                for (i = 0; i <= 5; ++i) {
                    xp[i + xpOffs] = 0.0;
                }
            } else {
                if (is_true_nodaps && (iflag & 0x40) == 0) {
                    this.sl.swi_coortrf2(xp, xpOffs, xp, xpOffs, -this.swed.nut.snut, this.swed.nut.cnut);
                    if ((iflag & 0x100) != 0) {
                        this.sl.swi_coortrf2(xp, 3 + xpOffs, xp, 3 + xpOffs, -this.swed.nut.snut, this.swed.nut.cnut);
                    }
                }
                this.sl.swi_coortrf2(xp, xpOffs, xp, xpOffs, -oe.seps, oe.ceps);
                this.sl.swi_coortrf2(xp, 3 + xpOffs, xp, 3 + xpOffs, -oe.seps, oe.ceps);
                if (is_true_nodaps && (iflag & 0x40) == 0) {
                    this.sw.swi_nutate(xp, xpOffs, iflag, true);
                }
                this.sl.swi_precess(xp, xpOffs, tjd_et, 1);
                if ((iflag & 0x100) != 0) {
                    this.sw.swi_precess_speed(xp, xpOffs, tjd_et, 1);
                }
                if (ipli == 1) {
                    for (i = 0; i <= 5; ++i) {
                        int n = i + xpOffs;
                        xp[n] = xp[n] + xear[i];
                    }
                } else if ((iflag & 4) == 0 && !ellipse_is_bary) {
                    for (j = 0; j <= 5; ++j) {
                        int n = j + xpOffs;
                        xp[n] = xp[n] + xsun[j];
                    }
                }
                for (j = 0; j <= 5; ++j) {
                    int n = j + xpOffs;
                    xp[n] = xp[n] - xobs[j];
                }
                if (ipl == 0 && (iflag & 0x4008) == 0) {
                    for (j = 0; j <= 5; ++j) {
                        xp[j + xpOffs] = -xp[j + xpOffs];
                    }
                }
                dt = Math.sqrt(this.sl.square_sum(xp, xpOffs)) * 1.4959787066E11 / 2.99792458E8 / 86400.0;
                if (do_defl) {
                    this.sw.swi_deflect_light(xp, xpOffs, dt, iflag);
                }
                if (do_aberr) {
                    this.sw.swi_aberr_light(xp, xpOffs, xobs, iflag);
                    if ((iflag & 0x100) != 0) {
                        if (this.sw.swe_calc(tjd_et - dt, ipli, iflg0 | iflag & 0x8000, x2, serr) == -1) {
                            return -1;
                        }
                        if ((iflag & 0x8000) != 0) {
                            for (i = 0; i <= 5; ++i) {
                                xobs2[i] = this.swed.topd.xobs[i];
                            }
                        } else {
                            for (i = 0; i <= 5; ++i) {
                                xobs2[i] = 0.0;
                            }
                        }
                        if ((iflag & 0x4008) != 0) {
                            if ((iflag & 8) != 0 && (iflag & 4) == 0) {
                                for (i = 0; i <= 5; ++i) {
                                    xobs2[i] = xsun[i];
                                }
                            }
                        } else if (ipl == 0 && (iflag & 4) == 0) {
                            for (i = 0; i <= 5; ++i) {
                                xobs2[i] = xsun[i];
                            }
                        } else {
                            for (i = 0; i <= 5; ++i) {
                                int n = i;
                                xobs2[n] = xobs2[n] + xear[i];
                            }
                        }
                        for (i = 3; i <= 5; ++i) {
                            int n = i + xpOffs;
                            xp[n] = xp[n] + (xobs[i] - xobs2[i]);
                        }
                        if (this.sw.swe_calc(tjd_et, 0, iflg0 | iflag & 0x8000, x2, serr) == -1) {
                            return -1;
                        }
                    }
                }
                for (j = 0; j <= 5; ++j) {
                    x2000[j] = xp[j + xpOffs];
                }
                if ((iflag & 0x20) == 0) {
                    this.sl.swi_precess(xp, xpOffs, tjd_et, -1);
                    if ((iflag & 0x100) != 0) {
                        this.sw.swi_precess_speed(xp, xpOffs, tjd_et, -1);
                    }
                }
                if ((iflag & 0x40) == 0) {
                    this.sw.swi_nutate(xp, xpOffs, iflag, false);
                }
                for (j = 0; j <= 5; ++j) {
                    pldat.xreturn[18 + j] = xp[j + xpOffs];
                }
                this.sl.swi_coortrf2(xp, xpOffs, xp, xpOffs, oe.seps, oe.ceps);
                if ((iflag & 0x100) != 0) {
                    this.sl.swi_coortrf2(xp, 3 + xpOffs, xp, 3 + xpOffs, oe.seps, oe.ceps);
                }
                if ((iflag & 0x40) == 0) {
                    this.sl.swi_coortrf2(xp, xpOffs, xp, xpOffs, this.swed.nut.snut, this.swed.nut.cnut);
                    if ((iflag & 0x100) != 0) {
                        this.sl.swi_coortrf2(xp, 3 + xpOffs, xp, 3 + xpOffs, this.swed.nut.snut, this.swed.nut.cnut);
                    }
                }
                for (j = 0; j <= 5; ++j) {
                    pldat.xreturn[6 + j] = xp[j + xpOffs];
                }
                if ((iflag & 0x10000) != 0) {
                    if ((this.swed.sidd.sid_mode & 0x100) != 0) {
                        if (this.sw.swi_trop_ra2sid_lon(x2000, pldat.xreturn, 6, pldat.xreturn, 18, iflag, serr) != 0) {
                            return -1;
                        }
                    } else if ((this.swed.sidd.sid_mode & 0x200) != 0) {
                        if (this.sw.swi_trop_ra2sid_lon_sosy(x2000, pldat.xreturn, 6, pldat.xreturn, 18, iflag, serr) != 0) {
                            return -1;
                        }
                    } else {
                        this.sl.swi_cartpol_sp(pldat.xreturn, 6, pldat.xreturn, 0);
                        pldat.xreturn[0] = pldat.xreturn[0] - this.sw.swe_get_ayanamsa(tjd_et) * 0.0174532925199433;
                        this.sl.swi_polcart_sp(pldat.xreturn, 0, pldat.xreturn, 6);
                    }
                }
                if ((iflag & 0x1000) != 0 && (iflag & 0x800) != 0) {
                    for (j = 0; j <= 5; ++j) {
                        xp[j + xpOffs] = pldat.xreturn[18 + j];
                    }
                } else if ((iflag & 0x1000) != 0) {
                    for (j = 0; j <= 5; ++j) {
                        xp[j + xpOffs] = pldat.xreturn[6 + j];
                    }
                } else {
                    this.sl.swi_cartpol_sp(pldat.xreturn, 18, pldat.xreturn, 12);
                    this.sl.swi_cartpol_sp(pldat.xreturn, 6, pldat.xreturn, 0);
                    for (j = 0; j < 2; ++j) {
                        int n = j;
                        pldat.xreturn[n] = pldat.xreturn[n] * 57.2957795130823;
                        int n6 = j + 3;
                        pldat.xreturn[n6] = pldat.xreturn[n6] * 57.2957795130823;
                        int n7 = j + 12;
                        pldat.xreturn[n7] = pldat.xreturn[n7] * 57.2957795130823;
                        int n8 = j + 15;
                        pldat.xreturn[n8] = pldat.xreturn[n8] * 57.2957795130823;
                    }
                    if ((iflag & 0x800) != 0) {
                        for (j = 0; j <= 5; ++j) {
                            xp[j + xpOffs] = pldat.xreturn[12 + j];
                        }
                    } else {
                        for (j = 0; j <= 5; ++j) {
                            xp[j + xpOffs] = pldat.xreturn[j];
                        }
                    }
                }
            }
            ++ij;
            xpOffs += 6;
        }
        for (i = 0; i <= 5; ++i) {
            if (i > 2 && (iflag & 0x100) == 0) {
                xap[i + 18] = 0.0;
                xpe[i + 12] = 0.0;
                xnd[i + 6] = 0.0;
                xna[i] = 0.0;
            }
            if (xnasc != null) {
                xnasc[i] = xna[i];
            }
            if (xndsc != null) {
                xndsc[i] = xnd[i + 6];
            }
            if (xperi != null) {
                xperi[i] = xpe[i + 12];
            }
            if (xaphe == null) continue;
            xaphe[i] = xap[i + 18];
        }
        return 0;
    }

    int swe_nod_aps_ut(double tjd_ut, int ipl, int iflag, int method, double[] xnasc, double[] xndsc, double[] xperi, double[] xaphe, StringBuffer serr) {
        return this.swe_nod_aps(tjd_ut + SweDate.getDeltaT(tjd_ut), ipl, iflag, method, xnasc, xndsc, xperi, xaphe, serr);
    }

    int swe_gauquelin_sector(double t_ut, int ipl, StringBuffer starname, int iflag, int imeth, double[] geopos, double atpress, double attemp, DblObj dgsect, StringBuffer serr) {
        DblObj dtmp = new DblObj();
        boolean rise_found = true;
        boolean set_found = true;
        double[] tret = new double[3];
        double[] x0 = new double[6];
        double[] nutlo = new double[2];
        int epheflag = iflag & 7;
        boolean do_fixstar = starname != null && starname.length() > 0;
        int risemeth = 256;
        boolean above_horizon = false;
        if ((imeth & 2) == 0) {
            double t_et = t_ut + SweDate.getDeltaT(t_ut);
            double eps = this.sl.swi_epsiln(t_et) * 57.2957795130823;
            this.sl.swi_nutation(t_et, nutlo);
            nutlo[0] = nutlo[0] * 57.2957795130823;
            nutlo[1] = nutlo[1] * 57.2957795130823;
            double armc = this.sl.swe_degnorm(this.sl.swe_sidtime0(t_ut, eps + nutlo[1], nutlo[0]) * 15.0 + geopos[0]);
            if (do_fixstar ? this.sw.swe_fixstar(starname, t_et, iflag, x0, serr) == -1 : this.sw.swe_calc(t_et, ipl, iflag, x0, serr) == -1) {
                return -1;
            }
            if ((imeth & 1) != 0) {
                x0[1] = 0.0;
            }
            dgsect.val = this.sw.swe_house_pos(armc, geopos[1], eps + nutlo[1], 71, x0, null);
            return 0;
        }
        if (imeth == 2) {
            risemeth |= 0x200;
        }
        dtmp.val = tret[0];
        int retval = this.swe_rise_trans(t_ut, ipl, starname, epheflag, 1 | risemeth, geopos, atpress, attemp, dtmp, serr);
        tret[0] = dtmp.val;
        if (retval == -1) {
            return -1;
        }
        if (retval == -2) {
            rise_found = false;
        }
        dtmp.val = tret[1];
        retval = this.swe_rise_trans(t_ut, ipl, starname, epheflag, 2 | risemeth, geopos, atpress, attemp, dtmp, serr);
        tret[1] = dtmp.val;
        if (retval == -1) {
            return -1;
        }
        if (retval == -2) {
            set_found = false;
        }
        if (tret[0] < tret[1] && rise_found) {
            above_horizon = false;
            double t = t_ut - 1.2;
            if (set_found) {
                t = tret[1] - 1.2;
            }
            set_found = true;
            dtmp.val = tret[1];
            retval = this.swe_rise_trans(t, ipl, starname, epheflag, 2 | risemeth, geopos, atpress, attemp, dtmp, serr);
            tret[1] = dtmp.val;
            if (retval == -1) {
                return -1;
            }
            if (retval == -2) {
                set_found = false;
            }
        } else if (tret[0] >= tret[1] && set_found) {
            above_horizon = true;
            double t = t_ut - 1.2;
            if (rise_found) {
                t = tret[0] - 1.2;
            }
            rise_found = true;
            dtmp.val = tret[0];
            retval = this.swe_rise_trans(t, ipl, starname, epheflag, 1 | risemeth, geopos, atpress, attemp, dtmp, serr);
            tret[0] = dtmp.val;
            if (retval == -1) {
                return -1;
            }
            if (retval == -2) {
                rise_found = false;
            }
        }
        if (rise_found && set_found) {
            dgsect.val = above_horizon ? (t_ut - tret[0]) / (tret[1] - tret[0]) * 18.0 + 1.0 : (t_ut - tret[1]) / (tret[0] - tret[1]) * 18.0 + 19.0;
            return 0;
        }
        dgsect.val = 0.0;
        if (serr != null) {
            serr.append("rise or set not found for planet ").append(ipl);
        }
        return -1;
    }
}

