/*
 * Decompiled with CFR 0.152.
 */
package swisseph;

import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;

public class FilePtr {
    public static final String useragent = "swisseph-java-1.67.00(03)";
    private static final int MAX_FAILURES = 100;
    RandomAccessFile fp;
    Socket sk;
    InputStream is;
    BufferedOutputStream os;
    String fnamp;
    private long fpos = 0L;
    private String host;
    private int port;
    private int BUFSIZE = 20;
    private long[] startIdx = new long[1];
    private long[] endIdx = new long[1];
    private byte[][] data;
    private byte[] inbuf;
    private int idx = 0;
    private long savedLength = -1L;

    public FilePtr(RandomAccessFile fp, Socket sk, InputStream is, BufferedOutputStream os, String fnamp, long fileLength, int bufsize) throws IOException {
        this.fp = fp;
        this.sk = sk;
        this.is = is;
        this.os = os;
        this.fnamp = fnamp;
        this.savedLength = fileLength;
        this.BUFSIZE = bufsize;
        this.data = new byte[this.BUFSIZE][1];
        this.inbuf = new byte[this.BUFSIZE];
        for (int i = 0; i < this.data[0].length; ++i) {
            this.startIdx[i] = -1L;
        }
        if (fp == null) {
            try {
                URL u = new URL(fnamp);
                this.host = u.getHost();
                this.port = u.getPort();
                if (this.port < 0) {
                    this.port = 80;
                }
            }
            catch (MalformedURLException me) {
                throw new IOException("Malformed URL '" + fnamp + "'");
            }
        }
    }

    public byte readByte() throws IOException, EOFException {
        if (this.startIdx[this.idx] < 0L || this.fpos < this.startIdx[this.idx] || this.fpos > this.endIdx[this.idx]) {
            this.readToBuffer();
        }
        ++this.fpos;
        return this.data[(int)(this.fpos - 1L - this.startIdx[this.idx])][this.idx];
    }

    public int readUnsignedByte() throws IOException, EOFException {
        return this.readByte() & 0xFF;
    }

    public short readShort() throws IOException, EOFException {
        return (short)((this.readByte() << 8) + this.readUnsignedByte());
    }

    public int readInt() throws IOException, EOFException {
        return (this.readByte() << 24) + (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + this.readUnsignedByte();
    }

    public double readDouble() throws IOException, EOFException {
        long ldb = ((long)this.readUnsignedByte() << 56) + ((long)this.readUnsignedByte() << 48) + ((long)this.readUnsignedByte() << 40) + ((long)this.readUnsignedByte() << 32) + ((long)this.readUnsignedByte() << 24) + ((long)this.readUnsignedByte() << 16) + ((long)this.readUnsignedByte() << 8) + (long)this.readUnsignedByte();
        return Double.longBitsToDouble(ldb);
    }

    public String readLine() throws IOException, EOFException {
        String sout;
        block3: {
            sout = "";
            try {
                char ch;
                while ((ch = (char)this.readUnsignedByte()) != '\n') {
                    sout = sout + ch;
                }
                sout = sout + ch;
            }
            catch (EOFException e) {
                if (sout.length() != 0) break block3;
                throw e;
            }
        }
        return sout;
    }

    public void close() throws IOException {
        try {
            this.fnamp = "";
            if (this.fp != null) {
                this.fp.close();
            }
            this.fp = null;
            if (this.sk != null) {
                this.sk.close();
            }
            this.sk = null;
            this.is = null;
            this.os = null;
        }
        catch (IOException ie) {
            if (this.sk != null) {
                this.sk.close();
            }
            this.sk = null;
            this.is = null;
            this.os = null;
            throw ie;
        }
    }

    public long getFilePointer() {
        return this.fpos;
    }

    public long length() throws IOException {
        if (this.fp != null && this.savedLength < 0L) {
            this.savedLength = this.fp.length();
        }
        if (this.fp != null || this.savedLength >= 0L) {
            return this.savedLength;
        }
        long len = 0L;
        String s = "HEAD " + this.fnamp + " HTTP/1.1\r\nUser-Agent: " + useragent + "\r\nHost: " + this.host + ":" + this.port + "\r\n\r\n";
        String sout = "";
        int failures = 0;
        int rc = 0;
        while (true) {
            try {
                this.URLwrite(this.os, s);
                sout = this.URLread(this.is);
            }
            catch (IOException ioe) {
                if (++failures >= 100) {
                    throw new IOException("(java.net.SocketException) " + ioe.getMessage());
                }
                this.reconnect();
                continue;
            }
            rc = this.checkHeader(sout);
            if (rc >= 0) break;
            if (++failures >= 100) {
                throw new IOException("Failed to read a valid / complete header.");
            }
            this.reconnect();
        }
        int idx = sout.indexOf("Content-Length:");
        if (rc != 200 || sout.indexOf("Content-Length:") < 0) {
            throw new IOException("Can't determine length of (HTTP-)file '" + this.fnamp + "'. HTTP error code: " + rc);
        }
        sout = sout.substring(idx + "Content-Length:".length());
        sout = sout.substring(0, sout.indexOf("\n")).trim();
        len = Long.parseLong(sout);
        return len;
    }

    public void seek(long pos) {
        this.fpos = pos;
    }

    void skipBytes(int count) throws IOException {
        if (this.fpos + (long)count >= this.length()) {
            throw new EOFException("Filepointer position " + (this.fpos + (long)count) + " exceeds file length by " + (this.fpos + (long)count - this.length() + 1L) + " byte(s).");
        }
        this.fpos += (long)count;
    }

    private String URLread(InputStream is) throws IOException {
        StringBuffer sret = new StringBuffer("");
        int av = is.read();
        if (av == -1) {
            throw new IOException("No bytes available.");
        }
        sret.append((char)av);
        while (is.available() > 0) {
            sret.append((char)is.read());
        }
        return sret.toString();
    }

    private void URLwrite(BufferedOutputStream os, String s) throws IOException {
        for (int n = 0; n < s.length(); ++n) {
            os.write((byte)s.charAt(n));
        }
        os.flush();
    }

    private String htmlStrip(String s) {
        int idx = s.indexOf("\r\n\r\n");
        if (idx >= 0) {
            return s.substring(idx + 4);
        }
        return "";
    }

    private int checkHeader(String s) {
        try {
            int ix1 = s.indexOf(" ");
            int ix2 = s.indexOf(" ", ix1 + 1);
            if (ix1 < 0 || ix2 < 0 || ix1 < 8 || ix1 + 4 != ix2) {
                return -1;
            }
            return Integer.parseInt(s.substring(ix1 + 1, ix2));
        }
        catch (NumberFormatException nf) {
            return -1;
        }
    }

    private void readToBuffer() throws IOException, EOFException {
        int slen;
        String sout;
        block11: {
            if (this.fp != null) {
                this.fp.seek(this.fpos);
                int cnt = this.fp.read(this.inbuf);
                if (cnt == -1) {
                    throw new EOFException("Filepointer position " + this.fpos + " exceeds file length by " + (this.fpos - this.length() + 1L) + " byte(s).");
                }
                for (int n = 0; n < cnt; ++n) {
                    this.data[n][this.idx] = this.inbuf[n];
                }
                this.startIdx[this.idx] = this.fpos;
                this.endIdx[this.idx] = this.fpos + (long)cnt - 1L;
                return;
            }
            if (this.fpos >= this.length()) {
                throw new EOFException("Filepointer position " + this.fpos + " exceeds file length by " + (this.fpos - this.length() + 1L) + " byte(s).");
            }
            String s = "GET " + this.fnamp + " HTTP/1.1\r\nUser-Agent: " + useragent + "\r\nHost: " + this.host + ":" + this.port + "\r\nRange: bytes=" + this.fpos + "-" + Math.min(this.length() - 1L, this.fpos + (long)this.BUFSIZE - 1L) + "\r\n\r\n";
            sout = "";
            slen = 0;
            int failures = 0;
            while (true) {
                try {
                    this.URLwrite(this.os, s);
                    sout = this.URLread(this.is);
                }
                catch (IOException ioe) {
                    if (++failures >= 100) {
                        throw new IOException("(java.net.SocketException) " + ioe.getMessage());
                    }
                    this.reconnect();
                    continue;
                }
                int rc = this.checkHeader(sout);
                if (rc < 0) {
                    if (++failures < 100) continue;
                    throw new IOException("Failed to read successfully from address\n'" + this.fnamp + "'. The http reply from the server was " + sout.length() + " bytes long and it's content is:\n\n" + sout);
                }
                sout = this.htmlStrip(sout);
                slen = sout.length();
                if (rc != 200 && rc != 206 || slen > this.BUFSIZE || slen < this.BUFSIZE && this.savedLength >= 0L && this.fpos + (long)slen != this.savedLength) {
                    if (++failures < 100) continue;
                    throw new IOException("HTTP read failed with HTTP response " + rc + ". Read " + slen + " bytes, requested " + this.BUFSIZE + " bytes.");
                }
                if (slen != 0) break block11;
                if (++failures >= 100) break;
            }
            throw new EOFException("Filepointer position " + this.fpos + " exceeds file length by " + (this.fpos - this.length() + 1L) + " byte(s).");
        }
        this.startIdx[this.idx] = this.fpos;
        this.endIdx[this.idx] = this.fpos + (long)slen - 1L;
        for (int n = 0; n < slen; ++n) {
            this.data[n][this.idx] = (byte)sout.charAt(n);
        }
    }

    private void reconnect() throws IOException {
        System.err.println("reconnecting...");
        this.sk.close();
        this.sk = new Socket(this.host, this.port);
        this.sk.setSoTimeout(5000);
        this.is = this.sk.getInputStream();
        this.os = new BufferedOutputStream(this.sk.getOutputStream());
    }
}

