/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.io.ExportFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;

public class ResultFile
extends ExportFile {
    public ResultFile(String filename, Charset encoding) throws IOException {
        super(filename, encoding);
    }

    public ResultFile(String path, String filename, String extension, Date now) throws IOException {
        super(path, filename, extension, now);
    }

    @Override
    public void print(int text) throws IOException {
        this.writer.write(Formatter.pReportNumber(text));
    }

    @Override
    public void print(long text) throws IOException {
        this.writer.write(Formatter.pReportNumber(text));
    }

    @Override
    public void print(double text) throws IOException {
        this.writer.write(Formatter.reportNumber(text));
    }

    @Override
    public void lprint(int ntext, int len) throws IOException {
        String text = Converter.stringToTrailingBlankString(Formatter.reportNumber(ntext), len);
        this.writer.write(text);
    }

    @Override
    public void rprint(int ntext, int len) throws IOException {
        String text = Converter.stringToLeadingBlankString(Formatter.reportNumber(ntext), len);
        this.writer.write(text);
    }

    @Override
    public void lprint(long ntext, int len) throws IOException {
        String text = Converter.stringToTrailingBlankString(Formatter.reportNumber(ntext), len);
        this.writer.write(text);
    }

    @Override
    public void rprint(long ntext, int len) throws IOException {
        String text = Converter.stringToLeadingBlankString(Formatter.reportNumber(ntext), len);
        this.writer.write(text);
    }

    @Override
    public void lprint(double ntext, int len) throws IOException {
        String text = Converter.stringToTrailingBlankString(Formatter.reportNumber(ntext), len);
        this.writer.write(text);
    }

    @Override
    public void rprint(double ntext, int len) throws IOException {
        String text = Converter.stringToLeadingBlankString(Formatter.reportNumber(ntext), len);
        this.writer.write(text);
    }

    public void printHeader(String text, String text2) throws IOException {
        this.println(text);
        this.println("Datum: " + Converter.timeToString(new Date()));
        if (!Util.isEmpty(text2)) {
            this.println(text2);
        }
        this.repeat("-", 80);
        this.newLine();
        this.newLine();
    }

    public void printHeader(String text) throws IOException {
        this.printHeader(text, null);
    }
}

