/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.client.gui.util.Popup;
import de.cni.common.core.Converter;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.Formatter;
import de.cni.common.core.LkzTimezoneMapper;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Geodaten;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.InternalErrorException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.ReportException;
import de.cni.common.io.AbstractFileImporter;
import de.cni.common.io.FileProcessor;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportPlzdaten
extends AbstractFileImporter {
    private static Log log = LogFactory.getLog(ImportPlzdaten.class);
    private static final int INTERVALL_ZWISCHENSUMME = 500;
    private static boolean COMMIT_ALLOWED = true;
    private static String importFilename = "plzdaten";
    private static String importExtension = "txt";
    private String resultFileName = importFilename;
    private int batchTimeout = 0;
    private boolean simulation;
    private Statistik statistik = new Statistik();
    private Geodaten element = new Geodaten();
    private SqLiteDatabase db = new SqLiteDatabase();
    private LkzTimezoneMapper lkzTimezoneMapper = new LkzTimezoneMapper();
    private int nextGeodatenId = this.db.getMaxGeodatenId() + 1;

    public String getResultString() throws IOException {
        if (this.statistik == null) {
            return "";
        }
        FormattedStringBuffer sb = new FormattedStringBuffer();
        int num_len = 10;
        sb.print("Datens\u00e4tze in der Datei       : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzInput), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze fehlerhaft         : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzErr), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze ok                 : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzOk), num_len);
        sb.newLine();
        sb.print("Datens\u00e4tze importiert         : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzImp), num_len);
        sb.newLine();
        sb.print("vorhandene Datens\u00e4tze beendet : ");
        sb.rprint(Formatter.reportNumber(this.statistik.anzTerminated), num_len);
        sb.newLine();
        return sb.toString();
    }

    public ImportPlzdaten(FileProcessor fileProcessor, boolean simulation) throws ClassNotFoundException, SQLException {
        super(fileProcessor);
        this.simulation = simulation;
        this.now = new Date();
    }

    @Override
    public String getLogfileDir() throws InternalErrorException {
        return "./io";
    }

    @Override
    public String getImportDir() throws InternalErrorException {
        return "./io";
    }

    @Override
    public String getResultfileName() throws InternalErrorException {
        return this.resultFileName;
    }

    @Override
    public String getImportFilename() {
        return importFilename;
    }

    @Override
    public String getExtension() {
        return importExtension;
    }

    @Override
    public boolean line2object(String line) throws IOException, DatabaseException, MappingException {
        boolean saveFlag = true;
        int lineNr = this.getLineNumber();
        if (lineNr <= 0) {
            return false;
        }
        this.element = new Geodaten();
        String lkz = this.getTabToken();
        String timezoneId = this.lkzTimezoneMapper.getTimezone(lkz);
        if (timezoneId == null) {
            return false;
        }
        this.element.setId(this.nextGeodatenId++);
        this.element.setLkz(lkz);
        this.element.setTimezoneId(timezoneId);
        this.element.setPlz(this.getTabToken());
        this.element.setOrt(this.getTabToken());
        this.getTabToken();
        this.getTabToken();
        this.getTabToken();
        this.getTabToken();
        this.getTabToken();
        this.getTabToken();
        this.element.setLatitude(this.getTabToken());
        this.element.setLongitude(this.getTabToken());
        ++this.statistik.anzInput;
        ++this.statistik.anzOk;
        return saveFlag;
    }

    @Override
    public void save(boolean fast) throws DatabaseException {
        try {
            if (this.element == null) {
                return;
            }
            if (this.simulation) {
                return;
            }
            this.db.bulkSaveGeodaten(this.element);
            ++this.statistik.anzImp;
            if (COMMIT_ALLOWED && this.statistik.anzImp % 500 == 0) {
                this.db.postBulkSaveGeodaten();
                this.db.preBulkSaveGeodaten();
                log.debug((Object)(Converter.timeToString(new Date()) + ", verarbeitet: " + Formatter.pReportNumber(this.statistik.anzImp)));
            }
        }
        catch (Exception e) {
            ++this.statistik.anzErr;
            e.printStackTrace();
            throw new DatabaseException(DatabaseException.ErrorType.customText, e);
        }
    }

    @Override
    public boolean isRemoveFile() {
        return false;
    }

    @Override
    public void preImport() throws DatabaseException {
        if (this.simulation) {
            return;
        }
        try {
            this.db.preBulkSaveGeodaten();
        }
        catch (Exception e) {
            throw new DatabaseException(DatabaseException.ErrorType.customText, e);
        }
    }

    @Override
    public void postImport() throws DatabaseException {
        this.db.postBulkSaveGeodaten();
    }

    public static void doImport() throws DatabaseException, CalculationException, ReportException {
        try {
            boolean simulation = false;
            FileProcessor fp = FileProcessor.newTextFileProcessor("UTF-8");
            ImportPlzdaten worker = new ImportPlzdaten(fp, simulation);
            int n = fp.processImport(worker);
            Popup.info(worker.getResultString());
        }
        catch (Exception e) {
            throw new CalculationException("Fehler beim Import. " + Util.NotNull(e.getMessage()));
        }
    }

    private class Statistik {
        int anzInput;
        int anzErr;
        int anzOk;
        int anzImp;
        int anzTerminated;

        private Statistik() {
        }
    }
}

