/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.cni.common.exceptions.TechnicalException;
import java.util.Date;
import java.util.HashMap;

public class ColumnHandler {
    Enum<?>[] Spalten;
    HashMap<Enum<?>, Integer> headerMap = new HashMap();
    String[] valueMap;

    public ColumnHandler(Enum<?>[] spalten) {
        this.Spalten = spalten;
    }

    public void prepareHeaderMap(String headerLine) {
        String[] headerArray = headerLine.split(";");
        String header = null;
        block0: for (int i = 0; i < headerArray.length; ++i) {
            header = headerArray[i];
            for (Enum<?> s : this.Spalten) {
                if (!Util.equals(s.toString().toUpperCase(), header.toUpperCase())) continue;
                this.headerMap.put(s, i);
                continue block0;
            }
        }
        this.valueMap = new String[headerArray.length];
    }

    public void fillValueMap(String line) {
        this.valueMap = line.split(";");
    }

    public String getValue(Enum<?> spalte) throws TechnicalException {
        try {
            int s = this.headerMap.get(spalte);
            return this.valueMap[s].trim();
        }
        catch (Exception e) {
            throw new TechnicalException("Die Datei enth\u00e4lt keine Spalte '" + spalte.toString() + "' oder der Wert ist nicht erlaubt.");
        }
    }

    public int getIntValue(Enum<?> spalte) throws TechnicalException {
        try {
            int s = this.headerMap.get(spalte);
            return Converter.stringToInt(this.valueMap[s].trim());
        }
        catch (Exception e) {
            throw new TechnicalException("Die Datei enth\u00e4lt keine Spalte '" + spalte.toString() + "' oder der Wert ist nicht erlaubt.");
        }
    }

    public boolean getBooleanValue(Enum<?> spalte) throws TechnicalException {
        try {
            int s = this.headerMap.get(spalte);
            return Converter.stringToBoolean(this.valueMap[s].trim());
        }
        catch (Exception e) {
            throw new TechnicalException("Die Datei enth\u00e4lt keine Spalte '" + spalte.toString() + "' oder der Wert ist nicht erlaubt.");
        }
    }

    public Date getDateValue(Enum<?> spalte) throws TechnicalException {
        try {
            return Converter.stringToDate(this.valueMap[this.headerMap.get(spalte)].trim());
        }
        catch (Exception e) {
            throw new TechnicalException("Die Datei enth\u00e4lt keine Spalte '" + spalte.toString() + "' oder der Wert ist nicht erlaubt.");
        }
    }
}

