/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.io;

import de.cni.common.core.Converter;
import de.cni.common.core.Domain;
import de.cni.common.core.IMappings;
import de.cni.common.core.Mappings;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.exceptions.CalculationException;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.InternalErrorException;
import de.cni.common.exceptions.MappingException;
import de.cni.common.exceptions.TechnicalException;
import de.cni.common.io.FileProcessor;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFileImporter {
    protected Date now = new Date();
    protected String letzterBearbeiter = "Import";
    protected int pos = 0;
    protected int column = 0;
    protected int lineNumber = 0;
    protected int numProcessed = 0;
    protected int numTotalProcessed = 0;
    protected String message = "";
    public static final String UTF8_BOM = "\ufeff";
    int limit;
    String line;
    FileProcessor fileProcessor;
    protected final int LEN_CSV = -1;
    protected final int LEN_TAB = -2;
    private static Log log = LogFactory.getLog(AbstractFileImporter.class);

    public static String removeUTF8BOM(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(1);
        }
        return s;
    }

    public void prepareNewFile() {
        this.pos = 0;
        this.lineNumber = 0;
        this.numProcessed = 0;
    }

    public String getMessage() {
        return this.message;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public AbstractFileImporter(FileProcessor fileProcessor) {
        this.fileProcessor = fileProcessor;
    }

    protected String getNextLine() throws IOException {
        if (this.fileProcessor != null) {
            return this.fileProcessor.getNextLine();
        }
        return null;
    }

    public int processLine(String line) throws IOException, TechnicalException {
        try {
            ++this.lineNumber;
            this.line = line;
            this.pos = 0;
            this.column = 0;
            if (this.line2object(line)) {
                this.save(true);
                ++this.numProcessed;
                ++this.numTotalProcessed;
            }
        }
        catch (Exception e) {
            String filename = null;
            try {
                filename = this.fileProcessor.getCurrentFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.handleError(filename, e);
        }
        return this.numProcessed;
    }

    protected void setDefaultValues(IBusinessObject o) {
        o.setCreated(this.now);
        o.setChanged(this.now);
        o.setLetzterBearbeiter(this.letzterBearbeiter);
    }

    protected String getStringToken(int len) {
        return this.getToken(len);
    }

    protected String getNumberToken(int len) {
        String s = this.getToken(len);
        long x = Converter.stringToLong(s);
        return Converter.longToString(x);
    }

    protected String getNotNullNumberToken(int len) {
        String s = this.getToken(len);
        long x = Converter.stringToLong(s);
        return Converter.longToNotNullString(x);
    }

    protected int getIntToken(int len) {
        int value = Converter.stringToInt(this.getToken(len));
        return value;
    }

    protected double getDoubleToken(int len) {
        try {
            return Converter.stringToDouble(this.getToken(len));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    protected Date getDateToken(int len) {
        Date value = Converter.stringToDate(this.getToken(len));
        return value;
    }

    protected Date getJahrDateToken(int len) {
        Date value = Converter.stringToDate(this.getToken(len) + "1231");
        return value;
    }

    protected Date getTimeToken(int len) {
        String time = this.getToken(len);
        Date value = Converter.stringToTime(time.substring(0, len - 1));
        return value;
    }

    protected int getPidToken(int len) {
        String value = this.getStringToken(len);
        int intPid = Converter.stringToInt(value);
        return intPid;
    }

    protected boolean getBooleanToken(int len) {
        String s = this.getStringToken(len);
        if (s.equalsIgnoreCase("J")) {
            return true;
        }
        if (s.equalsIgnoreCase("N")) {
            return false;
        }
        if (s.equals("0")) {
            return false;
        }
        if (s.equals("1")) {
            return true;
        }
        if (Util.isEmpty(s)) {
            return false;
        }
        char x = s.charAt(0);
        boolean ret = x != '\u0000';
        return ret;
    }

    protected int getComboTokenIgnore(int len, Domain domain) {
        try {
            return this.getComboToken(len, domain, 0);
        }
        catch (MappingException e) {
            log.error((Object)e.getMessage());
            return 0;
        }
    }

    protected int getComboTokenIgnore(int len, Domain domain, int offset) {
        try {
            return this.getComboToken(len, domain, offset);
        }
        catch (MappingException e) {
            log.error((Object)e.getMessage());
            return 0;
        }
    }

    protected int getComboToken(int len, Domain domain) throws MappingException {
        try {
            return this.getComboToken(len, domain, 0);
        }
        catch (MappingException e) {
            log.error((Object)e.getMessage());
            return 0;
        }
    }

    protected int getComboToken(int len, Domain domain, int offset) throws MappingException {
        String token = this.getToken(len);
        if (Util.isEmpty(token) || Util.isInt(token) && Converter.stringToInt(token) == 0) {
            return 0;
        }
        if (offset > 0) {
            token = token.substring(offset);
        }
        int value = Mappings.getInstance().getDomainIdFromKurztext(domain, token);
        return value;
    }

    protected String getToken(int len) {
        String s = null;
        if (len > 0) {
            s = this.limit == 0 || this.pos + len <= this.limit ? this.line.substring(this.pos, this.pos + len).trim() : "";
            this.pos += len;
        } else if (len == -1) {
            s = this.getCsvToken();
        } else if (len == -2) {
            s = this.getTabToken();
        } else if (len == -3) {
            ++this.column;
            s = this.line.substring(this.pos).trim();
        }
        return s;
    }

    protected String getCsvToken(String s) {
        String ret = this.getCsvToken();
        if (Util.isEmpty(ret)) {
            return s;
        }
        return ret;
    }

    protected String getCsvToken() {
        ++this.column;
        int len = 0;
        int endPos = this.line.indexOf(59, this.pos);
        len = endPos < 0 ? this.line.length() - this.pos : endPos - this.pos;
        if (len < 0) {
            return "";
        }
        String s = this.line.substring(this.pos, this.pos + len).trim();
        this.pos += len + 1;
        return s;
    }

    protected int getCsvKurztextToken(IMappings mappings, Domain domain) throws MappingException {
        return 0;
    }

    protected int getCsvLangtextToken(IMappings mappings, Domain domain) throws MappingException {
        return 0;
    }

    protected int getCsvIntToken() {
        String v = this.getCsvToken();
        return Converter.stringToInt(v);
    }

    protected double getCsvDoubleToken() {
        String v = this.getCsvToken();
        return Converter.stringToDouble(v);
    }

    protected boolean getCsvBooleanToken() {
        String v = this.getCsvToken();
        return Converter.stringToBoolean(v);
    }

    protected double getCsvGermanDoubleToken() {
        String v = this.getCsvToken();
        return Converter.germanStringToDouble(v);
    }

    protected Date getCsvDateToken() {
        String v = this.getCsvToken();
        return Converter.stringToDate(v);
    }

    protected String getTabToken() {
        ++this.column;
        int len = 0;
        int endPos = this.line.indexOf(9, this.pos);
        len = endPos < 0 ? this.line.length() - this.pos : endPos - this.pos;
        String s = this.line.substring(this.pos, this.pos + len).trim();
        this.pos += len + 1;
        return s;
    }

    public int getNumProcessed() {
        return this.numProcessed;
    }

    public String getLine() {
        return this.line;
    }

    public void handleError(Exception e) throws TechnicalException {
        this.handleError(null, e);
    }

    public void handleError(String filename, Exception e) throws TechnicalException {
        StringBuffer text = new StringBuffer();
        text.append("Fehler beim Import.\n");
        if (filename != null) {
            text.append("Datei: " + filename + "\n");
        }
        if (this.lineNumber >= 0) {
            text.append("Zeile: ");
            text.append(this.lineNumber);
            text.append("\n");
        }
        if (!Util.isEmpty(this.line)) {
            text.append("Inhalt: ");
            text.append(this.line);
            text.append("\n");
        }
        text.append("Fehlertyp: ");
        text.append(e.getClass().getCanonicalName());
        text.append("\n");
        text.append("Fehlermeldung: " + e.getMessage());
        TechnicalException exception = new TechnicalException(text.toString());
        if (this.fileProcessor != null && this.fileProcessor.resultFile != null) {
            try {
                this.fileProcessor.resultFile.println("Fehlermeldung:");
                this.fileProcessor.resultFile.println(text.toString());
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        throw exception;
    }

    public boolean isRemoveFile() {
        return false;
    }

    public boolean isMoveFileToHistorie() {
        return false;
    }

    public void preImport() throws IOException, DatabaseException {
    }

    public void postImport() throws IOException, DatabaseException {
    }

    public abstract String getLogfileDir() throws InternalErrorException;

    public abstract String getImportDir() throws InternalErrorException;

    public abstract String getResultfileName() throws InternalErrorException;

    public abstract String getImportFilename();

    public abstract String getExtension();

    public String getResultfilePath() throws InternalErrorException {
        return this.getLogfileDir();
    }

    public String getResultfileExtension() throws InternalErrorException {
        return "txt";
    }

    public abstract boolean line2object(String var1) throws CalculationException, IOException, DatabaseException, MappingException, TechnicalException;

    public abstract void save(boolean var1) throws DatabaseException;

    protected String strip(String s) {
        return Converter.strip(s, "\"");
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getNumTotalProcessed() {
        return this.numTotalProcessed;
    }
}

