/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.exceptions;

public class MappingException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorType errorType;
    private String domain;
    private int id;
    private String text;

    public MappingException(String domain) {
        this.domain = domain;
        this.errorType = ErrorType.illegalDomain;
    }

    public MappingException(String domain, int id) {
        this.domain = domain;
        this.id = id;
        this.errorType = ErrorType.illegalId;
    }

    public MappingException(String domain, ErrorType errorType, int id) {
        this.domain = domain;
        this.id = id;
        this.errorType = errorType;
    }

    public MappingException(String domain, String text) {
        this.domain = domain;
        this.text = text;
        this.errorType = ErrorType.illegalText;
    }

    @Override
    public String getMessage() {
        if (this.errorType == null) {
            return "unbekannte Dom\u00e4ne";
        }
        switch (this.errorType) {
            case illegalId: {
                return "Zur ID '" + this.id + "' gibt es keine Abbildungsvorschrift f\u00fcr die Dom\u00e4ne '" + this.domain + "'.\nAchtung: Ein Speichern der Daten kann zu irreversiblen Sch\u00e4den f\u00fchren.";
            }
            case illegalIndex: {
                return "Zum Index '" + this.id + "' gibt es keine Abbildungsvorschrift f\u00fcr die Dom\u00e4ne '" + this.domain + "'.\nAchtung: Ein Speichern der Daten kann zu irreversiblen Sch\u00e4den f\u00fchren.";
            }
            case illegalText: {
                return "Zum Text '" + this.text + "' gibt es keine Abbildungsvorschrift f\u00fcr die Dom\u00e4ne '" + this.domain + "'.";
            }
            case illegalDomain: {
                return "Die Dom\u00e4ne '" + this.domain + "' wurde nicht initialisiert.";
            }
        }
        return "";
    }

    public ErrorType getErrorCode() {
        return this.errorType;
    }

    public static enum ErrorType {
        illegalIndex,
        illegalId,
        illegalText,
        illegalDomain;

    }
}

