/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.exceptions;

import de.cni.common.core.ClassUtils;
import de.cni.common.core.Util;

public class DatabaseException
extends Exception {
    private static final long serialVersionUID = 1L;
    private ErrorType errorType;
    private String details;
    private Exception e;

    public DatabaseException(ErrorType errorType) {
        this.errorType = errorType;
        this.details = "";
    }

    public DatabaseException(ErrorType errorType, String details) {
        this.errorType = errorType;
        this.details = details;
    }

    public DatabaseException(ErrorType errorType, Exception e) {
        this.errorType = errorType;
        this.e = e;
    }

    @Override
    public String getMessage() {
        String ret = "";
        switch (this.errorType) {
            case objectExists: {
                ret = "Dieses Object existiert bereits.";
                break;
            }
            case lockError: {
                ret = "Der Datensatz wurde zeitgleich durch einen anderen Benutzer ge\u00e4ndert. Bitte f\u00fchren Sie zun\u00e4chst einen Refresh durch, bevor Sie erneut speichern.";
                break;
            }
            case constraintViolation: {
                ret = "Integrit\u00e4tsverletztung.\nEntweder haben sie versucht einen Wert zu speichern,\nden es schon gibt, oder Sie haben versucht\neinen Datensatz zu l\u00f6schen, der noch von\nanderen Datens\u00e4tzen referenziert wird.";
                break;
            }
            case technicalError: {
                ret = "Es ist ein technischer Fehler aufgetreten.";
                break;
            }
            case userExists: {
                ret = "Dieser Benutzer existiert bereits.";
                break;
            }
            case userInvalid: {
                ret = "Es sind nicht alle Pflichtfelder gef\u00fcllt.";
                break;
            }
            case illegalPassword: {
                ret = "Das neue Passwort ist nicht g\u00fcltig.";
                break;
            }
            case authorizationFailed: {
                ret = "Sie haben keine Berechtigung f\u00fcr diese Funktion.";
                break;
            }
            case illegalUser: {
                ret = "Der Benutzer existiert nicht im System.";
                break;
            }
            case passwordsDiffer: {
                ret = "Das neue Passwort und die Wiederholung des neuen Passworts sind unterschiedlich.";
                break;
            }
            case objectDoesNotExist: {
                ret = "Das Objekt, das ver\u00e4ndert werden soll, existiert nicht.";
                break;
            }
            case notSaveable: {
                ret = "Es sind Validierungsfehler aufgetreten.";
                break;
            }
            case notSupported: {
                ret = "Dieser Methodenaufruf wird nicht unterst\u00fctzt.";
                break;
            }
            case migration: {
                ret = "Migrationsfehler.";
                break;
            }
            case objectInvalid: {
                ret = "Validierungsfehler.";
                break;
            }
            case calculationFailed: {
                ret = "Fehler bei der Berechnung.";
                break;
            }
            case customText: {
                ret = "";
            }
        }
        if (this.e != null) {
            this.details = this.e.getMessage();
            if (Util.isEmpty(this.details)) {
                this.details = "Fehlertyp: " + ClassUtils.getClassName(this.e.getClass());
            }
        }
        if (!Util.isEmpty(this.details)) {
            ret = ret + "\n" + Util.NotNull(this.details);
        }
        return ret;
    }

    public ErrorType getErrorCode() {
        return this.errorType;
    }

    public static enum ErrorType {
        objectExists,
        lockError,
        technicalError,
        constraintViolation,
        userExists,
        userInvalid,
        illegalPassword,
        authorizationFailed,
        illegalUser,
        passwordsDiffer,
        objectDoesNotExist,
        notSaveable,
        migration,
        notSupported,
        objectInvalid,
        calculationFailed,
        customText;

    }
}

