/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.encoding;

import de.cni.common.encoding.CheckDigit;

public class CheckLuhnMod10
implements CheckDigit {
    @Override
    public String encode(String digits) {
        return digits + this.computeCheck(digits);
    }

    @Override
    public boolean verify(String digits) {
        try {
            return this.computeSum(digits) % 10 == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int computeCheck(String digits) {
        int val = this.computeSum(digits);
        return val == 0 ? 0 : 10 - val;
    }

    @Override
    public int getCheckDigit(String digits) {
        return digits.charAt(digits.length() - 1) - 48;
    }

    @Override
    public String getData(String digits) {
        return digits.substring(0, digits.length() - 1);
    }

    private int computeSum(String digits) {
        int c;
        int i;
        int val = 0;
        for (i = 0; i < digits.length(); i += 2) {
            c = digits.charAt(i) - 48;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("Bad digit: '" + digits.charAt(i) + "'");
            }
            val += c;
        }
        for (i = 1; i < digits.length(); i += 2) {
            c = digits.charAt(i) - 48;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("Bad digit: '" + digits.charAt(i) + "'");
            }
            val += c >= 5 ? 2 * c - 9 : 2 * c;
        }
        return val % 10;
    }
}

