/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.encoding;

import de.cni.common.encoding.CheckDigit;

public class CheckISO7064Mod11_10
implements CheckDigit {
    @Override
    public String encode(String digits) {
        return digits + this.computeCheck(digits);
    }

    @Override
    public boolean verify(String digits) {
        try {
            int t = 10;
            for (int i = 0; i < digits.length() - 1; ++i) {
                t = 2 * this.f(t + digits.charAt(i) - 48) % 11;
            }
            return (t + this.getCheckDigit(digits)) % 10 == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int f(int x) {
        int val = x % 10;
        return val == 0 ? 10 : val;
    }

    @Override
    public int computeCheck(String digits) {
        int t = 10;
        for (int i = 0; i < digits.length(); ++i) {
            int c = digits.charAt(i) - 48;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("Bad digit: '" + digits.charAt(i) + "'");
            }
            t = 2 * this.f(t + c) % 11;
        }
        return (11 - t) % 10;
    }

    @Override
    public int getCheckDigit(String digits) {
        return digits.charAt(digits.length() - 1) - 48;
    }

    @Override
    public String getData(String digits) {
        return digits.substring(0, digits.length() - 1);
    }
}

