/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.datamodel.enumtypes;

import de.cni.common.core.Brand;
import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.BatchjobBerechtigung;
import de.cni.common.datamodel.admin.Rolle;
import java.util.Arrays;
import java.util.List;

public enum Batchjobtyp {
    leer(0, "", "", Brand.ALL, true),
    gehaltsabrechnung(1, "01", "Gehaltsabrechnung", Brand.ALL, true),
    datenbereinigung(9999, "Datenbereinigung", "Datenbereinigung", Brand.ALL, true);

    boolean menu;
    int id;
    String name;
    String kuerzel;
    Brand brand;

    private Batchjobtyp(int id, String kuerzel, String name, Brand brand, boolean menu) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.name = Converter.stringToTrailingBlankString(kuerzel, 4) + " - " + name;
        this.menu = menu;
        this.brand = brand;
    }

    public final int getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static String[] getNameArray(Brand brand) {
        int length = 0;
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (!job.isMenu() || brand != null && job.getBrand() != Brand.ALL && job.getBrand() != brand) continue;
            ++length;
        }
        Object[] nameArray = new String[length];
        int i = 0;
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (!job.isMenu() || brand != null && job.getBrand() != Brand.ALL && job.getBrand() != brand) continue;
            nameArray[i++] = job.getName();
        }
        Arrays.sort(nameArray);
        return nameArray;
    }

    public static String[] getNameArray(Brand brand, List<Rolle> rolleList, List<IBusinessObject> berechtigungList) {
        int length = 0;
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (!job.isMenu() || brand != null && job.getBrand() != Brand.ALL && job.getBrand() != brand || !Batchjobtyp.isAllowed(job, rolleList, berechtigungList)) continue;
            ++length;
        }
        Object[] nameArray = new String[length];
        int i = 0;
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (!job.isMenu() || brand != null && job.getBrand() != Brand.ALL && job.getBrand() != brand || !Batchjobtyp.isAllowed(job, rolleList, berechtigungList)) continue;
            nameArray[i++] = job.getName();
        }
        Arrays.sort(nameArray);
        return nameArray;
    }

    public static boolean isAllowed(Batchjobtyp job, List<Rolle> rolleList, List<IBusinessObject> berechtigungList) {
        for (IBusinessObject object : berechtigungList) {
            BatchjobBerechtigung batchjobBerechtigung = (BatchjobBerechtigung)object;
            if (batchjobBerechtigung.getJob() != job.getId()) continue;
            for (Rolle rolle : rolleList) {
                if (!Util.equals(rolle.getRolle(), batchjobBerechtigung.getRole())) continue;
                return true;
            }
        }
        return false;
    }

    public static String getNameById(int id) {
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (job.getId() != id) continue;
            return job.getName();
        }
        return null;
    }

    public static String getKuerzelById(int id) {
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (job.getId() != id) continue;
            return job.getKuerzel();
        }
        return null;
    }

    public static int getIdByName(String name) {
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (!job.getName().equals(name)) continue;
            return job.getId();
        }
        return 0;
    }

    public static int getIdByKuerzel(String kuerzel) {
        for (Batchjobtyp job : Batchjobtyp.values()) {
            if (!job.getKuerzel().equals(kuerzel)) continue;
            return job.getId();
        }
        return 0;
    }

    public static Batchjobtyp getBatchjobtyp(int id) {
        for (Batchjobtyp jobtyp : Batchjobtyp.values()) {
            if (jobtyp.getId() != id) continue;
            return jobtyp;
        }
        return null;
    }

    public static Batchjobtyp getBatchjobtypByKuerzel(String kuerzel) {
        for (Batchjobtyp jobtyp : Batchjobtyp.values()) {
            if (!Util.equals(jobtyp.getKuerzel(), kuerzel)) continue;
            return jobtyp;
        }
        return null;
    }

    public boolean isMenu() {
        return this.menu;
    }

    public void setMenu(boolean menu) {
        this.menu = menu;
    }

    public String getKuerzel() {
        return this.kuerzel;
    }

    public void setKuerzel(String kuerzel) {
        this.kuerzel = kuerzel;
    }

    public Brand getBrand() {
        return this.brand;
    }

    public void setBrand(Brand brand) {
        this.brand = brand;
    }
}

