/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.datamodel;

import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.core.Converter;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.Basisdaten;

public class TkzGms
extends Basisdaten {
    int tkzIdx = -1;
    private int grad;
    private int minuten;
    private int sekunden;

    public double getWinkel(double ac) {
        double value = (double)this.grad + (double)this.minuten / 60.0 + (double)this.sekunden / 3600.0;
        if (!this.matchesSekunde(value = Util.roundGms(value), this.sekunden)) {
            double newValue = value + 1.0E-6;
            if (this.matchesSekunde(newValue = Util.roundGms(newValue), this.sekunden)) {
                value = newValue;
            } else {
                newValue = value - 1.0E-6;
                if (this.matchesSekunde(newValue = Util.roundGms(newValue), this.sekunden)) {
                    value = newValue;
                }
            }
        }
        if (this.tkzIdx >= 0) {
            double tkzWinkel = 30 * this.tkzIdx;
            tkzWinkel = FormatterGradzahlen.transfer(tkzWinkel, ac);
            value = Trigo.grad(value + tkzWinkel);
        }
        return value;
    }

    private boolean matchesSekunde(double value, int sekunde) {
        try {
            String s = Util.lon2dms(value);
            String sub = s.split(" ")[2];
            int sec = Converter.stringToInt(Util.cutString(sub, 2));
            return sec == sekunde;
        }
        catch (Exception e) {
            return true;
        }
    }

    public int getTkzIdx() {
        return this.tkzIdx;
    }

    public int getGrad() {
        return this.grad;
    }

    public int getMinuten() {
        return this.minuten;
    }

    public int getSekunden() {
        return this.sekunden;
    }

    public void setTkzIdx(int tkzIdx) {
        this.tkzIdx = tkzIdx;
    }

    public void setGrad(int grad) {
        this.grad = grad;
    }

    public void setMinuten(int minuten) {
        this.minuten = minuten;
    }

    public void setSekunden(int sekunden) {
        this.sekunden = sekunden;
    }
}

