/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.datamodel;

import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Util;
import de.cni.common.datamodel.enumtypes.JobParameterTyp;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RangeElement
implements Serializable {
    private static Log log = LogFactory.getLog(RangeElement.class);
    private static final long serialVersionUID = 1L;
    JobParameterTyp typ;
    boolean alle;
    boolean einen;
    boolean bereich;
    Object exact;
    Object von;
    Object bis;

    public RangeElement(JobParameterTyp typ) {
        this.typ = typ;
        this.alle = true;
        this.einen = false;
        this.bereich = false;
        this.exact = null;
        this.von = null;
        this.bis = null;
    }

    public RangeElement(JobParameterTyp typ, boolean alle, boolean einen, boolean bereich, Object exact, Object von, Object bis) {
        this.typ = typ;
        this.alle = alle;
        this.einen = einen;
        this.bereich = bereich;
        this.exact = exact;
        this.von = von;
        this.bis = bis;
    }

    public String getWhereElement(String where, String varName) {
        if (this.alle) {
            return where;
        }
        if (this.typ == JobParameterTyp.STRING) {
            if (this.einen) {
                where = Util.addFilter(where, varName, "=", (String)this.exact);
            } else {
                where = Util.addFilter(where, varName, ">=", (String)this.von);
                where = Util.addFilter(where, varName, "<=", (String)this.bis);
            }
        }
        if (this.typ == JobParameterTyp.INT) {
            if (this.einen) {
                where = Util.addForceFilter(where, varName, "=", (Integer)this.exact);
            } else {
                where = Util.addForceFilter(where, varName, ">=", (Integer)this.von);
                where = Util.addForceFilter(where, varName, "<=", (Integer)this.bis);
            }
        }
        if (this.typ == JobParameterTyp.DOUBLE) {
            if (this.einen) {
                where = Util.addFilter(where, varName, "=", (Double)this.exact);
            } else {
                where = Util.addFilter(where, varName, ">=", (Double)this.von);
                where = Util.addFilter(where, varName, "<=", (Double)this.bis);
            }
        }
        if (this.typ == JobParameterTyp.DATE) {
            if (this.einen) {
                where = Util.addDateFilter(where, varName, (Date)this.exact);
            } else {
                where = Util.addFilter(where, varName, ">=", (Date)this.von);
                where = Util.addFilter(where, varName, "<", DateUtil.dateAddDays((Date)this.bis, 1));
            }
        }
        return where;
    }

    public String toString() {
        String ret = null;
        log.debug((Object)("Range-Element-Alle:" + this.alle));
        if (this.alle) {
            return "<ALLE>";
        }
        if (this.typ == JobParameterTyp.STRING) {
            if (this.einen) {
                ret = "Wert=" + (String)this.exact;
            } else {
                ret = "Von=" + (String)this.von + " ";
                ret = ret + "Bis=" + (String)this.bis;
            }
        }
        if (this.typ == JobParameterTyp.INT) {
            if (this.einen) {
                ret = "Wert=" + Converter.intToString((Integer)this.exact);
            } else {
                ret = "Von=" + Converter.intToString((Integer)this.von) + " ";
                ret = ret + "Bis=" + Converter.intToString((Integer)this.bis);
            }
        }
        if (this.typ == JobParameterTyp.DOUBLE) {
            if (this.einen) {
                ret = "value=" + Converter.doubleToString((Double)this.exact);
            } else {
                ret = "min=" + Converter.doubleToString((Double)this.von) + " ";
                ret = ret + "max=" + Converter.doubleToString((Double)this.bis);
            }
        }
        if (this.typ == JobParameterTyp.DATE) {
            if (this.einen) {
                ret = "value=" + Converter.dateToString((Date)this.exact);
            } else {
                ret = "min=" + Converter.dateToString((Date)this.von) + " ";
                ret = ret + "max=" + Converter.dateToString((Date)this.bis);
            }
        }
        return ret;
    }

    public JobParameterTyp getTyp() {
        return this.typ;
    }

    public boolean isAlle() {
        return this.alle;
    }

    public boolean isEinen() {
        return this.einen;
    }

    public boolean isBereich() {
        return this.bereich;
    }

    public Object getExact() {
        return this.exact;
    }

    public Object getVon() {
        return this.von;
    }

    public Object getBis() {
        return this.bis;
    }
}

