/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.calculation.AnalyseAspektElement;
import de.cni.common.calculation.AnalyseElement;
import de.cni.common.calculation.AnalyseResult;
import de.cni.common.calculation.HerrscherResult;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Analyse;
import de.cni.common.datamodel.admin.AnalyseHerrscher;
import de.cni.common.datamodel.admin.Texte;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TexteHandler {
    private static Log log = LogFactory.getLog(TexteHandler.class);
    private boolean core;
    private String klasse;
    private int stufe;
    int[] excludeArray = new int[]{0};
    SqLiteDatabase db = new SqLiteDatabase();
    protected String textbaseCore = System.getProperty("user.dir") + "/texte";
    protected String textbaseCustom = GlobalData.getInstance().getSettings().getTexteDir();

    public TexteHandler(boolean core, String klasse, int stufe) {
        log.debug((Object)"TexteHandler initialisiert");
        this.core = core;
        this.klasse = klasse;
        this.stufe = stufe;
    }

    public String getText(AnalyseResult analyseResult) {
        try {
            Analyse filter = Analyse.newInstance(this.core);
            filter.setHoroskop(analyseResult.getHoroskopCalculator().getHoroskop().getName());
            filter.setPlanet1(analyseResult.getPlanet());
            filter.setTkz1(analyseResult.getTkz());
            filter.setHaus(analyseResult.getHaus());
            String key = this.db.getTextkey(filter, this.core);
            if (Util.isEmpty(key)) {
                return "";
            }
            return this.getText(key, this.excludeArray);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getText(AnalyseAspektElement analyseAspekt) {
        try {
            Analyse filter = Analyse.newInstance(this.core);
            filter.setHoroskop(analyseAspekt.getHoroskopname());
            filter.setAspekt(analyseAspekt.getAspekt().getLangname());
            filter.setPlanet1(Constants.planeten[analyseAspekt.getPlanet1()]);
            filter.setPlanet2(Constants.planeten[analyseAspekt.getPlanet2()]);
            String key = this.db.getTextkey(filter, this.core);
            if (Util.isEmpty(key)) {
                return "";
            }
            return this.getText(key, this.excludeArray);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getText(HerrscherResult herrscherResult) {
        try {
            AnalyseHerrscher filter = AnalyseHerrscher.newInstance(this.core);
            filter.setHoroskop(herrscherResult.getHoroskopName());
            filter.setHaus(Converter.intToString(herrscherResult.getHausId()));
            filter.setTkz(herrscherResult.getTkz());
            filter.setHerrscher(herrscherResult.getHerrscherPlanet());
            String key = this.db.getTextkey(filter, this.core);
            if (Util.isEmpty(key)) {
                return "";
            }
            return this.getText(key, this.excludeArray);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getText(AnalyseElement analyseElement) {
        try {
            Analyse filter = Analyse.newInstance(this.core);
            filter.setHoroskop(analyseElement.getAnalyse().getHoroskop());
            filter.setText1(analyseElement.getText1());
            String key = this.db.getTextkey(filter, this.core);
            if (Util.isEmpty(key)) {
                return "";
            }
            return this.getText(key, this.excludeArray);
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getText(String key, int[] stufeArray) {
        try {
            log.debug((Object)("getText " + key));
            if (Util.isEmpty(key)) {
                return "";
            }
            Texte filter = Texte.newInstance(this.core);
            filter.setKlasse(this.klasse);
            filter.setKey(key);
            List<IBusinessObject> list = this.db.select(filter, this.core);
            if (list == null || list.size() == 0) {
                return "";
            }
            String s = "";
            for (IBusinessObject obj : list) {
                Texte t = (Texte)obj;
                if (!Util.isEmpty(t.getUrl())) {
                    if (!this.core) {
                        String url = this.textbaseCustom + "/" + t.getUrl();
                        File file = new File(url);
                        if (file.exists()) {
                            return "URL:" + url;
                        }
                    } else {
                        return "URL:" + this.textbaseCore + "/" + t.getUrl();
                    }
                }
                for (int stufe : stufeArray) {
                    if (t.getStufe() == stufe) continue;
                    s = Formatter.append(s, t.getText(), "\n\n");
                }
            }
            return s;
        }
        catch (Exception e) {
            return "";
        }
    }
}

