/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Converter;
import de.cni.common.core.IParameterStore;
import de.cni.common.core.ServerConnection;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Parameter;
import de.cni.common.ejb.IBusinessObjectVerwaltung;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.InternalErrorException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterStore
implements IParameterStore {
    private static Log log = LogFactory.getLog(ParameterStore.class);
    HashMap<String, String> store = new HashMap();
    boolean initialized = false;

    public String getValue(String key) throws InternalErrorException {
        String value;
        try {
            value = this.store.get(key);
            if (Util.isEmpty(value)) {
                this.select(key);
                value = this.store.get(key);
            }
        }
        catch (Exception e) {
            throw new InternalErrorException(InternalErrorException.ErrorType.parameterNotFound, key);
        }
        if (Util.isEmpty(value)) {
            throw new InternalErrorException(InternalErrorException.ErrorType.parameterNotFound, key);
        }
        return value;
    }

    @Override
    public String getStringValue(String key) throws InternalErrorException {
        String value = this.getValue(key);
        return value;
    }

    @Override
    public int getIntValue(String key) throws InternalErrorException {
        String value = this.getValue(key);
        return Converter.stringToInt(value);
    }

    @Override
    public double getDoubleValue(String key) throws InternalErrorException {
        String value = this.getValue(key);
        return Converter.stringToDouble(value);
    }

    @Override
    public boolean getBooleanValue(String key) throws InternalErrorException {
        String value = this.getValue(key);
        return Converter.stringToBoolean(value);
    }

    public synchronized void initialize() throws DatabaseException {
        List<IBusinessObject> list;
        this.initialized = false;
        HashMap<String, String> store = new HashMap<String, String>();
        Parameter filter = new Parameter();
        IBusinessObjectVerwaltung<IBusinessObject> bean = ServerConnection.getInstance().getObjectVerwaltung();
        if (bean != null && (list = bean.select(filter)) != null) {
            for (IBusinessObject object : list) {
                Parameter parameter = (Parameter)object;
                store.put(parameter.getName(), parameter.getValue());
            }
        }
        this.store = store;
        this.initialized = true;
    }

    private synchronized void select(String key) throws DatabaseException {
        Parameter filter = new Parameter();
        filter.setName(key);
        IBusinessObjectVerwaltung<IBusinessObject> bean = ServerConnection.getInstance().getObjectVerwaltung();
        List<IBusinessObject> list = bean.select(filter);
        if (list != null) {
            for (IBusinessObject object : list) {
                Parameter parameter = (Parameter)object;
                this.store.put(parameter.getName(), parameter.getValue());
            }
        }
    }

    public Set<String> getKeySet() {
        return this.store.keySet();
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

