/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Util;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static Locale currentLocale = Locale.GERMAN;
    private static ResourceBundle bundle = ResourceBundle.getBundle("i18n.messages", currentLocale);
    private static final Locale DEFAULT_LOCALE = Locale.GERMAN;

    public static void init(Locale locale) {
        currentLocale = locale != null ? locale : DEFAULT_LOCALE;
        Messages.loadBundle();
    }

    public static void setLocale(Locale newLocale) {
        if (newLocale != null && !newLocale.equals(currentLocale)) {
            currentLocale = newLocale;
            Messages.loadBundle();
        }
    }

    public static void setLocale(String sprache) {
        currentLocale = Util.equals(sprache, "Deutsch") ? Locale.GERMAN : (Util.equals(sprache, "English") ? Locale.ENGLISH : (Util.equals(sprache, "Fran\u00e7ais") ? Locale.FRENCH : (Util.equals(sprache, "Espa\u00f1ol") ? new Locale("es") : Locale.GERMAN)));
        Messages.loadBundle();
    }

    public static Locale getLocale() {
        return currentLocale;
    }

    public static String get(String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            System.err.println("Kein Eintrag gefunden f\u00fcr Schl\u00fcssel: " + key);
            return key;
        }
    }

    public static String get(String key, Object ... params) {
        String template = Messages.get(key);
        return MessageFormat.format(template, params);
    }

    public static boolean exists(String key) {
        return bundle.containsKey(key);
    }

    private static void loadBundle() {
        try {
            bundle = ResourceBundle.getBundle("i18n.messages", currentLocale);
        }
        catch (MissingResourceException e) {
            System.err.println("Kein ResourceBundle f\u00fcr Locale: " + currentLocale + ", fallback auf Standard.");
            currentLocale = DEFAULT_LOCALE;
            bundle = ResourceBundle.getBundle("i18n.messages", DEFAULT_LOCALE);
        }
    }
}

