/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.Domain;
import de.cni.common.core.DomainItems;
import de.cni.common.core.IMappings;
import de.cni.common.core.MappingsFromDB;
import de.cni.common.core.MappingsFromMemory;
import de.cni.common.core.MappingsGenerated;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.DropdownText;
import de.cni.common.exceptions.DatabaseException;
import de.cni.common.exceptions.MappingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mappings
implements IMappings {
    private static Log log = LogFactory.getLog(Mappings.class);
    static Mappings instance = new Mappings();
    static Rule DEFAULT_RULE = Rule.LANGTEXT;
    private boolean initialized = false;
    HashMap<Domain, DomainItems> domains = new HashMap();

    private DomainItems getDomainItems(Domain domain) throws MappingException {
        DomainItems di = this.domains.get((Object)domain);
        if (di == null) {
            throw new MappingException(domain.toString());
        }
        return di;
    }

    @Override
    public int getDomainIdFromKurztext(Domain domain, String text) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        if (Util.isEmpty(text) && di.nullable) {
            return 0;
        }
        for (int i = 0; i < di.kurztext.length; ++i) {
            if (!di.kurztext[i].equals(text)) continue;
            return di.id[i];
        }
        throw new MappingException(domain.toString(), text);
    }

    public int getDomainIdFromLangtext(Domain domain, String text) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        if (Util.isEmpty(text) && di.nullable) {
            return 0;
        }
        if (di == null) {
            throw new MappingException(domain.toString());
        }
        for (int i = 0; i < di.langtext.length; ++i) {
            if (!di.langtext[i].equals(text)) continue;
            return di.id[i];
        }
        throw new MappingException(domain.toString(), text);
    }

    @Override
    public String getDomainKurztext(Domain domain, int id) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        if (id == 0 && di.nullable) {
            return "";
        }
        if (di == null) {
            throw new MappingException(domain.toString());
        }
        for (int i = 0; i < di.id.length; ++i) {
            if (di.id[i] != id) continue;
            return di.kurztext[i];
        }
        throw new MappingException(domain.toString(), id);
    }

    public String getDomainLangtext(Domain domain, int id, int limit) throws MappingException {
        String value = this.getDomainLangtext(domain, id);
        if (limit > 0) {
            return Util.string2MaxLengthString(value, limit);
        }
        return value;
    }

    public String getDomainLangtext(Domain domain, int id) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        if (id == 0 && di.nullable) {
            return "";
        }
        if (di == null) {
            throw new MappingException(domain.toString());
        }
        for (int i = 0; i < di.id.length; ++i) {
            if (di.id[i] != id) continue;
            return di.langtext[i];
        }
        throw new MappingException(domain.toString(), id);
    }

    public int[] getDomainIdArray(Domain domain) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        return di.id;
    }

    public String[] getDomainKurztextArray(Domain domain) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        return di.kurztext;
    }

    public String[] getDomainLangtextArray(Domain domain) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        return di.langtext;
    }

    public String[] getDomainLangtextArray(Domain domain, int maxLength) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        return Util.array2MaxLengthArray(di.langtext, maxLength);
    }

    public int getDomainIdFromText(Domain domain, Rule rule, String text) throws MappingException {
        if (rule == Rule.KURZTEXT) {
            return this.getDomainIdFromKurztext(domain, text);
        }
        return this.getDomainIdFromLangtext(domain, text);
    }

    public int getDomainIdFromText(Domain domain, String text) throws MappingException {
        if (DEFAULT_RULE == Rule.KURZTEXT) {
            return this.getDomainIdFromKurztext(domain, text);
        }
        return this.getDomainIdFromLangtext(domain, text);
    }

    public String[] getDomainTextArray(Domain domain, Rule rule) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        return rule == Rule.KURZTEXT ? di.kurztext : di.langtext;
    }

    public String[] getDomainTextArray(Domain domain) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        return DEFAULT_RULE == Rule.KURZTEXT ? di.kurztext : di.langtext;
    }

    public String getDomainText(Domain domain, Rule rule, int id) throws MappingException {
        if (rule == Rule.KURZTEXT) {
            return this.getDomainKurztext(domain, id);
        }
        return this.getDomainLangtext(domain, id);
    }

    @Override
    public String getDomainText(Domain domain, int id) throws MappingException {
        if (DEFAULT_RULE == Rule.KURZTEXT) {
            return this.getDomainKurztext(domain, id);
        }
        return this.getDomainLangtext(domain, id);
    }

    @Override
    public String getForceText(Domain domain, int id) {
        try {
            return this.getDomainText(domain, id);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return "";
        }
    }

    @Override
    public String getForceKurztext(Domain domain, int id) {
        try {
            return this.getDomainKurztext(domain, id);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            return "";
        }
    }

    public int getDomainDefaultId(Domain domain) throws MappingException {
        DomainItems di = this.getDomainItems(domain);
        return di.defaultValue;
    }

    public int getDomainIdFromIndex(Domain domain, int index) throws MappingException {
        try {
            return this.getDomainIdArray(domain)[index];
        }
        catch (Exception e) {
            throw new MappingException(domain.toString(), MappingException.ErrorType.illegalIndex, index);
        }
    }

    public int getDomainIndexFromId(Domain domain, int id) throws MappingException {
        DomainItems domainItems = this.getDomainItems(domain);
        int index = 0;
        for (index = 0; index < domainItems.id.length; ++index) {
            if (domainItems.id[index] != id) continue;
            return index;
        }
        throw new MappingException(domain.toString(), id);
    }

    public static Mappings getInstance() {
        return instance;
    }

    public String[] getDomainsAsStringArray(Brand brand) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        for (Domain domain : Domain.values()) {
            if (brand != null && domain.getBrand() != Brand.ALL && brand != domain.getBrand()) continue;
            list.add(domain.name());
        }
        String[] stringArray = new String[list.size()];
        return list.toArray(stringArray);
    }

    public void initialize() throws DatabaseException {
        Properties props = ApplicationProperties.getInstance().getProperties();
        Source ms = Source.MEMORY;
        String source = props.getProperty("application.mappings.source");
        if (source != null && source.equals("DB")) {
            ms = Source.DB;
        } else if (source != null && source.equals("GENERATED")) {
            ms = Source.GENERATED;
        }
        this.initialize(ms);
    }

    public void initialize(Source ms) throws DatabaseException {
        this.domains.clear();
        switch (ms) {
            case GENERATED: {
                MappingsGenerated.fillDomainMap(this.domains);
                break;
            }
            case MEMORY: {
                MappingsFromMemory.fillDomainMap(this.domains);
                break;
            }
            case DB: {
                MappingsFromDB.fillDomainMap(this.domains);
            }
        }
        this.initialized = true;
    }

    public void replaceDomainItem(DropdownText dropdownText) throws MappingException {
        if (dropdownText == null || dropdownText.getDomain() == null) {
            return;
        }
        Domain currentDomain = null;
        boolean found = false;
        for (Domain domain : Domain.values()) {
            if (!dropdownText.getDomain().equals(domain.name())) continue;
            currentDomain = domain;
            found = true;
            break;
        }
        if (!found) {
            throw new MappingException(dropdownText.getDomain());
        }
        DomainItems di = this.getDomainItems(currentDomain);
        int index = 0;
        found = false;
        for (int i = 0; i < di.id.length; ++i) {
            if (di.id[i] != dropdownText.getDomainkey()) continue;
            index = i;
            found = true;
            break;
        }
        if (!found) {
            int lengthNew = di.id.length + 1;
            int[] newId = new int[lengthNew];
            String[] newKurztext = new String[lengthNew];
            String[] newLangtext = new String[lengthNew];
            System.arraycopy(di.id, 0, newId, 0, di.id.length);
            System.arraycopy(di.kurztext, 0, newKurztext, 0, di.kurztext.length);
            System.arraycopy(di.langtext, 0, newLangtext, 0, di.langtext.length);
            di.id = newId;
            di.kurztext = newKurztext;
            di.langtext = newLangtext;
            di.id[lengthNew - 1] = dropdownText.getDomainkey();
            di.kurztext[lengthNew - 1] = dropdownText.getKurztext();
            di.langtext[lengthNew - 1] = dropdownText.getLangtext();
        } else {
            di.id[index] = dropdownText.getDomainkey();
            di.kurztext[index] = dropdownText.getKurztext();
            di.langtext[index] = dropdownText.getLangtext();
        }
        if (dropdownText.isDefaultValue()) {
            di.defaultValue = dropdownText.getDomainkey();
        } else if (di.defaultValue == dropdownText.getDomainkey()) {
            di.defaultValue = 0;
        }
    }

    public static String getReportText(IMappings mappings, Domain domain, Integer i) {
        try {
            if (mappings == null) {
                return domain.toString();
            }
            if (i == null) {
                return "";
            }
            return mappings.getDomainText(domain, i);
        }
        catch (Exception e) {
            return "---";
        }
    }

    public static String getReportKurztext(IMappings mappings, Domain domain, Integer i) {
        try {
            if (mappings == null) {
                return domain.toString();
            }
            if (i == null) {
                return "";
            }
            return mappings.getDomainKurztext(domain, i);
        }
        catch (Exception e) {
            return "---";
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static enum Rule {
        KURZTEXT,
        LANGTEXT;

    }

    public static enum Source {
        GENERATED,
        MEMORY,
        DB;

    }
}

