/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import de.cni.common.core.Util;
import de.cni.common.exceptions.TechnicalException;
import java.lang.reflect.Method;
import java.util.Date;

public class Introspection {
    public static String substitute(Object tokenObject, String text) {
        Method[] methodArray = tokenObject.getClass().getDeclaredMethods();
        Object[] params = null;
        String value = null;
        int intValue = 0;
        for (Method m : methodArray) {
            try {
                Object ret;
                value = "";
                intValue = 0;
                String token = null;
                Class<?> retType = m.getReturnType();
                if (m.getName().startsWith("get")) {
                    token = m.getName().substring(3).toUpperCase();
                    ret = m.invoke(tokenObject, params);
                    if (ret instanceof Integer) {
                        value = Formatter.reportNumber((Integer)ret);
                        intValue = (Integer)ret;
                    } else if (ret instanceof Double) {
                        value = Formatter.reportNumber((Double)ret);
                    } else if (ret instanceof String) {
                        value = (String)ret;
                    } else if (ret instanceof Date) {
                        value = Converter.dateToString((Date)ret);
                    }
                } else if (m.getName().startsWith("is")) {
                    ret = m.invoke(tokenObject, params);
                    token = m.getName().substring(2).toUpperCase();
                    if (ret instanceof Boolean) {
                        value = Converter.booleanToGuiString((Boolean)ret);
                    }
                }
                if (Util.isEmpty(token)) continue;
                text = text.replaceAll("%%" + token + "%%", value);
                text = text.replaceAll("%%@" + token + "@%%", Integer.toString(intValue));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    public static Object getValue(Object object, String varName, int maxLength) throws TechnicalException {
        Method[] methodArray = object.getClass().getDeclaredMethods();
        Object[] params = null;
        try {
            for (Method m : methodArray) {
                String token;
                if (m.getName().startsWith("get")) {
                    token = m.getName().substring(3).toUpperCase();
                    if (maxLength > 0) {
                        token = Util.cutString(token, maxLength);
                    }
                    if (token.equalsIgnoreCase(varName)) {
                        return m.invoke(object, params);
                    }
                }
                if (!m.getName().startsWith("is")) continue;
                token = m.getName().substring(2).toUpperCase();
                if (maxLength > 0) {
                    token = Util.cutString(token, maxLength);
                }
                if (!token.equalsIgnoreCase(varName)) continue;
                return m.invoke(object, params);
            }
            return null;
        }
        catch (Exception e) {
            throw new TechnicalException("Das Objekt '" + object.getClass() + "' enth\u00e4lt keine Variable mit dem Namen '" + varName + "'");
        }
    }

    public static String getStringValue(Object object, String varName, int maxLength, boolean formatted) throws TechnicalException {
        Object result = Introspection.getValue(object, varName, maxLength);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        if (result instanceof Date) {
            return Converter.dateToString((Date)result);
        }
        if (result instanceof Integer && !formatted) {
            return Converter.intToString((Integer)result);
        }
        if (result instanceof Integer && formatted) {
            return Formatter.reportNumber((Integer)result);
        }
        if (result instanceof Long && !formatted) {
            return Converter.longToString((Long)result);
        }
        if (result instanceof Long && !formatted) {
            return Formatter.reportNumber((Long)result);
        }
        if (result instanceof Double) {
            return Formatter.reportNumber((Double)result);
        }
        if (result instanceof Boolean) {
            return Converter.booleanToString((Boolean)result);
        }
        return null;
    }

    public static String getMsWordStringValue(Object object, String varName, boolean formatted) throws TechnicalException {
        int MAX_WORD_FIELDNAME_LENGTH = 20;
        String result = Introspection.getStringValue(object, varName, MAX_WORD_FIELDNAME_LENGTH, formatted);
        if (result != null) {
            result = result.replace("\r\n", "\r");
            result = result.replace("\n", "\r");
        }
        return result;
    }
}

