/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.YearMonth;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DateUtil {
    public static Date minDate = DateUtil.stringToDate("10000101");
    public static Date maxDate = DateUtil.stringToDate("99991231");

    public static boolean dateBetween(Date date1, int days, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date minLimit = cal.getTime();
        cal.add(5, days);
        Date maxLimit = cal.getTime();
        cal.setTime(date2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date compDate = cal.getTime();
        return compDate.compareTo(minLimit) >= 0 && compDate.compareTo(maxLimit) <= 0;
    }

    public static boolean dateBetweenYears(Date date1, int years, Date date2) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date minLimit = cal.getTime();
        cal.add(1, years);
        Date maxLimit = cal.getTime();
        cal.setTime(date2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date compDate = cal.getTime();
        return compDate.compareTo(minLimit) >= 0 && compDate.compareTo(maxLimit) <= 0;
    }

    public static boolean dateBetween(Date date1, Date min, Date max) {
        if (date1 == null) {
            return false;
        }
        return DateUtil.compareDateWithoutTime(date1, min) >= 0 && DateUtil.compareDateWithoutTime(date1, max) <= 0;
    }

    public static Date getDateWithoutTime(Date date1) {
        if (date1 == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public static Date getRoundedTime(Date date1) {
        if (date1 == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date1);
        cal = DateUtils.round((Calendar)cal, (int)12);
        Date date = cal.getTime();
        return date;
    }

    public static Date getNormedDateWithoutTime(Date date1) {
        if (date1 == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(date1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    public static int compareDateWithoutTime(Date d1, Date d2) {
        Date c1 = DateUtil.getDateWithoutTime(d1);
        Date c2 = DateUtil.getDateWithoutTime(d2);
        return Util.compare(c1, c2);
    }

    public static long getDiffInDays(Date begin, Date end) {
        Date d1 = DateUtil.getNormedDateWithoutTime(begin);
        Date d2 = DateUtil.getNormedDateWithoutTime(end);
        long diff = d2.getTime() - d1.getTime();
        return diff / 86400000L + 1L;
    }

    public static Date newDate(int day, int month, int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, day);
        cal.set(2, month - 1);
        cal.set(1, year);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = cal.getTime();
        return date;
    }

    public static long getDiffInDays(int day1, int month1, int year1, int day2, int month2, int year2) {
        Date d1 = DateUtil.newDate(day1, month1, year1);
        Date d2 = DateUtil.newDate(day2, month2, year2);
        return DateUtil.getDiffInDays(d1, d2);
    }

    public static long getDiffInMillis(Date begin, Date end) {
        long diff = end.getTime() - begin.getTime();
        return diff;
    }

    public static boolean dateIsInFuture(Date date1) {
        if (date1 == null) {
            return false;
        }
        Date date = DateUtil.getDateWithoutTime(date1);
        Date today = DateUtil.getDateWithoutTime(new Date());
        return today.compareTo(date) < 0;
    }

    public static boolean dateIsInPast(Date date1) {
        if (date1 == null) {
            return false;
        }
        Date date = DateUtil.getDateWithoutTime(date1);
        Date today = DateUtil.getDateWithoutTime(new Date());
        return today.compareTo(date) > 0;
    }

    public static Date dateAddDays(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, days);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateWithTimeAddDays(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateAddHours(Date date, int hours) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, hours);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateAddMinutes(Date date, int minutes) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, minutes);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateAddSec(Date date, int secs) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, secs);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateAddMilliseconds(Date date, long milliseconds) {
        long currentTimeInMillis = date.getTime();
        long newTimeInMillis = currentTimeInMillis + milliseconds;
        return new Date(newTimeInMillis);
    }

    public static Date getMiddleDate(Date min, Date max) {
        long diffInMillis = DateUtil.getDiffInMillis(min, max);
        return DateUtil.dateAddSec(min, (int)diffInMillis / 1000 / 2);
    }

    public static Date dateSetDay(Date date, int day, int month) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, day);
        cal.set(2, month - 1);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date getDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date getDate(String year, String month, String day) {
        return DateUtil.getDate(Converter.stringToInt(year), Converter.stringToInt(month), Converter.stringToInt(day));
    }

    public static Date dateSetYear(Date date, int year) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(1, year);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateReplaceYear(Date date, int year) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(1, year);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateAddMonths(Date date, int months) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, months);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateAddYears(Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(1, years);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date dateWithTimeAddYears(Date date, int years) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, years);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static int getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getCurrentMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2) + 1;
    }

    public static int getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        return cal.get(5);
    }

    public static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getYear(String sdate) {
        Date date = Converter.stringToDate(sdate);
        return DateUtil.getYear(date);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static Date getCurrentDateWithoutMilli() {
        Date date = new Date();
        long newDate = date.getTime() / 1000L;
        date.setTime(newDate * 1000L);
        return date;
    }

    public static Date getFirstDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        cal.set(2, 0);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date getFirstDayOfYear(int year) {
        return Converter.stringToDate(year + "0101");
    }

    public static Date getLastDayOfYear(int year) {
        return Converter.stringToDate(year + "1231");
    }

    public static Date getLastDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 31);
        cal.set(2, 11);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date getFirstDayOfNextYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(5, 1);
        cal.set(2, 0);
        cal.add(1, 1);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date getToday() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date getFirstDayOfNextHalfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        cal.set(5, 1);
        if (month < 6) {
            cal.set(2, 6);
        } else {
            cal.set(2, 0);
            cal.add(1, 1);
        }
        return cal.getTime();
    }

    public static Date getFirstDayOfNextQuater(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        cal.set(5, 1);
        if (month < 3) {
            cal.set(2, 3);
        } else if (month < 6) {
            cal.set(2, 6);
        } else if (month < 9) {
            cal.set(2, 9);
        } else {
            cal.set(2, 0);
            cal.add(1, 1);
        }
        return cal.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getFirstDayOfNextMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        cal.add(2, 1);
        return cal.getTime();
    }

    public static String getTimeDiff(long t1, long t2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        long elapsed = t2 - t1;
        return dateFormat.format(new Date(elapsed));
    }

    public static Date max(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (d1.getTime() > d2.getTime()) {
            return d1;
        }
        return d2;
    }

    public static Date min(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (d1.getTime() < d2.getTime()) {
            return d1;
        }
        return d2;
    }

    public static int getDiffInDays360(Date begin, Date end) {
        Calendar cbegin = null;
        Calendar cend = null;
        if (begin == null || end == null) {
            return 0;
        }
        cbegin = Converter.dateToCalendar(begin);
        int dayBegin = Math.min(30, cbegin.get(5));
        int monthBegin = cbegin.get(2);
        int yearBegin = cbegin.get(1);
        cend = Converter.dateToCalendar(end);
        int dayEnd = Math.min(30, cend.get(5));
        int monthEnd = cend.get(2);
        int yearEnd = cend.get(1);
        if (monthEnd == 1 && dayEnd >= 28) {
            dayEnd = 30;
        }
        int days = (yearEnd - yearBegin) * 360 + (monthEnd - monthBegin) * 30 + (dayEnd - dayBegin) + 1;
        return days;
    }

    public static double getRatioYear360(Date begin, Date end) {
        double result = 0.0;
        int days = DateUtil.getDiffInDays360(begin, end);
        result = (double)days / 360.0;
        return result;
    }

    public static double getRatioYear365(Date begin, Date end) {
        double result = 0.0;
        long diff = DateUtil.getDiffInDays(begin, end);
        result = (double)diff / 365.0;
        return result;
    }

    public static double getRatioYear366(Date begin, Date end) {
        double result = 0.0;
        int yearBegin = DateUtil.getYear(begin);
        int yearEnd = DateUtil.getYear(end);
        for (int i = yearBegin; i <= yearEnd; ++i) {
            Date minDate = DateUtil.max(begin, DateUtil.getFirstDayOfYear(i));
            Date maxDate = DateUtil.min(end, DateUtil.getLastDayOfYear(i));
            double divisor = 365.0;
            if (DateUtil.isLeapYear(i)) {
                divisor = 366.0;
            }
            long diff = DateUtil.getDiffInDays(minDate, maxDate);
            result += (double)diff / divisor;
        }
        return result;
    }

    public static Date stringToDate(String x) {
        return Converter.stringToDate(x);
    }

    public static boolean equalsDateWithoutYear(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        int day1 = cal1.get(5);
        int month1 = cal1.get(2);
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date2);
        int day2 = cal1.get(5);
        int month2 = cal1.get(2);
        return day1 == day2 || month1 == month2;
    }

    public static Date setTime(Date date, Date time) {
        if (date == null) {
            return null;
        }
        Calendar calTime = Calendar.getInstance();
        calTime.setTime(time);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, calTime.get(11));
        cal.set(12, calTime.get(12));
        cal.set(13, calTime.get(13));
        cal.set(14, 0);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date getTime(Date date, Date time) {
        if (date == null) {
            return null;
        }
        Calendar calTime = Calendar.getInstance();
        calTime.setTime(time);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, calTime.get(11));
        cal.set(12, calTime.get(12));
        cal.set(13, calTime.get(13));
        cal.set(14, 0);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static Date setTime(Date date, String time) {
        return DateUtil.setTime(date, time, null);
    }

    public static Date setTime(Date date, String time, String timezoneString) {
        if (time == null || Util.isEmpty(time)) {
            return date;
        }
        if (date == null) {
            return null;
        }
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        if (time.length() > 1) {
            hours = Converter.stringToInt(time.substring(0, 2));
        }
        if (time.length() > 4) {
            minutes = Converter.stringToInt(time.substring(3, 5));
        }
        if (time.length() > 7) {
            seconds = Converter.stringToInt(time.substring(6, 8));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (!Util.isEmpty(timezoneString)) {
            cal.setTimeZone(TimeZone.getTimeZone(timezoneString));
        }
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, 0);
        Date newDate = cal.getTime();
        return newDate;
    }

    public static boolean isLeapYear(int year) {
        GregorianCalendar cal = new GregorianCalendar();
        return cal.isLeapYear(year);
    }

    public static int getNextLeapYear(int year) {
        ++year;
        while (!DateUtil.isLeapYear(year)) {
            ++year;
        }
        return year;
    }

    public static String getMonthAsString(int m) {
        String monat = "";
        switch (m) {
            case 1: {
                monat = "Januar";
                break;
            }
            case 2: {
                monat = "Februar";
                break;
            }
            case 3: {
                monat = "M\u00e4rz";
                break;
            }
            case 4: {
                monat = "April";
                break;
            }
            case 5: {
                monat = "Mai";
                break;
            }
            case 6: {
                monat = "Juni";
                break;
            }
            case 7: {
                monat = "Juli";
                break;
            }
            case 8: {
                monat = "August";
                break;
            }
            case 9: {
                monat = "September";
                break;
            }
            case 10: {
                monat = "Oktober";
                break;
            }
            case 11: {
                monat = "November";
                break;
            }
            case 12: {
                monat = "Dezember";
            }
        }
        return monat;
    }

    public static String fixDate(String s) {
        if ((s = s.trim()).matches("[0-9]{1,2}\\.[0-9]{1,2}\\.[0-9]{1,4}")) {
            String[] a = s.split("\\.");
            String fixed = Converter.stringToLeading0String(a[0], 2) + "." + Converter.stringToLeading0String(a[1], 2) + "." + Converter.stringToLeading0String(a[2], 4);
            return fixed;
        }
        return s;
    }

    public static String fixTime(String s) {
        if ((s = s.trim()).matches("[0-9]{1,2}:{1}[0-9]{1,2}")) {
            String[] a = s.split(":");
            String fixed = Converter.stringToLeading0String(a[0], 2) + ":" + Converter.stringToLeading0String(a[1], 2);
            return fixed;
        }
        return s;
    }

    public static String getPrintableTimeString(Date d, int gmtOffsetInMinutes) {
        return Converter.datetimeToGmtString(d, gmtOffsetInMinutes);
    }

    public static Date getCetDate(String datum, String uhrzeit) {
        DateTime date = DateUtil.localString2jodaDateTime(datum, uhrzeit, "CET");
        Date dt = date.toDate();
        return dt;
    }

    public static Date getUtcDate(String datum, String uhrzeit) {
        DateTime date = DateUtil.localString2jodaDateTime(datum, uhrzeit, "UTC");
        Date dt = date.toDate();
        return dt;
    }

    public static int getRoundedDiffInYears(Date dMin, Date dMax) {
        long dayDiff = DateUtil.getDiffInDays(dMin, dMax);
        int jahre = (int)Math.round((double)dayDiff / 365.0);
        return jahre;
    }

    public static int getRoundedDiffInMonth(Date dMin, Date dMax) {
        long dayDiff = DateUtil.getDiffInDays(dMin, dMax);
        int month = (int)Math.round((double)dayDiff / 30.0);
        return month;
    }

    public static String checkDateString(String value, String name) {
        String error = null;
        if (Util.isEmpty(value)) {
            return name + " ist nicht gef\u00fcllt";
        }
        Date date = Converter.stringToDate(value);
        if (date == null || !Util.equals(Converter.dateToString(date), value)) {
            return name + "' " + value + "' ist kein g\u00fcltiges Datum  (TT.MM.JJJJ)";
        }
        return error;
    }

    public static String checkGeburtsdatum(String value) {
        Date date = Converter.stringToDate(value);
        if (date == null || DateUtil.getYear(date) < 650 || DateUtil.getYear(date) > 3000) {
            return "Das Geburtsjahr muss zwischen 650 A.D. und 2999 A.D. liegen";
        }
        return null;
    }

    public static String checkTimeString(String value, String name) {
        String error = null;
        if (Util.isEmpty(value)) {
            return name + " ist nicht gef\u00fcllt";
        }
        if (!value.matches("[0-9]{1,2}[:]{1}[0-9]{2}")) {
            return name + " '" + value + "' ist nicht richtig formatiert (HH:MM)";
        }
        String[] a = value.split(":");
        int h = Converter.stringToInt(a[0]);
        if (h < 0 || h > 23) {
            return name + ": Die Stunden m\u00fcssen zwischen 0 und 23 liegen.";
        }
        int m = Converter.stringToInt(a[1]);
        if (m < 0 || m > 59) {
            return name + ": Die Minuten m\u00fcssen zwischen 0 und 59 liegen.";
        }
        return error;
    }

    public static int getNextMonth(int monat) {
        if (++monat > 12) {
            monat = 1;
        }
        return monat;
    }

    public static int getDaysPerMonat(int year, int month) throws DateTimeException {
        YearMonth yearMonthObject = YearMonth.of(year, month);
        int daysInMonth = yearMonthObject.lengthOfMonth();
        return daysInMonth;
    }

    public static DateTime localString2jodaDateTime(String localDate, String localTime) {
        return DateUtil.localString2jodaDateTime(localDate, localTime, null);
    }

    public static DateTime localString2jodaDateTime(String localDate, String localTime, String timezoneId) {
        Date tmpDate = Converter.stringToDate(DateUtil.fixDate(localDate));
        tmpDate = DateUtil.setTime(tmpDate, DateUtil.fixTime(localTime), "UTC");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(tmpDate);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        DateTime dt = null;
        dt = !Util.isEmpty(timezoneId) ? new DateTime(year, month, day, hours, minutes, DateTimeZone.forID((String)timezoneId)) : new DateTime(year, month, day, hours, minutes, DateTimeZone.UTC);
        return dt;
    }

    public static Date jodaDate2UtcDate(DateTime dt) {
        return dt.toDate();
    }

    public static DateTime date2JodaDate(Date d, String timezoneId) {
        return new DateTime((Object)d, DateTimeZone.forID((String)timezoneId));
    }

    public static DateTime getJodaDateTime(int year, int month, int day, int hour, int minute, int second, String timezoneId) {
        DateTime dt = new DateTime(year, month, day, hour, minute, second, DateTimeZone.forID((String)timezoneId));
        return dt;
    }

    public static double getTimeZoneOffsetInHours(DateTime d, String timezoneId) {
        DateTimeZone tz = DateTimeZone.forID((String)timezoneId);
        Long instant = d.getMillis();
        long offsetInMilliseconds = tz.getOffset(instant.longValue());
        long minutes = TimeUnit.MILLISECONDS.toMinutes(offsetInMilliseconds);
        return Util.round((double)minutes / 60.0, -10);
    }

    public static String jodaDateTime2LocalHHmmTimeString(DateTime dt) {
        return dt.toString("dd.MM.yyyy HH:mm");
    }

    public static String jodaDateTime2LocalTimeString(DateTime dt) {
        return dt.toString("dd.MM.yyyy HH:mm:ss");
    }

    public static String joda2UtcHHmmTimeString(DateTime dt) {
        DateTime t = new DateTime((Object)dt, DateTimeZone.UTC);
        return t.toString("HH:mm");
    }

    public static String joda2UtcDateString(DateTime dt) {
        DateTime t = new DateTime((Object)dt, DateTimeZone.UTC);
        return t.toString("dd.MM.yyyy");
    }

    public static String jodaDateTime2UtcHHmmString(DateTime dt) {
        DateTime t = new DateTime((Object)dt, DateTimeZone.UTC);
        return t.toString("dd.MM.yyyy HH:mm");
    }

    public static String jodaDateTime2UtcString(DateTime dt) {
        DateTime t = new DateTime((Object)dt, DateTimeZone.UTC);
        return t.toString("dd.MM.yyyy HH:mm:ss");
    }

    public static double getExactDiffInYears(Date d1, Date d2) {
        long differenceInMillis = DateUtil.getDiffInMillis(d1, d2);
        double years = (double)differenceInMillis / 3.1556952E10;
        return years;
    }

    public static Date addExactDays(Date d1, double days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d1);
        long millisecondsToAdd = (long)(days * 1000.0 * 60.0 * 60.0 * 24.0);
        calendar.setTimeInMillis(calendar.getTimeInMillis() + millisecondsToAdd);
        return calendar.getTime();
    }
}

