/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.core;

import de.cni.common.core.Brand;
import de.cni.common.core.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationProperties {
    private static Log log = LogFactory.getLog(ApplicationProperties.class);
    private static ApplicationProperties instance = new ApplicationProperties();
    private Properties properties = new Properties();
    private boolean initialized = false;

    private ApplicationProperties() {
        try {
            this.initialize();
        }
        catch (IOException e) {
            this.initialized = false;
            log.error((Object)("Application Properties konnten nicht initialisiert werden. " + e.getMessage()));
            String currentdir = System.getProperty("user.dir");
            log.debug((Object)("Aktuelles Verzeichnis:" + currentdir));
        }
    }

    public synchronized void initialize() throws IOException {
        if (this.initialized) {
            return;
        }
        File file = new File("application.properties");
        if (!file.exists()) {
            throw new IOException("Die Properties Datei 'application.properties' existiert nicht.");
        }
        if (!file.canRead()) {
            throw new IOException("Die Properties Datei 'application.properties' kann nicht gelesen werden.");
        }
        this.properties.load(new FileInputStream("application.properties"));
        this.initialized = true;
        log.debug((Object)"Application Properties erfolgreich geladen: application.properties");
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public Boolean getBooleanProperty(String key) {
        try {
            return this.properties.getProperty(key).equalsIgnoreCase("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    public double getDoubleProperty(String key) {
        try {
            String p = this.properties.getProperty(key);
            return Double.parseDouble(p);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public int getIntProperty(String key) {
        try {
            String p = this.properties.getProperty(key);
            return Integer.parseInt(p);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean hasBrand(Brand[] brandArray) {
        if (brandArray == null || brandArray.length == 0) {
            return true;
        }
        String currentBrand = this.properties.getProperty("application.brand");
        for (int i = 0; i < brandArray.length; ++i) {
            if (!brandArray[i].toString().equals(currentBrand)) continue;
            return true;
        }
        return false;
    }

    public boolean hasBrand(String brand) {
        if (brand == null) {
            return true;
        }
        String currentBrand = this.properties.getProperty("application.brand");
        return Util.equalsIgnoreCase(brand, currentBrand);
    }

    public Brand getBrand() {
        String p = this.properties.getProperty("application.brand");
        if (Util.equalsIgnoreCase(p, "RANDOLF")) {
            return Brand.RANDOLF;
        }
        if (Util.equalsIgnoreCase(p, "COSMICCOMPASS")) {
            return Brand.COSMICCOMPASS;
        }
        if (Util.equalsIgnoreCase(p, "CARSTEN")) {
            return Brand.OPEN;
        }
        if (Util.equalsIgnoreCase(p, "OPEN")) {
            return Brand.OPEN;
        }
        return Brand.NONE;
    }

    public static ApplicationProperties getInstance() {
        return instance;
    }
}

