/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.Util;
import java.util.Date;

public class TransitHausRange
implements Comparable<TransitHausRange> {
    int planetnr;
    int haus;
    int lfdnr;
    Date transitVon;
    Date transitBis;

    public boolean equals(Object object) {
        if (!(object instanceof TransitHausRange)) {
            return false;
        }
        TransitHausRange obj = (TransitHausRange)object;
        return this.planetnr == obj.planetnr && this.haus == obj.haus && Util.equals(this.transitVon, obj.getTransitVon());
    }

    @Override
    public int compareTo(TransitHausRange object) {
        if (this == object) {
            return 0;
        }
        TransitHausRange obj = object;
        int ret = Util.compare(this.transitVon, obj.getTransitVon());
        if (ret == 0) {
            ret = Util.compare(this.planetnr, obj.planetnr);
        }
        if (ret == 0) {
            ret = Util.compare(this.haus, obj.haus);
        }
        return ret;
    }

    public String toString() {
        String s = Constants.planeten[this.planetnr] + " in Haus " + this.haus + ", " + Converter.timeToString(this.transitVon) + " - " + Converter.timeToString(this.transitBis);
        return s;
    }

    public String toString(String timezoneString) {
        String s = Constants.planeten[this.planetnr] + " in Haus " + this.haus + ", " + Converter.datetimeToString(this.transitVon, timezoneString) + " - " + Converter.datetimeToString(this.transitBis, timezoneString);
        return s;
    }

    public int getPlanetnr() {
        return this.planetnr;
    }

    public int getHaus() {
        return this.haus;
    }

    public Date getTransitVon() {
        return this.transitVon;
    }

    public Date getTransitBis() {
        return this.transitBis;
    }

    public void setPlanetnr(int planetnr) {
        this.planetnr = planetnr;
    }

    public void setHaus(int haus) {
        this.haus = haus;
    }

    public void setTransitVon(Date transitVon) {
        this.transitVon = transitVon;
    }

    public void setTransitBis(Date transitBis) {
        this.transitBis = transitBis;
    }

    public int getLfdnr() {
        return this.lfdnr;
    }

    public void setLfdnr(int lfdnr) {
        this.lfdnr = lfdnr;
    }
}

