/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.util.ErrorHandler;
import de.cni.client.paint.Controlpanel;
import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.HousesPaintInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.AnalyseElement;
import de.cni.common.calculation.AnalyseElementList;
import de.cni.common.calculation.AnalyseFilter;
import de.cni.common.calculation.AnalyseUrsacheElement;
import de.cni.common.calculation.Aspektarium;
import de.cni.common.calculation.AspektariumCalculator;
import de.cni.common.calculation.AstroHelper;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.Grundstruktur;
import de.cni.common.calculation.Herrscher;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.Tupel;
import de.cni.common.calculation.VierElemente;
import de.cni.common.core.Constants;
import de.cni.common.core.Converter;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.SqLiteDatabase;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.IBusinessObject;
import de.cni.common.datamodel.admin.Analyse;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextanalyseCalculator {
    private static Log log = LogFactory.getLog(TextanalyseCalculator.class);
    Horoskop horoskop = null;
    AstroHelper ah1;
    AstroHelper ah2;
    Astrodaten astrodaten;
    Aspektarium aspektarium;
    List<IBusinessObject> analyseList;
    VierElemente vierElemente = new VierElemente();
    FormattedStringBuffer herrscherText = null;
    Set<String> foundSet = new HashSet<String>();
    Controlpanel controlpanel;
    AnalyseFilter filter;
    boolean core = true;

    public TextanalyseCalculator(Controlpanel controlpanel, Astrodaten astrodaten) {
        this(controlpanel, astrodaten, null);
        try {
            this.analyseList = this.selectAnalyse(controlpanel.getStufe1(), this.horoskop);
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public TextanalyseCalculator(Controlpanel controlpanel, Astrodaten astrodaten, List<IBusinessObject> analyseList) {
        try {
            this.controlpanel = controlpanel;
            this.astrodaten = astrodaten;
            this.horoskop = controlpanel.getHoroskopCalculator() != null ? controlpanel.getHoroskopCalculator().getHoroskop() : Horoskop.Radix;
            this.ah1 = new AstroHelper(astrodaten);
            this.core = !controlpanel.isEigeneAnalysetexte();
            AspektariumCalculator aspektariumCalculator = new AspektariumCalculator(this.horoskop, controlpanel);
            this.aspektarium = aspektariumCalculator.berechneAspekte(astrodaten);
            if (analyseList == null) {
                analyseList = this.selectAnalyse(controlpanel.getStufe1(), this.horoskop);
            }
            this.analyseList = analyseList;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    public TextanalyseCalculator(Controlpanel controlpanel, Astrodaten astrodaten1, Astrodaten astrodaten2, List<IBusinessObject> analyseList) {
        try {
            this.controlpanel = controlpanel;
            this.astrodaten = astrodaten1;
            this.horoskop = controlpanel.getHoroskopCalculator().getHoroskop();
            this.ah1 = new AstroHelper(astrodaten1);
            this.ah2 = new AstroHelper(astrodaten2);
            this.core = !controlpanel.isEigeneAnalysetexte();
            AspektariumCalculator aspektariumCalculator = new AspektariumCalculator(this.horoskop, controlpanel);
            this.aspektarium = aspektariumCalculator.berechneInterAspekte(astrodaten1, astrodaten2, astrodaten2.getOffset());
            if (analyseList == null) {
                analyseList = this.selectAnalyse(controlpanel.getStufe1(), this.horoskop);
            }
            this.analyseList = analyseList;
        }
        catch (Exception e) {
            ErrorHandler.handleError(log, e);
        }
    }

    private List<IBusinessObject> selectAnalyse(int stufe, Horoskop horoskop) throws Exception {
        SqLiteDatabase db = new SqLiteDatabase();
        Analyse filter = Analyse.newInstance(this.core);
        filter.setStufe1(stufe);
        filter.setHoroskop(horoskop.getName());
        List<IBusinessObject> list = db.select(filter);
        return list;
    }

    public boolean doesAnalyseListMatch() {
        int n = 0;
        int lastProcessedLineNumber = 0;
        int lastFoundLineNumber = 0;
        for (IBusinessObject obj : this.analyseList) {
            Analyse analyse = (Analyse)obj;
            lastProcessedLineNumber = analyse.getLineNumber();
            if (this.filter != null && !this.filter.matches((Analyse)obj)) continue;
            this.doesAnalyseRecordMatch(analyse, 3);
            log.debug((Object)("Untersuche Zeile " + ++n + " :" + analyse.toString()));
            if (!analyse.hasFound()) continue;
            if (analyse.getLineNumber() - 1 == lastFoundLineNumber || analyse.getLineNumber() == lastFoundLineNumber) {
                lastFoundLineNumber = analyse.getLineNumber();
                continue;
            }
            return false;
        }
        return lastProcessedLineNumber == lastFoundLineNumber;
    }

    private boolean doesAnalyseRecordMatch(Analyse obj, int dreiGradRegelOffset) {
        Analyse analyse = obj;
        analyse.reset();
        if (this.filter != null && !this.filter.matches(obj)) {
            return false;
        }
        if (analyse.isRelevantAspekt()) {
            analyse.setFoundAspekt(this.hasAspekt(analyse));
        }
        if (this.horoskop.getPlanetenSaetze() == 1) {
            if (analyse.isRelevantTkz()) {
                analyse.setFoundTkz(this.hasTkz(analyse));
            }
            if (analyse.isRelevantDoubleTkz()) {
                analyse.setFoundDoubleTkz(this.hasDoubleTkz(analyse));
            }
            if (analyse.isRelevantHaus()) {
                analyse.setFoundHaus(this.hasHaus(analyse));
            }
            if (analyse.isRelevantHaus()) {
                analyse.setFound3GradHaus(this.has3GradHaus(analyse, dreiGradRegelOffset));
            }
            if (analyse.isRelevantTkzHaus()) {
                analyse.setFoundTkzHaus(this.hasTkzHaus(analyse));
            }
        } else if (Util.isEmpty(analyse.getPlanet1()) && !Util.isEmpty(analyse.getPlanet2())) {
            if (analyse.isRelevantP2Haus()) {
                analyse.setFoundP2Haus(this.hasP2Haus(analyse));
            }
            if (analyse.isRelevantP2Haus()) {
                analyse.setFound3GradP2Haus(this.has3GradP2Haus(analyse, dreiGradRegelOffset));
            }
        }
        return analyse.hasFound();
    }

    public AnalyseElement getAnalyseRecordMatchText(Analyse analyse, int dreiGradRegelOffset) {
        AnalyseElement element = new AnalyseElement();
        element.setWithHeader(true);
        element.setAnalyse(analyse);
        element.setText1(analyse.getText1());
        element.setText2(analyse.getText2());
        if (analyse.isRelevantAspekt()) {
            element.addUrsache(AnalyseUrsacheElement.Ursache.Aspekt, analyse);
        }
        if (analyse.isRelevantHaus()) {
            if (analyse.isFoundHaus() && analyse.isFound3GradHaus()) {
                element.addUrsache(AnalyseUrsacheElement.Ursache.Haus0und3Grad, analyse);
            } else if (analyse.isFoundHaus() && !analyse.isFound3GradHaus()) {
                element.addUrsache(AnalyseUrsacheElement.Ursache.Haus0Grad, analyse);
            } else if (analyse.isFound3GradHaus()) {
                element.addUrsache(AnalyseUrsacheElement.Ursache.Haus3Grad, analyse);
            }
        }
        if (analyse.isRelevantP2Haus()) {
            if (analyse.isFoundP2Haus() && analyse.isFound3GradP2Haus()) {
                element.setWithHeader(false);
                element.addUrsache(AnalyseUrsacheElement.Ursache.P2Haus0und3Grad, analyse);
            } else if (analyse.isFoundP2Haus() && !analyse.isFound3GradP2Haus()) {
                element.setWithHeader(false);
                element.addUrsache(AnalyseUrsacheElement.Ursache.P2Haus0Grad, analyse);
            } else if (analyse.isFound3GradP2Haus()) {
                element.setWithHeader(false);
                element.addUrsache(AnalyseUrsacheElement.Ursache.P2Haus3Grad, analyse);
            }
        }
        if (analyse.isRelevantTkz()) {
            element.addUrsache(AnalyseUrsacheElement.Ursache.Tkz, analyse);
        }
        if (analyse.isRelevantDoubleTkz()) {
            element.addUrsache(AnalyseUrsacheElement.Ursache.DoubleTkz, analyse);
        }
        if (analyse.isRelevantTkzHaus()) {
            element.addUrsache(AnalyseUrsacheElement.Ursache.TkzHaus, analyse);
        }
        return element;
    }

    public AnalyseElementList calculateKonstellation(int dreiGradRegelOffset) {
        AnalyseElementList analyseElementList = new AnalyseElementList();
        int n = 0;
        String lastHeader = "";
        boolean withHeader = true;
        for (IBusinessObject obj : this.analyseList) {
            Analyse analyse = (Analyse)obj;
            if (this.filter != null && !this.filter.matches((Analyse)obj)) continue;
            ++n;
            if (analyse.getId() == 67054) {
                System.out.println("break");
            }
            this.doesAnalyseRecordMatch(analyse, dreiGradRegelOffset);
            log.debug((Object)("Untersuche Zeile " + n + " :" + analyse.toString()));
            if (!analyse.hasFound()) continue;
            AnalyseElement element = this.getAnalyseRecordMatchText(analyse, dreiGradRegelOffset);
            String newHeader = element.getHeader();
            withHeader = element.withHeader && !Util.equals(lastHeader, newHeader);
            element.setWithHeader(withHeader);
            analyseElementList.addElement(element);
            lastHeader = newHeader;
        }
        return analyseElementList;
    }

    private String getAnalysePlanetName(Integer id) {
        if (id >= Constants.planeten.length) {
            return "";
        }
        return Constants.planeten[id];
    }

    private boolean hasAspekt(Analyse analyse) {
        int id1 = this.ah1.getPlanetId(analyse.getPlanet1());
        int id2 = this.ah1.getPlanetId(analyse.getPlanet2());
        if (!Util.equals(analyse.getHoroskop(), Horoskop.Transit.getName())) {
            if (this.filter != null && !Util.isEmpty(this.filter.getPlanet1()) && !Util.equals(this.filter.getPlanet1(), analyse.getPlanet1())) {
                id2 = this.ah1.getPlanetId(analyse.getPlanet1());
                id1 = this.ah1.getPlanetId(analyse.getPlanet2());
            }
            if (this.filter != null && !Util.isEmpty(this.filter.getPlanet2()) && !Util.equals(this.filter.getPlanet2(), analyse.getPlanet2())) {
                id2 = this.ah1.getPlanetId(analyse.getPlanet1());
                id1 = this.ah1.getPlanetId(analyse.getPlanet2());
            }
        }
        int aspektId = this.aspektarium.getAspekt(id1, id2).ordinal();
        String aspektName = analyse.getAspekt();
        return Util.equals(aspektName, Constants.aspekt[aspektId]);
    }

    private boolean hasHaus(Analyse analyse) {
        if (Util.isEmpty(analyse.getHaus())) {
            return false;
        }
        int myHouseId = Converter.stringToInt(analyse.getHaus());
        double gradPlanet = this.ah1.getGradPlanet(analyse.getPlanet1());
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(myHouseId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(myHouseId));
        return Trigo.isBetween(gradPlanet, von, bis);
    }

    private boolean has3GradHaus(Analyse analyse, int offset) {
        if (Util.isEmpty(analyse.getHaus())) {
            return false;
        }
        int myHouseId = Converter.stringToInt(analyse.getHaus());
        double gradPlanet = this.ah1.getGradPlanet(analyse.getPlanet1());
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(myHouseId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(myHouseId));
        return Trigo.isBetween(Trigo.grad(gradPlanet + (double)offset), von, bis);
    }

    private boolean hasP2Haus(Analyse analyse) {
        if (Util.isEmpty(analyse.getHaus())) {
            return false;
        }
        int myHouseId = Converter.stringToInt(analyse.getHaus());
        double gradPlanet = this.ah2.getGradPlanet(analyse.getPlanet2());
        gradPlanet = Trigo.grad(gradPlanet + this.ah2.astrodaten.getOffset());
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(myHouseId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(myHouseId));
        return Trigo.isBetween(gradPlanet, von, bis);
    }

    private boolean has3GradP2Haus(Analyse analyse, int offset) {
        if (Util.isEmpty(analyse.getHaus())) {
            return false;
        }
        int myHouseId = Converter.stringToInt(analyse.getHaus());
        double gradPlanet = this.ah2.getGradPlanet(analyse.getPlanet2());
        gradPlanet = Trigo.grad(gradPlanet + this.ah2.astrodaten.getOffset());
        double von = Trigo.grad(this.astrodaten.getHausVonGrad(myHouseId));
        double bis = Trigo.grad(this.astrodaten.getHausBisGrad(myHouseId));
        return Trigo.isBetween(Trigo.grad(gradPlanet + (double)offset), von, bis);
    }

    private boolean hasTkzHaus(Analyse analyse) {
        if (!analyse.isRelevantTkzHaus()) {
            return false;
        }
        double[] d = this.ah1.getGradHaus(analyse.getHaus());
        double vonHaus = d[0];
        double bisHaus = d[1];
        d = this.ah1.getGradTkz(analyse.getTkz1());
        double vonTkz = d[0];
        double bisTkz = d[1];
        return Trigo.isBetween(vonTkz, vonHaus, bisHaus) || Trigo.isBetween(bisTkz, vonHaus, bisHaus) || Trigo.isBetween(vonHaus, vonTkz, bisTkz) || Trigo.isBetween(bisHaus, bisTkz, bisTkz);
    }

    private boolean hasTkz(Analyse analyse) {
        if (!analyse.isRelevantTkz()) {
            return false;
        }
        return this.ah1.hasTkz(analyse.getPlanet1(), analyse.getTkz1());
    }

    private boolean hasDoubleTkz(Analyse analyse) {
        if (!analyse.isRelevantDoubleTkz()) {
            return false;
        }
        return this.ah1.hasTkz(analyse.getPlanet1(), analyse.getTkz1()) && this.ah1.hasTkz(analyse.getPlanet2(), analyse.getTkz2());
    }

    public Astrodaten getAstrodaten() {
        return this.astrodaten;
    }

    public List<IBusinessObject> getAnalyseList() {
        return this.analyseList;
    }

    public VierElemente getVierElemente() {
        return this.vierElemente;
    }

    public void herrscherIterationPlanetClassic(String planetName, int n, int max, int dreiGradRegelOffset) throws IOException {
        this.herrscherText.blank(n * 5);
        if (this.foundSet.contains(planetName)) {
            return;
        }
        this.foundSet.add(planetName);
        String haus = this.ah1.getHausByPlanet(planetName, dreiGradRegelOffset);
        String tkz = this.ah1.getTkzByHaus((String)haus).get((int)0).name;
        String herrscher = Herrscher.getHerrscherPlanet(tkz);
        if (n >= 0) {
            this.herrscherText.print(" --> ");
        }
        this.herrscherText.print("Planet " + planetName);
        this.herrscherText.print(", Haus " + haus);
        this.herrscherText.print(", Tierkreiszeichen " + tkz);
        this.herrscherText.print(", Herrscher = " + herrscher);
        this.herrscherText.newLine();
        if (n < max) {
            this.herrscherIterationPlanetClassic(herrscher, n + 1, max, dreiGradRegelOffset);
        }
    }

    public void herrscherIterationPlanetNachRandolf(String planetName, int n, int max, int dreiGradRegelOffset) throws IOException {
        this.herrscherText.blank(n * 5);
        if (this.foundSet.contains(planetName)) {
            return;
        }
        this.foundSet.add(planetName);
        String tkz = this.ah1.getTkzByPlanet(planetName);
        String herrscher = Herrscher.getHerrscherPlanet(tkz);
        String hausDesHerrschers = this.ah1.getHausByPlanet(herrscher, dreiGradRegelOffset);
        if (n >= 0) {
            this.herrscherText.print(" --> ");
        }
        this.herrscherText.print("Planet " + planetName);
        this.herrscherText.print(", Tierkreiszeichen " + tkz);
        this.herrscherText.print(", Herrscher = " + herrscher);
        this.herrscherText.print(" (Haus " + hausDesHerrschers + ")");
        this.herrscherText.newLine();
        if (n < max) {
            this.herrscherIterationPlanetNachRandolf(herrscher, n + 1, max, dreiGradRegelOffset);
        }
    }

    public void herrscherIterationHaus(String hausId, int n, int max, int dreiGradRegelOffset) throws IOException {
        String tkz = this.ah1.getTkzByHaus((String)hausId).get((int)0).name;
        String herrscherPlanet = Herrscher.getHerrscherPlanet(tkz);
        String neuesHaus = this.ah1.getHausByPlanet(herrscherPlanet, dreiGradRegelOffset);
        this.herrscherText.blank(n * 5);
        if (n > 0) {
            this.herrscherText.print(" --> ");
        }
        this.herrscherText.print("Haus " + hausId);
        this.herrscherText.print(", Tierkreiszeichen " + tkz);
        this.herrscherText.print(", Herrscher = " + herrscherPlanet);
        this.herrscherText.newLine();
        if (this.foundSet.contains(hausId)) {
            return;
        }
        this.foundSet.add(hausId);
        if (n < max) {
            this.herrscherIterationHaus(neuesHaus, n + 1, max, dreiGradRegelOffset);
        }
    }

    public void calculateVierElemente() {
        for (int planetId = 0; planetId < Constants.planeten.length; ++planetId) {
            String tkz = this.ah1.getTkzByPlanet(Constants.planeten[planetId]);
            if (planetId == AspektariumCalculator.ID_DC || planetId == AspektariumCalculator.ID_IC) continue;
            this.vierElemente.add(planetId, tkz);
        }
    }

    public Grundstruktur getGrundstruktur(int dreiGradRegelOffset) {
        Grundstruktur grundstruktur = new Grundstruktur(dreiGradRegelOffset);
        grundstruktur.setTkzZuAc(this.ah1.getTkzByPlanet(this.aspektarium.getPlanet((int)AspektariumCalculator.ID_AC).name));
        grundstruktur.setTkzZuMc(this.ah1.getTkzByPlanet(this.aspektarium.getPlanet((int)AspektariumCalculator.ID_MC).name));
        String herrscherVonHaus1 = Herrscher.getHerrscherPlanet(this.ah1.getTkzByHaus((int)1).get((int)0).name);
        String herrscherVonHaus10 = Herrscher.getHerrscherPlanet(this.ah1.getTkzByHaus((int)10).get((int)0).name);
        String hausVonherrscherVonHaus1 = this.ah1.getHausByPlanet(herrscherVonHaus1, dreiGradRegelOffset);
        String hausVonherrscherVonHaus10 = this.ah1.getHausByPlanet(herrscherVonHaus10, dreiGradRegelOffset);
        grundstruktur.setHerrscherVonHaus1(herrscherVonHaus1);
        grundstruktur.setHerrscherVonHaus10(herrscherVonHaus10);
        grundstruktur.setHausVonHerrscherVonHaus1(hausVonherrscherVonHaus1);
        grundstruktur.setHausVonHerrscherVonHaus10(hausVonherrscherVonHaus10);
        grundstruktur.setTkzZuHerrscherVonHaus1(this.ah1.getTkzByPlanet(herrscherVonHaus1));
        grundstruktur.setTkzZuHerrscherVonHaus10(this.ah1.getTkzByPlanet(herrscherVonHaus10));
        grundstruktur.setPlanetenInHaus1(this.ah1.getEchtePlanetenByHaus("1", dreiGradRegelOffset));
        grundstruktur.setPlanetenInHaus10(this.ah1.getEchtePlanetenByHaus("10", dreiGradRegelOffset));
        grundstruktur.setSonneInHaus(this.ah1.getHausByPlanet(this.aspektarium.getPlanet((int)0).name, dreiGradRegelOffset));
        grundstruktur.setSonneInTkz(this.ah1.getTkzByPlanet(this.aspektarium.getPlanet((int)0).name));
        return grundstruktur;
    }

    public HousesPaintInfo getHousesPaintInfo() {
        HousesInfo hi = this.astrodaten.housesInfo;
        hi = this.astrodaten.housesInfo;
        HousesPaintInfo hpi = new HousesPaintInfo();
        for (int i = 0; i < HousesPaintInfo.anz; ++i) {
            String tkz;
            hpi.gradVonAbs[i] = hi.getHouseVonGrad(i);
            hpi.gradBisAbs[i] = hi.getHouseBisAbs(i);
            List<Tupel> t = this.ah1.getTkzByHaus(i);
            hpi.tkz[i] = tkz = t.get((int)0).name;
            hpi.icon[i] = Tkz.icon[Tkz.getPosition(tkz)];
            double von = hi.getHouse(i);
            hpi.gradVon[i] = Trigo.grad(von) % 30.0;
            hpi.gradBis[i] = 0.0;
        }
        return hpi;
    }

    public AnalyseFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AnalyseFilter filter) {
        this.filter = filter;
    }

    public void setCore(boolean core) {
        this.core = core;
    }
}

