/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.OrbisCache;
import de.cni.common.core.Util;

public class OrbisPresettings {
    public static OrbisCache getGeneratedDefaultOrben() {
        return OrbisPresettings.getGeneratedDefaultOrben(null);
    }

    public static OrbisCache getGeneratedDefaultOrben(Horoskop h) {
        OrbisCache o = new OrbisCache();
        OrbisPresettings.setOrben(o, h);
        return o;
    }

    public static OrbisCache getGeneratedDefaultInterOrben() {
        return OrbisPresettings.getGeneratedDefaultInterOrben(null);
    }

    public static OrbisCache getGeneratedDefaultInterOrben(Horoskop h) {
        OrbisCache o = new OrbisCache();
        OrbisPresettings.setInterOrben(o, h);
        return o;
    }

    public static void setOrben(OrbisCache orbisCache) {
        OrbisPresettings.setOrben(orbisCache, null);
    }

    public static void setOrben(OrbisCache orbisCache, Horoskop h) {
        for (int horoskopId = 0; horoskopId < OrbisCache.anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < OrbisCache.anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < OrbisCache.anzPlaneten; ++planetId) {
                    if (h != null && horoskopId != h.ordinal()) continue;
                    OrbisPresettings.setValue(horoskopId, aspektId, planetId, orbisCache);
                }
            }
        }
    }

    public static String generateTestOrben(OrbisCache orbisCache, Horoskop h, int value) {
        for (int horoskopId = 0; horoskopId < OrbisCache.anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < OrbisCache.anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < OrbisCache.anzPlaneten; ++planetId) {
                    if (h != null && horoskopId != h.ordinal()) continue;
                    orbisCache.setValue(horoskopId, aspektId, planetId, value);
                }
            }
        }
        return orbisCache.object2string();
    }

    public static void setInterOrben(OrbisCache orbisCache) {
        OrbisPresettings.setInterOrben(orbisCache, null);
    }

    public static void setInterOrben(OrbisCache orbisCache, Horoskop h) {
        for (int horoskopId = 0; horoskopId < OrbisCache.anzHoroskope; ++horoskopId) {
            for (int aspektId = 0; aspektId < OrbisCache.anzAspekte; ++aspektId) {
                for (int planetId = 0; planetId < OrbisCache.anzPlaneten; ++planetId) {
                    if (h != null && horoskopId != h.ordinal()) continue;
                    OrbisPresettings.setInterValue(horoskopId, aspektId, planetId, orbisCache);
                }
            }
        }
    }

    private static void setValue(int horoskopId, int aspektId, int planetId, OrbisCache orbisCache) {
        if (Util.equals(horoskopId, new int[]{Horoskop.Radix.ordinal(), Horoskop.Solar.ordinal(), Horoskop.Septar.ordinal(), Horoskop.Komposit.ordinal(), Horoskop.Temposit.ordinal(), Horoskop.Septosit.ordinal(), Horoskop.KompositTransit.ordinal(), Horoskop.KompositSeptar.ordinal(), Horoskop.MultiKomposit.ordinal(), Horoskop.Progression.ordinal(), Horoskop.Direktion.ordinal(), Horoskop.Combine.ordinal()})) {
            if (planetId == 0 || planetId == 1) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 7);
            } else if (planetId == 2 || planetId == 3 || planetId == 4 || planetId == 5) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 5);
            } else if (planetId == 6 || planetId == 7 || planetId == 8 || planetId == 9) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 4);
            } else if (planetId == 13 || planetId == 14 || planetId == 15 || planetId == 16) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 5);
            } else {
                orbisCache.setValue(horoskopId, aspektId, planetId, 0);
            }
        }
        if (Util.equals(horoskopId, new int[]{Horoskop.Synastrie.ordinal(), Horoskop.Transit.ordinal(), Horoskop.Aktualitaet.ordinal(), Horoskop.Progression.ordinal(), Horoskop.Direktion.ordinal(), Horoskop.Combine.ordinal()})) {
            if (planetId == 0 || planetId == 1) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 7);
            } else if (planetId == 2 || planetId == 3 || planetId == 4 || planetId == 5) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 5);
            } else if (planetId == 6 || planetId == 7 || planetId == 8 || planetId == 9) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 4);
            } else if (planetId == 13 || planetId == 14 || planetId == 15 || planetId == 16) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 5);
            } else {
                orbisCache.setValue(horoskopId, aspektId, planetId, 0);
            }
        }
    }

    private static void setInterValue(int horoskopId, int aspektId, int planetId, OrbisCache orbisCache) {
        if (Util.equals(horoskopId, new int[]{Horoskop.Synastrie.ordinal(), Horoskop.Transit.ordinal(), Horoskop.KompositTransit.ordinal(), Horoskop.Progression.ordinal(), Horoskop.Direktion.ordinal(), Horoskop.Combine.ordinal()})) {
            if (planetId == 10 || planetId == 11 || planetId == 12) {
                orbisCache.setValue(horoskopId, aspektId, planetId, 0);
            } else {
                orbisCache.setValue(horoskopId, aspektId, planetId, 5);
            }
        }
    }
}

