/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.paint.Controlpanel;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.astrologie.AspektariumPlanet;
import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.AstrodatenMixer;
import de.cni.common.calculation.BaseCalculator;
import de.cni.common.calculation.Horoskop;
import de.cni.common.calculation.HoroskopCalculator;
import de.cni.common.calculation.OrbisCache;
import de.cni.common.calculation.TransitRange;
import de.cni.common.core.Converter;
import de.cni.common.core.DateUtil;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class KompoTransitCalculator {
    BaseCalculator baseCalculator = new BaseCalculator();
    HoroskopCalculator horoskopCalculator;
    Controlpanel controlpanel;
    Horoskop horoskop;
    AspektariumPlanet[] planetListe;
    private AspektTyp[][] aspektArray;
    OrbisCache myOrbisCache;
    public static final int anzPlaneten = PlanetInfo.REAL_PLANET_MAX;
    public static final int size = anzPlaneten + 4;
    public static int ID_AC = anzPlaneten + 0;
    public static int ID_DC = anzPlaneten + 1;
    public static int ID_MC = anzPlaneten + 2;
    public static int ID_IC = anzPlaneten + 3;
    public int counter = 0;

    public KompoTransitCalculator(HoroskopCalculator horoskopCalculator, Controlpanel controlpanel, AspektariumPlanet[] planetListe, AspektTyp[][] aspektArray) {
        this.horoskopCalculator = horoskopCalculator;
        this.controlpanel = controlpanel;
        this.planetListe = planetListe;
        this.aspektArray = aspektArray;
    }

    public List<TransitRange> calculate(int satz, boolean interAspekte) {
        Date date1 = this.horoskopCalculator.getDate1();
        double ac1 = this.horoskopCalculator.getAstrodaten1().housesInfo.getAc();
        double ac1Abs = this.horoskopCalculator.getAstrodaten1().housesInfo.getAcAbs();
        double lat1 = Converter.stringToDouble(this.horoskopCalculator.getLat1());
        double long1 = Converter.stringToDouble(this.horoskopCalculator.getLong1());
        if (satz == 2 && !interAspekte) {
            date1 = this.horoskopCalculator.getDate2();
            ac1 = this.horoskopCalculator.getAstrodaten2().housesInfo.getAc();
            ac1Abs = this.horoskopCalculator.getAstrodaten2().housesInfo.getAcAbs();
            lat1 = Converter.stringToDouble(this.horoskopCalculator.getLat2());
            long1 = Converter.stringToDouble(this.horoskopCalculator.getLong2());
        }
        Date date2 = null;
        double ac2 = 0.0;
        double ac2Abs = 0.0;
        double lat2 = 0.0;
        double long2 = 0.0;
        if (interAspekte) {
            date2 = this.horoskopCalculator.getDate2();
            ac2 = this.horoskopCalculator.getAstrodaten2().housesInfo.getAc();
            ac2Abs = this.horoskopCalculator.getAstrodaten2().housesInfo.getAcAbs();
            lat2 = Converter.stringToDouble(this.horoskopCalculator.getLat2());
            long2 = Converter.stringToDouble(this.horoskopCalculator.getLong2());
        }
        this.horoskop = this.horoskopCalculator.getHoroskop();
        this.myOrbisCache = !interAspekte ? this.controlpanel.getOrbisCache() : this.controlpanel.getInterOrbisCache();
        ArrayList<TransitRange> transitRangeList = new ArrayList<TransitRange>();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Date maxDate;
                Date minDate;
                double w2;
                double w1;
                if (this.aspektArray[i][j] == null || this.aspektArray[i][j] == AspektTyp.empty || !interAspekte && j >= i || Util.equals(this.planetListe[i].nr, new int[]{13, 15, 16, 14}) && Util.equals(this.planetListe[j].nr, new int[]{13, 15, 16, 14}) || this.aspektArray[i][j] == null || this.aspektArray[i][j] == AspektTyp.empty) continue;
                if (!interAspekte) {
                    w1 = this.getWinkel(date1, ac1, ac1Abs, lat1, long1, i);
                    w2 = this.getWinkel(date1, ac1, ac1Abs, lat1, long1, j);
                } else {
                    w1 = this.getWinkelInterKomposite(null, ac1, this.horoskopCalculator.getPd1(), this.horoskopCalculator.getPd2(), i);
                    w2 = this.getWinkelInterKomposite(date2, ac1, this.horoskopCalculator.getPd1(), this.horoskopCalculator.getPd2(), j);
                }
                double diff = Trigo.alphaDiff(w1, w2);
                this.counter = 0;
                int step = 20160;
                if (!interAspekte) {
                    if (i >= 13 || j >= 13) {
                        step = 5;
                    }
                    minDate = this.findLimitDate(this.aspektArray[i][j], i, j, date1, -step, ac1, ac1Abs, lat1, long1);
                    maxDate = this.findLimitDate(this.aspektArray[i][j], i, j, date1, step, ac1, ac1Abs, lat1, long1);
                } else {
                    if (j >= 13) {
                        step = 5;
                    }
                    minDate = this.findInterKompositLimitDate(this.aspektArray[i][j], i, j, -step, ac1, date2);
                    maxDate = this.findInterKompositLimitDate(this.aspektArray[i][j], i, j, step, ac1, date2);
                }
                TransitRange transitRange = new TransitRange();
                transitRange.setPlanetnr1(i);
                transitRange.setPlanetnr2(j);
                transitRange.setAspekttyp(this.aspektArray[i][j]);
                transitRange.setTransitVon(minDate);
                transitRange.setTransitBis(maxDate);
                transitRange.setCalculations(this.counter);
                transitRangeList.add(transitRange);
            }
        }
        return transitRangeList;
    }

    private Date findLimitDate(AspektTyp aspektTyp, int i, int j, Date date, int offsetInMinutes, double ac1, double ac1Abs, double lat1, double long1) {
        Date minDate = date;
        while (offsetInMinutes < -1 || offsetInMinutes > 1) {
            Date maxDate = this.findRangeLimit(this.aspektArray[i][j], i, j, offsetInMinutes, minDate, ac1, ac1Abs, lat1, long1);
            minDate = DateUtil.dateAddMinutes(maxDate, -offsetInMinutes);
            offsetInMinutes /= 2;
        }
        return minDate;
    }

    private Date findInterKompositLimitDate(AspektTyp aspektTyp, int i, int j, int offsetInMinutes, double ac1, Date minDate) {
        while (offsetInMinutes <= -1 || offsetInMinutes >= 1) {
            Date maxDate = this.findInterKompositeRangeLimit(this.aspektArray[i][j], i, j, offsetInMinutes, ac1, minDate);
            minDate = DateUtil.dateAddMinutes(maxDate, -offsetInMinutes);
            offsetInMinutes /= 2;
        }
        return minDate;
    }

    private Date findRangeLimit(AspektTyp aspektTyp, int i, int j, int offsetInMinutes, Date date, double ac, double acAbs, double lat, double lon) {
        Date newDate = date;
        double alphaDiff = 0.0;
        do {
            newDate = DateUtil.dateAddMinutes(newDate, offsetInMinutes);
            double w1 = this.getWinkel(newDate, ac, acAbs, lat, lon, i);
            double w2 = this.getWinkel(newDate, ac, acAbs, lat, lon, j);
            alphaDiff = Trigo.alphaDiff(w1, w2);
            ++this.counter;
        } while (this.isInRange(i, j, alphaDiff, aspektTyp, this.myOrbisCache));
        return newDate;
    }

    private Date findInterKompositeRangeLimit(AspektTyp aspektTyp, int i, int j, int offsetInMinutes, double acOriginal, Date newDate) {
        double alphaDiff = 0.0;
        double w1 = this.getWinkelInterKomposite(null, acOriginal, this.horoskopCalculator.getPd1(), this.horoskopCalculator.getPd2(), i);
        do {
            newDate = DateUtil.dateAddMinutes(newDate, offsetInMinutes);
            double w2 = this.getWinkelInterKomposite(newDate, acOriginal, this.horoskopCalculator.getPd1(), this.horoskopCalculator.getPd2(), j);
            alphaDiff = Trigo.alphaDiff(w1, w2);
            ++this.counter;
        } while (this.isInRange(i, j, alphaDiff, aspektTyp, this.myOrbisCache));
        return newDate;
    }

    private double getWinkel(Date date, double ac, double acAbs, double lat, double lon, int planetNr) {
        double winkel;
        if (planetNr == 13) {
            winkel = 180.0;
        } else if (planetNr == 15) {
            HousesInfo housesInfo = this.baseCalculator.calculateAllHouses(date, lat, lon, BaseCalculator.HOUSSYSTEM_PLACIDUS_KUERZEL);
            winkel = housesInfo.getMcAbs();
        } else {
            PlanetInfo pi = this.baseCalculator.calculatePlanet(date, this.planetListe[planetNr].nr, ac);
            HousesInfo housesInfo = this.baseCalculator.calculateAllHouses(date, lat, lon, BaseCalculator.HOUSSYSTEM_PLACIDUS_KUERZEL);
            winkel = pi.getWinkelAbs(housesInfo.getAc());
        }
        return winkel;
    }

    private double getWinkelInterKomposite(Date date, double acOriginal, Personendaten pd1, Personendaten pd2, int planetNr) {
        double winkel;
        double offset2Current;
        Date date1 = date != null ? date : pd1.getGeburtsdatum();
        Date date2 = date != null ? date : pd2.getGeburtsdatum();
        AstrodatenMixer astrodatenMixer = new AstrodatenMixer(pd1, pd2, date1, date2);
        Astrodaten ad2 = astrodatenMixer.getMixedAstrodaten();
        HousesInfo housesInfo = ad2.housesInfo;
        if (planetNr == 13) {
            offset2Current = Trigo.grad(360.0 - acOriginal + housesInfo.getAc());
            winkel = 180.0;
        } else if (planetNr == 15) {
            offset2Current = Trigo.grad(360.0 - acOriginal + housesInfo.getAc());
            winkel = housesInfo.getMcAbs();
        } else {
            offset2Current = Trigo.grad(360.0 - acOriginal + housesInfo.getAc());
            PlanetInfo pi = ad2.getPlanetInfo()[planetNr];
            winkel = pi.getWinkelAbs(housesInfo.getAc());
        }
        return Trigo.grad(winkel + offset2Current);
    }

    String getPlanetname(int planetNr) {
        return planetNr == 13 ? " AC" : (planetNr == 16 ? "IC" : this.planetListe[planetNr].name);
    }

    private boolean isInRange(int i, int j, double alphaDiff, AspektTyp aspektTyp, OrbisCache orbisCache) {
        int toleranz2;
        int toleranz1 = orbisCache.getValue(this.horoskop.ordinal(), aspektTyp.ordinal(), i);
        int toleranz = Util.average(toleranz1, toleranz2 = orbisCache.getValue(this.horoskop.ordinal(), aspektTyp.ordinal(), j));
        return this.isInRange(alphaDiff, aspektTyp.winkelbeziehung, toleranz);
    }

    private boolean isInRange(double alphaDiff, double alpha, int toleranz) {
        return alphaDiff <= alpha + (double)toleranz && alphaDiff >= alpha - (double)toleranz;
    }

    public void copyToAspektArray(List<TransitRange> transitRangeList, Date[][] von, Date[][] bis) {
        if (transitRangeList == null || this.aspektArray == null) {
            return;
        }
        for (TransitRange element : transitRangeList) {
            von[element.getPlanetnr1()][element.getPlanetnr2()] = element.getTransitVon();
            bis[element.getPlanetnr1()][element.getPlanetnr2()] = element.getTransitBis();
        }
    }

    public static boolean isCalculationAllowed(Horoskop horoskop) {
        return horoskop.isDayChangeAllowed();
    }
}

