/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.gui.util.Resources;
import de.cni.common.core.LicenseHandler;

public enum Horoskop {
    Radix("Radix", Resources.ICON.RADIX, true, true, 1, false, "Radix basierend auf Datum, Zeit und Ort", LicenseHandler.LicenseType.PROFESSIONAL),
    Solar("Solar", Resources.ICON.SOLAR, false, true, 1, false, "Solar:\nDatum/Uhrzeit in einem anderen Jahr (Vorgabe: aktuelles Jahr),\nan dem die Sonne am Geburtsort den gleichen Stand wie zum Geburtszeitpunkt hat"),
    Septar("Septar", Resources.ICON.SEPTAR, false, true, 1, false, "Ein Septar ist ein Horoskop, das die 7er Rhythmuslehre nutzt. Es hilft, eine Lebensphase zu deuten, wobei jedes Haus 7 Monate entspricht."),
    Komposit("Komposit", Resources.ICON.KOMPOSIT, false, false, 1, false, "Ein Composit ist eine Methode der Partnerschaftsastrologie, bei der aus den Horoskopen zweier Personen ein neues, gemeinsames Horoskop erstellt wird. Es hilft, die Schwerpunktthemen einer Beziehung schnell zu erkennen. (Halbsummentechnik)"),
    Temposit("Temposit", Resources.ICON.TEMPOSIT, false, true, 1, false, "Temposit:\nDarstellung: Mittelwert von Geburts- und aktuellen Daten einer Personen\nParameter1: Geburtsdatum, Geburtsort\nParameter2: Solardatum, Wohnort\n\nSolardatum:  Datum/Uhrzeit in einem anderen Jahr (Vorgabe: aktuelles Jahr),\nan dem die Sonne am Geburtsort den gleichen Stand wie zum Geburtszeitpunkt hat"),
    Septosit("Septosit", Resources.ICON.SEPTOSIT, false, true, 1, false, "Septosit:\nDarstellung: Mittelwert von Geburts- und aktuellen Daten einer Personen\nParameter1: Geburtsdatum, Geburtsort\nParameter2: Septardatum, Geburtsort\nDas Septardatum berechnet sich wie folgt:\n{Differenz} = {aktuelles Jahr} \u0096 {Geburtsjahr}\n{Berechnungsjahr}  = 12 - {Differenz} / 7 (Beginnend bei Haus 12 und dann R\u00fcckw\u00e4rts)\nDas {Berechnungsjahr}  wird zum Geburtsjahr hinzugez\u00e4hlt und daraus das Solardatum errechnet.\nDieser Zeitpunkt ist in der Berechnung das {Septardatum}, f\u00fcr dessen Zeitpunkt das Horoskop berechnet wird.\n"),
    Transit("Transit", Resources.ICON.TRANSIT, true, true, 2, false, "Ein Transit ist der Zeitraum, in dem ein Planet einen Aspekt zu einem anderen Horoskopfaktor bildet und zeigt den aktuellen Stand der Planeten im Kosmos an."),
    Synastrie("Synastrie", Resources.ICON.SYNASTRIE, true, true, 2, true, "Die Gegen\u00fcberstellung von zwei Personen. Bei einer Synastrie werden zwei Horoskope miteinander verglichen, indem die Planeten des einen Horoskops ins andere eingezeichnet werden."),
    Aktualitaet("Aktualit\u00e4t", Resources.ICON.AKTUALITAET, true, true, 1, false, "Der aktuelle Planetenstand in Bezug auf den Ort des Software Inhabers."),
    KompositSeptar("KompositSeptar", Resources.ICON.KOMPOSITSEPTAR, false, false, 1, false, "KompositSeptar:\nDarstellung: Mittelwert von zwei Personen\nParameter Person1: Geburtsdatum, Geburtsort\nParameter Person2: Geburtsdatum, Geburtsort\nParameter: Haus\nWenn kein Haus angegeben wird, erfolgt die Berechung jeweils f\u00fcr den aktuellen Lebensabschnitts, ansonsten werden beide Sepatare f\u00fcr das vorgebenen Haus berechnet."),
    MultiKomposit("MultiKomposit", Resources.ICON.MULTIKOMPOSIT, false, false, 1, false, "MultiKomposit:\nDarstellung: Mittelwert von mehreren Personen\nParameter:  Name der Gruppe"),
    KompositTransit("KompositTransit", Resources.ICON.KOMPOTRANSIT, true, true, 2, true, "KompositTransit:\nDarstellung: Mittelwert von zwei Kompositen\nKomposit1: Geburtsdatum, Geburtsort der Personen\nKomposit2: aktuelles Datum, aktueller Wohnort der Personen", LicenseHandler.LicenseType.PROFESSIONAL),
    Combine("Combine", Resources.ICON.COMBINE, false, false, 1, false, "Ein Combine erstellt aus den Geburtsdaten ein Horoskop. Es hat einen realen kosmischen Bezug, da es f\u00fcr einen bestimmten Zeitpunkt und Ort berechnet wird.", LicenseHandler.LicenseType.BASIC),
    Progression("Progression", Resources.ICON.PROGRESSION, false, false, 1, false, "Die Progression ist eine Methode, bei der ein Tag nach der Geburt einem Lebensjahr entspricht. Sie zeigt die Planetenstellungen zu bestimmten Zeitpunkten im Leben.", LicenseHandler.LicenseType.BASIC),
    Direktion("Direktion", Resources.ICON.DIREKTION, true, true, 2, true, "Die Sonnenbogendirektion ist eine Prognosemethode, bei der alle Planeten und Achsen pro Jahr um die Strecke verschoben werden, die die Sonne pro Tag nach der Geburt zur\u00fccklegte. Dies basiert auf dem wahren oder mittleren Sonnenbogen.", LicenseHandler.LicenseType.BASIC);

    public String name;
    public Resources.ICON icon;
    public boolean dayChangeAllowed;
    public boolean yearChangeAllowed;
    public int planetenSaetze;
    public boolean zweiterAcMc;
    public String toolTip;
    public LicenseHandler.LicenseType minLicenseType;

    private Horoskop(String name, Resources.ICON icon, boolean dayChangeAllowed, boolean yearChangeAllowed, int planetenSaetze, boolean zweiterAcMc, String toolTip) {
        this.name = name;
        this.icon = icon;
        this.dayChangeAllowed = dayChangeAllowed;
        this.yearChangeAllowed = yearChangeAllowed;
        this.planetenSaetze = planetenSaetze;
        this.zweiterAcMc = zweiterAcMc;
        this.toolTip = toolTip;
    }

    private Horoskop(String name, Resources.ICON icon, boolean dayChangeAllowed, boolean yearChangeAllowed, int planetenSaetze, boolean zweiterAcMc, String toolTip, LicenseHandler.LicenseType minLicenseType) {
        this.name = name;
        this.icon = icon;
        this.dayChangeAllowed = dayChangeAllowed;
        this.yearChangeAllowed = yearChangeAllowed;
        this.planetenSaetze = planetenSaetze;
        this.zweiterAcMc = zweiterAcMc;
        this.toolTip = toolTip;
        this.minLicenseType = minLicenseType;
    }

    public static Horoskop fromString(String str) throws IllegalArgumentException {
        try {
            return Horoskop.valueOf(str);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Ung\u00fcltiger Enum-Wert: " + str);
        }
    }

    public static String[] getAllNames() {
        String[] names = new String[Horoskop.values().length];
        int i = 0;
        for (Horoskop h : Horoskop.values()) {
            names[i++] = h.getName();
        }
        return names;
    }

    public String getName() {
        return this.name;
    }

    public Resources.ICON getIcon() {
        return this.icon;
    }

    public boolean isDayChangeAllowed() {
        if (this.minLicenseType == null || LicenseHandler.getInstance().isAllowed(this.minLicenseType)) {
            return this.dayChangeAllowed;
        }
        return false;
    }

    public boolean isYearChangeAllowed() {
        if (this.minLicenseType == null || LicenseHandler.getInstance().isAllowed(this.minLicenseType)) {
            return this.yearChangeAllowed;
        }
        return false;
    }

    public int getPlanetenSaetze() {
        return this.planetenSaetze;
    }

    public boolean isZweiterAcMc() {
        return this.zweiterAcMc;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(Resources.ICON icon) {
        this.icon = icon;
    }

    public void setDayChangeAllowed(boolean dayChangeAllowed) {
        this.dayChangeAllowed = dayChangeAllowed;
    }

    public void setYearChangeAllowed(boolean yearChangeAllowed) {
        this.yearChangeAllowed = yearChangeAllowed;
    }

    public void setPlanetenSaetze(int planetenSaetze) {
        this.planetenSaetze = planetenSaetze;
    }

    public void setZweiterAcMc(boolean zweiterAcMc) {
        this.zweiterAcMc = zweiterAcMc;
    }
}

