/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.calculation.HerrscherResult;
import de.cni.common.core.Converter;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HerrscherResultList {
    ArrayList<HerrscherResult>[] hausArray = new ArrayList[13];

    public HerrscherResultList() {
        this.hausArray[0] = null;
        for (int i = 1; i <= 12; ++i) {
            this.hausArray[i] = new ArrayList();
        }
    }

    public void add(String horoskopName, String hausId, String planet, String tkz, String herrscherPlanet, String herrscherHaus) {
        this.add(horoskopName, Converter.stringToInt(hausId), planet, tkz, herrscherPlanet, herrscherHaus);
    }

    public void add(String horoskopName, int hausId, String planet, String tkz, String herrscherPlanet, String herrscherHaus) {
        HerrscherResult hr = new HerrscherResult(horoskopName, hausId, planet, tkz, herrscherPlanet, herrscherHaus);
        this.add(hr);
    }

    public void add(HerrscherResult hr) {
        this.hausArray[hr.getHausId()].add(hr);
    }

    public String toRandolfString() throws IOException {
        FormattedStringBuffer sb = new FormattedStringBuffer();
        for (int hausId = 1; hausId <= 12; ++hausId) {
            sb.print(this.toRandolfString(hausId));
            sb.newLine();
            sb.repeat("-", 90);
            sb.newLine();
        }
        return sb.toString();
    }

    public String toRandolfString(int hausId) throws IOException {
        FormattedStringBuffer sb = new FormattedStringBuffer();
        int n = 0;
        for (HerrscherResult hr : this.hausArray[hausId]) {
            if (n > 0) {
                sb.blank((n - 1) * 5);
                sb.print(" --> ");
            }
            sb.print(hr.toRandolfString());
            sb.newLine();
            ++n;
        }
        return sb.toString();
    }

    public String toClassicString() throws IOException {
        FormattedStringBuffer sb = new FormattedStringBuffer();
        for (int hausId = 1; hausId <= 12; ++hausId) {
            sb.print(this.toClassicString(hausId));
            sb.newLine();
            sb.repeat("-", 90);
            sb.newLine();
        }
        return sb.toString();
    }

    public String toClassicString(int hausId) throws IOException {
        FormattedStringBuffer sb = new FormattedStringBuffer();
        int n = 0;
        for (HerrscherResult hr : this.hausArray[hausId]) {
            if (n > 0) {
                sb.blank((n - 1) * 5);
                sb.print(" --> ");
            }
            sb.print(hr.toClassicString());
            sb.newLine();
            ++n;
        }
        return sb.toString();
    }

    public List<HerrscherResult> getList(int hausId) {
        if (hausId < 1 || hausId > 12) {
            return null;
        }
        return this.hausArray[hausId];
    }

    public List<HerrscherResult> getList(String haus) {
        if (Util.isInt(haus)) {
            return this.getList(Converter.stringToInt(haus));
        }
        return null;
    }
}

