/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.AstroHelper;
import de.cni.common.calculation.Astrodaten;
import de.cni.common.calculation.BaseCalculator;
import de.cni.common.core.Constants;
import de.cni.common.core.Trigo;
import de.cni.common.core.Util;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.Date;

public class AstrodatenMixer {
    protected BaseCalculator baseCalculator = new BaseCalculator();
    Personendaten pdx;
    Personendaten pd1;
    Personendaten pd2;
    Date date1;
    Date date2;
    public PlanetInfo[] planetInfoX;
    public PlanetInfo sunX;
    public PlanetInfo moonX;
    public HousesInfo housesInfoX;
    public double gluecksfaktorX;
    public int[] bahnX;
    public PlanetInfo[] planetInfo1;
    public PlanetInfo sun1;
    public PlanetInfo moon1;
    public HousesInfo housesInfo1;
    public double gluecksfaktor1;
    public int[] bahn1;
    public PlanetInfo[] planetInfo2;
    public PlanetInfo sun2;
    public PlanetInfo moon2;
    public HousesInfo housesInfo2;
    public double gluecksfaktor2;
    public int[] bahn2;
    private boolean useWohnort = false;

    public Personendaten getMixedPersonendaten() {
        this.pdx = new Personendaten();
        this.pdx.setVirtuell(true);
        this.pdx.setNachname(this.pd1.getVorname() + " " + this.pd1.getNachname() + " /" + this.pd2.getVorname() + " " + this.pd2.getNachname());
        return this.pdx;
    }

    public Astrodaten getMixedAstrodaten() {
        return Astrodaten.newInstance(this);
    }

    public AstrodatenMixer(Personendaten pd1, Personendaten pd2, Date date1, Date date2) {
        this(pd1, pd2, date1, date2, false);
    }

    public AstrodatenMixer(Personendaten pd1, Personendaten pd2, Date date1, Date date2, boolean useWohnort) {
        this.pd1 = pd1;
        this.pd2 = pd2;
        this.date1 = date1;
        this.date2 = date2;
        this.useWohnort = useWohnort;
        this.calculate();
    }

    private void calculate() {
        double latitude1 = Double.parseDouble(this.useWohnort ? this.pd1.getWohnortLatitude() : this.pd1.getLatitude());
        double longitude1 = Double.parseDouble(this.useWohnort ? this.pd1.getWohnortLongitude() : this.pd1.getLongitude());
        this.housesInfo1 = this.baseCalculator.calculateAllHouses(this.date1, latitude1, longitude1, BaseCalculator.HOUSSYSTEM_PLACIDUS_KUERZEL);
        this.planetInfo1 = this.baseCalculator.calculateAllPlanets(this.date1, this.housesInfo1.getAc());
        this.sun1 = this.planetInfo1[0];
        this.moon1 = this.planetInfo1[1];
        this.bahn1 = new int[this.planetInfo1.length];
        double latitude2 = Double.parseDouble(this.useWohnort ? this.pd2.getWohnortLatitude() : this.pd2.getLatitude());
        double longitude2 = Double.parseDouble(this.useWohnort ? this.pd2.getWohnortLongitude() : this.pd2.getLongitude());
        this.housesInfo2 = this.baseCalculator.calculateAllHouses(this.date2, latitude2, longitude2, BaseCalculator.HOUSSYSTEM_PLACIDUS_KUERZEL);
        this.planetInfo2 = this.baseCalculator.calculateAllPlanets(this.date2, this.housesInfo2.getAc());
        this.sun2 = this.planetInfo2[0];
        this.moon2 = this.planetInfo2[1];
        this.bahn2 = new int[this.planetInfo2.length];
        this.calculateAveragePlanetInfo();
        this.calculateAverageHouseInfo();
    }

    private void calculateAveragePlanetInfo() {
        this.planetInfoX = new PlanetInfo[Constants.planeten.length];
        for (int i = 0; i < Constants.planeten.length; ++i) {
            this.planetInfoX[i] = new PlanetInfo(i);
            this.planetInfoX[i].setLatitude(Trigo.averageGrad(this.planetInfo1[i].getLatitude(), this.planetInfo2[i].getLatitude()));
            this.planetInfoX[i].setLongitude(Trigo.averageGrad(this.planetInfo1[i].getLongitude(), this.planetInfo2[i].getLongitude()));
            this.planetInfoX[i].setDistance(Util.average(this.planetInfo1[i].getDistance(), this.planetInfo2[i].getDistance()));
            this.planetInfoX[i].setDistanceSpeed(Util.average(this.planetInfo1[i].getDistanceSpeed(), this.planetInfo2[i].getDistanceSpeed()));
            this.planetInfoX[i].setLatitudeSpeed(Util.average(this.planetInfo1[i].getLatitudeSpeed(), this.planetInfo2[i].getLatitudeSpeed()));
            this.planetInfoX[i].setLongitudeSpeed(Util.average(this.planetInfo1[i].getLongitudeSpeed(), this.planetInfo2[i].getLongitudeSpeed()));
        }
        this.sunX = this.planetInfoX[0];
        this.moonX = this.planetInfoX[1];
        this.bahnX = new int[Constants.planeten.length];
    }

    private void spiegeln(PlanetInfo[] planetInfo, int id) {
        double ySonne = Math.sin(planetInfo[0].getLongitude() * 2.0 * Math.PI / 360.0);
        double xSonne = Math.cos(planetInfo[0].getLongitude() * 2.0 * Math.PI / 360.0);
        double yPlanet = Math.sin(planetInfo[id].getLongitude() * 2.0 * Math.PI / 360.0);
        double xPlanet = Math.cos(planetInfo[id].getLongitude() * 2.0 * Math.PI / 360.0);
        if (Math.signum(ySonne) != Math.signum(yPlanet) || Math.signum(xSonne) != Math.signum(xPlanet) || Math.signum(ySonne) != Math.signum(yPlanet) && Math.signum(xSonne) != Math.signum(xPlanet)) {
            planetInfo[id].setLongitude(Trigo.grad(planetInfo[id].getLongitude() + 180.0));
        }
    }

    private void calculateAverageHouseInfo() {
        int i;
        this.housesInfoX = new HousesInfo();
        this.housesInfoX.setAc(Trigo.averageGrad(this.housesInfo1.getAc(), this.housesInfo2.getAc()));
        this.housesInfoX.setAcAbs(Trigo.averageGrad(this.housesInfo1.getAcAbs(), this.housesInfo2.getAcAbs()));
        this.housesInfoX.setMc(Trigo.averageGrad(this.housesInfo1.getMc(), this.housesInfo2.getMc()));
        this.housesInfoX.setMcAbs(Trigo.averageGrad(this.housesInfo1.getMcAbs(), this.housesInfo2.getMcAbs()));
        double acX = this.housesInfoX.getAc();
        double mcX = this.housesInfoX.getMc();
        this.acDrehen(this.housesInfoX, this.getTkzByPlanet(mcX), this.getTkzByPlanet(acX));
        this.mcDrehen(this.housesInfoX);
        for (i = 0; i < this.housesInfo1.houseVonRel.length; ++i) {
            this.housesInfoX.houseVonRel[i] = Trigo.averageGrad(this.housesInfo1.houseVonRel[i], this.housesInfo2.houseVonRel[i]);
        }
        for (i = 0; i < this.housesInfo1.houseVonAbs.length; ++i) {
            this.housesInfoX.houseVonAbs[i] = Trigo.averageGrad(this.housesInfo1.houseVonAbs[i], this.housesInfo2.houseVonAbs[i]);
        }
        for (i = 0; i < this.housesInfo1.houseBisAbs.length; ++i) {
            this.housesInfoX.houseBisAbs[i] = Trigo.averageGrad(this.housesInfo1.houseBisAbs[i], this.housesInfo2.houseBisAbs[i]);
        }
    }

    private void acDrehen(HousesInfo housesInfo, String tkzMc, String tkzAc) {
        if (!AstrodatenMixer.isTkzValid(tkzMc, tkzAc)) {
            double ac = Trigo.grad(this.housesInfoX.getAc() + 180.0);
            this.housesInfoX.setAc(ac);
        }
    }

    public static boolean isTkzValid(String tkzMc, String tkzAc) {
        int tkcMcPosition = Tkz.getPosition(tkzMc);
        int tkzAcPosition = Tkz.getPosition(tkzAc);
        int max = (tkcMcPosition + 6) % 12;
        int min = (tkcMcPosition + 2) % 12;
        if (max > min) {
            return tkzAcPosition >= min && tkzAcPosition <= max;
        }
        return tkzAcPosition >= min || tkzAcPosition <= max;
    }

    private void mcDrehen(HousesInfo housesInfo) {
        double acX = this.housesInfoX.getAc();
        double mcX = this.housesInfoX.getMc();
        double mcXAbs = this.housesInfoX.getMcAbs();
        String tkzMc = this.getTkzByPlanet(mcX);
        String tkzMcAbs = this.getTkzByPlanet(mcXAbs);
        mcX = this.housesInfoX.getMc();
        acX = this.housesInfoX.getAc();
        double mcAbs = FormatterGradzahlen.transfer(mcX, acX);
        this.housesInfoX.setMcAbs(mcAbs);
    }

    public String getTkzByPlanet(double winkel) {
        for (String tkz : Constants.tkz) {
            if (!this.hasTkz(winkel, tkz)) continue;
            return tkz;
        }
        return null;
    }

    public boolean hasTkz(double winkel, String tkz) {
        int myTkzId = AstroHelper.getTkzId(tkz);
        String kuerzel = Tkz.name[myTkzId];
        double von = Tkz.getGrad(kuerzel);
        double bis = Tkz.getGradNext(kuerzel);
        return Trigo.isBetween(winkel, von, bis);
    }
}

