/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.common.astrologie.FormatterGradzahlen;
import de.cni.common.astrologie.HousesInfo;
import de.cni.common.astrologie.PlanetInfo;
import de.cni.common.astrologie.Tkz;
import de.cni.common.calculation.AstrodatenMixer;
import de.cni.common.calculation.AstrodatenMultiMixer;
import de.cni.common.calculation.BaseCalculator;
import de.cni.common.core.DateUtil;
import de.cni.common.core.FormattedStringBuffer;
import de.cni.common.core.Trigo;
import de.cni.common.datamodel.admin.Personendaten;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Astrodaten {
    private static Log log = LogFactory.getLog(Astrodaten.class);
    public Date date;
    public String longitude;
    public String latitude;
    public PlanetInfo[] planet = new PlanetInfo[PlanetInfo.PLANET_MAX];
    public PlanetInfo sun;
    public PlanetInfo moon;
    public HousesInfo housesInfo;
    public double gluecksfaktor;
    public int[] bahn = new int[PlanetInfo.PLANET_MAX];
    public double offset;
    protected BaseCalculator baseCalculator = new BaseCalculator();

    public PlanetInfo[] getPlanetInfo() {
        return this.planet;
    }

    protected Astrodaten() {
    }

    public Astrodaten(Personendaten pd) {
        this.date = pd.getGeburtsdatum();
        this.longitude = pd.getLongitude();
        this.latitude = pd.getLatitude();
        this.calculate();
    }

    public Astrodaten(Personendaten pd, Date date) {
        this.date = date;
        this.longitude = pd.getLongitude();
        this.latitude = pd.getLatitude();
        this.calculate();
    }

    public Astrodaten(String longitude, String latitude, Date date) {
        this.baseCalculator = new BaseCalculator();
        this.date = date;
        this.longitude = longitude;
        this.latitude = latitude;
        this.calculate();
    }

    private void calculate() {
        if (this.longitude != null && this.latitude != null) {
            this.housesInfo = this.baseCalculator.calculateAllHouses(this.date, Double.parseDouble(this.latitude), Double.parseDouble(this.longitude), BaseCalculator.HOUSSYSTEM_PLACIDUS_KUERZEL);
        }
        this.planet = this.baseCalculator.calculateAllPlanets(this.date, this.housesInfo.getAc());
        this.sun = this.planet[0];
        this.moon = this.planet[1];
        this.bahn = new int[this.planet.length];
    }

    public double getHausVonGrad(int idx) {
        if (idx < 1) {
            idx = 12;
        }
        if (idx > 12) {
            idx = 1;
        }
        return this.housesInfo.getHouseVonGrad(idx);
    }

    public double getHausBisGrad(int idx) {
        if (idx < 1) {
            idx = 12;
        }
        if (idx > 12) {
            idx = 1;
        }
        return this.housesInfo.getHouseBisAbs(idx);
    }

    public double getPlanetAbs(int idx) {
        double asc = this.housesInfo.getAc();
        double winkel = this.planet[idx].getTransferedLongitude(asc);
        return winkel;
    }

    public double getPlanet(int idx) {
        double winkel = this.planet[idx].getLongitude();
        return winkel;
    }

    public boolean isRetrogradeDirection(int idx) {
        double asc = this.housesInfo.getAc();
        boolean retrogradeDirection = this.planet[idx].isRetrogradeDirection(asc);
        return retrogradeDirection;
    }

    public int getBahn(int idx) {
        return this.bahn[idx];
    }

    public int collision(int current) {
        this.bahn[current] = 0;
        double asc = this.housesInfo.getAc();
        int anzCollision = 0;
        double tolleranz = 12.0;
        ArrayList<Integer> besetzteBahnen = new ArrayList<Integer>();
        for (int i = 0; i < current; ++i) {
            double lOther;
            double lCurrent = this.planet[current].getTransferedLongitude(asc);
            if (!(Math.abs(lCurrent - (lOther = this.planet[i].getTransferedLongitude(asc))) < tolleranz)) continue;
            ++anzCollision;
            besetzteBahnen.add(this.bahn[i]);
        }
        if (anzCollision > 0) {
            this.bahn[current] = current;
            for (int b = 0; b < current; ++b) {
                if (besetzteBahnen.contains(b)) continue;
                this.bahn[current] = b;
                break;
            }
        }
        return this.bahn[current];
    }

    public static Astrodaten newInstance(AstrodatenMixer x) {
        Astrodaten a = new Astrodaten();
        a.bahn = x.bahnX;
        a.housesInfo = x.housesInfoX;
        a.planet = x.planetInfoX;
        a.sun = x.sunX;
        a.moon = x.moonX;
        return a;
    }

    public static Astrodaten newInstance(AstrodatenMultiMixer x) {
        Astrodaten a = new Astrodaten();
        a.bahn = x.bahnX;
        a.housesInfo = x.housesInfoX;
        a.planet = x.planetInfoX;
        a.sun = x.sunX;
        a.moon = x.moonX;
        return a;
    }

    public double getMonatsskalaWinkel(Date today) {
        int month = DateUtil.getMonth(today);
        int day = DateUtil.getDay(today);
        log.debug((Object)("Monat=" + month + ", Day=" + day));
        double von = this.getHausVonGrad(13 - month);
        double bis = this.getHausBisGrad(13 - month);
        if (von > bis) {
            bis += 360.0;
        }
        if (day > 30) {
            day = 30;
        }
        double winkel = bis - (bis - von) * (double)(day - 1) / 30.0;
        return winkel;
    }

    public String toString() {
        try {
            int i;
            FormattedStringBuffer sb = new FormattedStringBuffer();
            double ac = this.housesInfo.getAc();
            double mc = this.housesInfo.getMc();
            if (this.getPlanetInfo() != null) {
                for (i = 0; i < PlanetInfo.REAL_PLANET_MAX; ++i) {
                    sb.println(this.getPlanetInfo()[i].toString(true, ac));
                }
            }
            for (i = 1; i < 13; ++i) {
                sb.println(this.housesInfo.toString(i, true, ac));
            }
            sb.println("AC\t" + FormatterGradzahlen.format(ac) + "\t (" + FormatterGradzahlen.formatAbsolute(FormatterGradzahlen.transfer(ac, ac)) + ")");
            sb.println("MC\t" + FormatterGradzahlen.format(mc) + "\t (" + FormatterGradzahlen.formatAbsolute(FormatterGradzahlen.transfer(mc, ac)) + ")");
            return sb.toString();
        }
        catch (Exception e) {
            return "Fehler beim Darstellen der Astro-Daten";
        }
    }

    public double getTkzVonAbs(String tkzName) {
        double offset = -(this.housesInfo.getAc() + 180.0);
        double von = Trigo.grad(offset + (double)Tkz.getGrad(tkzName));
        return von;
    }

    public double getTkzBisAbs(String tkzName) {
        double offset = -(this.housesInfo.getAc() + 180.0);
        double bis = Trigo.grad(offset + (double)Tkz.getGradNext(tkzName));
        return bis;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }
}

