/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.calculation;

import de.cni.client.paint.GrafikSymbole;
import de.cni.common.astrologie.AspektTyp;
import de.cni.common.astrologie.AspektariumPlanet;
import de.cni.common.core.Converter;
import de.cni.common.core.Formatter;
import java.util.Date;

public class Aspektarium {
    int size;
    AspektariumPlanet[] planetListe;
    AspektariumPlanet[] interPlanetListe;
    private AspektTyp[][] aspektArray;
    private Double[][] winkelArray;
    private Double[][] abweichungArray;
    private Date[][] transitVonArray;
    private Date[][] transitBisArray;

    public Aspektarium(int size) {
        this.size = size;
        this.planetListe = new AspektariumPlanet[size];
        this.interPlanetListe = new AspektariumPlanet[size];
        this.aspektArray = new AspektTyp[size][size];
        this.winkelArray = new Double[size][size];
        this.abweichungArray = new Double[size][size];
        this.transitVonArray = new Date[size][size];
        this.transitBisArray = new Date[size][size];
    }

    public String toString() {
        return this.asString(true, false);
    }

    public String asString(boolean interAspekte, boolean withSymbol) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                if (!interAspekte && j >= i || this.planetListe[i].nr == 14 || this.planetListe[i].nr == 16 || this.planetListe[j].nr == 14 || this.planetListe[j].nr == 16 || this.aspektArray[i][j] == null || this.aspektArray[i][j] == AspektTyp.empty) continue;
                if (withSymbol) {
                    sb.append(GrafikSymbole.getPlanet(i));
                    sb.append("\t");
                }
                sb.append(this.planetListe[i].name);
                sb.append("\t");
                sb.append("-");
                sb.append("\t");
                if (withSymbol) {
                    sb.append(GrafikSymbole.getPlanet(j) + " ");
                    sb.append("\t");
                }
                sb.append(this.planetListe[j].name);
                sb.append("\t");
                sb.append("=");
                sb.append("\t");
                if (withSymbol) {
                    sb.append(GrafikSymbole.getAspekt(this.aspektArray[i][j]));
                    sb.append("\t");
                }
                sb.append(this.aspektArray[i][j].langname);
                sb.append("\t");
                sb.append("( " + Formatter.reportNumber(this.winkelArray[i][j]) + " \u00b0)");
                sb.append("\t");
                if (this.transitVonArray != null && this.transitVonArray[i][j] != null && this.transitBisArray != null && this.transitBisArray[i][j] != null) {
                    sb.append(Converter.datetimeToHHmmString(this.transitVonArray[i][j], null));
                    sb.append(" - ");
                    sb.append(Converter.datetimeToHHmmString(this.transitBisArray[i][j], null));
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void setAspekt(int i, int j, AspektTyp obj) {
        this.aspektArray[i][j] = obj;
    }

    public void setWinkel(int i, int j, Double obj) {
        this.winkelArray[i][j] = obj;
    }

    public void setAbweichung(int i, int j, Double obj) {
        this.abweichungArray[i][j] = obj;
    }

    public AspektariumPlanet getPlanet(int i) {
        return this.planetListe[i];
    }

    public AspektariumPlanet getInterPlanet(int i) {
        return this.interPlanetListe[i];
    }

    public AspektTyp getAspekt(int i, int j) {
        return this.aspektArray[i][j];
    }

    public double getWinkel(int i, int j) {
        return this.winkelArray[i][j];
    }

    public double getAbweichung(int i, int j) {
        return this.abweichungArray[i][j];
    }

    public AspektariumPlanet[] getPlanetListe() {
        return this.planetListe;
    }

    public void setPlanetListe(AspektariumPlanet[] planetListe) {
        this.planetListe = planetListe;
    }

    public int getSize() {
        return this.size;
    }

    public AspektTyp[][] getAspektArray() {
        return this.aspektArray;
    }

    public Double[][] getWinkelArray() {
        return this.winkelArray;
    }

    public Double[][] getAbweichungArray() {
        return this.abweichungArray;
    }

    public AspektariumPlanet[] getInterPlanetListe() {
        return this.interPlanetListe;
    }

    public void setInterPlanetListe(AspektariumPlanet[] interPlanetListe) {
        this.interPlanetListe = interPlanetListe;
    }

    public Date[][] getTransitVonArray() {
        return this.transitVonArray;
    }

    public Date[][] getTransitBisArray() {
        return this.transitBisArray;
    }

    public void setTransitVonArray(Date[][] transitVonArray) {
        this.transitVonArray = transitVonArray;
    }

    public void setTransitBisArray(Date[][] transitBisArray) {
        this.transitBisArray = transitBisArray;
    }

    public void setWinkelArray(Double[][] winkelArray) {
        this.winkelArray = winkelArray;
    }

    public void setAbweichungArray(Double[][] abweichungArray) {
        this.abweichungArray = abweichungArray;
    }
}

