/*
 * Decompiled with CFR 0.152.
 */
package de.cni.common.astrologie;

import de.cni.common.astrologie.Tkz;
import de.cni.common.core.Trigo;

public class FormatterGradzahlen {
    public static String format(double degree) {
        return FormatterGradzahlen.format(degree, "p h\u00b0 m' s''");
    }

    public static String formatRelativeToTKz(double degree) {
        return FormatterGradzahlen.format(Trigo.grad(degree) % 30.0, "h\u00b0 m' s''");
    }

    public static String formatAbsolute(double degree) {
        return FormatterGradzahlen.format(Trigo.grad(degree), "h\u00b0 m' s''");
    }

    public static String formatOnlyTkz(double degree) {
        return FormatterGradzahlen.format(Trigo.grad(degree), "p");
    }

    public static String format(double degree, String pattern) {
        StringBuffer sb = new StringBuffer();
        String direct = "";
        String upattern = pattern.toLowerCase();
        if (pattern.indexOf("+") == 0) {
            if (degree < 0.0) {
                degree = 0.0 - degree;
                sb.append("-");
            } else {
                sb.append("+");
            }
            pattern = pattern.substring(1);
        } else if (upattern.indexOf("w") >= 0) {
            if (degree < 0.0) {
                degree = 0.0 - degree;
                direct = "W";
            } else {
                direct = "O";
            }
        } else if (upattern.indexOf("n") >= 0) {
            if (degree < 0.0) {
                degree = 0.0 - degree;
                direct = "S";
            } else {
                direct = "N";
            }
        } else if (upattern.indexOf("p") >= 0) {
            degree = Trigo.grad(degree);
        }
        int d = (int)(degree / 30.0);
        double r = upattern.indexOf("p") == -1 ? degree : degree % 30.0;
        int h = (int)r;
        double dm = (r - (double)h) * 60.0;
        int m = (int)dm;
        double ds = (dm - (double)m) * 60.0;
        int s = (int)ds;
        if (s > 30 && pattern.indexOf("s") == -1 && ++m == 60) {
            m = 0;
            ++h;
        }
        char[] pchars = pattern.toCharArray();
        block8: for (int i = 0; i < pchars.length; ++i) {
            char c = pchars[i];
            switch (c) {
                case 'h': {
                    sb.append(h);
                    continue block8;
                }
                case 'm': {
                    if (m < 10) {
                        sb.append('0');
                    }
                    sb.append(m);
                    continue block8;
                }
                case 's': {
                    if (s < 10) {
                        sb.append('0');
                    }
                    sb.append(s);
                    continue block8;
                }
                case 'p': {
                    sb.append(Tkz.name[d]);
                    continue block8;
                }
                case 'n': 
                case 'w': {
                    sb.append(direct);
                    continue block8;
                }
                case 'N': 
                case 'W': {
                    sb.append("\u5317\u7eac");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static double dmsLongitude2double(String latitudeString) {
        return 0.0;
    }

    public static double dms2double(String coordinateString) {
        String[] components = coordinateString.split("[^\\d\\w\\.]+");
        int degrees = Integer.parseInt(components[0]);
        int minutes = Integer.parseInt(components[1]);
        int seconds = Integer.parseInt(components[2]);
        String direction = components[3];
        double decimalDegrees = (double)degrees + (double)minutes / 60.0 + (double)seconds / 3600.0;
        if ((coordinateString.endsWith("W") || coordinateString.endsWith("O")) && direction.equals("W")) {
            decimalDegrees = -decimalDegrees;
        }
        if ((coordinateString.endsWith("N") || coordinateString.endsWith("S")) && direction.equals("S")) {
            decimalDegrees = -decimalDegrees;
        }
        return decimalDegrees;
    }

    public static double transfer(double winkel, double asc) {
        return Trigo.grad(winkel - asc + 180.0);
    }

    public static double undoTransfer(double winkel, double asc) {
        return Trigo.grad(winkel + asc - 180.0);
    }

    public static double transfer(double winkel, double asc, double offset) {
        return Trigo.grad(winkel - asc + 180.0 + offset);
    }
}

