/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.IWrapper;
import de.cni.client.gui.util.WidgetFactory;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.Converter;
import de.cni.common.core.GlobalData;
import de.cni.common.core.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class TextWrapper
implements IWrapper<Text> {
    private static Log log = LogFactory.getLog(WidgetFactory.class);
    protected String id;
    protected boolean emptyAllowed = true;
    protected Text widget;
    protected int leadingZeros = 0;
    protected String value;
    protected boolean active = true;
    protected Font defaultFont = null;

    public TextWrapper() {
        this.widget = null;
        this.active = false;
    }

    public TextWrapper(Brand[] brands, Composite parent, int style) {
        log.debug((Object)("TextWrapper - T1 Brands:" + (brands == null ? "kein Branding" : brands.toString())));
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            log.debug((Object)"TextWrapper - T2");
            try {
                this.widget = new Text(parent, style);
            }
            catch (Exception e) {
                log.debug((Object)("Fehler beim Erzeugen des Widgets widget=" + (this.widget == null ? "widget ist null" : "widget ist nicht null")));
                e.printStackTrace();
            }
            log.debug((Object)"TextWrapper - T3");
            Font f = GlobalData.getInstance().getDefaultFont();
            log.debug((Object)"TextWrapper - T4");
            log.debug((Object)("TextWrapper - T4 DefaultFont: " + (f == null ? " ist leer" : f.toString())));
            this.widget.setFont(GlobalData.getInstance().getDefaultFont());
            log.debug((Object)"TextWrapper - T5");
        } else {
            log.debug((Object)"TextWrapper - T1x");
            this.widget = null;
            this.active = false;
        }
    }

    public void setValue(String text) {
        this.value = Util.NotNull(text);
        if (this.widget != null) {
            this.widget.setText(this.value);
        }
    }

    public void setValue(int text) {
        if (this.leadingZeros > 0) {
            this.setValue(Converter.intToLeading0String(text, this.leadingZeros));
        } else if (this.emptyAllowed) {
            this.setValue(Converter.intToNotNullString(text));
        } else {
            this.setValue(Converter.intToString(text));
        }
    }

    public void setValue(long text) {
        if (this.leadingZeros > 0) {
            this.setValue(Converter.longToLeading0String(text, this.leadingZeros));
        } else if (this.emptyAllowed) {
            this.setValue(Converter.longToNotNullString(text));
        } else {
            this.setValue(Converter.longToString(text));
        }
    }

    public String getValue() {
        if (this.widget != null) {
            this.value = this.widget.getText();
        }
        return this.value;
    }

    public int getIntValue() {
        return Converter.stringToInt(this.getValue());
    }

    public long getLongValue() {
        return Converter.stringToLong(this.getValue());
    }

    @Override
    public Control getControlWidget() {
        return this.widget;
    }

    public void setToolTipText(String text) {
        if (this.widget != null) {
            this.widget.setToolTipText(text);
        }
    }

    @Override
    public Text getWidget() {
        return this.widget;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
    }

    public int getLeadingZeros() {
        return this.leadingZeros;
    }

    public void setLeadingZeros(int leadingZeros) {
        this.leadingZeros = leadingZeros;
    }

    @Override
    public void setFocus() {
        if (this.widget != null) {
            this.widget.setFocus();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

