/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.cni.client.gui.util.IWrapper;
import de.cni.common.core.ApplicationProperties;
import de.cni.common.core.Brand;
import de.cni.common.core.Converter;
import de.cni.common.core.GlobalData;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.nebula.widgets.formattedtext.NumberFormatter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class FormattedTextWrapper
implements IWrapper<FormattedText> {
    String id;
    FormattedText widget;
    double value;
    boolean active = true;
    Font defaultFont = GlobalData.getInstance().getDefaultFont();

    public FormattedTextWrapper() {
        this.widget = null;
        this.active = false;
    }

    public FormattedTextWrapper(Brand[] brands, Composite parent, int style) {
        if (ApplicationProperties.getInstance().hasBrand(brands)) {
            this.widget = new FormattedText(parent, style);
            this.widget.getControl().setFont(this.defaultFont);
            this.widget.getControl().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    Text t = (Text)e.widget;
                    t.selectAll();
                }

                public void focusLost(FocusEvent arg0) {
                }
            });
            this.widget.getControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Text t = (Text)e.widget;
                    t.selectAll();
                }
            });
        } else {
            this.widget = null;
            this.active = false;
        }
    }

    public void setNumberFormatter(String format) {
        NumberFormatter formatter = new NumberFormatter(format){

            public String getDisplayString() {
                if (this.value.doubleValue() == 0.0) {
                    return "";
                }
                return super.getDisplayString();
            }
        };
        if (this.widget != null) {
            this.widget.setFormatter((ITextFormatter)formatter);
        }
    }

    public void setNullAllowedNumberFormatter(String format) {
        NumberFormatter formatter = new NumberFormatter(format);
        if (this.widget != null) {
            this.widget.setFormatter((ITextFormatter)formatter);
        }
    }

    public void setValue(double value) {
        this.value = value;
        if (this.widget != null) {
            this.widget.setValue((Object)value);
        }
    }

    public double getValue() {
        if (this.widget != null) {
            this.value = Converter.numberToDouble(this.widget.getValue());
        }
        return this.value;
    }

    @Override
    public Control getControlWidget() {
        if (this.widget != null) {
            return this.widget.getControl();
        }
        return null;
    }

    @Override
    public FormattedText getWidget() {
        return this.widget;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setFocus() {
        if (this.widget != null) {
            this.widget.getControl().setFocus();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void addTraverseListener(TraverseListener listener) {
        Control c = this.getControlWidget();
        if (c != null) {
            c.addTraverseListener(listener);
        }
    }
}

