/*
 * Decompiled with CFR 0.152.
 */
package de.cni.client.gui.util;

import de.jaret.util.ui.datechooser.DateChooser;
import de.jaret.util.ui.datechooser.TimeChooser;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class EnablingRegistry {
    private Collection<Object> enableList = new ArrayList<Object>();
    private Collection<Object> disableList = new ArrayList<Object>();
    private Collection<Object> disabledList = new ArrayList<Object>();
    boolean disabled = false;

    public void addToEnableList(Control element) {
        if (!this.enableList.contains(element)) {
            this.enableList.add(element);
        }
    }

    public void removeFromEnableList(Control element) {
        while (this.enableList.contains(element)) {
            this.enableList.remove(element);
        }
    }

    public void addToDisableList(Control element) {
        if (!this.disableList.contains(element)) {
            this.disableList.add(element);
        }
    }

    public void removeFromDisableList(Control element) {
        while (this.disableList.contains(element)) {
            this.disableList.remove(element);
        }
    }

    public void addToDisabledList(Control element) {
        if (!this.disabledList.contains(element)) {
            this.disabledList.add(element);
        }
    }

    public void removeFromDisabledList(Control element) {
        while (this.disabledList.contains(element)) {
            this.disabledList.remove(element);
        }
    }

    public void enableAllElements() {
        if (this.disabled) {
            for (Object object : this.enableList) {
                if (!this.disabledList.contains(object)) continue;
                this.disabledList.remove(object);
                this.enableOneElement(object);
            }
            this.disabledList.clear();
            this.disabled = false;
        }
    }

    public void disableAllElements() {
        this.disabled = true;
        for (Object object : this.disableList) {
            if (EnablingRegistry.isEnabled(object)) {
                this.disabledList.add(object);
            }
            this.disableOneElement(object);
        }
    }

    public void disableOneElement(Object object) {
        this.disableWidget(object);
    }

    public void enableOneElement(Object object) {
        this.enableWidget(object);
    }

    public boolean enableListContains(Control control) {
        return !this.disabled && this.enableList.contains(control);
    }

    private void disableWidget(Object object) {
        if (object instanceof Text) {
            EnablingRegistry.disableText((Text)object);
        } else if (object instanceof DateChooser) {
            DateChooser c = (DateChooser)object;
            this.disableDateChooser(c);
        } else if (object instanceof TimeChooser) {
            TimeChooser c = (TimeChooser)object;
            this.disableTimeChooser(c);
        } else if (object instanceof Combo) {
            EnablingRegistry.disableCombo((Combo)object);
        } else {
            ((Control)object).setEnabled(false);
        }
    }

    private void enableWidget(Object object) {
        if (object instanceof Text) {
            this.enableText((Text)object);
        } else if (object instanceof DateChooser) {
            DateChooser c = (DateChooser)object;
            this.enableDateChooser(c);
        } else if (object instanceof TimeChooser) {
            TimeChooser c = (TimeChooser)object;
            this.enableTimeChooser(c);
        } else if (object instanceof Combo) {
            this.enableCombo((Combo)object);
        } else {
            ((Control)object).setEnabled(true);
        }
    }

    private void enableText(Text control) {
        if (!control.getEditable()) {
            control.setEditable(true);
        }
    }

    private static void disableText(Text control) {
        if (control.getEditable()) {
            control.setEditable(false);
        }
    }

    private void enableDateChooser(DateChooser control) {
        if (!EnablingRegistry.isEnabled(control)) {
            control.setEditable(true);
        }
    }

    private void disableDateChooser(DateChooser control) {
        if (EnablingRegistry.isEnabled(control)) {
            control.setEditable(false);
        }
    }

    private void enableTimeChooser(TimeChooser control) {
        if (!EnablingRegistry.isEnabled(control)) {
            control.setEditable(true);
        }
    }

    private void disableTimeChooser(TimeChooser control) {
        if (EnablingRegistry.isEnabled(control)) {
            control.setEditable(false);
        }
    }

    private void enableCombo(Combo control) {
        control.setEnabled(true);
    }

    private static void disableCombo(Combo control) {
        control.setEnabled(true);
        control.setEnabled(false);
    }

    public static boolean isEnabled(Object object) {
        if (object instanceof Text) {
            Text c = (Text)object;
            return c.getEditable();
        }
        if (object instanceof DateChooser) {
            DateChooser c = (DateChooser)object;
            return c.isEditable();
        }
        if (object instanceof TimeChooser) {
            TimeChooser c = (TimeChooser)object;
            return c.isEditable();
        }
        if (object instanceof Combo) {
            Combo c = (Combo)object;
            return c.getEnabled();
        }
        return ((Control)object).isEnabled();
    }
}

